/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTripleEncapsulatedExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTripleEncapsulatedExpressionStateObject
extends AbstractEncapsulatedExpressionStateObject {
    private StateObject firstStateObject;
    private StateObject secondStateObject;
    private StateObject thirdStateObject;
    public static final String FIRST_STATE_OBJECT_PROPERTY = "firstStateObject";
    public static final String SECOND_STATE_OBJECT_PROPERTY = "secondStateObject";
    public static final String THIRD_STATE_OBJECT_PROPERTY = "thirdStateObject";

    protected AbstractTripleEncapsulatedExpressionStateObject(StateObject parent) {
        super(parent);
    }

    protected AbstractTripleEncapsulatedExpressionStateObject(StateObject parent, StateObject firstStateObject, StateObject secondStateObject, StateObject thirdStateObject) {
        super(parent);
        this.firstStateObject = this.parent(firstStateObject);
        this.secondStateObject = this.parent(secondStateObject);
        this.thirdStateObject = this.parent(thirdStateObject);
    }

    protected AbstractTripleEncapsulatedExpressionStateObject(StateObject parent, String firstJpqlFragment, String secondJpqlFragment, String thirdJpqlFragment) {
        super(parent);
        this.parseFirst(firstJpqlFragment);
        this.parseSecond(secondJpqlFragment);
        this.parseThird(thirdJpqlFragment);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        if (this.firstStateObject != null) {
            children.add(this.firstStateObject);
        }
        if (this.secondStateObject != null) {
            children.add(this.secondStateObject);
        }
        if (this.thirdStateObject != null) {
            children.add(this.thirdStateObject);
        }
    }

    @Override
    public AbstractTripleEncapsulatedExpression getExpression() {
        return (AbstractTripleEncapsulatedExpression)super.getExpression();
    }

    public StateObject getFirst() {
        return this.firstStateObject;
    }

    protected abstract String getFirstQueryBNFId();

    public StateObject getSecond() {
        return this.secondStateObject;
    }

    protected abstract String getSecondQueryBNFId();

    public StateObject getThird() {
        return this.thirdStateObject;
    }

    protected abstract String getThirdQueryBNFId();

    public boolean hasFirst() {
        return this.firstStateObject != null;
    }

    public boolean hasSecond() {
        return this.secondStateObject != null;
    }

    public boolean hasThird() {
        return this.thirdStateObject != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            AbstractTripleEncapsulatedExpressionStateObject encapsulated = (AbstractTripleEncapsulatedExpressionStateObject)stateObject;
            return this.areEquivalent(this.firstStateObject, encapsulated.firstStateObject) && this.areEquivalent(this.secondStateObject, encapsulated.secondStateObject) && this.areEquivalent(this.thirdStateObject, encapsulated.thirdStateObject);
        }
        return false;
    }

    public void parseFirst(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, this.getFirstQueryBNFId());
        this.setFirst((StateObject)stateObject);
    }

    public void parseSecond(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, this.getSecondQueryBNFId());
        this.setSecond((StateObject)stateObject);
    }

    public void parseThird(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, this.getThirdQueryBNFId());
        this.setThird((StateObject)stateObject);
    }

    public void setFirst(StateObject firstStateObject) {
        StateObject oldFirstStateObject = this.firstStateObject;
        this.firstStateObject = this.parent(firstStateObject);
        this.firePropertyChanged(FIRST_STATE_OBJECT_PROPERTY, oldFirstStateObject, firstStateObject);
    }

    public void setSecond(StateObject secondStateObject) {
        StateObject oldSecondStateObject = this.firstStateObject;
        this.secondStateObject = this.parent(secondStateObject);
        this.firePropertyChanged(SECOND_STATE_OBJECT_PROPERTY, oldSecondStateObject, secondStateObject);
    }

    public void setThird(StateObject thirdStateObject) {
        StateObject oldThirdStateObject = this.thirdStateObject;
        this.thirdStateObject = this.parent(thirdStateObject);
        this.firePropertyChanged(THIRD_STATE_OBJECT_PROPERTY, oldThirdStateObject, thirdStateObject);
    }

    @Override
    protected void toTextEncapsulatedExpression(Appendable writer) throws IOException {
        if (this.firstStateObject != null) {
            this.firstStateObject.toString(writer);
            writer.append(' ');
        }
        writer.append(',');
        if (this.secondStateObject != null) {
            writer.append(' ');
            this.secondStateObject.toString(writer);
        }
        writer.append(',');
        if (this.thirdStateObject != null) {
            writer.append(' ');
            this.thirdStateObject.toString(writer);
        }
    }
}

