/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.datatype.tests.formatter;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.core.api.model.datatype.impl.DatatypePackageImpl;
import org.eclipse.vorto.editor.datatype.tests.DatatypeInjectorProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.junit4.AbstractXtextTests;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=DatatypeInjectorProvider.class)
public class DatatypeModelFormatterTest
extends AbstractXtextTests {
    @Inject
    @Extension
    private ParseHelper<Type> parserHelper;
    @Inject
    @Extension
    private INodeModelFormatter formatter;

    @BeforeClass
    public static void initializeModel() {
        DatatypePackageImpl.init();
    }

    @Test
    public void testFormattingEntity() {
        String expectedText = this.getEntityColorFormatted();
        String rawText = this.getEntityColorUnFormatted();
        this.assertFormattedAs(rawText, expectedText);
    }

    public String getEntityColorFormatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example");
        _builder.newLine();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"Color\"");
        _builder.newLine();
        _builder.append((Object)"description \"Type for Color\"");
        _builder.newLine();
        _builder.append((Object)"category demo");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"entity Color {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"mandatory r as int");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"mandatory g as int");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"mandatory b as int");
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder.toString();
    }

    public String getEntityColorUnFormatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example version 1.0.0 ");
        _builder.newLine();
        _builder.append((Object)"displayname \"Color\" description \"Type for Color\" category demo");
        _builder.newLine();
        _builder.append((Object)"entity Color {mandatory r as int mandatory g as int mandatory b as int }");
        _builder.newLine();
        return _builder.toString();
    }

    @Test
    public void testFormattingEnum() {
        String expectedText = this.getEnumColorFormatted();
        String rawText = this.getEnumColorUnFormatted();
        this.assertFormattedAs(rawText, expectedText);
    }

    public String getEnumColorFormatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example");
        _builder.newLine();
        _builder.append((Object)"version 1.0.0");
        _builder.newLine();
        _builder.append((Object)"displayname \"Color\"");
        _builder.newLine();
        _builder.append((Object)"description \"Type for Color\"");
        _builder.newLine();
        _builder.append((Object)"category demo");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"enum Color {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"RED,");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"GREEN,");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"BLUE");
        _builder.newLine();
        _builder.append((Object)"}");
        return _builder.toString();
    }

    public String getEnumColorUnFormatted() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"namespace org.eclipse.vorto.example version 1.0.0 ");
        _builder.newLine();
        _builder.append((Object)"displayname \"Color\" description \"Type for Color\" category demo");
        _builder.newLine();
        _builder.append((Object)"enum Color {RED, GREEN, BLUE}");
        return _builder.toString();
    }

    public void assertFormattedAs(CharSequence input, CharSequence expected) {
        try {
            String expectedText = expected.toString();
            Type _parse = (Type)this.parserHelper.parse(input);
            Resource _eResource = _parse.eResource();
            IParseResult _parseResult = ((XtextResource)_eResource).getParseResult();
            ICompositeNode _rootNode = _parseResult.getRootNode();
            int _length = input.length();
            INodeModelFormatter.IFormattedRegion _format = this.formatter.format(_rootNode, 0, _length);
            String formattedText = _format.getFormattedText();
            Assert.assertEquals((Object)expectedText, (Object)formattedText);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

