/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.listener;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.core.ui.model.ModelParserFactory;
import org.eclipse.vorto.core.ui.model.VortoModelProject;
import org.eclipse.vorto.perspective.view.ILocalModelWorkspace;

public class RemoveModelProjectListener
implements IResourceChangeListener {
    private ILocalModelWorkspace localModelBrowser;

    public RemoveModelProjectListener(ILocalModelWorkspace localModelBrowser) {
        this.localModelBrowser = localModelBrowser;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.isVortoModelProjectChangeEvent(event)) {
            IModelProject deletedModelProject = this.getModelProjectFromEvent(event);
            this.localModelBrowser.getProjectBrowser().removeProject(deletedModelProject);
        }
    }

    private IModelProject getModelProjectFromEvent(IResourceChangeEvent event) {
        IProject project = (IProject)event.getResource();
        return new VortoModelProject(project, ModelParserFactory.getInstance().getModelParser());
    }

    private boolean isVortoModelProjectChangeEvent(IResourceChangeEvent event) {
        return event.getResource() != null && event.getResource() instanceof IProject && VortoModelProject.isVortoModelProject((IProject)((IProject)event.getResource()));
    }
}

