/*******************************************************************************
 * Copyright (c) 2015 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *   
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *   
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *******************************************************************************/
package org.eclipse.vorto.codegen.coap.common.templates

import org.eclipse.vorto.codegen.api.ITemplate
import org.eclipse.vorto.codegen.api.InvocationContext
import org.eclipse.vorto.codegen.coap.CoAPUtils
import org.eclipse.vorto.core.api.model.functionblock.Operation

class JavaFBOperationParamSetTemplate implements ITemplate<Operation>{
	
	var String className;
	var String classPackage;
	var String[] imports;
	
	new(
		String className,
		String classPackage,
		String[] imports
	) {
		this.className = className;
		this.classPackage = classPackage;
		this.imports = imports;
	}
	
	override getContent(Operation op,InvocationContext invocationContext) {
		'''
			/*
			*****************************************************************************************
			* The present code has been generated by the Eclipse Vorto CoAP Code Generator.
			*
			* The basis for the generation was the Information Model which is uniquely identified by:
			* Name:			« op.name »
			* Namespace:	«classPackage»
			* Version:		
			*****************************************************************************************
			*/
			
			package «classPackage»;
			
			«FOR imprt: imports»
				import «imprt».*;
			«ENDFOR»
			
			public class «className.toFirstUpper» {
				
				«FOR param : op.params»
				private «CoAPUtils.getParameterTypeAsString(param)» «param.name»;
				
			«ENDFOR»
				«FOR param : op.params»
				public «CoAPUtils.getParameterTypeAsString(param)» get«param.name.toFirstUpper»() {
					return «param.name»;
				}
				
				public void set«param.name.toFirstUpper»(«CoAPUtils.getParameterTypeAsString(param)» «param.name») {
					this.«param.name» = «param.name»; 
				}
			«ENDFOR»
			}
			'''
	}

}