/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard.datatype;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.ITemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.ui.handler.ModelGenerationTask;
import org.eclipse.vorto.codegen.ui.tasks.ProjectFileOutputter;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.wizard.AbstractVortoWizard;
import org.eclipse.vorto.wizard.datatype.DataTypeFileTemplate;
import org.eclipse.vorto.wizard.datatype.Datatype;
import org.eclipse.vorto.wizard.datatype.DatatypeWizardPage;

public abstract class AbstractDatatypeWizard
extends AbstractVortoWizard
implements INewWizard {
    private IModelProject modelProject;
    private DatatypeWizardPage iotWizardPage;
    private String modelFolder = "datatypes/";
    private Datatype datatype;

    public AbstractDatatypeWizard(IModelProject modelProject) {
        this.modelProject = modelProject;
    }

    public void addPages() {
        this.iotWizardPage = new DatatypeWizardPage(this.datatype, "New Datatype", this.modelProject);
        this.setTitle("Create " + this.datatype.name().toLowerCase() + " type ");
        this.setDescription("Please enter the details for creating a " + this.datatype.name().toLowerCase() + " model.");
        this.addPage((IWizardPage)this.iotWizardPage);
    }

    public boolean performFinish() {
        new ModelGenerationTask(ModelType.Datatype.getExtension(), (ITemplate)new DataTypeFileTemplate(this.datatype.name().toLowerCase()), this.modelFolder).generate((Object)this.iotWizardPage, InvocationContext.simpleInvocationContext(), (IGeneratedWriter)new ProjectFileOutputter(this.modelProject.getProject()));
        this.openTypeWithDefaultEditor(this.iotWizardPage);
        return true;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    protected void setDatatypeName(Datatype datatype) {
        this.datatype = datatype;
    }

    protected void setDescription(String description) {
        this.iotWizardPage.setDescription(description);
    }

    protected void setTitle(String title) {
        this.iotWizardPage.setTitle(title);
    }
}

