/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vorto.codegen.ui.context.IModelProjectContext;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.wizard.AbstractWizardPage;

public abstract class ModelBaseWizardPage
extends AbstractWizardPage
implements IModelProjectContext {
    private IModelProject modelProject;
    protected ModifyListener modificationListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ModelBaseWizardPage.this.modelNameChanged();
            ModelBaseWizardPage.this.dialogChanged();
        }
    };
    private Text txtModelName;
    private Text txtNamespace;
    private Text txtVersion;
    private Text txtDescription;
    private String workspaceLocation;

    protected ModelBaseWizardPage(String pageName, IModelProject modelProject) {
        super(pageName);
        this.modelProject = modelProject;
    }

    public void createControl(Composite parent) {
        Composite topContainer = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        topContainer.setLayout((Layout)fillLayout);
        Group grp = new Group(topContainer, 0);
        grp.setText(this.getGroupTitle());
        grp.setLayout((Layout)new GridLayout(2, false));
        this.txtModelName = this.newLabeledText((Composite)grp, this.getModelLabel(), 2048, this.newTxtGridData(400, null), this.modificationListener);
        this.txtNamespace = this.newLabeledText((Composite)grp, "Namespace:", 2048, this.newTxtGridData(400, null), this.modificationListener);
        this.decorate((Composite)grp);
        this.txtVersion = this.newLabeledText((Composite)grp, "Version:", 2048, this.newTxtGridData(400, null), this.modificationListener);
        this.txtDescription = this.newLabeledText((Composite)grp, "Description:", 2562, this.newTxtGridData(null, 53), null);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)topContainer);
    }

    protected Text newLabeledText(Composite parent, String labelStr, int style, Object layoutData, ModifyListener listener) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        label.setText(labelStr);
        Text text = new Text(parent, style);
        text.setLayoutData(layoutData);
        if (listener != null) {
            text.addModifyListener(listener);
        }
        return text;
    }

    protected GridData newTxtGridData(Integer widthHint, Integer heightHint) {
        GridData gridData = new GridData(4, 128, false, false, 1, 1);
        if (widthHint != null) {
            gridData.widthHint = widthHint;
        }
        if (heightHint != null) {
            gridData.heightHint = heightHint;
        }
        return gridData;
    }

    protected void initialize() {
        this.txtModelName.setText(this.getDefaultModelName());
        this.txtVersion.setText(this.getDefaultVersion());
        this.txtDescription.setText(String.valueOf(this.getDefaultDescription()) + this.getDefaultModelName());
        this.txtNamespace.setText(this.getDefaultNamespace());
    }

    public void dialogChanged() {
        if (this.validateProject()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected boolean validateProject() {
        for (Validator validator : this.getValidators(this.getModelId())) {
            ValidationResult result = validator.validate();
            if (result.isValid) continue;
            this.setErrorMessage(result.errorMessage);
            return false;
        }
        return true;
    }

    protected Collection<Validator> getValidators(final ModelId id) {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        validators.add(new Validator(){

            @Override
            public ValidationResult validate() {
                if (Strings.nullToEmpty((String)id.getNamespace()).trim().isEmpty()) {
                    return ModelBaseWizardPage.this.invalid("Model namespace must not be empty.");
                }
                return ModelBaseWizardPage.this.valid();
            }
        });
        validators.add(new Validator(){

            @Override
            public ValidationResult validate() {
                if (Strings.nullToEmpty((String)id.getName()).trim().isEmpty()) {
                    return ModelBaseWizardPage.this.invalid("Model name must not be empty.");
                }
                return ModelBaseWizardPage.this.valid();
            }
        });
        validators.add(new Validator(){

            @Override
            public ValidationResult validate() {
                if (ModelBaseWizardPage.this.checkForRegexPattern(id.getName(), false, "[A-Z][a-zA-Z0-9_]*$")) {
                    return ModelBaseWizardPage.this.invalid("Model name should start with a capital letter and must not contain any special characters.");
                }
                return ModelBaseWizardPage.this.valid();
            }
        });
        validators.add(new Validator(){

            @Override
            public ValidationResult validate() {
                if (Strings.nullToEmpty((String)id.getVersion()).trim().isEmpty()) {
                    return ModelBaseWizardPage.this.invalid("Model version must not be empty.");
                }
                return ModelBaseWizardPage.this.valid();
            }
        });
        validators.add(new Validator(){

            @Override
            public ValidationResult validate() {
                if (ModelBaseWizardPage.this.checkForRegexPattern(id.getVersion(), false, "^\\d+\\.\\d+\\.\\d+(-\\w+)*$")) {
                    return ModelBaseWizardPage.this.invalid("Model version should follow pattern <MAJOR>.<MINOR>.<PATCH>");
                }
                return ModelBaseWizardPage.this.valid();
            }
        });
        validators.add(new Validator(){

            @Override
            public ValidationResult validate() {
                if (ModelBaseWizardPage.this.getModelProject().exists(id)) {
                    return ModelBaseWizardPage.this.invalid("Project already contains model with the same model ID.");
                }
                return ModelBaseWizardPage.this.valid();
            }
        });
        return validators;
    }

    protected ValidationResult valid() {
        ValidationResult result = new ValidationResult();
        result.isValid = true;
        return result;
    }

    protected ValidationResult invalid(String errorMessage) {
        ValidationResult result = new ValidationResult();
        result.isValid = false;
        result.errorMessage = errorMessage;
        return result;
    }

    protected void modelNameChanged() {
        String modelName = this.txtModelName.getText();
        this.txtDescription.setText(String.valueOf(this.getDefaultDescription()) + modelName);
    }

    public String getWorkspaceLocation() {
        if (this.workspaceLocation == null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.workspaceLocation = workspace.getRoot().getLocation().toString();
        }
        return this.workspaceLocation;
    }

    public IModelProject getModelProject() {
        return this.modelProject;
    }

    public void setModelProject(IModelProject modelProject) {
        this.modelProject = modelProject;
    }

    @Override
    public String getProjectName() {
        return this.modelProject.getProject().getName();
    }

    public String getModelDescription() {
        return this.txtDescription.getText();
    }

    public ModelId getModelId() {
        return ModelIdFactory.newInstance((ModelType)this.getModelType(), (String)this.txtNamespace.getText(), (String)this.txtVersion.getText(), (String)this.txtModelName.getText());
    }

    protected abstract ModelType getModelType();

    protected void decorate(Composite parent) {
    }

    protected abstract String getDefaultVersion();

    protected abstract String getDefaultDescription();

    protected abstract String getDefaultModelName();

    protected abstract String getGroupTitle();

    protected abstract String getModelLabel();

    protected abstract String getDefaultNamespace();

    public class ValidationResult {
        public boolean isValid;
        public String errorMessage;
    }

    public static interface Validator {
        public ValidationResult validate();
    }
}

