/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.internal.impl.ContainerManagedEntityImpl;

public class CMPKeySynchronizationAdapter
extends AdapterImpl {
    public static final String ADAPTER_TYPE = CMPKeySynchronizationAdapter.class.getName();
    private boolean initialized = false;
    protected ContainerManagedEntity cmp = null;
    private boolean isUpdating = false;
    private boolean isEnabled = true;
    private static WeakHashMap<CMPKeySynchronizationAdapter, Object> unresolvedCMPAttributesToFlush = new WeakHashMap();

    public CMPKeySynchronizationAdapter(ContainerManagedEntity cmp) {
        this.cmp = cmp;
    }

    public void initializeKeyAttributes() {
        if (this.cmp == null || this.initialized) {
            return;
        }
        this.cmp.eSetDeliver(false);
        try {
            Resource res = this.cmp.eResource();
            if (res == null) {
                return;
            }
            boolean cachedIsModified = res.isModified();
            try {
                if (this.cmp.getPrimKeyField() != null) {
                    this.initializeForPrimKey();
                } else {
                    this.initializeForCompoundKey();
                }
            }
            finally {
                res.setModified(cachedIsModified);
            }
        }
        finally {
            this.cmp.eSetDeliver(true);
            this.initialized = true;
        }
    }

    protected void initializeForPrimKey() {
        if (this.getKeyAttributes().size() != 1 || !this.getKeyAttributes().contains((Object)this.cmp.getPrimKeyField())) {
            this.primKeyFieldChanged((EObject)this.cmp.getPrimKeyField());
        }
    }

    protected void initializeForCompoundKey() {
        EList keys = this.getKeyAttributes();
        keys.clear();
        JavaClass keyClass = this.cmp.getPrimaryKey();
        if (keyClass == null) {
            return;
        }
        keyClass.eAdapters().add((Object)this);
        List keyFields = keyClass.getFieldsExtended();
        if (keyFields.size() == 0) {
            unresolvedCMPAttributesToFlush.put(this, null);
        } else {
            unresolvedCMPAttributesToFlush.remove((Object)this);
        }
        int i = 0;
        while (i < keyFields.size()) {
            CMPAttribute keyAttribute;
            Field field = (Field)keyFields.get(i);
            if (field.getJavaVisibility() == JavaVisibilityKind.PUBLIC_LITERAL && (keyAttribute = this.cmp.getPersistentAttribute(field.getName())) != null) {
                keys.add(keyAttribute);
            }
            ++i;
        }
    }

    public static void flushUnresolvedKeyAttributesOnCleanBuild() {
        for (CMPKeySynchronizationAdapter curAdapter : unresolvedCMPAttributesToFlush.keySet()) {
            curAdapter.initialized = false;
            curAdapter.initializeKeyAttributes();
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.isUpdating || !this.isEnabled) {
            return;
        }
        try {
            this.isUpdating = true;
            EClass featureClass = ((EObject)notification.getNotifier()).eClass();
            if (EjbPackage.eINSTANCE.getContainerManagedEntity().equals(featureClass)) {
                switch (notification.getFeatureID(ContainerManagedEntity.class)) {
                    case 27: {
                        this.handleCMPAttributeEvent(notification);
                        break;
                    }
                    case 28: {
                        this.handleCMPAttributeEvent(notification);
                        break;
                    }
                    case 24: {
                        this.handleKeyClassEvent(notification);
                        break;
                    }
                    case 31: {
                        this.handlePrimKeyFieldEvent(notification);
                    }
                }
            } else if (EjbPackage.eINSTANCE.getCMPAttribute().equals(featureClass)) {
                switch (notification.getFeatureID(CMPAttribute.class)) {
                    case 1: {
                        this.handleCMPAttributeRenameEvent((CMPAttribute)notification.getNotifier(), notification.getOldValue());
                    }
                }
            }
        }
        finally {
            this.isUpdating = false;
        }
    }

    private void handleCMPAttributeRenameEvent(CMPAttribute attribute, Object oldValue) {
        if (this.getKeyAttributes().contains((Object)attribute)) {
            if (!this.isAttributeKeyClassField(attribute.getName())) {
                this.removeKeyAttribute(attribute, (String)oldValue);
            }
        } else {
            this.attributeAdded(attribute);
        }
    }

    private void handlePrimKeyFieldEvent(Notification notification) {
        EObject newPrimKeyField = (EObject)notification.getNewValue();
        this.cmp.setPrimKeyField((CMPAttribute)newPrimKeyField);
        if (newPrimKeyField == null || newPrimKeyField.eIsProxy()) {
            CMPAttribute primField = (CMPAttribute)newPrimKeyField;
            if (primField != null && primField.getName() == null) {
                primField.setName(((InternalEObject)primField).eProxyURI().toString());
                this.makePrimKeyFieldProxy(primField.getName());
            }
            this.removeAllKeyAttributes();
            this.initialized = false;
            this.initializeKeyAttributes();
        } else if (this.getKeyAttributes().size() != 1 || !this.getKeyAttributes().contains((Object)newPrimKeyField)) {
            this.primKeyFieldChanged(newPrimKeyField);
        }
    }

    private void handleKeyClassEvent(Notification notification) {
        if (this.cmp.getPrimKeyField() == null || this.cmp.getPrimKeyField().eIsProxy()) {
            this.keyClassChanged();
        }
    }

    private void handleCMPAttributeEvent(Notification notification) {
        int eventType = notification.getEventType();
        if (eventType == 3) {
            this.attributeAdded((CMPAttribute)notification.getNewValue());
        } else if (eventType == 4) {
            CMPAttribute attribute = (CMPAttribute)notification.getOldValue();
            attribute.eAdapters().remove((Object)this);
            this.removeKeyAttribute(attribute, attribute.getName());
        }
    }

    protected void removeKeyAttribute(CMPAttribute attribute, String oldName) {
        this.getKeyAttributes().remove((Object)attribute);
        if (this.cmp.getPrimKeyField() != null && this.cmp.getPrimKeyField().equals(attribute)) {
            this.makePrimKeyFieldProxy(oldName);
        }
    }

    public void makePrimKeyFieldProxy(String oldName) {
        if (this.cmp.getPrimKeyField() == null) {
            return;
        }
        this.cmp.setPrimKeyField(EjbFactory.eINSTANCE.createCMPAttribute());
        this.cmp.getPrimKeyField().setName(oldName);
        ((InternalEObject)this.cmp.getPrimKeyField()).eSetProxyURI(URI.createURI((String)oldName));
    }

    protected void removeAllKeyAttributes() {
        this.getKeyAttributes().clear();
    }

    protected void addKeyAttribute(CMPAttribute attribute) {
        CMPAttribute primKeyField = this.cmp.getPrimKeyField();
        if (primKeyField == null || primKeyField.eIsProxy()) {
            if (!this.getKeyAttributes().contains((Object)attribute)) {
                this.getKeyAttributes().add((Object)attribute);
            }
            if (this.getKeyAttributes().size() == 1 && attribute.getType().equals(this.cmp.getPrimaryKey())) {
                this.cmp.setPrimKeyField(attribute);
            }
        } else if (primKeyField.equals(attribute)) {
            if (this.getKeyAttributes().size() != 1 || !this.getKeyAttributes().contains((Object)attribute)) {
                this.getKeyAttributes().clear();
                this.getKeyAttributes().add((Object)attribute);
            }
        } else {
            this.cmp.setPrimKeyField(null);
            if (!this.getKeyAttributes().contains((Object)attribute)) {
                this.getKeyAttributes().add((Object)attribute);
            }
        }
    }

    protected void attributeAdded(CMPAttribute attribute) {
        this.cmp.getKeyAttributes();
        if (!attribute.eAdapters().contains((Object)this)) {
            attribute.eAdapters().add((Object)this);
        }
        if (attribute.getName() == null) {
            return;
        }
        if (this.isAttributeKeyClassField(attribute.getName())) {
            this.addKeyAttribute(attribute);
            this.sortKeyAttributeList();
        } else if (this.cmp.getPrimKeyField() != null && this.cmp.getPrimKeyField().eIsProxy() && attribute.getName().equals(this.cmp.getPrimKeyField().getName())) {
            this.cmp.setPrimKeyField(attribute);
            this.primKeyFieldChanged((EObject)attribute);
        }
    }

    protected boolean isAttributeKeyClassField(String attributeName) {
        JavaClass keyClass = this.cmp.getPrimaryKey();
        if (keyClass == null) {
            return false;
        }
        List keyFields = keyClass.getFieldsExtended();
        int i = 0;
        while (i < keyFields.size()) {
            Field field = (Field)keyFields.get(i);
            if (field.getJavaVisibility() == JavaVisibilityKind.PUBLIC_LITERAL && field.getName().equals(attributeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void sortKeyAttributeList() {
        ArrayList<CMPAttribute> result = new ArrayList<CMPAttribute>();
        JavaClass keyClass = this.cmp.getPrimaryKey();
        if (keyClass == null) {
            return;
        }
        List keyFields = keyClass.getFieldsExtended();
        EList currentKeys = this.getKeyAttributes();
        int i = 0;
        while (i < keyFields.size()) {
            Field field = (Field)keyFields.get(i);
            if (field.getJavaVisibility() == JavaVisibilityKind.PUBLIC_LITERAL) {
                int j = 0;
                while (j < currentKeys.size()) {
                    CMPAttribute attribute = (CMPAttribute)currentKeys.get(j);
                    if (field.getName().equals(attribute.getName())) {
                        result.add(attribute);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.getKeyAttributes().clear();
        this.getKeyAttributes().addAll(result);
    }

    protected void keyClassChanged() {
        JavaClass key = this.cmp.getPrimaryKey();
        if (key != null) {
            key.eAdapters().remove((Object)this);
        }
        this.removeAllKeyAttributes();
        this.initialized = false;
        this.initializeKeyAttributes();
    }

    protected void primKeyFieldChanged(EObject primKeyField) {
        this.removeAllKeyAttributes();
        if (primKeyField != null && !primKeyField.eIsProxy()) {
            if (!primKeyField.eAdapters().contains((Object)this)) {
                primKeyField.eAdapters().add((Object)this);
            }
            this.getKeyAttributes().add((Object)primKeyField);
        }
    }

    private EList getKeyAttributes() {
        return ((ContainerManagedEntityImpl)this.cmp).getKeyAttributesGen();
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
    }

    public boolean isAdapterForType(Object type) {
        return ADAPTER_TYPE.equals(type);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }
}

