/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal.facets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.facets.RuntimeComponentProviderWrapper;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetMappingUtil
extends Plugin {
    private static List<RuntimeComponentProviderWrapper> runtimeComponentProviders;
    private static List<RuntimeFacetMapping> runtimeFacetMappings;

    public static RuntimeFacetMapping[] getRuntimeFacetMapping() {
        if (runtimeFacetMappings == null) {
            FacetMappingUtil.loadRuntimeFacetMapping();
        }
        RuntimeFacetMapping[] rfm = new RuntimeFacetMapping[runtimeFacetMappings.size()];
        runtimeFacetMappings.toArray(rfm);
        return rfm;
    }

    public static void addFacetRuntimeComponents(IRuntime runtime, List<IRuntimeComponent> components) {
        if (runtime == null || runtime.getRuntimeType() == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeComponentProviders == null) {
            FacetMappingUtil.loadRuntimeComponentProviders();
        }
        for (RuntimeComponentProviderWrapper runtimeComponentProvider : runtimeComponentProviders) {
            List<IRuntimeComponent> list;
            if (!runtimeComponentProvider.supportsRuntimeType(runtime.getRuntimeType()) || (list = runtimeComponentProvider.getComponents(runtime)) == null) continue;
            components.addAll(list);
        }
    }

    private static synchronized void loadRuntimeComponentProviders() {
        IConfigurationElement ce;
        if (runtimeComponentProviders != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "->- Loading .runtimeFacetComponentProviders extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "runtimeFacetComponentProviders");
        ArrayList<RuntimeComponentProviderWrapper> list = new ArrayList<RuntimeComponentProviderWrapper>(cf.length);
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                ce = iConfigurationElementArray[n2];
                try {
                    list.add(new RuntimeComponentProviderWrapper(ce));
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded runtimeFacetComponentProvider: " + ce.getAttribute("id"));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block11;
                    Trace.trace("/severe", "  Could not load runtimeFacetComponentProvider: " + ce.getAttribute("id"), t);
                }
            }
            ++n2;
        }
        iConfigurationElementArray = cf = registry.getConfigurationElementsFor("org.eclipse.jst.server.core.internalRuntimeComponentProviders");
        n = cf.length;
        n2 = 0;
        while (n2 < n) {
            block12: {
                ce = iConfigurationElementArray[n2];
                try {
                    list.add(new RuntimeComponentProviderWrapper(ce));
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded runtimeFacetComponentProvider: " + ce.getAttribute("id"));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block12;
                    Trace.trace("/severe", "  Could not load runtimeFacetComponentProvider: " + ce.getAttribute("id"), t);
                }
            }
            ++n2;
        }
        runtimeComponentProviders = list;
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .runtimeFacetComponentProviders extension point -<-");
        }
    }

    private static synchronized void loadRuntimeFacetMapping() {
        if (runtimeFacetMappings != null) {
            return;
        }
        if (Trace.CONFIG) {
            Trace.trace("/config", "->- Loading .runtimeFacetMapping extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.jst.server.core.runtimeFacetMappings");
        ArrayList<RuntimeFacetMapping> list = new ArrayList<RuntimeFacetMapping>(cf.length);
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                try {
                    list.add(new RuntimeFacetMapping(ce));
                    if (Trace.CONFIG) {
                        Trace.trace("/config", "  Loaded runtimeFacetMapping: " + ce.getAttribute("runtimeTypeId"));
                    }
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block7;
                    Trace.trace("/severe", "  Could not load runtimeFacetMapping: " + ce.getAttribute("id"), t);
                }
            }
            ++n2;
        }
        runtimeFacetMappings = list;
        if (Trace.CONFIG) {
            Trace.trace("/config", "-<- Done loading .runtimeFacetMapping extension point -<-");
        }
    }
}

