/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaAssociationOverrideContainer
extends AbstractJavaJpaContextNode
implements JavaAssociationOverrideContainer {
    protected JavaResourcePersistentMember javaResourcePersistentMember;
    protected final JavaAssociationOverrideContainer.Owner owner;
    protected final List<JavaAssociationOverride> specifiedAssociationOverrides;
    protected final List<JavaAssociationOverride> virtualAssociationOverrides;

    public GenericJavaAssociationOverrideContainer(JavaJpaContextNode parent, JavaAssociationOverrideContainer.Owner owner) {
        super(parent);
        this.owner = owner;
        this.specifiedAssociationOverrides = new ArrayList<JavaAssociationOverride>();
        this.virtualAssociationOverrides = new ArrayList<JavaAssociationOverride>();
    }

    protected JavaAssociationOverrideContainer.Owner getOwner() {
        return this.owner;
    }

    @Override
    public JavaAssociationOverride getAssociationOverrideNamed(String name) {
        return (JavaAssociationOverride)this.getOverrideNamed(name, this.associationOverrides());
    }

    public boolean containsAssociationOverride(String name) {
        return this.containsOverride(name, this.associationOverrides());
    }

    public boolean containsSpecifiedAssociationOverride(String name) {
        return this.containsOverride(name, this.specifiedAssociationOverrides());
    }

    public boolean containsDefaultAssociationOverride(String name) {
        return this.containsOverride(name, this.virtualAssociationOverrides());
    }

    protected BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    protected boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    protected Iterator<String> allOverridableAssociationNames() {
        return this.getOwner().allOverridableNames();
    }

    @Override
    public ListIterator<JavaAssociationOverride> associationOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAssociationOverrides(), this.virtualAssociationOverrides()});
    }

    @Override
    public int associationOverridesSize() {
        return this.specifiedAssociationOverridesSize() + this.virtualAssociationOverridesSize();
    }

    @Override
    public ListIterator<JavaAssociationOverride> virtualAssociationOverrides() {
        return new CloneListIterator(this.virtualAssociationOverrides);
    }

    @Override
    public int virtualAssociationOverridesSize() {
        return this.virtualAssociationOverrides.size();
    }

    @Override
    public ListIterator<JavaAssociationOverride> specifiedAssociationOverrides() {
        return new CloneListIterator(this.specifiedAssociationOverrides);
    }

    @Override
    public int specifiedAssociationOverridesSize() {
        return this.specifiedAssociationOverrides.size();
    }

    public JavaAssociationOverride addSpecifiedAssociationOverride(int index) {
        JavaAssociationOverride associationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        this.specifiedAssociationOverrides.add(index, associationOverride);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)((Object)this.javaResourcePersistentMember.addAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"));
        associationOverride.initialize(associationOverrideResource);
        this.fireItemAdded("specifiedAssociationOverrides", index, associationOverride);
        return associationOverride;
    }

    protected JavaAssociationOverride.Owner createAssociationOverrideOwner() {
        return new AssociationOverrideOwner();
    }

    protected void addSpecifiedAssociationOverride(int index, JavaAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    protected void addSpecifiedAssociationOverride(JavaAssociationOverride associationOverride) {
        this.addSpecifiedAssociationOverride(this.specifiedAssociationOverrides.size(), associationOverride);
    }

    protected void removeSpecifiedAssociationOverride_(JavaAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    @Override
    public void moveSpecifiedAssociationOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAssociationOverrides, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentMember.moveAnnotation(targetIndex, sourceIndex, "javax.persistence.AssociationOverrides");
        this.fireItemMoved("specifiedAssociationOverrides", targetIndex, sourceIndex);
    }

    protected JavaAssociationOverride setAssociationOverrideVirtual(boolean virtual, JavaAssociationOverride associationOverride) {
        if (virtual) {
            return this.setAssociationOverrideVirtual(associationOverride);
        }
        return this.setAssociationOverrideSpecified(associationOverride);
    }

    protected JavaAssociationOverride setAssociationOverrideVirtual(JavaAssociationOverride associationOverride) {
        int index = this.specifiedAssociationOverrides.indexOf(associationOverride);
        this.specifiedAssociationOverrides.remove(index);
        String associationOverrideName = associationOverride.getName();
        JavaAssociationOverride virtualAssociationOverride = null;
        if (associationOverrideName != null) {
            for (String name : CollectionTools.iterable(this.allOverridableAssociationNames())) {
                if (!name.equals(associationOverrideName)) continue;
                virtualAssociationOverride = this.buildVirtualAssociationOverride(name);
                this.virtualAssociationOverrides.add(virtualAssociationOverride);
                break;
            }
        }
        this.javaResourcePersistentMember.removeAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.fireItemRemoved("specifiedAssociationOverrides", index, associationOverride);
        if (virtualAssociationOverride != null) {
            this.fireItemAdded("virtualAssociationOverrides", this.virtualAssociationOverridesSize() - 1, virtualAssociationOverride);
        }
        return virtualAssociationOverride;
    }

    protected JavaAssociationOverride setAssociationOverrideSpecified(JavaAssociationOverride oldAssociationOverride) {
        int index = this.specifiedAssociationOverridesSize();
        JavaAssociationOverride newAssociationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        this.specifiedAssociationOverrides.add(index, newAssociationOverride);
        AssociationOverrideAnnotation attributeOverrideResource = (AssociationOverrideAnnotation)((Object)this.javaResourcePersistentMember.addAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"));
        newAssociationOverride.initialize(attributeOverrideResource);
        int virtualIndex = this.virtualAssociationOverrides.indexOf(oldAssociationOverride);
        this.virtualAssociationOverrides.remove(virtualIndex);
        newAssociationOverride.initializeFrom(oldAssociationOverride);
        this.fireItemRemoved("virtualAssociationOverrides", virtualIndex, oldAssociationOverride);
        this.fireItemAdded("specifiedAssociationOverrides", index, newAssociationOverride);
        return newAssociationOverride;
    }

    protected void addVirtualAssociationOverride(JavaAssociationOverride associationOverride) {
        this.addItemToList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverrides");
    }

    protected void removeVirtualAssociationOverride(JavaAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverrides");
    }

    @Override
    public void initialize(JavaResourcePersistentMember resourcePersistentMember) {
        this.javaResourcePersistentMember = resourcePersistentMember;
        this.initializeSpecifiedAssociationOverrides();
        this.initializeVirtualAssociationOverrides();
    }

    protected void initializeSpecifiedAssociationOverrides() {
        Iterator<NestableAnnotation> stream = this.relavantResourceAssociationOverrides();
        while (stream.hasNext()) {
            this.specifiedAssociationOverrides.add(this.buildAssociationOverride((AssociationOverrideAnnotation)((Object)stream.next())));
        }
    }

    protected void initializeVirtualAssociationOverrides() {
        for (String name : CollectionTools.iterable(this.allOverridableAssociationNames())) {
            JavaAssociationOverride associationOverride = this.getAssociationOverrideNamed(name);
            if (associationOverride != null) continue;
            this.virtualAssociationOverrides.add(this.buildVirtualAssociationOverride(name));
        }
    }

    @Override
    public void update(JavaResourcePersistentMember resourcePersistentMember) {
        this.javaResourcePersistentMember = resourcePersistentMember;
        this.updateSpecifiedAssociationOverrides();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.updateVirtualAssociationOverrides();
    }

    protected void updateSpecifiedAssociationOverrides() {
        ListIterator<JavaAssociationOverride> associationOverrides = this.specifiedAssociationOverrides();
        Iterator<NestableAnnotation> resourceAssociationOverrides = this.relavantResourceAssociationOverrides();
        while (associationOverrides.hasNext()) {
            JavaAssociationOverride associationOverride = associationOverrides.next();
            if (resourceAssociationOverrides.hasNext()) {
                associationOverride.update((AssociationOverrideAnnotation)((Object)resourceAssociationOverrides.next()));
                continue;
            }
            this.removeSpecifiedAssociationOverride_(associationOverride);
        }
        while (resourceAssociationOverrides.hasNext()) {
            this.addSpecifiedAssociationOverride(this.buildAssociationOverride((AssociationOverrideAnnotation)((Object)resourceAssociationOverrides.next())));
        }
    }

    protected Iterator<NestableAnnotation> relavantResourceAssociationOverrides() {
        Iterator<NestableAnnotation> resourceAssociationOverrides = this.javaResourcePersistentMember.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        return new FilteringIterator<NestableAnnotation>(resourceAssociationOverrides){

            protected boolean accept(NestableAnnotation o) {
                String overrideName = ((AssociationOverrideAnnotation)((Object)o)).getName();
                return overrideName != null && GenericJavaAssociationOverrideContainer.this.getOwner().isRelevant(overrideName);
            }
        };
    }

    protected JavaAssociationOverride buildAssociationOverride(AssociationOverrideAnnotation associationOverrideResource) {
        JavaAssociationOverride associationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        associationOverride.initialize(associationOverrideResource);
        return associationOverride;
    }

    protected JavaAssociationOverride buildVirtualAssociationOverride(String name) {
        return this.buildAssociationOverride(this.buildVirtualAssociationOverrideAnnotation(name));
    }

    protected AssociationOverrideAnnotation buildVirtualAssociationOverrideAnnotation(String name) {
        RelationshipReference relationshipReference = this.resolveAssociationOverrideRelationshipReference(name);
        return this.getJpaFactory().buildJavaVirtualAssociationOverrideAnnotation(this.javaResourcePersistentMember, name, relationshipReference.getPredominantJoiningStrategy());
    }

    private RelationshipReference resolveAssociationOverrideRelationshipReference(String associationOverrideName) {
        return this.getOwner().resolveRelationshipReference(associationOverrideName);
    }

    protected void updateVirtualAssociationOverrides() {
        for (String name : CollectionTools.iterable(this.allOverridableAssociationNames())) {
            JavaAssociationOverride associationOverride = this.getAssociationOverrideNamed(name);
            if (associationOverride == null) {
                this.addVirtualAssociationOverride(this.buildVirtualAssociationOverride(name));
                continue;
            }
            if (!associationOverride.isVirtual()) continue;
            associationOverride.update(this.buildVirtualAssociationOverrideAnnotation(name));
        }
        HashBag associationNames = CollectionTools.collection(this.allOverridableAssociationNames());
        for (JavaAssociationOverride associationOverride : CollectionTools.iterable(this.virtualAssociationOverrides())) {
            if (associationNames.contains(associationOverride.getName()) && !this.containsSpecifiedAssociationOverride(associationOverride.getName())) continue;
            this.removeVirtualAssociationOverride(associationOverride);
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaAssociationOverride override : CollectionTools.iterable(this.associationOverrides())) {
            result = override.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        ListIterator<JavaAssociationOverride> stream = this.associationOverrides();
        while (stream.hasNext()) {
            ((JavaAssociationOverride)stream.next()).validate(messages, reporter, astRoot);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getOwner().getValidationTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssociationOverrideOwner
    implements JavaAssociationOverride.Owner {
        protected AssociationOverrideOwner() {
        }

        @Override
        public RelationshipMapping getRelationshipMapping(String attributeName) {
            return MappingTools.getRelationshipMapping(attributeName, GenericJavaAssociationOverrideContainer.this.getOwner().getOverridableTypeMapping());
        }

        @Override
        public boolean isVirtual(BaseOverride override) {
            return GenericJavaAssociationOverrideContainer.this.virtualAssociationOverrides.contains(override);
        }

        @Override
        public BaseOverride setVirtual(boolean virtual, BaseOverride attributeOverride) {
            return GenericJavaAssociationOverrideContainer.this.setAssociationOverrideVirtual(virtual, (JavaAssociationOverride)attributeOverride);
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericJavaAssociationOverrideContainer.this.getOwner().getTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableAttributeNames() {
            return GenericJavaAssociationOverrideContainer.this.allOverridableAssociationNames();
        }

        @Override
        public String getPossiblePrefix() {
            return GenericJavaAssociationOverrideContainer.this.getOwner().getPossiblePrefix();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return GenericJavaAssociationOverrideContainer.this.getOwner().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return GenericJavaAssociationOverrideContainer.this.getOwner().candidateTableNames();
        }

        @Override
        public String getDefaultTableName() {
            return GenericJavaAssociationOverrideContainer.this.getOwner().getDefaultTableName();
        }

        @Override
        public Table getDbTable(String tableName) {
            return GenericJavaAssociationOverrideContainer.this.getOwner().getDbTable(tableName);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            return GenericJavaAssociationOverrideContainer.this.getOwner().buildColumnTableNotValidMessage(override, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            return GenericJavaAssociationOverrideContainer.this.getOwner().buildColumnUnresolvedNameMessage(override, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedReferencedColumnNameMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            return GenericJavaAssociationOverrideContainer.this.getOwner().buildColumnUnresolvedReferencedColumnNameMessage(override, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            return GenericJavaAssociationOverrideContainer.this.getOwner().buildUnspecifiedNameMultipleJoinColumnsMessage(override, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            return GenericJavaAssociationOverrideContainer.this.getOwner().buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(override, column, textRange);
        }
    }
}

