/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2;

import java.util.ListIterator;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.db.DatabaseIdentifierAdapter;

public class GenericJpaDatabaseIdentifierAdapter
implements DatabaseIdentifierAdapter {
    private final JpaDataSource dataSource;

    public GenericJpaDatabaseIdentifierAdapter(JpaDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String convertIdentifierToName(String identifier, DatabaseIdentifierAdapter.DefaultCallback defaultCallback) {
        return this.getDefaultDelimitedIdentifiers() ? identifier : defaultCallback.convertIdentifierToName(identifier);
    }

    public String convertNameToIdentifier(String name, DatabaseIdentifierAdapter.DefaultCallback defaultCallback) {
        return this.getDefaultDelimitedIdentifiers() ? name : defaultCallback.convertNameToIdentifier(name);
    }

    protected boolean getDefaultDelimitedIdentifiers() {
        PersistenceUnit2_0 pu = this.getPersistenceUnit();
        return pu != null && pu.getDefaultDelimitedIdentifiers();
    }

    protected PersistenceUnit2_0 getPersistenceUnit() {
        Persistence p = this.getPersistence();
        if (p == null) {
            return null;
        }
        ListIterator<PersistenceUnit> units = this.getPersistence().persistenceUnits();
        return (PersistenceUnit2_0)(units.hasNext() ? (PersistenceUnit)units.next() : null);
    }

    protected Persistence getPersistence() {
        PersistenceXml pxml = this.getPersistenceXml();
        return pxml == null ? null : pxml.getPersistence();
    }

    protected PersistenceXml getPersistenceXml() {
        JpaRootContextNode rcn = this.dataSource.getJpaProject().getRootContextNode();
        return rcn == null ? null : rcn.getPersistenceXml();
    }
}

