/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.core.resource.java.GenerationType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceGeneratedValueAnnotation
extends SourceAnnotation<Member>
implements GeneratedValueAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.GeneratedValue");
    private static final DeclarationAnnotationElementAdapter<String> STRATEGY_ADAPTER = SourceGeneratedValueAnnotation.buildStrategyAdapter();
    private final AnnotationElementAdapter<String> strategyAdapter;
    private GenerationType strategy;
    private static final DeclarationAnnotationElementAdapter<String> GENERATOR_ADAPTER = SourceGeneratedValueAnnotation.buildGeneratorAdapter();
    private final AnnotationElementAdapter<String> generatorAdapter;
    private String generator;

    public SourceGeneratedValueAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.strategyAdapter = new MemberAnnotationElementAdapter<String>(attribute, STRATEGY_ADAPTER);
        this.generatorAdapter = new MemberAnnotationElementAdapter<String>(attribute, GENERATOR_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.GeneratedValue";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.strategy = this.buildStrategy(astRoot);
        this.generator = this.buildGenerator(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncStrategy(this.buildStrategy(astRoot));
        this.syncGenerator(this.buildGenerator(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.strategy);
    }

    @Override
    public GenerationType getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(GenerationType strategy) {
        if (this.attributeValueHasChanged((Object)this.strategy, (Object)strategy)) {
            this.strategy = strategy;
            this.strategyAdapter.setValue(GenerationType.toJavaAnnotationValue(strategy));
        }
    }

    private void syncStrategy(GenerationType astStrategy) {
        GenerationType old = this.strategy;
        this.strategy = astStrategy;
        this.firePropertyChanged("strategy", (Object)old, (Object)astStrategy);
    }

    private GenerationType buildStrategy(CompilationUnit astRoot) {
        return GenerationType.fromJavaAnnotationValue(this.strategyAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getStrategyTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(STRATEGY_ADAPTER, astRoot);
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public void setGenerator(String generator) {
        if (this.attributeValueHasChanged(this.generator, generator)) {
            this.generator = generator;
            this.generatorAdapter.setValue(generator);
        }
    }

    private void syncGenerator(String astGenerator) {
        String old = this.generator;
        this.generator = astGenerator;
        this.firePropertyChanged("generator", old, astGenerator);
    }

    private String buildGenerator(CompilationUnit astRoot) {
        return this.generatorAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getGeneratorTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(GENERATOR_ADAPTER, astRoot);
    }

    @Override
    public boolean generatorTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(GENERATOR_ADAPTER, pos, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "strategy", false);
    }

    private static DeclarationAnnotationElementAdapter<String> buildGeneratorAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(DECLARATION_ANNOTATION_ADAPTER, "generator", false);
    }
}

