/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.internal.command.J2EEClipboard;
import org.eclipse.wst.common.internal.emf.utilities.CopyGroup;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class J2EECopyCommand
extends AbstractCommand {
    protected EObject objectToCopy;
    protected EObject bindingToCopy;
    protected EObject extensionToCopy;
    protected J2EEClipboard result;
    protected EtoolsCopyUtility copyUtil;

    public J2EECopyCommand(EObject object, EObject binding, EObject extension, EtoolsCopyUtility copyUtility) {
        this.objectToCopy = object;
        this.bindingToCopy = binding;
        this.extensionToCopy = extension;
        this.copyUtil = copyUtility;
    }

    public void execute() {
        CopyGroup group = new CopyGroup();
        group.add(this.objectToCopy);
        if (this.bindingToCopy != null) {
            group.add(this.bindingToCopy);
        }
        if (this.extensionToCopy != null) {
            group.add(this.extensionToCopy);
        }
        this.copyUtil.copy(group);
        EObject copy = this.copyUtil.getCopy(this.objectToCopy);
        this.result = new J2EEClipboard(Collections.singleton(copy));
        if (this.bindingToCopy != null) {
            this.result.addBinding(copy, this.copyUtil.getCopy(this.bindingToCopy));
        }
        if (this.extensionToCopy != null) {
            this.result.addExtension(copy, this.copyUtil.getCopy(this.extensionToCopy));
        }
    }

    public Collection getAffectedObjects() {
        return this.result;
    }

    public Collection getResult() {
        return this.result;
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }
}

