/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.CallbackChangeSupport;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;

public abstract class AbstractJavaResourceNode
extends AbstractModel
implements JavaResourceNode {
    protected final JavaResourceNode parent;

    protected AbstractJavaResourceNode(JavaResourceNode parent) {
        this.checkParent(parent);
        this.parent = parent;
    }

    protected void checkParent(JavaResourceNode p) {
        if (p == null) {
            if (this.requiresParent()) {
                throw new IllegalArgumentException("'parent' cannot be null");
            }
        } else if (this.forbidsParent()) {
            throw new IllegalArgumentException("'parent' must be null");
        }
    }

    protected boolean requiresParent() {
        return true;
    }

    protected boolean forbidsParent() {
        return !this.requiresParent();
    }

    protected final ChangeSupport buildChangeSupport() {
        return new CallbackChangeSupport((Model)this, this.buildChangeSupportListener());
    }

    private CallbackChangeSupport.Listener buildChangeSupportListener() {
        return new CallbackChangeSupport.Listener(){

            public void aspectChanged(String aspectName) {
                AbstractJavaResourceNode.this.aspectChanged(aspectName);
            }
        };
    }

    protected void aspectChanged(String aspectName) {
        this.getRoot().resourceModelChanged();
    }

    public JavaResourceNode.Root getRoot() {
        return this.parent.getRoot();
    }

    public IFile getFile() {
        return this.getRoot().getFile();
    }

    protected JpaAnnotationProvider getAnnotationProvider() {
        return this.getRoot().getAnnotationProvider();
    }
}

