/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseNamedQueryAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceQueryHintAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableNamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NestableQueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceNamedNativeQueryAnnotation
extends SourceBaseNamedQueryAnnotation
implements NestableNamedNativeQueryAnnotation {
    public static final SimpleDeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.NamedNativeQuery");
    private final DeclarationAnnotationElementAdapter<String> resultClassDeclarationAdapter;
    private final AnnotationElementAdapter<String> resultClassAdapter;
    private String resultClass;
    private String fullyQualifiedResultClassName;
    private final DeclarationAnnotationElementAdapter<String> resultSetMappingDeclarationAdapter;
    private final AnnotationElementAdapter<String> resultSetMappingAdapter;
    private String resultSetMapping;

    public SourceNamedNativeQueryAnnotation(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, type, daa, annotationAdapter);
        this.resultClassDeclarationAdapter = this.buildResultClassAdapter(daa);
        this.resultClassAdapter = this.buildAdapter(this.resultClassDeclarationAdapter);
        this.resultSetMappingDeclarationAdapter = this.buildResultSetMappingAdapter(daa);
        this.resultSetMappingAdapter = this.buildAdapter(this.resultSetMappingDeclarationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.NamedNativeQuery";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.resultClass = this.buildResultClass(astRoot);
        this.fullyQualifiedResultClassName = this.buildFullyQualifiedResultClassName(astRoot);
        this.resultSetMapping = this.buildResultSetMapping(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncResultClass(this.buildResultClass(astRoot));
        this.syncFullyQualifiedResultClassName(this.buildFullyQualifiedResultClassName(astRoot));
        this.syncResultSetMapping(this.buildResultSetMapping(astRoot));
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getQueryElementName() {
        return "query";
    }

    @Override
    String getHintsElementName() {
        return "hints";
    }

    @Override
    NestableQueryHintAnnotation buildHint(int index) {
        return SourceQueryHintAnnotation.createNamedNativeQueryQueryHint(this, (Type)this.member, this.daa, index);
    }

    @Override
    public String getResultClass() {
        return this.resultClass;
    }

    @Override
    public void setResultClass(String resultClass) {
        if (this.attributeValueHasChanged(this.resultClass, resultClass)) {
            this.resultClass = resultClass;
            this.resultClassAdapter.setValue(resultClass);
        }
    }

    private void syncResultClass(String astResultClass) {
        String old = this.resultClass;
        this.resultClass = astResultClass;
        this.firePropertyChanged("resultClass", old, astResultClass);
    }

    private String buildResultClass(CompilationUnit astRoot) {
        return this.resultClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getResultClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultClassDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultClassAdapter(DeclarationAnnotationAdapter daAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(daAdapter, "resultClass", SimpleTypeStringExpressionConverter.instance());
    }

    @Override
    public String getFullyQualifiedResultClassName() {
        return this.fullyQualifiedResultClassName;
    }

    private void syncFullyQualifiedResultClassName(String astName) {
        String old = this.fullyQualifiedResultClassName;
        this.fullyQualifiedResultClassName = astName;
        this.firePropertyChanged("fullyQualifiedResultClassName", old, astName);
    }

    private String buildFullyQualifiedResultClassName(CompilationUnit astRoot) {
        return this.resultClass == null ? null : ASTTools.resolveFullyQualifiedName(this.resultClassAdapter.getExpression(astRoot));
    }

    @Override
    public String getResultSetMapping() {
        return this.resultSetMapping;
    }

    @Override
    public void setResultSetMapping(String resultSetMapping) {
        if (this.attributeValueHasChanged(this.resultSetMapping, resultSetMapping)) {
            this.resultSetMapping = resultSetMapping;
            this.resultSetMappingAdapter.setValue(resultSetMapping);
        }
    }

    private void syncResultSetMapping(String astResultSetMapping) {
        String old = this.resultSetMapping;
        this.resultSetMapping = astResultSetMapping;
        this.firePropertyChanged("resultSetMapping", old, astResultSetMapping);
    }

    private String buildResultSetMapping(CompilationUnit astRoot) {
        return this.resultSetMappingAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getResultSetMappingTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.resultSetMappingDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildResultSetMappingAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daAdapter, "resultSetMapping");
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        NamedNativeQueryAnnotation oldQuery = (NamedNativeQueryAnnotation)((Object)oldAnnotation);
        this.setResultClass(oldQuery.getResultClass());
        this.setResultSetMapping(oldQuery.getResultSetMapping());
    }

    public static SourceNamedNativeQueryAnnotation createNamedNativeQuery(JavaResourceNode parent, Type type) {
        return new SourceNamedNativeQueryAnnotation(parent, type, (DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(type, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceNamedNativeQueryAnnotation createNestedNamedNativeQuery(JavaResourceNode parent, Type type, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceNamedNativeQueryAnnotation.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter((Member)type, idaa);
        return new SourceNamedNativeQueryAnnotation(parent, type, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter namedQueriesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedQueriesAdapter, index, "javax.persistence.NamedNativeQuery");
    }
}

