/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryHint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.java.JavaQueryHint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.BaseNamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaQuery
extends AbstractJavaJpaContextNode
implements JavaQuery {
    protected String name;
    protected String query;
    protected final Vector<JavaQueryHint> hints = new Vector();
    protected BaseNamedQueryAnnotation queryAnnotation;

    protected AbstractJavaQuery(JavaJpaContextNode parent) {
        super(parent);
    }

    protected BaseNamedQueryAnnotation getResourceQuery() {
        return this.queryAnnotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.queryAnnotation.setName(newName);
        this.firePropertyChanged("name", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        this.queryAnnotation.setQuery(newQuery);
        this.firePropertyChanged("query", oldQuery, newQuery);
    }

    protected void setQuery_(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        this.firePropertyChanged("query", oldQuery, newQuery);
    }

    @Override
    public ListIterator<JavaQueryHint> hints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public JavaQueryHint addHint(int index) {
        JavaQueryHint hint = this.getJpaFactory().buildJavaQueryHint(this);
        this.hints.add(index, hint);
        this.getResourceQuery().addHint(index);
        this.fireItemAdded("hints", index, hint);
        return hint;
    }

    protected void addHint(int index, JavaQueryHint hint) {
        this.addItemToList(index, hint, this.hints, "hints");
    }

    protected void addHint(JavaQueryHint hint) {
        this.addHint(this.hints.size(), hint);
    }

    @Override
    public void removeHint(QueryHint queryHint) {
        this.removeHint(this.hints.indexOf(queryHint));
    }

    @Override
    public void removeHint(int index) {
        JavaQueryHint removedHint = this.hints.remove(index);
        this.getResourceQuery().removeHint(index);
        this.fireItemRemoved("hints", index, removedHint);
    }

    protected void removeHint_(JavaQueryHint hint) {
        this.removeItemFromList(hint, this.hints, "hints");
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.hints, (int)targetIndex, (int)sourceIndex);
        this.getResourceQuery().moveHint(targetIndex, sourceIndex);
        this.fireItemMoved("hints", targetIndex, sourceIndex);
    }

    protected void initialize(BaseNamedQueryAnnotation annotation) {
        this.queryAnnotation = annotation;
        this.name = annotation.getName();
        this.query = annotation.getQuery();
        this.initializeQueryHints();
    }

    protected void update(BaseNamedQueryAnnotation annotation) {
        this.queryAnnotation = annotation;
        this.setName_(annotation.getName());
        this.setQuery_(annotation.getQuery());
        this.updateQueryHints();
        this.getPersistenceUnit().addQuery(this);
    }

    protected void initializeQueryHints() {
        ListIterator<QueryHintAnnotation> resourceHints = this.queryAnnotation.hints();
        while (resourceHints.hasNext()) {
            this.hints.add(this.createQueryHint(resourceHints.next()));
        }
    }

    protected void updateQueryHints() {
        ListIterator<JavaQueryHint> contextHints = this.hints();
        ListIterator<QueryHintAnnotation> resourceHints = this.queryAnnotation.hints();
        while (contextHints.hasNext()) {
            JavaQueryHint hint = contextHints.next();
            if (resourceHints.hasNext()) {
                hint.update(resourceHints.next());
                continue;
            }
            this.removeHint_(hint);
        }
        while (resourceHints.hasNext()) {
            this.addHint(this.createQueryHint(resourceHints.next()));
        }
    }

    protected JavaQueryHint createQueryHint(QueryHintAnnotation resourceQueryHint) {
        JavaQueryHint queryHint = this.getJpaFactory().buildJavaQueryHint(this);
        queryHint.initialize(resourceQueryHint);
        return queryHint;
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.queryAnnotation.getTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.queryAnnotation.getNameTextRange(astRoot);
    }

    @Override
    public boolean overrides(Query other) {
        return false;
    }

    @Override
    public boolean duplicates(Query other) {
        return this != other && !StringTools.stringIsEmpty((String)this.name) && this.name.equals(other.getName()) && !this.overrides(other) && !other.overrides(this);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

