/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.editor.IServerEditorInput;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorInputFactory;

public class ServerEditorInput
implements IServerEditorInput,
IPersistableElement {
    private String serverId;

    public ServerEditorInput(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServerEditorInput)) {
            return false;
        }
        ServerEditorInput other = (ServerEditorInput)obj;
        return !(this.serverId == null ? other.serverId != null : !this.serverId.equals(other.serverId));
    }

    public boolean exists() {
        return this.serverId == null || ServerCore.findServer((String)this.serverId) != null;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getFactoryId() {
        return "org.eclipse.wst.server.ui.editor.input.factory";
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageResource.getImageDescriptor("server");
    }

    public String getName() {
        if (this.serverId != null) {
            IServer server = ServerCore.findServer((String)this.serverId);
            if (server != null) {
                return server.getName();
            }
            return this.serverId;
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        IServer server;
        String s = null;
        if (this.serverId != null && (server = ServerCore.findServer((String)this.serverId)) != null) {
            Server server2 = (Server)server;
            if (server2.getFile() != null) {
                s = server2.getFile().getFullPath().makeRelative().toString();
                if (s.startsWith("/")) {
                    s = s.substring(1);
                }
            } else {
                s = server.getName();
            }
        }
        if (s == null) {
            s = "";
        }
        return s;
    }

    public void saveState(IMemento memento) {
        ServerEditorInputFactory.saveState(memento, this);
    }
}

