/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CodeActionCompletionProposal
implements ICompletionProposal {
    private CodeAction fcodeAction;
    private Command fcommand;
    private String fdisplayString;
    private final LanguageServerWrapper serverWrapper;

    public CodeActionCompletionProposal(Either<Command, CodeAction> command, LanguageServerWrapper serverWrapper) {
        this.serverWrapper = serverWrapper;
        if (command.isLeft()) {
            this.fcommand = (Command)command.getLeft();
            this.fdisplayString = this.fcommand.getTitle();
        } else if (command.isRight()) {
            this.fcodeAction = (CodeAction)command.getRight();
            this.fdisplayString = this.fcodeAction.getTitle();
        }
    }

    static boolean isCodeActionResolveSupported(ServerCapabilities capabilities) {
        if (capabilities != null) {
            CodeActionOptions options;
            Boolean resolveProvider;
            Either caProvider = capabilities.getCodeActionProvider();
            if (caProvider.isLeft()) {
                return (Boolean)caProvider.getLeft();
            }
            if (caProvider.isRight() && (resolveProvider = (options = (CodeActionOptions)caProvider.getRight()).getResolveProvider()) != null) {
                return resolveProvider;
            }
        }
        return false;
    }

    public void apply(IDocument document) {
        if (this.fcodeAction != null) {
            if (CodeActionCompletionProposal.isCodeActionResolveSupported(this.serverWrapper.getServerCapabilities()) && this.fcodeAction.getEdit() == null) {
                this.serverWrapper.execute(ls -> ls.getTextDocumentService().resolveCodeAction(this.fcodeAction)).thenAccept(this::apply);
            } else {
                this.apply(this.fcodeAction);
            }
        } else if (this.fcommand != null) {
            this.executeCommand(this.fcommand);
        }
    }

    private void apply(CodeAction codeaction) {
        if (codeaction != null) {
            if (codeaction.getEdit() != null) {
                LSPEclipseUtils.applyWorkspaceEdit(codeaction.getEdit(), codeaction.getTitle());
            }
            if (codeaction.getCommand() != null) {
                this.executeCommand(codeaction.getCommand());
            }
        }
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return "";
    }

    public String getDisplayString() {
        return this.fdisplayString;
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation("some context display string", "some information display string");
    }

    private void executeCommand(Command command) {
        ExecuteCommandOptions provider;
        ServerCapabilities capabilities = this.serverWrapper.getServerCapabilities();
        if (capabilities != null && (provider = capabilities.getExecuteCommandProvider()) != null && provider.getCommands().contains(command.getCommand())) {
            ExecuteCommandParams params = new ExecuteCommandParams();
            params.setCommand(command.getCommand());
            params.setArguments(command.getArguments());
            this.serverWrapper.execute(ls -> ls.getWorkspaceService().executeCommand(params));
        }
    }
}

