/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.model;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.CommentRule;
import org.eclipse.tm4e.languageconfiguration.internal.model.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.FoldingRules;
import org.eclipse.tm4e.languageconfiguration.internal.model.OnEnterRule;
import org.eclipse.tm4e.languageconfiguration.internal.utils.RegExpUtils;

public class LanguageConfiguration {
    private @Nullable CommentRule comments;
    private @Nullable List<CharacterPair> brackets;
    private @Nullable String wordPattern;
    private @Nullable List<OnEnterRule> onEnterRules;
    private @Nullable List<AutoClosingPairConditional> autoClosingPairs;
    private @Nullable List<AutoClosingPair> surroundingPairs;
    private @Nullable String autoCloseBefore;
    private @Nullable FoldingRules folding;

    @NonNullByDefault(value={})
    public static @Nullable LanguageConfiguration load(@NonNull Reader reader) {
        return (LanguageConfiguration)new GsonBuilder().registerTypeAdapter(OnEnterRule.class, (json, typeOfT, context) -> {
            JsonObject actionJsonObj;
            String indentActionString;
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            Pattern beforeText = LanguageConfiguration.getAsPattern(jsonObj.get("beforeText"));
            if (beforeText == null) {
                return null;
            }
            JsonElement actionElem = jsonObj.get("action");
            if (actionElem != null && actionElem.isJsonObject() && (indentActionString = LanguageConfiguration.getAsString((actionJsonObj = actionElem.getAsJsonObject()).get("indent"))) != null) {
                Pattern afterText = LanguageConfiguration.getAsPattern(jsonObj.get("afterText"));
                EnterAction.IndentAction indentAction = EnterAction.IndentAction.get(indentActionString);
                Integer removeText = LanguageConfiguration.getAsInteger(actionJsonObj.get("removeText"));
                String appendText = LanguageConfiguration.getAsString(actionJsonObj.get("appendText"));
                EnterAction action = new EnterAction(indentAction);
                action.appendText = appendText;
                action.removeText = removeText;
                return new OnEnterRule(beforeText, afterText, action);
            }
            return null;
        }).registerTypeAdapter(CommentRule.class, (json, typeOfT, context) -> {
            JsonArray blockCommentArray;
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            String lineComment = LanguageConfiguration.getAsString(jsonObj.get("lineComment"));
            JsonElement blockCommentElem = jsonObj.get("blockComment");
            CharacterPair blockComment = null;
            if (blockCommentElem != null && blockCommentElem.isJsonArray() && (blockCommentArray = blockCommentElem.getAsJsonArray()).size() == 2) {
                String blockCommentStart = LanguageConfiguration.getAsString(blockCommentArray.get(0));
                String blockCommentEnd = LanguageConfiguration.getAsString(blockCommentArray.get(1));
                if (blockCommentStart != null && blockCommentEnd != null) {
                    blockComment = new CharacterPair(blockCommentStart, blockCommentEnd);
                }
            }
            return lineComment == null && blockComment == null ? null : new CommentRule(lineComment, blockComment);
        }).registerTypeAdapter(CharacterPair.class, (json, typeOfT, context) -> {
            if (!json.isJsonArray()) {
                return null;
            }
            JsonArray charsPair = json.getAsJsonArray();
            if (charsPair.size() != 2) {
                return null;
            }
            String open = LanguageConfiguration.getAsString(charsPair.get(0));
            String close = LanguageConfiguration.getAsString(charsPair.get(1));
            return open == null || close == null ? null : new CharacterPair(open, close);
        }).registerTypeAdapter(AutoClosingPair.class, (json, typeOfT, context) -> {
            String open = null;
            String close = null;
            if (json.isJsonArray()) {
                JsonArray charsPair = json.getAsJsonArray();
                if (charsPair.size() != 2) {
                    return null;
                }
                open = LanguageConfiguration.getAsString(charsPair.get(0));
                close = LanguageConfiguration.getAsString(charsPair.get(1));
            } else if (json.isJsonObject()) {
                JsonObject autoClosePair = json.getAsJsonObject();
                open = LanguageConfiguration.getAsString(autoClosePair.get("open"));
                close = LanguageConfiguration.getAsString(autoClosePair.get("close"));
            }
            return open == null || close == null ? null : new AutoClosingPair(open, close);
        }).registerTypeAdapter(AutoClosingPairConditional.class, (json, typeOfT, context) -> {
            ArrayList<String> notInList = new ArrayList<String>(2);
            String open = null;
            String close = null;
            if (json.isJsonArray()) {
                JsonArray charsPair = json.getAsJsonArray();
                if (charsPair.size() != 2) {
                    return null;
                }
                open = LanguageConfiguration.getAsString(charsPair.get(0));
                close = LanguageConfiguration.getAsString(charsPair.get(1));
            } else if (json.isJsonObject()) {
                JsonObject autoClosePair = json.getAsJsonObject();
                open = LanguageConfiguration.getAsString(autoClosePair.get("open"));
                close = LanguageConfiguration.getAsString(autoClosePair.get("close"));
                JsonElement notInElem = autoClosePair.get("notIn");
                if (notInElem != null && notInElem.isJsonArray()) {
                    notInElem.getAsJsonArray().forEach(element -> {
                        String string = LanguageConfiguration.getAsString(element);
                        if (string != null) {
                            notInList.add(string);
                        }
                    });
                }
            }
            return open == null || close == null ? null : new AutoClosingPairConditional(open, close, notInList);
        }).registerTypeAdapter(FoldingRules.class, (json, typeOfT, context) -> {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            JsonElement markersElem = jsonObj.get("markers");
            if (markersElem != null && markersElem.isJsonObject()) {
                JsonObject markersObj = markersElem.getAsJsonObject();
                Pattern startMarker = LanguageConfiguration.getAsPattern(markersObj.get("start"));
                Pattern endMarker = LanguageConfiguration.getAsPattern(markersObj.get("end"));
                if (startMarker != null && endMarker != null) {
                    boolean offSide = LanguageConfiguration.getAsBoolean(jsonObj.get("offSide"), false);
                    return new FoldingRules(offSide, startMarker, endMarker);
                }
            }
            return null;
        }).create().fromJson((Reader)new BufferedReader(reader), LanguageConfiguration.class);
    }

    private static @Nullable Pattern getAsPattern(@Nullable JsonElement element) {
        String pattern = LanguageConfiguration.getPattern(element);
        return pattern == null ? null : RegExpUtils.create(pattern);
    }

    private static @Nullable String getPattern(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        if (element.isJsonObject()) {
            String pattern = LanguageConfiguration.getAsString(((JsonObject)element).get("pattern"));
            if (pattern == null) {
                return null;
            }
            String flags = LanguageConfiguration.getAsString(((JsonObject)element).get("flags"));
            return flags != null ? String.valueOf(pattern) + "(?" + flags + ")" : pattern;
        }
        return LanguageConfiguration.getAsString(element);
    }

    private static @Nullable String getAsString(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        try {
            return element.getAsString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean getAsBoolean(@Nullable JsonElement element, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        try {
            return element.getAsBoolean();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static @Nullable Integer getAsInteger(@Nullable JsonElement element) {
        if (element == null) {
            return null;
        }
        try {
            return element.getAsInt();
        }
        catch (Exception e) {
            return null;
        }
    }

    public @Nullable CommentRule getComments() {
        return this.comments;
    }

    public @Nullable List<CharacterPair> getBrackets() {
        return this.brackets;
    }

    public @Nullable String getWordPattern() {
        return this.wordPattern;
    }

    public @Nullable List<OnEnterRule> getOnEnterRules() {
        return this.onEnterRules;
    }

    public @Nullable List<AutoClosingPairConditional> getAutoClosingPairs() {
        return this.autoClosingPairs;
    }

    public @Nullable List<AutoClosingPair> getSurroundingPairs() {
        return this.surroundingPairs;
    }

    public @Nullable String getAutoCloseBefore() {
        return this.autoCloseBefore;
    }

    public @Nullable FoldingRules getFolding() {
        return this.folding;
    }
}

