#include <stdio.h>
#include <string.h>

#include <libbonobo.h>

#include "Evolution-DataServer-Mail.h"
#include "e-mail-remote-glue-sessionchange.h"
#include "e-mail-remote-glue-storeinfo.h"

static void e_mail_remote_glue_sessionchange_class_init (EMailRemoteGlueSessionChangeClass *klass);
static void e_mail_remote_glue_sessionchange_init (EMailRemoteGlueSessionChange *comp, EMailRemoteGlueSessionChangeClass *klass);
static void e_mail_remote_glue_sessionchange_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

/**
 * e_mail_remote_glue_sessionchange_get_type:
 *
 * Registers the #EMailRemoteGlueSessionChange class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueSessionChange class.
 **/
GType
e_mail_remote_glue_sessionchange_get_type (void)
{
  static GType e_mail_remote_glue_sessionchange_type = 0;

  if (!e_mail_remote_glue_sessionchange_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueSessionChangeClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_sessionchange_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueSessionChange),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_sessionchange_init
    };
    e_mail_remote_glue_sessionchange_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueSessionChange", &info, 0);
  }

  return e_mail_remote_glue_sessionchange_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_sessionchange_class_init (EMailRemoteGlueSessionChangeClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_sessionchange_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_sessionchange_init (EMailRemoteGlueSessionChange *emrg_schange, EMailRemoteGlueSessionChangeClass *klass)
{  
  emrg_schange->store_infos = NULL;
}

/**
 * e_mail_remote_glue_sessionchange_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueSessionChange *
e_mail_remote_glue_sessionchange_new (void)
{
  return E_MAIL_REMOTE_GLUE_SESSIONCHANGE (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_SESSIONCHANGE, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_sessionchange_finalize (GObject *object)
{
  EMailRemoteGlueSessionChange *fchange;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_SESSIONCHANGE (object));

  fchange = E_MAIL_REMOTE_GLUE_SESSIONCHANGE (object);

  if (fchange->store_infos) {
    g_slist_foreach (fchange->store_infos, (GFunc)g_object_unref, NULL);
    g_slist_free (fchange->store_infos);
  }
  
  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueSessionChange*
e_mail_remote_glue_sessionchange_new_clone (EMailRemoteGlueSessionChange* sess_change)
{
  EMailRemoteGlueSessionChange* emrg_sess_change = NULL;
  EMailRemoteGlueStoreInfo* storeinfo = NULL;
  GSList* l;

  emrg_sess_change = e_mail_remote_glue_sessionchange_new ();
  for (l = sess_change->store_infos; l; l = l->next) {
    storeinfo = e_mail_remote_glue_storeinfo_new_clone (l->data);
    emrg_sess_change->store_infos = g_slist_append (emrg_sess_change->store_infos, storeinfo);
  }
  return emrg_sess_change;
}


EMailRemoteGlueSessionChange*
e_mail_remote_glue_sessionchange_new_from_EMSessionChange (Evolution_Mail_SessionChange sess_change)
{
  EMailRemoteGlueSessionChange* emrg_sess_change;
  EMailRemoteGlueStoreInfo* storeinfo = NULL;
  int i = 0;

  emrg_sess_change = e_mail_remote_glue_sessionchange_new ();
  for (i = 0; i < sess_change.stores._length; i++) {
    storeinfo = e_mail_remote_glue_storeinfo_new_from_EMStoreInfo (sess_change.stores._buffer[i]);
    emrg_sess_change->store_infos = g_slist_append (emrg_sess_change->store_infos, storeinfo);
  }
  return emrg_sess_change;
}

GSList*
e_mail_remote_glue_sessionchange_get_store_info_list (EMailRemoteGlueSessionChange* sess_change)
{
  g_return_val_if_fail (sess_change != NULL, NULL);
  return sess_change->store_infos;
}
