/* -*- Mode: C; c-basic-offset: 4 -*- */

#include <pygobject.h>
#include <pyorbit.h>
#include <bonobo/bonobo-types.h>

static PyObject *
PyBonoboArg_from_value(const GValue *value)
{
    return pycorba_any_new(g_value_get_boxed(value));

}
static int
PyBonoboArg_to_value(GValue *value, PyObject *object)
{
    CORBA_any any = ((PyCORBA_Any*)object)->any;
    
    g_value_set_boxed(value, &any);
    return 0;
}
static PyObject *
PyBonoboArgType_from_value(const GValue *value)
{
    return pycorba_typecode_new(g_value_get_boxed(value));

}
static int
PyBonoboArgType_to_value(GValue *value, PyObject *object)
{
    CORBA_TypeCode tc = ((PyCORBA_TypeCode*)object)->tc;
    
    g_value_set_boxed(value, &tc);
    return 0;
}

void
_pybonobo_register_boxed_types(PyObject *moddict)
{
	pyg_register_boxed_custom(BONOBO_TYPE_STATIC_CORBA_ANY,
				  PyBonoboArg_from_value,
				  PyBonoboArg_to_value);
	pyg_register_boxed_custom(BONOBO_TYPE_STATIC_CORBA_TYPECODE,
				  PyBonoboArgType_from_value,
				  PyBonoboArgType_to_value);
}

