/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator;

import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.FileMenu;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class ROMGenerator {
    private static int globalbits;
    private static int folds;
    private static double lambda;
    private static Technology tech;

    public static void generateROM() {
        String romfile = OpenFile.chooseInputFile(FileType.TEXT, null);
        if (romfile == null) {
            return;
        }
        DoROM rom = new DoROM(romfile);
    }

    public static Cell makeAROM(String romfile, String romcell) {
        PortProto apport1;
        NodeInst ap1;
        int i;
        int i2;
        int i3;
        int i4;
        tech = Technology.findTechnology("mocmos");
        int[][] romarray = ROMGenerator.romarraygen(romfile);
        String dpr = new String(romcell + "_decoderpmos");
        String dnr = new String(romcell + "_decodernmos");
        String dpm = new String(romcell + "_decoderpmosmux");
        String dnm = new String(romcell + "_decodernmosmux");
        String invt = new String(romcell + "_invertertop");
        String invb = new String(romcell + "_inverterbot");
        String romname = new String(romcell + "_rom");
        String rp = new String(romcell + "_romplane");
        String ip = new String(romcell + "_inverterplane");
        String mp = new String(romcell + "_muxplane");
        if (folds > 1) {
            romarray = ROMGenerator.romfold(romarray);
        }
        ROMGenerator.romplane(lambda, romarray, rp);
        int bits = new Double(Math.ceil(Math.log(globalbits) / Math.log(2.0))).intValue();
        int words = (int)Math.pow(2.0, bits);
        int foldbits = new Double(Math.ceil(Math.log(folds) / Math.log(2.0))).intValue();
        boolean top = true;
        boolean bot = false;
        ROMGenerator.decoderpmos(lambda, bits, dpr, top);
        ROMGenerator.decodernmos(lambda, bits, dnr, top);
        ROMGenerator.inverterplane(lambda, romarray.length, folds, ip);
        ROMGenerator.ininverterplane(lambda, bits, invt, top, bits);
        ArcProto m1arc = tech.findArcProto("Metal-1");
        ArcProto m2arc = tech.findArcProto("Metal-2");
        Cell decp = (Cell)Cell.findNodeProto(dpr + "{lay}");
        Rectangle2D decpBounds = decp.getBounds();
        PortProto[] decpin = new PortProto[words];
        PortProto[] decpout = new PortProto[words];
        PortProto[] decpbit = new PortProto[2 * bits];
        PortProto decpvdd = decp.findPortProto("vdd");
        PortProto decpvddb = decp.findPortProto("vddb");
        for (i4 = 0; i4 < words; ++i4) {
            decpin[i4] = decp.findPortProto("wordin" + i4);
            decpout[i4] = decp.findPortProto("word" + i4);
        }
        for (i4 = 0; i4 < bits; ++i4) {
            decpbit[2 * i4] = decp.findPortProto("top_in" + i4);
            decpbit[2 * i4 + 1] = decp.findPortProto("top_in" + i4 + "_b");
        }
        Cell decn = (Cell)Cell.findNodeProto(dnr + "{lay}");
        Rectangle2D decnBounds = decn.getBounds();
        PortProto[] decnout = new PortProto[words];
        PortProto[] decnin = new PortProto[words];
        PortProto[] decnbit = new PortProto[2 * bits];
        for (i3 = 0; i3 < words; ++i3) {
            decnin[i3] = decn.findPortProto("mid" + i3);
            decnout[i3] = decn.findPortProto("word" + i3);
        }
        for (i3 = 0; i3 < bits; ++i3) {
            decnbit[2 * i3] = decn.findPortProto("top_in" + i3);
            decnbit[2 * i3 + 1] = decn.findPortProto("top_in" + i3 + "_b");
        }
        Cell romp = (Cell)Cell.findNodeProto(rp + "{lay}");
        Rectangle2D rompBounds = romp.getBounds();
        PortProto[] rompin = new PortProto[globalbits];
        PortProto[] rompout = new PortProto[romarray.length];
        PortProto[] rompgnd = new PortProto[romarray.length / 2];
        PortProto rompvdd = romp.findPortProto("vdd");
        PortProto rompgndc = romp.findPortProto("gndc");
        for (i2 = 0; i2 < globalbits; ++i2) {
            rompin[i2] = romp.findPortProto("wordline_" + i2);
        }
        for (i2 = 0; i2 < romarray.length; ++i2) {
            rompout[i2] = romp.findPortProto("out_" + i2);
        }
        for (i2 = 0; i2 < romarray.length / 2; ++i2) {
            rompgnd[i2] = romp.findPortProto("romgnd" + i2);
        }
        Cell invp = (Cell)Cell.findNodeProto(ip + "{lay}");
        Rectangle2D invpBounds = invp.getBounds();
        PortProto[] invin = new PortProto[romarray.length];
        PortProto[] invout = new PortProto[romarray.length];
        PortProto[] invgnd = new PortProto[romarray.length / 2];
        PortProto invvddc = invp.findPortProto("vdd");
        PortProto invgndc = invp.findPortProto("gnd");
        for (int i5 = 0; i5 < romarray.length / folds; ++i5) {
            invin[i5] = invp.findPortProto("invin" + i5);
            invout[i5] = invp.findPortProto("invout" + i5);
        }
        int invplanegnd = romarray.length / folds;
        if (folds == 1) {
            invplanegnd /= 2;
        }
        for (int i6 = 0; i6 < invplanegnd; ++i6) {
            invgnd[i6] = invp.findPortProto("invgnd" + i6);
        }
        Cell ininvtp = (Cell)Cell.findNodeProto(invt + "{lay}");
        Rectangle2D ininvtpBounds = ininvtp.getBounds();
        PortProto[] ivttop = new PortProto[bits];
        PortProto[] ivtbot = new PortProto[bits];
        PortProto[] ivtbar = new PortProto[bits];
        PortProto ivtvdd = ininvtp.findPortProto("vdd");
        PortProto ivtgnd = ininvtp.findPortProto("gnd");
        for (int i7 = 0; i7 < bits; ++i7) {
            ivttop[i7] = ininvtp.findPortProto("in_top" + i7);
            ivtbot[i7] = ininvtp.findPortProto("in_bot" + i7);
            ivtbar[i7] = ininvtp.findPortProto("in_b" + i7);
        }
        Cell rom = Cell.newInstance(Library.getCurrent(), romname + "{lay}");
        double offset = (double)(2 * bits) * (8.0 * lambda) + 16.0 * lambda;
        double rompoffset = 8.0 * lambda * 2.0 * (double)bits + 12.0 * lambda + offset;
        double rompoffsety = 8.0 * lambda * (double)(globalbits + 1);
        double foldoffsetx = (double)(2 * (bits - foldbits)) * (8.0 * lambda);
        double muxpoffsety = -6.0 * lambda;
        double foldoffsety = -8.0 * lambda * (double)(folds + 1);
        double ininvtoffset = (double)((globalbits + 2) * 8) * lambda + 48.0 * lambda;
        double invpoffsety = -8.0 * lambda * (double)(folds + 1) - 16.0 * lambda;
        if (folds == 1) {
            invpoffsety += 24.0 * lambda;
        }
        NodeInst nplane = ROMGenerator.makeCStyleNodeInst(decn, decnBounds.getMinX() + offset, decnBounds.getMaxX() + offset, decnBounds.getMinY(), decnBounds.getMaxY(), 0, 0, rom);
        NodeInst pplane = ROMGenerator.makeCStyleNodeInst(decp, decpBounds.getMinX(), decpBounds.getMaxX(), decpBounds.getMinY(), decpBounds.getMaxY(), 0, 0, rom);
        NodeInst rompln = ROMGenerator.makeCStyleNodeInst(romp, rompBounds.getMinX() + rompoffset, rompBounds.getMaxX() + rompoffset, rompBounds.getMinY() + rompoffsety, rompBounds.getMaxY() + rompoffsety, 0, 2700, rom);
        NodeInst invpln = ROMGenerator.makeCStyleNodeInst(invp, invpBounds.getMinX() + rompoffset, invpBounds.getMaxX() + rompoffset, invpBounds.getMinY() + invpoffsety, invpBounds.getMaxY() + invpoffsety, 0, 0, rom);
        NodeInst ininvtop1 = ROMGenerator.makeCStyleNodeInst(ininvtp, ininvtpBounds.getMinX(), ininvtpBounds.getMaxX(), ininvtpBounds.getMinY() + ininvtoffset, ininvtpBounds.getMaxY() + ininvtoffset, 0, 0, rom);
        NodeInst ininvtop2 = ROMGenerator.makeCStyleNodeInst(ininvtp, ininvtpBounds.getMinX() + offset, ininvtpBounds.getMaxX() + offset, ininvtpBounds.getMinY() + ininvtoffset, ininvtpBounds.getMaxY() + ininvtoffset, 0, 0, rom);
        for (i = 0; i < bits; ++i) {
            ap1 = ininvtop1;
            apport1 = ivttop[i];
            ROMGenerator.makeCStyleExport(rom, ap1, apport1, "sel" + i, PortCharacteristic.IN);
        }
        for (i = 0; i < romarray.length / folds; ++i) {
            ap1 = invpln;
            apport1 = invout[i];
            ROMGenerator.makeCStyleExport(rom, ap1, apport1, "out" + i, PortCharacteristic.OUT);
        }
        NodeInst ap2 = rompln;
        PortProto apport2 = rompvdd;
        ROMGenerator.makeCStyleExport(rom, ap2, apport2, "vdd", PortCharacteristic.PWR);
        ap1 = nplane;
        apport1 = decn.findPortProto("gnd");
        double[] appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = rompln;
        apport2 = rompgndc;
        double[] appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        apport2 = romp.findPortProto("gnd");
        for (i = 0; i < words; ++i) {
            ap1 = pplane;
            apport1 = decpout[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nplane;
            apport2 = decnin[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < words; ++i) {
            if (i >= globalbits) continue;
            ap1 = nplane;
            apport1 = decnout[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = rompln;
            apport2 = rompin[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (folds > 1) {
            for (i = 0; i < romarray.length / folds; ++i) {
                ap1 = invpln;
                apport1 = invgnd[i];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = rompln;
                apport2 = rompgnd[i * folds / 2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        } else {
            for (i = 0; i < romarray.length / (2 * folds); ++i) {
                ap1 = invpln;
                apport1 = invgnd[i];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = rompln;
                apport2 = rompgnd[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        }
        for (i = 0; i < bits; ++i) {
            ap1 = ininvtop1;
            apport1 = ivttop[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvtop2;
            apport2 = ivttop[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < bits; ++i) {
            ap1 = ininvtop1;
            apport1 = ivtbot[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pplane;
            apport2 = decpbit[i * 2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ininvtop1;
            apport1 = ivtbar[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pplane;
            apport2 = decpbit[i * 2 + 1];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < bits; ++i) {
            ap1 = ininvtop2;
            apport1 = ivtbot[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nplane;
            apport2 = decnbit[i * 2];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ininvtop2;
            apport1 = ivtbar[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nplane;
            apport2 = decnbit[i * 2 + 1];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = ininvtop1;
        apport1 = ivtvdd;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = ininvtop2;
        apport2 = ivtvdd;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        NodeInst ap3 = pplane;
        PortProto apport3 = decpvdd;
        double[] appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
        ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
        ap1 = ininvtop1;
        apport1 = ivtgnd;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = ininvtop2;
        apport2 = ivtgnd;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ap3 = rompln;
        apport3 = rompgndc;
        appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
        ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        ROMGenerator.makeCStyleExport(rom, ap2, apport2, "gnd", PortCharacteristic.GND);
        ap1 = ininvtop2;
        apport1 = ivtvdd;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = rompln;
        apport2 = rompvdd;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        if (folds > 1) {
            int i8;
            int i9;
            int i10;
            int i11;
            ROMGenerator.decoderpmos(lambda, foldbits, dpm, bot);
            ROMGenerator.decodernmos(lambda, foldbits, dnm, bot);
            ROMGenerator.ininverterplane(lambda, foldbits, invb, bot, bits);
            ROMGenerator.muxplane(lambda, folds, romarray.length, mp);
            Cell decpmux = (Cell)Cell.findNodeProto(dpm + "{lay}");
            Rectangle2D decpmuxBounds = decpmux.getBounds();
            PortProto[] decpmuxin = new PortProto[folds];
            PortProto[] decpmuxout = new PortProto[folds];
            PortProto[] decpmuxbit = new PortProto[2 * foldbits];
            PortProto decpmuxvdd = decpmux.findPortProto("vdd");
            PortProto decpmuxvddb = decpmux.findPortProto("vddb");
            for (i11 = 0; i11 < folds; ++i11) {
                decpmuxin[i11] = decpmux.findPortProto("wordin" + i11);
                decpmuxout[i11] = decpmux.findPortProto("word" + i11);
            }
            for (i11 = 0; i11 < foldbits; ++i11) {
                decpmuxbit[2 * i11] = decpmux.findPortProto("bot_in" + i11);
                decpmuxbit[2 * i11 + 1] = decpmux.findPortProto("bot_in" + i11 + "_b");
            }
            Cell decnmux = (Cell)Cell.findNodeProto(dnm + "{lay}");
            Rectangle2D decnmuxBounds = decnmux.getBounds();
            PortProto[] decnmuxout = new PortProto[folds];
            PortProto[] decnmuxin = new PortProto[folds];
            PortProto[] decnmuxbit = new PortProto[2 * foldbits];
            for (i10 = 0; i10 < folds; ++i10) {
                decnmuxin[i10] = decnmux.findPortProto("mid" + i10);
                decnmuxout[i10] = decnmux.findPortProto("word" + i10);
            }
            for (i10 = 0; i10 < foldbits; ++i10) {
                decnmuxbit[2 * i10] = decnmux.findPortProto("bot_in" + i10);
                decnmuxbit[2 * i10 + 1] = decnmux.findPortProto("bot_in" + i10 + "_b");
            }
            Cell muxp = (Cell)Cell.findNodeProto(mp + "{lay}");
            Rectangle2D muxpBounds = muxp.getBounds();
            PortProto[] muxin = new PortProto[romarray.length];
            PortProto[] muxout = new PortProto[romarray.length / folds];
            PortProto[] muxsel = new PortProto[folds];
            for (i9 = 0; i9 < romarray.length; ++i9) {
                muxin[i9] = muxp.findPortProto("muxin" + i9);
            }
            for (i9 = 0; i9 < romarray.length / folds; ++i9) {
                muxout[i9] = muxp.findPortProto("muxout" + i9);
            }
            for (i9 = 0; i9 < folds; ++i9) {
                muxsel[i9] = muxp.findPortProto("sel" + i9);
            }
            Cell ininvbp = (Cell)Cell.findNodeProto(invb + "{lay}");
            Rectangle2D ininvbpBounds = ininvbp.getBounds();
            PortProto[] ivbtop = new PortProto[foldbits];
            PortProto[] ivbbot = new PortProto[foldbits];
            PortProto[] ivbbar = new PortProto[foldbits];
            PortProto ivbvdd = ininvbp.findPortProto("vdd");
            PortProto ivbgnd = ininvbp.findPortProto("gnd");
            for (int i12 = 0; i12 < foldbits; ++i12) {
                ivbtop[i12] = ininvbp.findPortProto("in_top" + i12);
                ivbbot[i12] = ininvbp.findPortProto("in_bot" + i12);
                ivbbar[i12] = ininvbp.findPortProto("in_b" + i12);
            }
            NodeInst muxpln = ROMGenerator.makeCStyleNodeInst(muxp, muxpBounds.getMinX() + rompoffset, muxpBounds.getMaxX() + rompoffset, muxpBounds.getMinY() + muxpoffsety, muxpBounds.getMaxY() + muxpoffsety, 0, 2700, rom);
            NodeInst pplnmx = ROMGenerator.makeCStyleNodeInst(decpmux, decpmuxBounds.getMinX() + foldoffsetx, decpmuxBounds.getMaxX() + foldoffsetx, decpmuxBounds.getMinY() + muxpoffsety + foldoffsety, decpmuxBounds.getMaxY() + muxpoffsety + foldoffsety, 0, 0, rom);
            NodeInst nplnmx = ROMGenerator.makeCStyleNodeInst(decnmux, decnmuxBounds.getMinX() + foldoffsetx + offset, decnmuxBounds.getMaxX() + foldoffsetx + offset, decnmuxBounds.getMinY() + muxpoffsety + foldoffsety, decnmuxBounds.getMaxY() + muxpoffsety + foldoffsety, 0, 0, rom);
            NodeInst ininvbot1 = ROMGenerator.makeCStyleNodeInst(ininvbp, ininvbpBounds.getMinX() + foldoffsetx, ininvbpBounds.getMaxX() + foldoffsetx, ininvbpBounds.getMinY() + invpoffsety, ininvbpBounds.getMaxY() + invpoffsety, 0, 0, rom);
            NodeInst ininvbot2 = ROMGenerator.makeCStyleNodeInst(ininvbp, ininvbpBounds.getMinX() + foldoffsetx + offset, ininvbpBounds.getMaxX() + foldoffsetx + offset, ininvbpBounds.getMinY() + invpoffsety, ininvbpBounds.getMaxY() + invpoffsety, 0, 0, rom);
            for (i8 = 0; i8 < foldbits; ++i8) {
                ap1 = ininvbot1;
                apport1 = ivbbot[i8];
                ROMGenerator.makeCStyleExport(rom, ap1, apport1, "colsel" + i8, PortCharacteristic.IN);
            }
            ap1 = nplane;
            apport1 = decn.findPortProto("gnd");
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap3 = pplnmx;
            apport3 = decpmuxvdd;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            NodeInst ap4 = pplane;
            PortProto apport4 = decpvddb;
            double[] appos4 = ROMGenerator.getCStylePortPosition(ap4, apport4);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap4, apport4, appos4[0], appos4[1], ap3, apport3, appos3[0], appos3[1]);
            ap3 = nplnmx;
            apport3 = decnmux.findPortProto("gnd");
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
            for (i8 = 0; i8 < folds; ++i8) {
                ap1 = pplnmx;
                apport1 = decpmuxout[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = nplnmx;
                apport2 = decnmuxin[i8];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i8 = 0; i8 < folds; ++i8) {
                ap1 = nplnmx;
                apport1 = decnmuxout[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = muxpln;
                apport2 = muxsel[i8];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i8 = 0; i8 < romarray.length; ++i8) {
                ap1 = rompln;
                apport1 = rompout[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = muxpln;
                apport2 = muxin[i8];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i8 = 0; i8 < romarray.length / folds; ++i8) {
                ap1 = invpln;
                apport1 = invin[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = muxpln;
                apport2 = muxout[i8];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i8 = 0; i8 < foldbits; ++i8) {
                ap1 = ininvbot1;
                apport1 = ivbbot[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = ininvbot2;
                apport2 = ivbbot[i8];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i8 = 0; i8 < foldbits; ++i8) {
                ap1 = ininvbot1;
                apport1 = ivbtop[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = pplnmx;
                apport2 = decpmuxbit[i8 * 2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ininvbot1;
                apport1 = ivbbar[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = pplnmx;
                apport2 = decpmuxbit[i8 * 2 + 1];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i8 = 0; i8 < foldbits; ++i8) {
                ap1 = ininvbot2;
                apport1 = ivbtop[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = nplnmx;
                apport2 = decnmuxbit[i8 * 2];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ininvbot2;
                apport1 = ivbbar[i8];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = nplnmx;
                apport2 = decnmuxbit[i8 * 2 + 1];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ap1 = ininvbot1;
            apport1 = ivbvdd;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvbot2;
            apport2 = ivbvdd;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = pplnmx;
            apport3 = decpmuxvddb;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
            ap1 = ininvbot1;
            apport1 = ivbgnd;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvbot2;
            apport2 = ivbgnd;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = invpln;
            apport3 = invgndc;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap3, apport3, appos3[0], appos3[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = invpln;
            apport1 = invvddc;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ininvbot2;
            apport2 = ivbvdd;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (folds == 1) {
            for (int i13 = 0; i13 < romarray.length; ++i13) {
                ap1 = invpln;
                apport1 = invin[i13];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = rompln;
                apport2 = rompout[i13];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            PrimitiveNode m1m2c = tech.findNodeProto("Metal-1-Metal-2-Con");
            PortProto m1m2cport = m1m2c.getPort(0);
            double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
            double vddoffsetx = offset - 4.0 * lambda;
            double vddoffsety = invpoffsety - 26.0 * lambda;
            NodeInst vddbot = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + vddoffsetx, m1m2cbox[1] + vddoffsetx, m1m2cbox[2] + vddoffsety, m1m2cbox[3] + vddoffsety, 0, 0, rom);
            ap1 = invpln;
            apport1 = invvddc;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = vddbot;
            apport2 = m1m2cport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = pplane;
            apport3 = decpvddb;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        return rom;
    }

    private static void romplane(double lambda, int[][] romarray, String rp) {
        double[] appos3;
        PortProto apport3;
        NodeInst ap3;
        double[] appos2;
        PortProto apport2;
        NodeInst ap2;
        double[] appos1;
        int m;
        PortProto apport1;
        NodeInst ap1;
        int i;
        int inputs = romarray[0].length;
        int wordlines = romarray.length;
        NodeInst[][] andtrans = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[] pulluptrans = new NodeInst[wordlines + 2];
        NodeInst[] nwellc = new NodeInst[(wordlines + 2) / 2];
        NodeInst[][] minpins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] diffpins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] gndpins = new NodeInst[wordlines / 2][inputs + 2];
        NodeInst[] gnd_2pins = new NodeInst[wordlines / 2];
        NodeInst[] m1polypins = new NodeInst[inputs + 2];
        NodeInst[] m1m2pins = new NodeInst[inputs + 2];
        NodeInst[] m1m2_2pins = new NodeInst[wordlines + 2];
        NodeInst[] m1m2_3pins = new NodeInst[wordlines + 2];
        NodeInst[] m1m2_4pins = new NodeInst[wordlines + 2];
        NodeInst[] mpac_1pins = new NodeInst[wordlines + 2];
        NodeInst[] mpac_2pins = new NodeInst[wordlines + 2];
        NodeInst[] gndpex = new NodeInst[1];
        NodeInst[] gndm1ex = new NodeInst[1];
        NodeInst gnd1pin = null;
        Object vdd1pin = null;
        NodeInst vdd2pin = null;
        PortProto[] nwellcports = new PortProto[(wordlines + 2) / 2];
        PortProto[][] minports = new PortProto[wordlines + 2][inputs + 2];
        PortProto[][] gndports = new PortProto[wordlines / 2][inputs + 2];
        PortProto[] gnd_2ports = new PortProto[wordlines / 2];
        PortProto[][] diffports = new PortProto[wordlines / 2][inputs + 2];
        PortProto[] m1polyports = new PortProto[inputs + 2];
        PortProto[] m1m2ports = new PortProto[inputs + 2];
        PortProto[] m1m2_2ports = new PortProto[wordlines + 2];
        PortProto[] m1m2_3ports = new PortProto[wordlines + 2];
        PortProto[] m1m2_4ports = new PortProto[wordlines + 2];
        PortProto[] mpac_1ports = new PortProto[wordlines + 2];
        PortProto[] mpac_2ports = new PortProto[wordlines + 2];
        PortProto[] gndpexport = new PortProto[1];
        PortProto[] gndm1export = new PortProto[1];
        PortProto gnd1port = null;
        Object vdd1port = null;
        PortProto vdd2port = null;
        PrimitiveNode nmos = tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("n-trans-poly-right");
        PortProto nmosg2port = nmos.findPortProto("n-trans-poly-left");
        PortProto nmosd1port = nmos.findPortProto("n-trans-diff-top");
        PortProto nmosd2port = nmos.findPortProto("n-trans-diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth() / 2.0 - lambda / 2.0, nmos.getDefWidth() / 2.0 + lambda / 2.0, -nmos.getDefHeight() / 2.0, nmos.getDefHeight() / 2.0};
        PrimitiveNode pmos = tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("p-trans-poly-right");
        PortProto pmosg2port = pmos.findPortProto("p-trans-poly-left");
        PortProto pmosd1port = pmos.findPortProto("p-trans-diff-top");
        PortProto pmosd2port = pmos.findPortProto("p-trans-diff-bottom");
        double bbb = 15.0;
        double ccc = 23.0;
        double[] pmosbox = new double[]{-bbb * lambda / 2.0, bbb * lambda / 2.0, -ccc * lambda / 2.0, ccc * lambda / 2.0};
        PrimitiveNode ppin = tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth() / 2.0, ppin.getDefWidth() / 2.0, -ppin.getDefHeight() / 2.0, ppin.getDefHeight() / 2.0};
        PrimitiveNode napin = tech.findNodeProto("N-Active-Pin");
        PrimitiveNode m1pin = tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m2pin.getDefWidth() / 2.0 - lambda / 2.0, m2pin.getDefWidth() / 2.0 + lambda / 2.0, -m2pin.getDefHeight() / 2.0 - lambda / 2.0, m2pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode diffpin = tech.findNodeProto("Active-Pin");
        PortProto diffpinport = diffpin.getPort(0);
        double[] diffpinbox = new double[]{-diffpin.getDefWidth() / 2.0 - lambda / 2.0, diffpin.getDefWidth() / 2.0 + lambda / 2.0, -diffpin.getDefHeight() / 2.0 - lambda / 2.0, diffpin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode nwnode = tech.findNodeProto("N-Well-Node");
        double[] nwnodebox = new double[]{-nwnode.getDefWidth() / 2.0 - lambda / 2.0, nwnode.getDefWidth() / 2.0 + lambda / 2.0, -nwnode.getDefHeight() / 2.0 - lambda / 2.0, nwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode pwnode = tech.findNodeProto("P-Well-Node");
        double[] pwnodebox = new double[]{-pwnode.getDefWidth() / 2.0 - lambda / 2.0, pwnode.getDefWidth() / 2.0 + lambda / 2.0, -pwnode.getDefHeight() / 2.0 - lambda / 2.0, pwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode psnode = tech.findNodeProto("P-Select-Node");
        double[] psnodebox = new double[]{-psnode.getDefWidth() / 2.0 - lambda / 2.0, psnode.getDefWidth() / 2.0 + lambda / 2.0, -psnode.getDefHeight() / 2.0 - lambda / 2.0, psnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode mnac = tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpac = tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpwc = tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double nwellx = 29.0;
        double nwelly = 17.0;
        double[] mnwcbox = new double[]{-nwellx * lambda / 2.0, nwellx * lambda / 2.0, -nwelly * lambda / 2.0, nwelly * lambda / 2.0};
        PrimitiveNode mpc = tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double mx = 5.0;
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode m1m2c = tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode nsnode = tech.findNodeProto("N-Select-Node");
        double nselectx = 8.0;
        double nselecty = 8.0;
        double[] nsnodebox = new double[]{-nselectx * lambda / 2.0, nselectx * lambda / 2.0, -nselecty * lambda / 2.0, nselecty * lambda / 2.0};
        ArcProto parc = tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = tech.findArcProto("Metal-1");
        ArcProto m2arc = tech.findArcProto("Metal-2");
        ArcProto ndiffarc = tech.findArcProto("N-Active");
        ArcProto pdiffarc = tech.findArcProto("P-Active");
        Cell romplane = Cell.newInstance(Library.getCurrent(), rp + "{lay}");
        NodeInst pwellnode = ROMGenerator.makeCStyleNodeInst(pwnode, -4.0 * lambda, 8.0 * lambda * (double)(inputs + 2), -4.0 * lambda, 24.0 * lambda * (double)wordlines / 2.0, 0, 0, romplane);
        double ptranssize = 20.0;
        NodeInst pselectnode = ROMGenerator.makeCStyleNodeInst(psnode, -28.0 * lambda, (ptranssize - 28.0) * lambda, 4.0 * lambda, (double)(4 + 24 * wordlines / 2) * lambda, 0, 0, romplane);
        NodeInst nselectnode = ROMGenerator.makeCStyleNodeInst(nsnode, 0.0 * lambda, 8.0 * lambda * (double)inputs, 4.0 * lambda, (double)(4 + 24 * wordlines / 2) * lambda, 0, 0, romplane);
        NodeInst nwellnode = ROMGenerator.makeCStyleNodeInst(nwnode, -38.0 * lambda, (ptranssize - 38.0) * lambda, 20.0 * lambda, (double)(4 + 24 * wordlines / 2) * lambda, 0, 0, romplane);
        double x = 0.0;
        for (i = 0; i < inputs + 1; ++i) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i < inputs) {
                andtrans[0][i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, romplane);
                m1polypins[i] = ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, romplane);
                m1m2pins[i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2], m1m2cbox[3], 0, 0, romplane);
                ap1 = m1m2pins[i];
                apport1 = m1m2cport;
                ROMGenerator.makeCStyleExport(romplane, ap1, apport1, "wordline_" + (inputs - i - 1), PortCharacteristic.IN);
            }
            for (m = 0; m < wordlines; ++m) {
                y += 8.0 * lambda;
                if (m % 2 == 1) {
                    if (i % 2 == 1) {
                        gndpins[m / 2][i] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, romplane);
                        gndports[m / 2][i] = mnacport;
                    } else if (i == inputs) {
                        gndpins[m / 2][i] = ROMGenerator.makeCStyleNodeInst(mpwc, mpwcbox[0] + x - 4.0 * lambda, mpwcbox[1] + x - 4.0 * lambda, mpwcbox[2] + y, mpwcbox[3] + y, 0, 0, romplane);
                        gndports[m / 2][i] = mpwcport;
                    } else {
                        gndpins[m / 2][i] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                        gndports[m / 2][i] = m1pinport;
                    }
                    if (i == 0) {
                        gnd_2pins[m / 2] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 12.0 * lambda, m1pinbox[1] + x - 12.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                        gnd_2ports[m / 2] = m1pinport;
                        if (m == 1) {
                            gndm1ex[m / 2] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 12.0 * lambda, m1pinbox[1] + x - 12.0 * lambda, m1pinbox[2] + y - 16.0 * lambda, m1pinbox[3] + y - 16.0 * lambda, 0, 0, romplane);
                            gndm1export[m / 2] = m1pinport;
                            gnd1pin = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 8.0 * lambda, m1pinbox[1] + x - 8.0 * lambda, m1pinbox[2] + y - 16.0 * lambda, m1pinbox[3] + y - 16.0 * lambda, 0, 0, romplane);
                            gnd1port = m1pinport;
                            vdd2pin = ROMGenerator.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 32.0 * lambda, m2pinbox[1] + x - 32.0 * lambda, m2pinbox[2] + y - 16.0 * lambda, m2pinbox[3] + y - 16.0 * lambda, 0, 0, romplane);
                            vdd2port = m2pinport;
                        }
                    }
                    y += 8.0 * lambda;
                }
                if (i < inputs) {
                    andtrans[m + 1][i] = romarray[m][i] == 1 ? ROMGenerator.makeCStyleNodeInst(nmos, nmosbox[0] + x, nmosbox[1] + x, nmosbox[2] + y, nmosbox[3] + y, 1, 0, romplane) : ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, romplane);
                }
                boolean transcont = false;
                if (i < inputs) {
                    boolean bl = transcont = romarray[m][i] == 1;
                }
                if (i > 1) {
                    transcont |= romarray[m][i - 1] == 1;
                }
                if (i % 2 == 0 && transcont) {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, romplane);
                    diffpins[m][i] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                    minports[m][i] = mnacport;
                } else {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                    diffpins[m][i] = transcont || i == 1 && romarray[m][0] == 1 ? ROMGenerator.makeCStyleNodeInst(diffpin, diffpinbox[0] + x - 4.0 * lambda, diffpinbox[1] + x - 4.0 * lambda, diffpinbox[2] + y, diffpinbox[3] + y, 0, 0, romplane) : ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, romplane);
                    minports[m][i] = m1pinport;
                }
                if (i == inputs) {
                    ap1 = minpins[m][i];
                    apport1 = minports[m][i];
                    ROMGenerator.makeCStyleExport(romplane, ap1, apport1, "out_" + m, PortCharacteristic.OUT);
                }
                if (i != 0) continue;
                if (m % 2 == 1) {
                    nwellc[m / 2] = ROMGenerator.makeCStyleNodeInst(mnwc, m1m2cbox[0] + x - 46.0 * lambda, mnwcbox[1] + x - 46.0 * lambda, mnwcbox[2] + y, mnwcbox[3] + y, 0, 0, romplane);
                    nwellcports[m / 2] = mnwcport;
                }
                m1m2_2pins[m] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, romplane);
                m1m2_2ports[m] = m1m2cport;
                m1m2_3pins[m] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 20.0 * lambda, m1m2cbox[1] + x - 20.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, romplane);
                m1m2_3ports[m] = m1m2cport;
                mpac_1pins[m] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x - 20.0 * lambda, mpacbox[1] + x - 20.0 * lambda, mpacbox[2] + y, mpacbox[3] + y, 0, 0, romplane);
                mpac_1ports[m] = mpacport;
                pulluptrans[m] = ROMGenerator.makeCStyleNodeInst(pmos, pmosbox[0] + x - 26.0 * lambda, pmosbox[1] + x - 26.0 * lambda, pmosbox[2] + y, pmosbox[3] + y, 1, 0, romplane);
                mpac_2pins[m] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x - 32.0 * lambda, mpacbox[1] + x - 32.0 * lambda, mpacbox[2] + y, mpacbox[3] + y, 0, 0, romplane);
                mpac_2ports[m] = mpacport;
                m1m2_4pins[m] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 32.0 * lambda, m1m2cbox[1] + x - 32.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, romplane);
                m1m2_4ports[m] = m1m2cport;
                if (m != 0) continue;
                gndpex[m] = ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x - 26.0 * lambda, mpcbox[1] + x - 26.0 * lambda, mpcbox[2] + y - 8.0 * lambda, mpcbox[3] + y - 8.0 * lambda, 0, 0, romplane);
                gndpexport[m] = mpcport;
            }
        }
        for (i = 0; i < inputs; ++i) {
            ap1 = andtrans[0][i];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1polypins[i];
            apport2 = mpcport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = m1m2pins[i];
            apport3 = m1m2cport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i = 0; i < inputs; ++i) {
            ap1 = andtrans[0][i];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m = 1; m < wordlines + 1; ++m) {
                ap2 = andtrans[m][i];
                if (romarray[m - 1][i] == 1) {
                    apport2 = nmosg1port;
                    apport3 = nmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
        }
        for (m = 0; m < wordlines; ++m) {
            ap1 = minpins[m][0];
            apport1 = minports[m][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i = 1; i < inputs + 1; ++i) {
                ap2 = minpins[m][i];
                apport2 = minports[m][i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m = 0; m < wordlines; ++m) {
            for (i = 0; i < inputs; ++i) {
                NodeInst intgnd;
                NodeInst gnd2;
                PortProto gndport1;
                if (romarray[m][i] != 1) continue;
                NodeInst gnd1 = ap1 = andtrans[m + 1][i];
                if (i % 2 == 0) {
                    apport1 = nmosd1port;
                    gndport1 = nmosd2port;
                    ap2 = minpins[m][i];
                    gnd2 = gndpins[m / 2][i + 1];
                    intgnd = diffpins[m][i + 1];
                } else {
                    apport1 = nmosd2port;
                    gndport1 = nmosd1port;
                    ap2 = minpins[m][i + 1];
                    gnd2 = gndpins[m / 2][i];
                    intgnd = diffpins[m][i];
                }
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                double[] gndpos1 = ROMGenerator.getCStylePortPosition(gnd1, gndport1);
                apport2 = mnacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                PortProto gndport2 = mnacport;
                double[] gndpos2 = ROMGenerator.getCStylePortPosition(gnd2, gndport2);
                PortProto intgndport = diffpinport;
                double[] intgndpos = ROMGenerator.getCStylePortPosition(intgnd, intgndport);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, gnd1, gndport1, gndpos1[0], gndpos1[1], intgnd, intgndport, intgndpos[0], intgndpos[1]);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, intgnd, intgndport, intgndpos[0], intgndpos[1], gnd2, gndport2, gndpos2[0], gndpos2[1]);
            }
        }
        for (m = 0; m < wordlines / 2; ++m) {
            ap1 = gndpins[m][0];
            apport1 = gndports[m][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i = 1; i < inputs + 1; ++i) {
                ap2 = gndpins[m][i];
                apport2 = gndports[m][i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                if (i == inputs) {
                    ROMGenerator.makeCStyleExport(romplane, ap1, apport1, "romgnd" + m, PortCharacteristic.GND);
                }
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m = 0; m < wordlines / 2; ++m) {
            ap1 = gndpins[m][0];
            apport1 = gndports[m][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = gnd_2pins[m];
            apport2 = gnd_2ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = gnd_2pins[0];
        apport1 = gnd_2ports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (m = 0; m < wordlines / 2; ++m) {
            ap2 = gnd_2pins[m];
            apport2 = gnd_2ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            if (m != wordlines / 2 - 1) continue;
            ROMGenerator.makeCStyleExport(romplane, ap2, apport2, "gnd", PortCharacteristic.GND);
        }
        ap2 = gndm1ex[0];
        apport2 = gndm1export[0];
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ap1 = gnd1pin;
        apport1 = gnd1port;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleExport(romplane, ap1, apport1, "gndc", PortCharacteristic.GND);
        ap1 = gndpex[0];
        apport1 = gndpexport[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ap2 = pulluptrans[0];
        apport2 = pmosg1port;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(parc, 3.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        for (m = 0; m < wordlines; ++m) {
            ap1 = minpins[m][0];
            apport1 = minports[m][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1m2_2pins[m];
            apport2 = m1m2_2ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = m1m2_3pins[m];
            apport3 = m1m2_3ports[m];
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (m = 0; m < wordlines; ++m) {
            ap1 = m1m2_3pins[m];
            apport1 = m1m2_3ports[m];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = mpac_1pins[m];
            apport2 = mpac_1ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m = 0; m < wordlines; ++m) {
            NodeInst ap4 = ap1 = pulluptrans[m];
            PortProto apport4 = pmosd1port;
            apport1 = pmosd2port;
            ap2 = mpac_1pins[m];
            ap3 = mpac_2pins[m];
            apport2 = mpacport;
            apport3 = mpacport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            double[] appos4 = ROMGenerator.getCStylePortPosition(ap4, apport4);
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(pdiffarc, 15.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(pdiffarc, 15.0 * lambda, ap4, apport4, appos4[0], appos4[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (m = 0; m < wordlines; ++m) {
            ap1 = m1m2_4pins[m];
            apport1 = m1m2_4ports[m];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = mpac_2pins[m];
            apport2 = mpac_2ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m = 0; m < wordlines; ++m) {
            if (m % 2 != 1) continue;
            ap1 = nwellc[m / 2];
            apport1 = nwellcports[m / 2];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = mpac_2pins[m];
            apport2 = mpac_2ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = m1m2_4pins[0];
        apport1 = m1m2_4ports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (m = 0; m < wordlines; ++m) {
            ap2 = m1m2_4pins[m];
            apport2 = m1m2_4ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap2 = vdd2pin;
        apport2 = vdd2port;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleExport(romplane, ap2, apport2, "vdd", PortCharacteristic.PWR);
        for (m = 0; m < wordlines - 1; ++m) {
            ap1 = pulluptrans[m];
            apport1 = pmosg2port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pulluptrans[m + 1];
            apport2 = pmosg1port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 3.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
    }

    private static void decodernmos(double lambda, int bits, String cellname, boolean top) {
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        NodeInst ap2;
        PortProto apport1;
        NodeInst ap1;
        int m;
        int i;
        int[][] romplane = ROMGenerator.generateplane(bits);
        int inputs = romplane[0].length;
        int wordlines = romplane.length;
        NodeInst[][] ortrans = new NodeInst[wordlines + 3][inputs + 2];
        NodeInst[][] minpins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] diffpins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] gndpins = new NodeInst[wordlines / 2][inputs + 2];
        NodeInst[][] vddpins = new NodeInst[wordlines][inputs / 2];
        NodeInst[] pwrpins = new NodeInst[inputs / 2];
        NodeInst[][] m1m2pins = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[] pwcpins = new NodeInst[wordlines + 2];
        PortProto[][] minports = new PortProto[wordlines + 2][inputs + 2];
        PortProto[][] gndports = new PortProto[wordlines / 2][inputs + 2];
        PortProto[][] vddports = new PortProto[wordlines][inputs / 2];
        PortProto[] pwrports = new PortProto[inputs / 2];
        PortProto[][] diffports = new PortProto[wordlines / 2][inputs + 2];
        PortProto[][] m1m2ports = new PortProto[wordlines + 2][inputs + 2];
        PortProto[] pwcports = new PortProto[wordlines + 2];
        PrimitiveNode nmos = tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("n-trans-poly-right");
        PortProto nmosg2port = nmos.findPortProto("n-trans-poly-left");
        PortProto nmosd1port = nmos.findPortProto("n-trans-diff-top");
        PortProto nmosd2port = nmos.findPortProto("n-trans-diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth() / 2.0 - lambda / 2.0, nmos.getDefWidth() / 2.0 + lambda / 2.0, -nmos.getDefHeight() / 2.0, nmos.getDefHeight() / 2.0};
        PrimitiveNode pmos = tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("p-trans-poly-right");
        PortProto pmosg2port = pmos.findPortProto("p-trans-poly-left");
        PortProto pmosd1port = pmos.findPortProto("p-trans-diff-top");
        PortProto pmosd2port = pmos.findPortProto("p-trans-diff-bottom");
        double[] pmosbox = new double[]{-pmos.getDefWidth() / 2.0 - lambda / 2.0, pmos.getDefWidth() / 2.0 + lambda / 2.0, -pmos.getDefHeight() / 2.0, pmos.getDefHeight() / 2.0};
        PrimitiveNode ppin = tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth() / 2.0, ppin.getDefWidth() / 2.0, -ppin.getDefHeight() / 2.0, ppin.getDefHeight() / 2.0};
        PrimitiveNode napin = tech.findNodeProto("N-Active-Pin");
        PrimitiveNode m1pin = tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode nwnode = tech.findNodeProto("N-Well-Node");
        double[] nwnodebox = new double[]{-nwnode.getDefWidth() / 2.0 - lambda / 2.0, nwnode.getDefWidth() / 2.0 + lambda / 2.0, -nwnode.getDefHeight() / 2.0 - lambda / 2.0, nwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode pwnode = tech.findNodeProto("P-Well-Node");
        double[] pwnodebox = new double[]{-pwnode.getDefWidth() / 2.0 - lambda / 2.0, pwnode.getDefWidth() / 2.0 + lambda / 2.0, -pwnode.getDefHeight() / 2.0 - lambda / 2.0, pwnode.getDefHeight() / 2.0 + lambda / 2.0};
        double mx = 5.0;
        PrimitiveNode mpc = tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode m1m2c = tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode diffpin = tech.findNodeProto("Active-Pin");
        PortProto diffpinport = diffpin.getPort(0);
        double[] diffpinbox = new double[]{-diffpin.getDefWidth() / 2.0 - lambda / 2.0, diffpin.getDefWidth() / 2.0 + lambda / 2.0, -diffpin.getDefHeight() / 2.0 - lambda / 2.0, diffpin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode mnac = tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpac = tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpwc = tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double[] mnwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        ArcProto parc = tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = tech.findArcProto("Metal-1");
        ArcProto m2arc = tech.findArcProto("Metal-2");
        ArcProto ndiffarc = tech.findArcProto("N-Active");
        ArcProto pdiffarc = tech.findArcProto("P-Active");
        Cell decn = Cell.newInstance(Library.getCurrent(), cellname + "{lay}");
        PrimitiveNode nsnode = tech.findNodeProto("N-Select-Node");
        int nselectx = 8;
        int nselecty = 8;
        double[] nsnodebox = new double[]{(double)(-nselectx) * lambda / 2.0, (double)nselectx * lambda / 2.0, (double)(-nselecty) * lambda / 2.0, (double)nselecty * lambda / 2.0};
        NodeInst pwellnode = ROMGenerator.makeCStyleNodeInst(pwnode, 0.0, 8.0 * lambda * (double)(2 * bits + 1), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decn);
        NodeInst nselectnode = ROMGenerator.makeCStyleNodeInst(nsnode, 0.0, 8.0 * lambda * (double)(2 * bits + 1), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decn);
        double x = 0.0;
        for (i = 0; i < inputs + 1; ++i) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i % 2 == 1) {
                x += 0.0 * lambda;
            }
            if (i < inputs) {
                ortrans[0][i] = top ? ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, decn) : ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, decn);
            }
            for (m = 0; m < wordlines; ++m) {
                y += 8.0 * lambda;
                if (i % 2 == 1) {
                    vddpins[m][i / 2] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, decn);
                    vddports[m][i / 2] = mnacport;
                    if (m == wordlines - 1) {
                        pwrpins[i / 2] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y + 8.0 * lambda, m1pinbox[3] + y + 8.0 * lambda, 0, 0, decn);
                        pwrports[i / 2] = m1pinport;
                    }
                }
                if (i < inputs) {
                    ortrans[m + 1][i] = romplane[m][i] == 1 ? ROMGenerator.makeCStyleNodeInst(nmos, nmosbox[0] + x, nmosbox[1] + x, nmosbox[2] + y, nmosbox[3] + y, 1, 0, decn) : ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, decn);
                    if (m == wordlines - 1) {
                        ortrans[m + 2][i] = top ? ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2] + y + 16.0 * lambda, mpcbox[3] + y + 16.0 * lambda, 0, 0, decn) : ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y + 4.0 * lambda, ppinbox[3] + y + 4.0 * lambda, 0, 0, decn);
                    }
                }
                boolean transcont = false;
                if (i < inputs) {
                    boolean bl = transcont = romplane[m][i] == 1;
                }
                if (i > 1) {
                    transcont |= romplane[m][i - 1] == 1;
                }
                if (i % 2 == 0 && transcont) {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, decn);
                    minports[m][i] = mnacport;
                    m1m2pins[m][i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, decn);
                    m1m2ports[m][i] = m1m2cport;
                } else {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 4.0 * lambda, m2pinbox[1] + x - 4.0 * lambda, m2pinbox[2] + y, m2pinbox[3] + y, 0, 0, decn);
                    minports[m][i] = m2pinport;
                    if (i == 0) {
                        m1m2pins[m][i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, decn);
                        m1m2ports[m][i] = m1m2cport;
                    } else {
                        m1m2pins[m][i] = ROMGenerator.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 4.0 * lambda, m2pinbox[1] + x - 4.0 * lambda, m2pinbox[2] + y, m2pinbox[3] + y, 0, 0, decn);
                        m1m2ports[m][i] = m2pinport;
                    }
                }
                if (i != 0) continue;
                ap1 = m1m2pins[m][i];
                apport1 = m1m2ports[m][i];
                ROMGenerator.makeCStyleExport(decn, ap1, apport1, "mid" + m, PortCharacteristic.IN);
            }
        }
        ap1 = pwrpins[0];
        apport1 = pwrports[0];
        double[] appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (i = 1; i < inputs / 2; ++i) {
            ap2 = pwrpins[i];
            apport2 = pwrports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ap2;
            apport1 = apport2;
            appos1 = appos2;
        }
        ROMGenerator.makeCStyleExport(decn, ap1, apport1, "gnd", PortCharacteristic.GND);
        m = wordlines - 1;
        for (i = 0; i < inputs / 2; ++i) {
            ap1 = vddpins[m][i];
            apport1 = vddports[m][i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pwrpins[i];
            apport2 = pwrports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < inputs; ++i) {
            ap1 = ortrans[wordlines + 1][i];
            apport1 = top ? mpcport : ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i % 2 == 0) {
                ROMGenerator.makeCStyleExport(decn, ap1, apport1, "top_in" + i / 2, PortCharacteristic.IN);
            } else {
                ROMGenerator.makeCStyleExport(decn, ap1, apport1, "top_in" + (i - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            ap1 = ortrans[0][i];
            apport1 = top ? ppinport : mpcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i % 2 == 0) {
                ROMGenerator.makeCStyleExport(decn, ap1, apport1, "bot_in" + i / 2, PortCharacteristic.IN);
            } else {
                ROMGenerator.makeCStyleExport(decn, ap1, apport1, "bot_in" + (i - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            for (m = 1; m < wordlines + 1; ++m) {
                ap2 = ortrans[m][i];
                if (romplane[m - 1][i] == 1) {
                    apport2 = nmosg1port;
                    apport3 = nmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
            ap2 = ortrans[wordlines + 1][i];
            if (top) {
                apport2 = mpcport;
                apport3 = mpcport;
            } else {
                apport2 = ppinport;
                apport3 = ppinport;
            }
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m = 0; m < wordlines; ++m) {
            ap1 = m1m2pins[m][0];
            apport1 = m1m2ports[m][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i = 1; i < inputs + 1; ++i) {
                ap2 = m1m2pins[m][i];
                apport2 = m1m2ports[m][i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
            ROMGenerator.makeCStyleExport(decn, ap1, apport1, "word" + m, PortCharacteristic.OUT);
        }
        for (m = 0; m < wordlines; ++m) {
            for (i = 0; i < inputs; ++i) {
                NodeInst vdd2;
                NodeInst ap3;
                PortProto vddport1;
                if (romplane[m][i] != 1) continue;
                NodeInst vdd1 = ap1 = ortrans[m + 1][i];
                if (i % 2 == 0) {
                    apport1 = nmosd1port;
                    vddport1 = nmosd2port;
                    ap2 = minpins[m][i];
                    ap3 = m1m2pins[m][i];
                    vdd2 = vddpins[m][i / 2];
                } else {
                    apport1 = nmosd2port;
                    vddport1 = nmosd1port;
                    ap2 = minpins[m][i + 1];
                    ap3 = m1m2pins[m][i + 1];
                    vdd2 = vddpins[m][i / 2];
                }
                apport2 = mnacport;
                apport3 = m1m2cport;
                PortProto vddport2 = mnacport;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                double[] vddpos1 = ROMGenerator.getCStylePortPosition(vdd1, vddport1);
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                double[] vddpos2 = ROMGenerator.getCStylePortPosition(vdd2, vddport2);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, vdd1, vddport1, vddpos1[0], vddpos1[1], vdd2, vddport2, vddpos2[0], vddpos2[1]);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
            }
        }
        for (i = 0; i < inputs / 2; ++i) {
            ap1 = vddpins[0][i];
            apport1 = vddports[0][i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m = 1; m < wordlines; ++m) {
                ap2 = vddpins[m][i];
                apport2 = vddports[m][i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
    }

    private static void decoderpmos(double lambda, int bits, String cellname, boolean top) {
        double[] appos3;
        double[] appos2;
        PortProto apport3;
        PortProto apport2;
        NodeInst ap2;
        double[] appos1;
        PortProto apport1;
        NodeInst ap1;
        int m;
        int i;
        int[][] romplane = ROMGenerator.generateplane(bits);
        int inputs = romplane[0].length;
        int wordlines = romplane.length;
        NodeInst[][] andtrans = new NodeInst[wordlines + 2][inputs + 2];
        NodeInst[][] minpins = new NodeInst[wordlines + 3][inputs + 2];
        NodeInst[] m1m2pins = new NodeInst[wordlines + 2];
        NodeInst[] m2pins = new NodeInst[wordlines + 2];
        NodeInst vddpin = null;
        Object vddipin = null;
        NodeInst vddbpin = null;
        NodeInst vddcpin = null;
        PortProto[][] minports = new PortProto[wordlines + 2][inputs + 2];
        PortProto[] m1m2ports = new PortProto[wordlines + 2];
        PortProto[] m2ports = new PortProto[wordlines + 2];
        PortProto vddport = null;
        Object vddiport = null;
        PortProto vddbport = null;
        PortProto vddcport = null;
        PrimitiveNode nmos = tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("n-trans-poly-right");
        PortProto nmosg2port = nmos.findPortProto("n-trans-poly-left");
        PortProto nmosd1port = nmos.findPortProto("n-trans-diff-top");
        PortProto nmosd2port = nmos.findPortProto("n-trans-diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth() / 2.0 - lambda / 2.0, nmos.getDefWidth() / 2.0 + lambda / 2.0, -nmos.getDefHeight() / 2.0, nmos.getDefHeight() / 2.0};
        PrimitiveNode pmos = tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("p-trans-poly-right");
        PortProto pmosg2port = pmos.findPortProto("p-trans-poly-left");
        PortProto pmosd1port = pmos.findPortProto("p-trans-diff-top");
        PortProto pmosd2port = pmos.findPortProto("p-trans-diff-bottom");
        double[] pmosbox = new double[]{-pmos.getDefWidth() / 2.0 - lambda / 2.0, pmos.getDefWidth() / 2.0 + lambda / 2.0, -pmos.getDefHeight() / 2.0, pmos.getDefHeight() / 2.0};
        PrimitiveNode ppin = tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth() / 2.0, ppin.getDefWidth() / 2.0, -ppin.getDefHeight() / 2.0, ppin.getDefHeight() / 2.0};
        PrimitiveNode napin = tech.findNodeProto("N-Active-Pin");
        PrimitiveNode m1pin = tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        double mx = 5.0;
        PrimitiveNode mpc = tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        PrimitiveNode diffpin = tech.findNodeProto("Active-Pin");
        PortProto diffpinport = diffpin.getPort(0);
        double[] diffpinbox = new double[]{-diffpin.getDefWidth() / 2.0 - lambda / 2.0, diffpin.getDefWidth() / 2.0 + lambda / 2.0, -diffpin.getDefHeight() / 2.0 - lambda / 2.0, diffpin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m1m2c = tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode mnac = tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double[] mnacbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mpac = tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double[] mnwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mpwc = tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-2.0 * lambda, 2.0 * lambda, -2.0 * lambda, 2.0 * lambda};
        ArcProto parc = tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = tech.findArcProto("Metal-1");
        ArcProto m2arc = tech.findArcProto("Metal-2");
        ArcProto ndiffarc = tech.findArcProto("N-Active");
        ArcProto pdiffarc = tech.findArcProto("P-Active");
        PrimitiveNode nwnode = tech.findNodeProto("N-Well-Node");
        double[] nwnodebox = new double[]{-nwnode.getDefWidth() / 2.0 - lambda / 2.0, nwnode.getDefWidth() / 2.0 + lambda / 2.0, -nwnode.getDefHeight() / 2.0 - lambda / 2.0, nwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode pwnode = tech.findNodeProto("P-Well-Node");
        double[] pwnodebox = new double[]{-pwnode.getDefWidth() / 2.0 - lambda / 2.0, pwnode.getDefWidth() / 2.0 + lambda / 2.0, -pwnode.getDefHeight() / 2.0 - lambda / 2.0, pwnode.getDefHeight() / 2.0 + lambda / 2.0};
        Cell decp = Cell.newInstance(Library.getCurrent(), cellname + "{lay}");
        PrimitiveNode psnode = tech.findNodeProto("P-Select-Node");
        int pselectx = 8;
        int pselecty = 8;
        double[] psnodebox = new double[]{(double)(-pselectx) * lambda / 2.0, (double)pselectx * lambda / 2.0, (double)(-pselecty) * lambda / 2.0, (double)pselecty * lambda / 2.0};
        NodeInst nwellnode = ROMGenerator.makeCStyleNodeInst(nwnode, 0.0, 8.0 * lambda * (double)(2 * bits), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decp);
        NodeInst pselectnode = ROMGenerator.makeCStyleNodeInst(psnode, 0.0, 8.0 * lambda * (double)(2 * bits), 0.0, 8.0 * lambda * (double)(wordlines + 1), 0, 0, decp);
        double x = 0.0;
        for (i = 0; i < inputs + 1; ++i) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i < inputs) {
                andtrans[0][i] = top ? ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, decp) : ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, decp);
            }
            for (m = 0; m < wordlines; ++m) {
                y += 8.0 * lambda;
                if (i < inputs) {
                    andtrans[m + 1][i] = romplane[m][i] == 1 ? ROMGenerator.makeCStyleNodeInst(pmos, pmosbox[0] + x, pmosbox[1] + x, pmosbox[2] + y, pmosbox[3] + y, 1, 0, decp) : ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, decp);
                    if (m == wordlines - 1) {
                        andtrans[m + 2][i] = top ? ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2] + y + 16.0 * lambda, mpcbox[3] + y + 16.0 * lambda, 0, 0, decp) : ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y + 4.0 * lambda, ppinbox[3] + y + 4.0 * lambda, 0, 0, decp);
                    }
                }
                boolean transcont = false;
                if (i < inputs) {
                    boolean bl = transcont = romplane[m][i] == 1;
                }
                if (i == 0) {
                    m1m2pins[m] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, decp);
                    m1m2ports[m] = m1m2cport;
                }
                if (i == inputs) {
                    m2pins[m] = ROMGenerator.makeCStyleNodeInst(m2pin, m2pinbox[0] + x - 4.0 * lambda, m2pinbox[1] + x - 4.0 * lambda, m2pinbox[2] + y, m2pinbox[3] + y, 0, 0, decp);
                    m2ports[m] = m2pinport;
                }
                if (i >= 1) {
                    transcont |= romplane[m][i - 1] == 1;
                }
                if (transcont) {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x - 4.0 * lambda, mpacbox[1] + x - 4.0 * lambda, mpacbox[2] + y, mpacbox[3] + y, 0, 0, decp);
                    minports[m][i] = mpacport;
                } else if (i == inputs) {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(mnwc, mnwcbox[0] + x - 4.0 * lambda, mnwcbox[1] + x - 4.0 * lambda, mnwcbox[2] + y, mnwcbox[3] + y, 0, 0, decp);
                    minports[m][i] = mnwcport;
                } else {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, decp);
                    minports[m][i] = m1pinport;
                }
                if (i != inputs) continue;
                vddpin = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y + 8.0 * lambda, m1pinbox[3] + y + 8.0 * lambda, 0, 0, decp);
                vddport = m1pinport;
                if (m == 0) {
                    vddbpin = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x + 4.0 * lambda, m1pinbox[1] + x + 4.0 * lambda, m1pinbox[2] + y + 0.0 * lambda, m1pinbox[3] + y + 0.0 * lambda, 0, 0, decp);
                    vddbport = m1pinport;
                }
                if (m != wordlines - 1) continue;
                vddcpin = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x + 4.0 * lambda, m1m2cbox[1] + x + 4.0 * lambda, m1m2cbox[2] + y + 8.0 * lambda, m1m2cbox[3] + y + 8.0 * lambda, 0, 0, decp);
                vddcport = m1m2cport;
            }
        }
        for (i = 0; i < inputs; ++i) {
            ap1 = andtrans[wordlines + 1][i];
            apport1 = top ? mpcport : ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i % 2 == 0) {
                ROMGenerator.makeCStyleExport(decp, ap1, apport1, "top_in" + i / 2, PortCharacteristic.IN);
            } else {
                ROMGenerator.makeCStyleExport(decp, ap1, apport1, "top_in" + (i - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            ap1 = andtrans[0][i];
            apport1 = top ? ppinport : mpcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            if (i % 2 == 0) {
                ROMGenerator.makeCStyleExport(decp, ap1, apport1, "bot_in" + i / 2, PortCharacteristic.IN);
            } else {
                ROMGenerator.makeCStyleExport(decp, ap1, apport1, "bot_in" + (i - 1) / 2 + "_b", PortCharacteristic.IN);
            }
            for (m = 1; m < wordlines + 1; ++m) {
                ap2 = andtrans[m][i];
                if (romplane[m - 1][i] == 1) {
                    apport2 = pmosg1port;
                    apport3 = pmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
            ap2 = andtrans[wordlines + 1][i];
            if (top) {
                apport2 = mpcport;
                apport3 = mpcport;
            } else {
                apport2 = ppinport;
                apport3 = ppinport;
            }
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (m = 0; m < wordlines; ++m) {
            ap1 = minpins[m][0];
            apport1 = minports[m][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i = 1; i < inputs + 1; ++i) {
                ap2 = minpins[m][i];
                apport2 = minports[m][i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                if (romplane[m][i - 1] != 1) {
                    ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                }
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m = 0; m < wordlines; ++m) {
            for (i = 0; i < inputs; ++i) {
                if (romplane[m][i] != 1) continue;
                ap1 = andtrans[m + 1][i];
                apport1 = pmosd1port;
                apport2 = pmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                appos2 = ROMGenerator.getCStylePortPosition(ap1, apport2);
                NodeInst apx = minpins[m][i];
                NodeInst apy = minpins[m][i + 1];
                PortProto apportx = mpacport;
                PortProto apporty = mpacport;
                double[] apposx = ROMGenerator.getCStylePortPosition(apx, apportx);
                double[] apposy = ROMGenerator.getCStylePortPosition(apy, apporty);
                ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], apx, apportx, apposx[0], apposx[1]);
                ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, apport2, appos2[0], appos2[1], apy, apporty, apposy[0], apposy[1]);
            }
        }
        i = inputs;
        ap1 = minpins[0][i];
        apport1 = minports[0][i];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (m = 1; m < wordlines; ++m) {
            ap2 = minpins[m][i];
            apport2 = minports[m][i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = ap2;
            apport1 = apport2;
            appos1 = appos2;
        }
        ap1 = vddpin;
        apport1 = vddport;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = minpins[wordlines - 1][inputs];
        apport2 = minports[wordlines - 1][inputs];
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ap1 = vddcpin;
        apport1 = vddcport;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = vddpin;
        apport2 = vddport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleExport(decp, ap1, apport1, "vdd", PortCharacteristic.PWR);
        ap1 = vddbpin;
        apport1 = vddbport;
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = minpins[0][inputs];
        apport2 = minports[0][inputs];
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleExport(decp, ap1, apport1, "vddb", PortCharacteristic.PWR);
        for (m = 0; m < wordlines; ++m) {
            ap1 = m1m2pins[m];
            apport1 = m1m2ports[m];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m2pins[m];
            apport2 = m2ports[m];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            NodeInst ap3 = minpins[m][0];
            apport3 = minports[m][0];
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap3, apport3, appos3[0], appos3[1]);
            ROMGenerator.makeCStyleExport(decp, ap2, apport2, "word" + m, PortCharacteristic.OUT);
            ROMGenerator.makeCStyleExport(decp, ap1, apport1, "wordin" + m, PortCharacteristic.IN);
        }
    }

    private static int[][] generatemuxarray(int folds, int romoutputs) {
        int muxes = romoutputs / folds;
        int[][] muxarray = new int[romoutputs][folds];
        for (int i = 0; i < muxes; ++i) {
            for (int j = 0; j < folds; ++j) {
                for (int k = 0; k < folds; ++k) {
                    muxarray[i * folds + j][k] = j == k ? 1 : 0;
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < romoutputs; ++i) {
            sb = new StringBuffer();
            for (int j = 0; j < folds; ++j) {
                sb.append(Integer.toString(muxarray[i][j]));
            }
        }
        return muxarray;
    }

    private static void muxplane(double lambda, int folds, int romoutputs, String mp) {
        int j;
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        NodeInst ap2;
        double[] appos1;
        int m;
        PortProto apport1;
        NodeInst ap1;
        int i;
        int[][] muxarray = ROMGenerator.generatemuxarray(folds, romoutputs);
        int muxnumber = folds;
        int selects = folds;
        int outputbits = romoutputs;
        NodeInst[][] ntrans = new NodeInst[outputbits + 2][selects + 2];
        NodeInst[][] minpins = new NodeInst[outputbits + 2][selects + 2];
        NodeInst[] m1m2pins2 = new NodeInst[outputbits + 2];
        NodeInst[] m1m2pins = new NodeInst[selects + 2];
        NodeInst[] m2pins = new NodeInst[outputbits + 2];
        NodeInst[] m1polypins = new NodeInst[outputbits + 2];
        PortProto[][] minports = new PortProto[outputbits + 2][selects + 2];
        PortProto[] m1m2ports2 = new PortProto[outputbits + 2];
        PortProto[] m1m2ports = new PortProto[selects + 2];
        PortProto[] m2ports = new PortProto[outputbits + 2];
        PortProto[] m1polyports = new PortProto[outputbits + 2];
        PrimitiveNode nmos = tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("n-trans-poly-right");
        PortProto nmosg2port = nmos.findPortProto("n-trans-poly-left");
        PortProto nmosd1port = nmos.findPortProto("n-trans-diff-top");
        PortProto nmosd2port = nmos.findPortProto("n-trans-diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth() / 2.0 - lambda / 2.0, nmos.getDefWidth() / 2.0 + lambda / 2.0, -nmos.getDefHeight() / 2.0, nmos.getDefHeight() / 2.0};
        PrimitiveNode pmos = tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("p-trans-poly-right");
        PortProto pmosg2port = pmos.findPortProto("p-trans-poly-left");
        PortProto pmosd1port = pmos.findPortProto("p-trans-diff-top");
        PortProto pmosd2port = pmos.findPortProto("p-trans-diff-bottom");
        double[] pmosbox = new double[]{-nmos.getDefWidth() / 2.0 - lambda / 2.0, nmos.getDefWidth() / 2.0 + lambda / 2.0, -nmos.getDefHeight() / 2.0, nmos.getDefHeight() / 2.0};
        PrimitiveNode ppin = tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth() / 2.0, ppin.getDefWidth() / 2.0, -ppin.getDefHeight() / 2.0, ppin.getDefHeight() / 2.0};
        PrimitiveNode napin = tech.findNodeProto("N-Active-Pin");
        PrimitiveNode m1pin = tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode diffpin = tech.findNodeProto("Active-Pin");
        PortProto diffpinport = diffpin.getPort(0);
        double[] diffpinbox = new double[]{-diffpin.getDefWidth() / 2.0 - lambda / 2.0, diffpin.getDefWidth() / 2.0 + lambda / 2.0, -diffpin.getDefHeight() / 2.0 - lambda / 2.0, diffpin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m1m2c = tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode mnac = tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double mult = 17.0;
        double[] mnacbox = new double[]{-1.0 * mult * lambda / 2.0, mult * lambda / 2.0, -1.0 * mult * lambda / 2.0, mult * lambda / 2.0};
        PrimitiveNode mpac = tech.findNodeProto("Metal-1-N-Active-Con");
        PrimitiveNode mpwc = tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-2.0 * lambda, 2.0 * lambda, -2.0 * lambda, 2.0 * lambda};
        PrimitiveNode mpc = tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double mx = 5.0;
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -mx * lambda / 2.0, mx * lambda / 2.0};
        ArcProto parc = tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = tech.findArcProto("Metal-1");
        ArcProto m2arc = tech.findArcProto("Metal-2");
        ArcProto ndiffarc = tech.findArcProto("N-Active");
        PrimitiveNode pwnode = tech.findNodeProto("P-Well-Node");
        double[] pwnodebox = new double[]{-pwnode.getDefWidth() / 2.0 - lambda / 2.0, pwnode.getDefWidth() / 2.0 + lambda / 2.0, -pwnode.getDefHeight() / 2.0 - lambda / 2.0, pwnode.getDefHeight() / 2.0 + lambda / 2.0};
        Cell muxplane = Cell.newInstance(Library.getCurrent(), mp + "{lay}");
        NodeInst pwellnode = ROMGenerator.makeCStyleNodeInst(pwnode, -8.0 * lambda, lambda * 8.0 * (double)(folds + 1), -8.0 * lambda, 8.0 * lambda * 3.0 * (double)romoutputs / 2.0, 0, 0, muxplane);
        double x = 0.0;
        for (i = 0; i < selects + 1; ++i) {
            x += 8.0 * lambda;
            double y = 0.0;
            if (i < selects) {
                ntrans[0][i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2], ppinbox[3], 0, 0, muxplane);
                m1polypins[i] = ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x, mpcbox[1] + x, mpcbox[2], mpcbox[3], 0, 0, muxplane);
                m1m2pins[i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2], m1m2cbox[3], 0, 0, muxplane);
                ap1 = m1m2pins[i];
                apport1 = m1m2cport;
                ROMGenerator.makeCStyleExport(muxplane, ap1, apport1, "sel" + (selects - i - 1), PortCharacteristic.IN);
            }
            for (m = 0; m < outputbits; ++m) {
                y += 8.0 * lambda;
                if (m % 2 == 1) {
                    y += 8.0 * lambda;
                }
                if (i < selects) {
                    ntrans[m + 1][i] = muxarray[m][i] == 1 ? ROMGenerator.makeCStyleNodeInst(nmos, nmosbox[0] + x, nmosbox[1] + x, nmosbox[2] + y, nmosbox[3] + y, 1, 0, muxplane) : ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y, ppinbox[3] + y, 0, 0, muxplane);
                }
                boolean transcont = false;
                if (i < selects) {
                    boolean bl = transcont = muxarray[m][i] == 1;
                }
                if (i == selects) {
                    m1m2pins2[m] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 4.0 * lambda, m1m2cbox[1] + x - 4.0 * lambda, m1m2cbox[2] + y, m1m2cbox[3] + y, 0, 0, muxplane);
                    m1m2ports2[m] = m1m2cport;
                }
                if (i >= 1) {
                    transcont |= muxarray[m][i - 1] == 1;
                }
                if (transcont) {
                    minpins[m][i] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x - 4.0 * lambda, mnacbox[1] + x - 4.0 * lambda, mnacbox[2] + y, mnacbox[3] + y, 0, 0, muxplane);
                    minports[m][i] = mnacport;
                    continue;
                }
                minpins[m][i] = ROMGenerator.makeCStyleNodeInst(m1pin, m1pinbox[0] + x - 4.0 * lambda, m1pinbox[1] + x - 4.0 * lambda, m1pinbox[2] + y, m1pinbox[3] + y, 0, 0, muxplane);
                minports[m][i] = m1pinport;
            }
        }
        for (i = 0; i < selects; ++i) {
            ap1 = ntrans[0][i];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1polypins[i];
            apport2 = mpcport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            NodeInst ap3 = m1m2pins[i];
            apport3 = m1m2cport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap2, apport2, appos2[0], appos2[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i = 0; i < selects; ++i) {
            ap1 = ntrans[0][i];
            apport1 = ppinport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m = 1; m < outputbits + 1; ++m) {
                ap2 = ntrans[m][i];
                if (muxarray[m - 1][i] == 1) {
                    apport2 = nmosg1port;
                    apport3 = nmosg2port;
                } else {
                    apport2 = ppinport;
                    apport3 = ppinport;
                }
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                appos3 = ROMGenerator.getCStylePortPosition(ap2, apport3);
                ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ap1 = ap2;
                apport1 = apport3;
                appos1 = appos3;
            }
        }
        for (m = 0; m < outputbits; ++m) {
            ap1 = minpins[m][0];
            apport1 = minports[m][0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i = 1; i < selects + 1; ++i) {
                ap2 = minpins[m][i];
                apport2 = minports[m][i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                if (muxarray[m][i - 1] != 1) {
                    ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                }
                if (i == 1) {
                    ROMGenerator.makeCStyleExport(muxplane, ap1, apport1, "muxin" + m, PortCharacteristic.IN);
                }
                ap1 = ap2;
                apport1 = apport2;
                appos1 = appos2;
            }
        }
        for (m = 0; m < outputbits; ++m) {
            for (i = 0; i < selects; ++i) {
                if (muxarray[m][i] != 1) continue;
                ap1 = ntrans[m + 1][i];
                apport1 = nmosd1port;
                apport2 = nmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                appos2 = ROMGenerator.getCStylePortPosition(ap1, apport2);
                NodeInst apx = minpins[m][i];
                NodeInst apy = minpins[m][i + 1];
                PortProto apportx = mnacport;
                PortProto apporty = mnacport;
                double[] apposx = ROMGenerator.getCStylePortPosition(apx, apportx);
                double[] apposy = ROMGenerator.getCStylePortPosition(apy, apporty);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], apx, apportx, apposx[0], apposx[1]);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, apport2, appos2[0], appos2[1], apy, apporty, apposy[0], apposy[1]);
            }
        }
        for (j = 0; j < outputbits; ++j) {
            i = selects;
            ap1 = minpins[j][i];
            apport1 = minports[j][i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = m1m2pins2[j];
            apport2 = m1m2ports2[j];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (j = 0; j < outputbits / muxnumber; ++j) {
            ap1 = m1m2pins2[j * muxnumber];
            apport1 = m1m2ports2[j * muxnumber];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (m = 1 + j * muxnumber; m < muxnumber + j * muxnumber; ++m) {
                ap2 = m1m2pins2[m];
                apport2 = m1m2ports2[m];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ROMGenerator.makeCStyleExport(muxplane, ap1, apport1, "muxout" + j, PortCharacteristic.OUT);
        }
    }

    private static void inverterplane(double lambda, int outs, int folds, String ip) {
        double[] vddpos1;
        PortProto vddport1;
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        double[] gndpos1;
        double[] appos1;
        PortProto gndport1;
        PortProto apport1;
        NodeInst ap1;
        NodeInst ap3;
        NodeInst ap2;
        int i;
        NodeInst[] ntrans = new NodeInst[outs / folds];
        NodeInst[] ptrans = new NodeInst[outs / folds];
        NodeInst[] inpins = new NodeInst[outs / folds];
        NodeInst[] polypins = new NodeInst[outs / folds];
        NodeInst[] intppins = new NodeInst[outs / folds];
        NodeInst[] nmospins = new NodeInst[outs / folds];
        NodeInst[] pmospins = new NodeInst[outs / folds];
        NodeInst[] gndpins = new NodeInst[outs / 2];
        NodeInst[] pwellpins = new NodeInst[outs / 2];
        NodeInst[] vddpins = new NodeInst[outs / 2];
        NodeInst[] midvddpins = new NodeInst[outs / 2];
        NodeInst[] gndpins2 = new NodeInst[outs / folds];
        NodeInst[] pwellpins2 = new NodeInst[outs / folds];
        NodeInst[] vddpins2 = new NodeInst[outs / folds];
        NodeInst[] midvddpins2 = new NodeInst[outs / folds];
        NodeInst gndc = null;
        NodeInst nwellc = null;
        NodeInst nwellm = null;
        PortProto[] ntransports = new PortProto[outs / folds];
        PortProto[] ptransports = new PortProto[outs / folds];
        PortProto[] inports = new PortProto[outs / folds];
        PortProto[] polyports = new PortProto[outs / folds];
        PortProto[] intpports = new PortProto[outs / folds];
        PortProto[] nmosports = new PortProto[outs / folds];
        PortProto[] pmosports = new PortProto[outs / folds];
        PortProto[] pwellports = new PortProto[outs / 2];
        PortProto[] gndports = new PortProto[outs / 2];
        PortProto[] vddports = new PortProto[outs / 2];
        PortProto[] midvddports = new PortProto[outs / 2];
        PortProto[] pwellports2 = new PortProto[outs / folds];
        PortProto[] gndports2 = new PortProto[outs / folds];
        PortProto[] vddports2 = new PortProto[outs / folds];
        PortProto[] midvddports2 = new PortProto[outs / folds];
        PortProto gndcport = null;
        PortProto nwellcport = null;
        PortProto nwellmport = null;
        PrimitiveNode nmos = tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("n-trans-poly-right");
        PortProto nmosg2port = nmos.findPortProto("n-trans-poly-left");
        PortProto nmosd1port = nmos.findPortProto("n-trans-diff-top");
        PortProto nmosd2port = nmos.findPortProto("n-trans-diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth() / 2.0 - lambda / 2.0, nmos.getDefWidth() / 2.0 + lambda / 2.0, -nmos.getDefHeight() / 2.0, nmos.getDefHeight() / 2.0};
        PrimitiveNode pmos = tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("p-trans-poly-right");
        PortProto pmosg2port = pmos.findPortProto("p-trans-poly-left");
        PortProto pmosd1port = pmos.findPortProto("p-trans-diff-top");
        PortProto pmosd2port = pmos.findPortProto("p-trans-diff-bottom");
        double[] pmosbox = new double[]{-pmos.getDefWidth() / 2.0 - lambda / 2.0, pmos.getDefWidth() / 2.0 + lambda / 2.0, -pmos.getDefHeight() / 2.0, pmos.getDefHeight() / 2.0};
        PrimitiveNode ppin = tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth() / 2.0, ppin.getDefWidth() / 2.0, -ppin.getDefHeight() / 2.0, ppin.getDefHeight() / 2.0};
        PrimitiveNode napin = tech.findNodeProto("N-Active-Pin");
        PrimitiveNode m1pin = tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode nwnode = tech.findNodeProto("N-Well-Node");
        double[] nwnodebox = new double[]{-nwnode.getDefWidth() / 2.0 - lambda / 2.0, nwnode.getDefWidth() / 2.0 + lambda / 2.0, -nwnode.getDefHeight() / 2.0 - lambda / 2.0, nwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode pwnode = tech.findNodeProto("P-Well-Node");
        double[] pwnodebox = new double[]{-pwnode.getDefWidth() / 2.0 - lambda / 2.0, pwnode.getDefWidth() / 2.0 + lambda / 2.0, -pwnode.getDefHeight() / 2.0 - lambda / 2.0, pwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m1m2c = tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode diffpin = tech.findNodeProto("Active-Pin");
        PortProto diffpinport = diffpin.getPort(0);
        double[] diffpinbox = new double[]{-diffpin.getDefWidth() / 2.0 - lambda / 2.0, diffpin.getDefWidth() / 2.0 + lambda / 2.0, -diffpin.getDefHeight() / 2.0 - lambda / 2.0, diffpin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode mnac = tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpac = tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpc = tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double mx = -7.0;
        double my = 5.0;
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -my * lambda / 2.0, my * lambda / 2.0};
        PrimitiveNode mpwc = tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double[] mnwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        ArcProto parc = tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = tech.findArcProto("Metal-1");
        ArcProto m2arc = tech.findArcProto("Metal-2");
        ArcProto ndiffarc = tech.findArcProto("N-Active");
        ArcProto pdiffarc = tech.findArcProto("P-Active");
        Cell invp = Cell.newInstance(Library.getCurrent(), ip + "{lay}");
        NodeInst pwellnode = ROMGenerator.makeCStyleNodeInst(pwnode, -32.0 * lambda, 3.0 * lambda * 8.0 * (double)outs / 2.0 + 8.0 * lambda, -18.0 * lambda, 16.0 * lambda, 0, 0, invp);
        NodeInst nwellnode = ROMGenerator.makeCStyleNodeInst(nwnode, -32.0 * lambda, 3.0 * lambda * 8.0 * (double)outs / 2.0 + 8.0 * lambda, -34.0 * lambda, -18.0 * lambda, 0, 0, invp);
        double x = 0.0 * lambda;
        for (i = 0; i < outs; ++i) {
            double off;
            x += 8.0 * lambda;
            double y = 0.0;
            if (folds > 1) {
                if (i % folds == 1) {
                    pwellpins2[i / folds] = ROMGenerator.makeCStyleNodeInst(mpwc, mpwcbox[0] + x, mpwcbox[1] + x, mpwcbox[2] + y, mpwcbox[3] + y, 0, 0, invp);
                    pwellports2[i / folds] = mpwcport;
                    gndpins2[i / folds] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                    gndports2[i / folds] = mnacport;
                    midvddpins2[i / folds] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    midvddports2[i / folds] = mpacport;
                    vddpins2[i / folds] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    vddports2[i / folds] = m1m2cport;
                    if (i == 1) {
                        gndc = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, invp);
                        gndcport = m1m2cport;
                        ROMGenerator.makeCStyleExport(invp, gndc, gndcport, "gnd", PortCharacteristic.GND);
                    }
                }
            } else if (i % 2 == 1) {
                gndpins[i / 2] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                gndports[i / 2] = mnacport;
                midvddpins[i / 2] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                midvddports[i / 2] = mpacport;
                vddpins[i / 2] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, invp);
                vddports[i / 2] = m1m2cport;
                if (i == 1) {
                    nwellc = ROMGenerator.makeCStyleNodeInst(mnwc, mnwcbox[0] + x - 24.0 * lambda, mnwcbox[1] + x - 24.0 * lambda, mnwcbox[2] + y - 26.0 * lambda, mnwcbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    nwellcport = mnwcport;
                    nwellm = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 24.0 * lambda, m1m2cbox[1] + x - 24.0 * lambda, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    nwellmport = m1m2cport;
                    gndc = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x, m1m2cbox[1] + x, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, invp);
                    gndcport = m1m2cport;
                    ROMGenerator.makeCStyleExport(invp, gndc, gndcport, "gnd", PortCharacteristic.GND);
                }
            }
            if (i % 2 == 1) {
                x += 8.0 * lambda;
            }
            if (folds > 1) {
                if (i % folds == 0) {
                    inpins[i / folds] = ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x - 6.0 * lambda, mpacbox[1] + x - 6.0 * lambda, mpcbox[2] + y, mpcbox[3] + y, 0, 0, invp);
                    inports[i / folds] = mpcport;
                    polypins[i / folds] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
                    polyports[i / folds] = ppinport;
                    nmospins[i / folds] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                    nmosports[i / folds] = mnacport;
                    pmospins[i / folds] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                    pmosports[i / folds] = mpacport;
                }
            } else {
                inpins[i] = ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x - 6.0 * lambda, mpacbox[1] + x - 6.0 * lambda, mpcbox[2] + y, mpcbox[3] + y, 0, 0, invp);
                inports[i] = mpcport;
                polypins[i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x, ppinbox[1] + x, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
                polyports[i] = ppinport;
                nmospins[i] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, invp);
                nmosports[i] = mnacport;
                pmospins[i] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, invp);
                pmosports[i] = mpacport;
            }
            if (folds > 1) {
                if (i % folds != 0) continue;
                off = 4.0 * lambda;
                ptrans[i / folds] = ROMGenerator.makeCStyleNodeInst(pmos, pmosbox[0] + x + off, pmosbox[1] + x + off, pmosbox[2] + y - 26.0 * lambda, pmosbox[3] + y - 26.0 * lambda, 1, 0, invp);
                ntrans[i / folds] = ROMGenerator.makeCStyleNodeInst(nmos, nmosbox[0] + x + off, nmosbox[1] + x + off, nmosbox[2] + y - 10.0 * lambda, nmosbox[3] + y - 10.0 * lambda, 1, 0, invp);
                intppins[i / folds] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x + off, ppinbox[1] + x + off, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
                intpports[i / folds] = ppinport;
                continue;
            }
            off = 0.0;
            off = i % 2 == 0 ? 4.0 * lambda : -4.0 * lambda;
            ptrans[i] = ROMGenerator.makeCStyleNodeInst(pmos, pmosbox[0] + x + off, pmosbox[1] + x + off, pmosbox[2] + y - 26.0 * lambda, pmosbox[3] + y - 26.0 * lambda, 1, 0, invp);
            ntrans[i] = ROMGenerator.makeCStyleNodeInst(nmos, nmosbox[0] + x + off, nmosbox[1] + x + off, nmosbox[2] + y - 10.0 * lambda, nmosbox[3] + y - 10.0 * lambda, 1, 0, invp);
            intppins[i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x + off, ppinbox[1] + x + off, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, invp);
            intpports[i] = ppinport;
        }
        if (folds > 1) {
            for (i = 0; i < outs / folds; ++i) {
                ap2 = nmospins[i];
                ap3 = gndpins2[i];
                ap1 = ntrans[i];
                apport1 = nmosd1port;
                gndport1 = nmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                gndpos1 = ROMGenerator.getCStylePortPosition(ap1, gndport1);
                apport2 = mnacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mnacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, gndport1, gndpos1[0], gndpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        } else {
            for (i = 0; i < outs; ++i) {
                if (i % 2 == 0) {
                    ap2 = nmospins[i];
                    ap3 = gndpins[i / 2];
                } else {
                    ap2 = gndpins[i / 2];
                    ap3 = nmospins[i];
                }
                ap1 = ntrans[i];
                apport1 = nmosd1port;
                gndport1 = nmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                gndpos1 = ROMGenerator.getCStylePortPosition(ap1, gndport1);
                apport2 = mnacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mnacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, gndport1, gndpos1[0], gndpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        }
        if (folds > 1) {
            for (i = 0; i < outs / folds; ++i) {
                ap2 = pmospins[i];
                ap3 = midvddpins2[i];
                ap1 = ptrans[i];
                ap1 = ptrans[i];
                apport1 = pmosd1port;
                vddport1 = pmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                vddpos1 = ROMGenerator.getCStylePortPosition(ap1, vddport1);
                apport2 = mpacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mpacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, vddport1, vddpos1[0], vddpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        } else {
            for (i = 0; i < outs; ++i) {
                if (i % 2 == 0) {
                    ap2 = pmospins[i];
                    ap3 = midvddpins[i / 2];
                } else {
                    ap2 = midvddpins[i / 2];
                    ap3 = pmospins[i];
                }
                ap1 = ptrans[i];
                apport1 = pmosd1port;
                vddport1 = pmosd2port;
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                vddpos1 = ROMGenerator.getCStylePortPosition(ap1, vddport1);
                apport2 = mpacport;
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                apport3 = mpacport;
                appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
                ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
                ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, vddport1, vddpos1[0], vddpos1[1], ap3, apport3, appos3[0], appos3[1]);
            }
        }
        for (i = 0; i < outs / folds; ++i) {
            ap1 = nmospins[i];
            apport1 = nmosports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pmospins[i];
            apport2 = pmosports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs / folds; ++i) {
            ap1 = inpins[i];
            apport1 = inports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = polypins[i];
            apport2 = polyports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs / folds; ++i) {
            ap1 = polypins[i];
            apport1 = polyports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = intppins[i];
            apport2 = intpports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs / folds; ++i) {
            ap1 = intppins[i];
            apport1 = intpports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ntrans[i];
            apport2 = nmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs / folds; ++i) {
            ap1 = ntrans[i];
            apport1 = nmosg1port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ptrans[i];
            apport2 = pmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (folds > 1) {
            for (i = 0; i < outs / folds; ++i) {
                ap1 = pwellpins2[i];
                apport1 = pwellports2[i];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = gndpins2[i];
                apport2 = gndports2[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            for (i = 0; i < outs / folds; ++i) {
                ap1 = midvddpins2[i];
                apport1 = midvddports2[i];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = vddpins2[i];
                apport2 = vddports2[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ap1 = vddpins2[0];
            apport1 = vddports2[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i = 1; i < outs / folds; ++i) {
                ap2 = vddpins2[i];
                apport2 = vddports2[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ROMGenerator.makeCStyleExport(invp, ap1, apport1, "vdd", PortCharacteristic.PWR);
            for (i = 0; i < outs / folds; ++i) {
                ap1 = gndpins2[i];
                apport1 = gndports2[i];
                ROMGenerator.makeCStyleExport(invp, ap1, apport1, "invgnd" + i, PortCharacteristic.GND);
            }
            ap1 = gndpins2[0];
            apport1 = gndports2[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        } else {
            for (i = 0; i < outs / 2; ++i) {
                ap1 = midvddpins[i];
                apport1 = midvddports[i];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = vddpins[i];
                apport2 = vddports[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ap1 = vddpins[0];
            apport1 = vddports[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nwellm;
            apport2 = nwellmport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ap3 = nwellc;
            apport3 = nwellcport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap3, apport3, appos3[0], appos3[1], ap2, apport2, appos2[0], appos2[1]);
            ap1 = vddpins[0];
            apport1 = vddports[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            for (i = 1; i < outs / 2; ++i) {
                ap2 = vddpins[i];
                apport2 = vddports[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
            ROMGenerator.makeCStyleExport(invp, ap1, apport1, "vdd", PortCharacteristic.PWR);
            for (i = 0; i < outs / 2; ++i) {
                ap1 = gndpins[i];
                apport1 = gndports[i];
                ROMGenerator.makeCStyleExport(invp, ap1, apport1, "invgnd" + i, PortCharacteristic.GND);
            }
            ap1 = gndpins[0];
            apport1 = gndports[0];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        }
        ap2 = gndc;
        apport2 = gndcport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        for (i = 0; i < outs / folds; ++i) {
            ap1 = inpins[i];
            apport1 = inports[i];
            ROMGenerator.makeCStyleExport(invp, ap1, apport1, "invin" + i, PortCharacteristic.IN);
        }
        for (i = 0; i < outs / folds; ++i) {
            ap1 = pmospins[i];
            apport1 = pmosports[i];
            ROMGenerator.makeCStyleExport(invp, ap1, apport1, "invout" + (outs / folds - 1 - i), PortCharacteristic.OUT);
        }
    }

    private static void ininverterplane(double lambda, int outs, String layoutname, boolean top, int lengthbits) {
        double[] appos3;
        PortProto apport3;
        double[] appos2;
        PortProto apport2;
        double[] appos1;
        PortProto apport1;
        NodeInst ap1;
        NodeInst ap3;
        NodeInst ap2;
        int i;
        NodeInst[] ntrans = new NodeInst[outs];
        NodeInst[] ptrans = new NodeInst[outs];
        NodeInst[] inpins = new NodeInst[outs];
        NodeInst[] inpins2 = new NodeInst[outs];
        NodeInst[] outpins = new NodeInst[outs];
        NodeInst[] outpins2 = new NodeInst[outs];
        NodeInst[] polypins = new NodeInst[outs];
        NodeInst[] intppins = new NodeInst[outs];
        NodeInst[] polypins2 = new NodeInst[outs];
        NodeInst[] intppins2 = new NodeInst[outs];
        NodeInst[] gndpins = new NodeInst[outs];
        NodeInst[] midvddpins = new NodeInst[outs];
        NodeInst[] nmospins = new NodeInst[outs];
        NodeInst[] gndpins2 = new NodeInst[outs];
        NodeInst[] vddpins = new NodeInst[outs];
        NodeInst[] pmospins = new NodeInst[outs];
        NodeInst vddc = null;
        NodeInst nwellc = null;
        NodeInst gndc = null;
        NodeInst pwellc = null;
        PortProto[] ntransports = new PortProto[outs];
        PortProto[] ptransports = new PortProto[outs];
        PortProto[] inports = new PortProto[outs];
        PortProto[] outports = new PortProto[outs];
        PortProto[] inports2 = new PortProto[outs];
        PortProto[] outports2 = new PortProto[outs];
        PortProto[] polyports = new PortProto[outs];
        PortProto[] intpports = new PortProto[outs];
        PortProto[] polyports2 = new PortProto[outs];
        PortProto[] intpports2 = new PortProto[outs];
        PortProto[] nmosports = new PortProto[outs];
        PortProto[] pmosports = new PortProto[outs];
        PortProto[] gndports = new PortProto[outs];
        PortProto[] gndports2 = new PortProto[outs];
        PortProto[] vddports = new PortProto[outs];
        PortProto[] midvddports = new PortProto[outs];
        PortProto vddcport = null;
        PortProto nwellport = null;
        PortProto gndcport = null;
        PortProto pwellport = null;
        PrimitiveNode nmos = tech.findNodeProto("N-Transistor");
        PortProto nmosg1port = nmos.findPortProto("n-trans-poly-right");
        PortProto nmosg2port = nmos.findPortProto("n-trans-poly-left");
        PortProto nmosd1port = nmos.findPortProto("n-trans-diff-top");
        PortProto nmosd2port = nmos.findPortProto("n-trans-diff-bottom");
        double[] nmosbox = new double[]{-nmos.getDefWidth() / 2.0 - lambda / 2.0, nmos.getDefWidth() / 2.0 + lambda / 2.0, -nmos.getDefHeight() / 2.0, nmos.getDefHeight() / 2.0};
        PrimitiveNode pmos = tech.findNodeProto("P-Transistor");
        PortProto pmosg1port = pmos.findPortProto("p-trans-poly-right");
        PortProto pmosg2port = pmos.findPortProto("p-trans-poly-left");
        PortProto pmosd1port = pmos.findPortProto("p-trans-diff-top");
        PortProto pmosd2port = pmos.findPortProto("p-trans-diff-bottom");
        double[] pmosbox = new double[]{-pmos.getDefWidth() / 2.0 - lambda / 2.0, pmos.getDefWidth() / 2.0 + lambda / 2.0, -pmos.getDefHeight() / 2.0, pmos.getDefHeight() / 2.0};
        PrimitiveNode ppin = tech.findNodeProto("Polysilicon-1-Pin");
        PortProto ppinport = ppin.getPort(0);
        double[] ppinbox = new double[]{-ppin.getDefWidth() / 2.0, ppin.getDefWidth() / 2.0, -ppin.getDefHeight() / 2.0, ppin.getDefHeight() / 2.0};
        PrimitiveNode napin = tech.findNodeProto("N-Active-Pin");
        PrimitiveNode m1pin = tech.findNodeProto("Metal-1-Pin");
        PortProto m1pinport = m1pin.getPort(0);
        double[] m1pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m2pin = tech.findNodeProto("Metal-2-Pin");
        PortProto m2pinport = m2pin.getPort(0);
        double[] m2pinbox = new double[]{-m1pin.getDefWidth() / 2.0 - lambda / 2.0, m1pin.getDefWidth() / 2.0 + lambda / 2.0, -m1pin.getDefHeight() / 2.0 - lambda / 2.0, m1pin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode nwnode = tech.findNodeProto("N-Well-Node");
        double[] nwnodebox = new double[]{-nwnode.getDefWidth() / 2.0 - lambda / 2.0, nwnode.getDefWidth() / 2.0 + lambda / 2.0, -nwnode.getDefHeight() / 2.0 - lambda / 2.0, nwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode pwnode = tech.findNodeProto("P-Well-Node");
        double[] pwnodebox = new double[]{-pwnode.getDefWidth() / 2.0 - lambda / 2.0, pwnode.getDefWidth() / 2.0 + lambda / 2.0, -pwnode.getDefHeight() / 2.0 - lambda / 2.0, pwnode.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode m1m2c = tech.findNodeProto("Metal-1-Metal-2-Con");
        PortProto m1m2cport = m1m2c.getPort(0);
        double[] m1m2cbox = new double[]{-5.0 * lambda / 2.0, 5.0 * lambda / 2.0, -5.0 * lambda / 2.0, 5.0 * lambda / 2.0};
        PrimitiveNode diffpin = tech.findNodeProto("Active-Pin");
        PortProto diffpinport = diffpin.getPort(0);
        double[] diffpinbox = new double[]{-diffpin.getDefWidth() / 2.0 - lambda / 2.0, diffpin.getDefWidth() / 2.0 + lambda / 2.0, -diffpin.getDefHeight() / 2.0 - lambda / 2.0, diffpin.getDefHeight() / 2.0 + lambda / 2.0};
        PrimitiveNode mnac = tech.findNodeProto("Metal-1-N-Active-Con");
        PortProto mnacport = mnac.getPort(0);
        double aaa = 17.0;
        double[] mnacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        PrimitiveNode mpac = tech.findNodeProto("Metal-1-P-Active-Con");
        PortProto mpacport = mpac.getPort(0);
        double[] mpacbox = new double[]{-aaa * lambda / 2.0, aaa * lambda / 2.0, -aaa * lambda / 2.0, aaa * lambda / 2.0};
        double mx = -7.0;
        double my = 5.0;
        PrimitiveNode mpc = tech.findNodeProto("Metal-1-Polysilicon-1-Con");
        PortProto mpcport = mpc.getPort(0);
        double[] mpcbox = new double[]{-mx * lambda / 2.0, mx * lambda / 2.0, -my * lambda / 2.0, my * lambda / 2.0};
        PrimitiveNode mpwc = tech.findNodeProto("Metal-1-P-Well-Con");
        PortProto mpwcport = mpwc.getPort(0);
        double[] mpwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        PrimitiveNode mnwc = tech.findNodeProto("Metal-1-N-Well-Con");
        PortProto mnwcport = mnwc.getPort(0);
        double[] mnwcbox = new double[]{-17.0 * lambda / 2.0, 17.0 * lambda / 2.0, -17.0 * lambda / 2.0, 17.0 * lambda / 2.0};
        ArcProto parc = tech.findArcProto("Polysilicon-1");
        ArcProto m1arc = tech.findArcProto("Metal-1");
        ArcProto m2arc = tech.findArcProto("Metal-2");
        ArcProto ndiffarc = tech.findArcProto("N-Active");
        ArcProto pdiffarc = tech.findArcProto("P-Active");
        Cell ininvp = Cell.newInstance(Library.getCurrent(), layoutname + "{lay}");
        NodeInst pwellnode = ROMGenerator.makeCStyleNodeInst(pwnode, -8.0 * lambda, 4.0 * lambda * 8.0 * (double)lengthbits + 24.0 * lambda, -18.0 * lambda, 10.0 * lambda, 0, 0, ininvp);
        NodeInst nwellnode = ROMGenerator.makeCStyleNodeInst(nwnode, -8.0 * lambda, 4.0 * lambda * 8.0 * (double)lengthbits + 24.0 * lambda, -36.0 * lambda, -18.0 * lambda, 0, 0, ininvp);
        double x = 0.0;
        for (i = 0; i < outs; ++i) {
            double y = 0.0;
            gndpins[i] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + (x += 8.0 * lambda), mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            gndports[i] = mnacport;
            midvddpins[i] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            midvddports[i] = mpacport;
            double off = 4.0 * lambda;
            ptrans[i] = ROMGenerator.makeCStyleNodeInst(pmos, pmosbox[0] + x + off, pmosbox[1] + x + off, pmosbox[2] + y - 26.0 * lambda, pmosbox[3] + y - 26.0 * lambda, 1, 0, ininvp);
            ntrans[i] = ROMGenerator.makeCStyleNodeInst(nmos, nmosbox[0] + x + off, nmosbox[1] + x + off, nmosbox[2] + y - 10.0 * lambda, nmosbox[3] + y - 10.0 * lambda, 1, 0, ininvp);
            polypins[i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + (x += 8.0 * lambda) - 8.0 * lambda, ppinbox[1] + x - 8.0 * lambda, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, ininvp);
            polyports[i] = ppinport;
            inpins[i] = ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x - 14.0 * lambda, mpacbox[1] + x - 14.0 * lambda, mpcbox[2] + y, mpcbox[3] + y, 0, 0, ininvp);
            inports[i] = mpcport;
            if (top) {
                inpins2[i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y + 8.0 * lambda * (double)(i + 1), m1m2cbox[3] + y + 8.0 * lambda * (double)(i + 1), 0, 0, ininvp);
                inports2[i] = m1m2cport;
            }
            intppins[i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x - off, ppinbox[1] + x - off, ppinbox[2] + y - 6.0 * lambda, ppinbox[3] + y - 6.0 * lambda, 0, 0, ininvp);
            intpports[i] = ppinport;
            pmospins[i] = ROMGenerator.makeCStyleNodeInst(mpac, mpacbox[0] + x, mpacbox[1] + x, mpacbox[2] + y - 26.0 * lambda, mpacbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            pmosports[i] = mpacport;
            vddpins[i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            vddports[i] = m1m2cport;
            nmospins[i] = ROMGenerator.makeCStyleNodeInst(mnac, mnacbox[0] + x, mnacbox[1] + x, mnacbox[2] + y - 10.0 * lambda, mnacbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            nmosports[i] = mnacport;
            gndpins2[i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            gndports2[i] = m1m2cport;
            outpins[i] = ROMGenerator.makeCStyleNodeInst(mpc, mpcbox[0] + x - 14.0 * lambda, mpacbox[1] + x - 14.0 * lambda, mpcbox[2] + y - 36.0 * lambda, mpcbox[3] + y - 36.0 * lambda, 0, 0, ininvp);
            outports[i] = mpcport;
            if (!top) {
                outpins2[i] = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x - 8.0 * lambda, m1m2cbox[1] + x - 8.0 * lambda, m1m2cbox[2] + y - 8.0 * lambda * (double)(i + 1) - 36.0 * lambda, m1m2cbox[3] + y - 8.0 * lambda * (double)(i + 1) - 36.0 * lambda, 0, 0, ininvp);
                outports2[i] = m1m2cport;
            }
            polypins2[i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x - 8.0 * lambda, ppinbox[1] + x - 8.0 * lambda, ppinbox[2] + y - 30.0 * lambda, ppinbox[3] + y - 30.0 * lambda, 0, 0, ininvp);
            polyports2[i] = ppinport;
            intppins2[i] = ROMGenerator.makeCStyleNodeInst(ppin, ppinbox[0] + x - off, ppinbox[1] + x - off, ppinbox[2] + y - 30.0 * lambda, ppinbox[3] + y - 30.0 * lambda, 0, 0, ininvp);
            intpports2[i] = ppinport;
            if (i != outs - 1) continue;
            if (top) {
                vddc = ROMGenerator.makeCStyleNodeInst(m2pin, m2pinbox[0] + x + 12.0 * lambda, m2pinbox[1] + x + 12.0 * lambda, m2pinbox[2] + y - 26.0 * lambda, m2pinbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
                vddcport = m2pinport;
                gndc = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x + 12.0 * lambda, m1m2cbox[1] + x + 12.0 * lambda, m1m2cbox[2] + y - 10.0 * lambda, m1m2cbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
                gndcport = m1m2cport;
                pwellc = ROMGenerator.makeCStyleNodeInst(mpwc, mpwcbox[0] + x + 12.0 * lambda, mpwcbox[1] + x + 12.0 * lambda, mpwcbox[2] + y - 10.0 * lambda, mpwcbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
                pwellport = mpwcport;
                continue;
            }
            vddc = ROMGenerator.makeCStyleNodeInst(m1m2c, m1m2cbox[0] + x + 12.0 * lambda, m1m2cbox[1] + x + 12.0 * lambda, m1m2cbox[2] + y - 26.0 * lambda, m1m2cbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            vddcport = m1m2cport;
            nwellc = ROMGenerator.makeCStyleNodeInst(mnwc, mnwcbox[0] + x + 12.0 * lambda, mnwcbox[1] + x + 12.0 * lambda, mnwcbox[2] + y - 26.0 * lambda, mnwcbox[3] + y - 26.0 * lambda, 0, 0, ininvp);
            nwellport = mnwcport;
            gndc = ROMGenerator.makeCStyleNodeInst(m2pin, m2pinbox[0] + x + 12.0 * lambda, m2pinbox[1] + x + 12.0 * lambda, m2pinbox[2] + y - 10.0 * lambda, m2pinbox[3] + y - 10.0 * lambda, 0, 0, ininvp);
            gndcport = m2pinport;
        }
        for (i = 0; i < outs; ++i) {
            ap2 = gndpins[i];
            ap3 = nmospins[i];
            ap1 = ntrans[i];
            apport1 = nmosd1port;
            PortProto gndport1 = nmosd2port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            double[] gndpos1 = ROMGenerator.getCStylePortPosition(ap1, gndport1);
            apport2 = mnacport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            apport3 = mnacport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(ndiffarc, 16.0 * lambda, ap1, gndport1, gndpos1[0], gndpos1[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap2 = midvddpins[i];
            ap3 = pmospins[i];
            ap1 = ptrans[i];
            apport1 = pmosd1port;
            PortProto vddport1 = pmosd2port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            double[] vddpos1 = ROMGenerator.getCStylePortPosition(ap1, vddport1);
            apport2 = mpacport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            apport3 = mpacport;
            appos3 = ROMGenerator.getCStylePortPosition(ap3, apport3);
            ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            ROMGenerator.makeCStyleArcInst(pdiffarc, 16.0 * lambda, ap1, vddport1, vddpos1[0], vddpos1[1], ap3, apport3, appos3[0], appos3[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = nmospins[i];
            apport1 = nmosports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pmospins[i];
            apport2 = pmosports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (top) {
            ap1 = gndc;
            apport1 = gndcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = pwellc;
            apport2 = pwellport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        } else {
            ap1 = vddc;
            apport1 = vddcport;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = nwellc;
            apport2 = nwellport;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        if (top) {
            for (i = 0; i < outs; ++i) {
                ap1 = inpins[i];
                apport1 = inports[i];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = inpins2[i];
                apport2 = inports2[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        } else {
            for (i = 0; i < outs; ++i) {
                ap1 = outpins[i];
                apport1 = outports[i];
                appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
                ap2 = outpins2[i];
                apport2 = outports2[i];
                appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
                ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
            }
        }
        for (i = 0; i < outs; ++i) {
            ap1 = inpins[i];
            apport1 = inports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = polypins[i];
            apport2 = polyports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = polypins[i];
            apport1 = polyports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = intppins[i];
            apport2 = intpports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = intppins[i];
            apport1 = intpports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ntrans[i];
            apport2 = nmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = ntrans[i];
            apport1 = nmosg1port;
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ptrans[i];
            apport2 = pmosg2port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = outpins[i];
            apport1 = outports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = polypins2[i];
            apport2 = polyports2[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = polypins2[i];
            apport1 = polyports2[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = intppins2[i];
            apport2 = intpports2[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = intppins2[i];
            apport1 = intpports2[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = ptrans[i];
            apport2 = pmosg1port;
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(parc, 2.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = midvddpins[i];
            apport1 = midvddports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = vddpins[i];
            apport2 = vddports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        for (i = 0; i < outs; ++i) {
            ap1 = gndpins[i];
            apport1 = gndports[i];
            appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
            ap2 = gndpins2[i];
            apport2 = gndports2[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m1arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = gndpins2[0];
        apport1 = gndports2[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (i = 1; i < outs; ++i) {
            ap2 = gndpins2[i];
            apport2 = gndports2[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = vddpins[0];
        apport1 = vddports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        for (i = 1; i < outs; ++i) {
            ap2 = vddpins[i];
            apport2 = vddports[i];
            appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
            ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        }
        ap1 = vddpins[0];
        apport1 = vddports[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = vddc;
        apport2 = vddcport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleExport(ininvp, ap2, apport2, "vdd", PortCharacteristic.PWR);
        ap1 = gndpins2[0];
        apport1 = gndports2[0];
        appos1 = ROMGenerator.getCStylePortPosition(ap1, apport1);
        ap2 = gndc;
        apport2 = gndcport;
        appos2 = ROMGenerator.getCStylePortPosition(ap2, apport2);
        ROMGenerator.makeCStyleArcInst(m2arc, 4.0 * lambda, ap1, apport1, appos1[0], appos1[1], ap2, apport2, appos2[0], appos2[1]);
        ROMGenerator.makeCStyleExport(ininvp, ap2, apport2, "gnd", PortCharacteristic.GND);
        if (top) {
            for (i = 0; i < outs; ++i) {
                ap1 = inpins2[i];
                apport1 = inports2[i];
                ROMGenerator.makeCStyleExport(ininvp, ap1, apport1, "in_top" + i, PortCharacteristic.IN);
            }
        } else {
            for (i = 0; i < outs; ++i) {
                ap1 = inpins[i];
                apport1 = inports[i];
                ROMGenerator.makeCStyleExport(ininvp, ap1, apport1, "in_top" + i, PortCharacteristic.IN);
            }
        }
        if (top) {
            for (i = 0; i < outs; ++i) {
                ap1 = outpins[i];
                apport1 = outports[i];
                ROMGenerator.makeCStyleExport(ininvp, ap1, apport1, "in_bot" + i, PortCharacteristic.IN);
            }
        } else {
            for (i = 0; i < outs; ++i) {
                ap1 = outpins2[i];
                apport1 = outports2[i];
                ROMGenerator.makeCStyleExport(ininvp, ap1, apport1, "in_bot" + i, PortCharacteristic.IN);
            }
        }
        for (i = 0; i < outs; ++i) {
            ap1 = pmospins[i];
            apport1 = pmosports[i];
            ROMGenerator.makeCStyleExport(ininvp, ap1, apport1, "in_b" + i, PortCharacteristic.IN);
        }
    }

    private static int[][] romarraygen(String romfile) {
        boolean end = false;
        int[][] returnarray = new int[1][1];
        try {
            BufferedReader in = new BufferedReader(new FileReader(romfile));
            try {
                int w = -1;
                int bits = 0;
                StringBuffer allfile = new StringBuffer();
                while (!end) {
                    ++w;
                    String temp = in.readLine();
                    if (temp == null) {
                        end = true;
                        continue;
                    }
                    StringBuffer sb = new StringBuffer(temp);
                    if (w == 1) {
                        bits = sb.length();
                    }
                    if (w == 0) {
                        folds = Integer.parseInt(temp, 10);
                        continue;
                    }
                    allfile.append(sb);
                }
                globalbits = --w / folds;
                returnarray = new int[bits][w];
                for (int r = 0; r < w; ++r) {
                    for (int s = 0; s < bits; ++s) {
                        returnarray[s][w - r - 1] = allfile.charAt(r * bits + s) == '1' ? 1 : 0;
                    }
                }
            }
            catch (IOException e) {
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        return returnarray;
    }

    private static int[][] generateplane(int bits) {
        int lines = (int)Math.pow(2.0, bits);
        char[][] wordlines = new char[lines][bits];
        for (int i = 0; i < lines; ++i) {
            int h;
            int len = Integer.toBinaryString(i).length();
            int leadingz = bits - len;
            for (h = 0; h < leadingz; ++h) {
                wordlines[i][h] = 48;
            }
            for (int j = h; j < bits; ++j) {
                wordlines[i][j] = Integer.toBinaryString(i).charAt(j - h);
            }
        }
        int[][] x = new int[lines][bits];
        for (int j = 0; j < lines; ++j) {
            for (int k = 0; k < bits; ++k) {
                x[j][k] = Character.getNumericValue(wordlines[j][k]);
            }
        }
        int[][] wcomp = new int[lines][2 * bits];
        for (int j = 0; j < lines; ++j) {
            for (int k = 0; k < bits; ++k) {
                wcomp[j][2 * k] = x[j][k];
                int complement = x[j][k] == 1 ? 0 : 1;
                wcomp[j][2 * k + 1] = complement;
            }
        }
        int[][] wcompb = new int[lines][2 * bits];
        for (int j = 0; j < lines; ++j) {
            for (int k = 0; k < 2 * bits; ++k) {
                wcompb[j][k] = wcomp[j][2 * bits - 1 - k];
            }
        }
        return wcompb;
    }

    private static int[][] romfold(int[][] romarray) {
        int roma = romarray.length * folds;
        int romb = romarray[1].length / folds;
        int[][] foldedrom = new int[roma][romb];
        for (int i = 0; i < romarray.length; ++i) {
            for (int j = 0; j < folds; ++j) {
                for (int k = 0; k < romb; ++k) {
                    foldedrom[ROMGenerator.folds * i + j][k] = romarray[i][j * romb + k];
                }
            }
        }
        return foldedrom;
    }

    private static NodeInst makeCStyleNodeInst(NodeProto np, double lX, double hX, double lY, double hY, int trn, int rot, Cell parent) {
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        if (np instanceof Cell) {
            Rectangle2D bounds = ((Cell)np).getBounds();
            cX -= bounds.getCenterX();
            cY -= bounds.getCenterY();
        }
        double width = hX - lX;
        double height = hY - lY;
        Orientation orient = Orientation.fromC(rot, trn != 0);
        NodeInst ni = NodeInst.makeInstance(np, new Point2D.Double(cX, cY), width, height, parent, orient, null, 0);
        return ni;
    }

    private static void makeCStyleArcInst(ArcProto ap, double wid, NodeInst hNI, PortProto hPP, double hX, double hY, NodeInst tNI, PortProto tPP, double tX, double tY) {
        PortInst head = hNI.findPortInstFromProto(hPP);
        PortInst tail = tNI.findPortInstFromProto(tPP);
        ArcInst ai = ArcInst.makeInstance(ap, wid, head, tail, new Point2D.Double(hX, hY), new Point2D.Double(tX, tY), null);
    }

    private static void makeCStyleExport(Cell parent, NodeInst ni, PortProto pp, String name, PortCharacteristic exporttype) {
        PortInst pi = ni.findPortInstFromProto(pp);
        Export e = Export.newInstance(parent, pi, name);
        e.setCharacteristic(exporttype);
    }

    private static double[] getCStylePortPosition(NodeInst ni, PortProto pp) {
        PortInst pi = ni.findPortInstFromProto(pp);
        Poly poly = pi.getPoly();
        double[] ret = new double[]{poly.getCenterX(), poly.getCenterY()};
        return ret;
    }

    static {
        lambda = 1.0;
    }

    private static class DoROM
    extends Job {
        private String romfile;

        private DoROM(String romfile) {
            super("ROM Generator", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.romfile = romfile;
            this.startJob();
        }

        public boolean doIt() {
            String romcell = "ROMCELL";
            Cell toplevel = ROMGenerator.makeAROM(this.romfile, romcell);
            if (toplevel == null) {
                return false;
            }
            FileMenu.CreateCellWindow creator = new FileMenu.CreateCellWindow(toplevel);
            SwingUtilities.invokeLater(creator);
            return true;
        }
    }
}

