/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClickZoomWireListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener,
ActionListener {
    private static Preferences prefs = Preferences.userNodeForPackage(ClickZoomWireListener.class);
    private static long cancelMoveDelayMillis;
    private static long zoomInDelayMillis;
    private static final boolean debug = false;
    public static ClickZoomWireListener theOne;
    private int clickX;
    private int clickY;
    private Cell startCell;
    private double dbMoveStartX;
    private double dbMoveStartY;
    private double lastdbMouseX;
    private double lastdbMouseY;
    private Mode modeLeft = Mode.none;
    private Mode modeRight = Mode.none;
    private boolean specialSelect = false;
    private boolean invertSelection = false;
    private boolean another;
    private long leftMousePressedTimeStamp;
    private long rightMousePressedTimeStamp;
    private ElectricObject wiringTarget;
    private InteractiveRouter router = new SimpleWirer();
    private ElectricObject startObj;
    private ElectricObject endObj;
    private ArcProto currentArcWhenWiringPressed;
    private int mouseX;
    private int mouseY;
    private Highlight2 moveDelta;
    private EventListener oldListener;
    private static final boolean isMac;
    private static final String cancelMoveDelayMillisPref = "cancelMoveDelayMillis";
    private static final String zoomInDelayMillisPref = "zoomInDelayMillis";

    private ClickZoomWireListener() {
        this.router.setTool(User.getUserTool());
        this.readPrefs();
    }

    public void setSpecialSelect() {
        this.specialSelect = true;
    }

    public void clearSpecialSelect() {
        this.specialSelect = false;
    }

    public boolean getStickyMove() {
        return false;
    }

    public void setRouter(InteractiveRouter router) {
        this.router = router;
    }

    public boolean getStickyWiring() {
        return true;
    }

    public Point2D getLastMouse() {
        return new Point2D.Double(this.mouseX, this.mouseY);
    }

    public void zoomBoxSingleShot(EventListener oldListener) {
        this.modeRight = Mode.zoomBoxSingleShot;
        this.modeLeft = Mode.zoomBoxSingleShot;
        this.oldListener = oldListener;
    }

    private boolean isLeftMouse(MouseEvent evt) {
        return isMac ? !evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16 : (evt.getModifiers() & 0x10) == 16;
    }

    public static boolean isRightMouse(InputEvent evt) {
        if (isMac) {
            if (evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16) {
                return true;
            }
            if ((evt.getModifiers() & 4) == 4) {
                return true;
            }
        } else if ((evt.getModifiers() & 4) == 4) {
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            this.startCell = wnd.getCell();
            if (this.startCell == null) {
                return;
            }
            this.clickX = evt.getX();
            this.clickY = evt.getY();
            Point2D dbClick = wnd.screenToDatabase(this.clickX, this.clickY);
            this.lastdbMouseX = dbClick.getX();
            this.lastdbMouseY = dbClick.getY();
            boolean another = (evt.getModifiersEx() & 0x80) != 0;
            this.invertSelection = (evt.getModifiersEx() & 0x40) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.rightMousePressedTimeStamp = currentTime;
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    return;
                }
                if (!this.invertSelection) {
                    ElectricObject eobj1;
                    Highlight2 h1;
                    ArrayList<Highlight2> highlights = new ArrayList<Highlight2>();
                    for (Highlight2 h : highlighter.getHighlights()) {
                        ElectricObject eobj;
                        if (!h.isHighlightEOBJ() || !((eobj = h.getElectricObject()) instanceof PortInst) && !(eobj instanceof NodeInst) && !(eobj instanceof ArcInst)) continue;
                        highlights.add(h);
                    }
                    Iterator hIt = highlights.iterator();
                    if (highlights.size() == 2) {
                        h1 = (Highlight2)hIt.next();
                        Highlight2 h2 = (Highlight2)hIt.next();
                        ElectricObject eobj12 = h1.getElectricObject();
                        ElectricObject eobj2 = h2.getElectricObject();
                        if (eobj12 != null && eobj2 != null) {
                            this.modeRight = Mode.wiringConnect;
                            this.wiringTarget = null;
                            this.startObj = h1.getElectricObject();
                            this.endObj = h2.getElectricObject();
                            this.currentArcWhenWiringPressed = User.getUserTool().getCurrentArcProto();
                            EditWindow.gridAlign(dbClick);
                            this.router.highlightRoute(wnd, this.startCell, h1.getElectricObject(), h2.getElectricObject(), dbClick);
                            return;
                        }
                    }
                    if (highlights.size() == 1 && (eobj1 = (h1 = (Highlight2)hIt.next()).getElectricObject()) != null) {
                        this.modeRight = Mode.wiringFind;
                        this.endObj = null;
                        this.wiringTarget = null;
                        this.startObj = h1.getElectricObject();
                        this.router.startInteractiveRoute(wnd);
                        Highlight2 h2 = highlighter.findObject(dbClick, wnd, false, false, false, true, false, this.specialSelect, false);
                        if (h2 == null) {
                            this.endObj = null;
                            this.wiringTarget = null;
                        } else {
                            this.endObj = h2.getElectricObject();
                        }
                        this.currentArcWhenWiringPressed = User.getUserTool().getCurrentArcProto();
                        EditWindow.gridAlign(dbClick);
                        this.router.highlightRoute(wnd, this.startCell, h1.getElectricObject(), this.endObj, dbClick);
                        return;
                    }
                    System.out.println("Must start new arc from one node or arc; or wire two node/arcs together");
                    this.modeRight = Mode.none;
                    return;
                }
                wnd.setStartDrag(this.clickX, this.clickY);
                wnd.setEndDrag(this.clickX, this.clickY);
                wnd.setDoingAreaDrag();
                if (this.invertSelection && !another) {
                    this.modeRight = Mode.zoomOut;
                }
                if (another && this.invertSelection) {
                    highlighter.clear();
                    this.modeRight = Mode.drawBox;
                }
                return;
            }
            if (this.isLeftMouse(evt)) {
                if (this.modeLeft == Mode.zoomBoxSingleShot) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    return;
                }
                if (this.modeLeft == Mode.stickyMove) {
                    if (another) {
                        dbClick = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbClick);
                    }
                    Point2D.Double dbDelta = new Point2D.Double(dbClick.getX() - this.dbMoveStartX, dbClick.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                        highlighter.setHighlightOffset(0, 0);
                        CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                        wnd.repaintContents(null, false);
                    }
                    this.modeLeft = Mode.none;
                    return;
                }
                this.leftMousePressedTimeStamp = evt.getWhen();
                if (evt.getClickCount() == 2 && !another && !this.invertSelection && highlighter.getNumHighlights() >= 1) {
                    EditMenu.getInfoCommand(true);
                    return;
                }
                if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
                    wnd.setStartDrag(this.clickX, this.clickY);
                    wnd.setEndDrag(this.clickX, this.clickY);
                    wnd.setDoingAreaDrag();
                    highlighter.clear();
                    this.modeLeft = Mode.drawBox;
                    return;
                }
                if (!another && !this.invertSelection && highlighter.overHighlighted(wnd, this.clickX, this.clickY) != null) {
                    highlighter.finished();
                    this.dbMoveStartX = dbClick.getX();
                    this.dbMoveStartY = dbClick.getY();
                    this.moveDelta = null;
                    this.modeLeft = Mode.move;
                } else {
                    Highlight2 h = highlighter.findObject(dbClick, wnd, false, another, this.invertSelection, true, false, this.specialSelect, true);
                    if (h == null) {
                        wnd.setStartDrag(this.clickX, this.clickY);
                        wnd.setEndDrag(this.clickX, this.clickY);
                        wnd.setDoingAreaDrag();
                        this.modeLeft = Mode.selectBox;
                    } else {
                        this.dbMoveStartX = dbClick.getX();
                        this.dbMoveStartY = dbClick.getY();
                        this.moveDelta = null;
                        this.modeLeft = Mode.move;
                    }
                    this.mouseOver(dbClick, wnd);
                }
                return;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        long currentTime = System.currentTimeMillis();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            int mouseX = evt.getX();
            int mouseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(mouseX, mouseY);
            this.lastdbMouseX = (int)dbMouse.getX();
            this.lastdbMouseY = (int)dbMouse.getY();
            boolean another = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                if (this.modeRight == Mode.zoomBoxSingleShot) {
                    if (!wnd.isDoingAreaDrag()) {
                        wnd.setStartDrag(mouseX, mouseY);
                        wnd.setEndDrag(mouseX, mouseY);
                        wnd.setDoingAreaDrag();
                    }
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.zoomOut && currentTime - this.rightMousePressedTimeStamp > zoomInDelayMillis) {
                    this.modeRight = Mode.zoomBox;
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox) {
                    wnd.setEndDrag(mouseX, mouseY);
                }
                if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    Highlight2 h3 = highlighter.findObject(dbMouse, wnd, false, false, false, true, false, this.specialSelect, false);
                    if (h3 == null) {
                        EditWindow.gridAlign(dbMouse);
                        this.endObj = null;
                        this.wiringTarget = null;
                    } else {
                        Iterator<Highlight2> hIt;
                        this.endObj = null;
                        if (this.wiringTarget != null) {
                            EditWindow.gridAlign(dbMouse);
                            List<Highlight2> underCursor = Highlighter.findAllInArea(highlighter, cell, false, true, true, false, this.specialSelect, false, new Rectangle2D.Double(dbMouse.getX(), dbMouse.getY(), 0.0, 0.0), wnd);
                            for (Highlight2 h : underCursor) {
                                ElectricObject eobj = h.getElectricObject();
                                if (eobj != this.wiringTarget) continue;
                                this.endObj = this.wiringTarget;
                                break;
                            }
                            if (this.endObj == null) {
                                this.wiringTarget = null;
                            }
                        }
                        if (this.endObj == null && (hIt = highlighter.getHighlights().iterator()).hasNext()) {
                            Highlight2 h2 = hIt.next();
                            this.endObj = h2.getElectricObject();
                        }
                        EditWindow.gridAlign(dbMouse);
                    }
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.highlightRoute(wnd, cell, this.startObj, null, dbMouse);
                }
            }
            if (this.isLeftMouse(evt)) {
                if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.zoomBoxSingleShot) {
                    wnd.setEndDrag(mouseX, mouseY);
                    wnd.repaint();
                }
                if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                    if (another) {
                        dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse);
                    }
                    Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                    EditWindow.gridAlign(dbDelta);
                    Point screenDelta = wnd.deltaDatabaseToScreen(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                    highlighter.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                    if (this.moveDelta != null) {
                        highlighter.remove(this.moveDelta);
                    }
                    Rectangle2D bounds = wnd.getDisplayedBounds();
                    this.moveDelta = highlighter.addMessage(cell, "(" + ((Point2D)dbDelta).getX() + "," + ((Point2D)dbDelta).getY() + ")", new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
                    wnd.repaint();
                }
            }
            wnd.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            if (cell != this.startCell) {
                this.escapePressed(wnd);
                return;
            }
            int releaseX = evt.getX();
            int releaseY = evt.getY();
            Point2D dbMouse = wnd.screenToDatabase(releaseX, releaseY);
            boolean another = (evt.getModifiersEx() & 0x80) != 0;
            this.specialSelect = ToolBar.isSelectSpecial();
            if (ClickZoomWireListener.isRightMouse(evt)) {
                double scale;
                if (this.modeRight == Mode.zoomIn) {
                    scale = wnd.getScale();
                    wnd.setScale(scale * 2.0);
                    wnd.clearDoingAreaDrag();
                    wnd.getSavedFocusBrowser().saveCurrentFocus();
                    wnd.repaintContents(null, false);
                }
                if (this.modeRight == Mode.zoomOut) {
                    scale = wnd.getScale();
                    wnd.setScale(scale / 2.0);
                    if (wnd.isInPlaceEdit()) {
                        wnd.getInPlaceTransformOut().transform(dbMouse, dbMouse);
                    }
                    wnd.setOffset(dbMouse);
                    wnd.clearDoingAreaDrag();
                    wnd.getSavedFocusBrowser().saveCurrentFocus();
                    wnd.repaintContents(null, false);
                }
                if (this.modeRight == Mode.drawBox || this.modeRight == Mode.zoomBox || this.modeRight == Mode.zoomBoxSingleShot) {
                    Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                    Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                    double minSelX = Math.min(start.getX(), end.getX());
                    double maxSelX = Math.max(start.getX(), end.getX());
                    double minSelY = Math.min(start.getY(), end.getY());
                    double maxSelY = Math.max(start.getY(), end.getY());
                    boolean onePoint = true;
                    Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                    if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                        onePoint = false;
                    }
                    if (Math.abs(wnd.getStartDrag().getX() - wnd.getEndDrag().getX()) > 10.0 || Math.abs(wnd.getStartDrag().getY() - wnd.getEndDrag().getY()) > 10.0) {
                        onePoint = false;
                    }
                    if (this.modeRight == Mode.drawBox) {
                        highlighter.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
                    }
                    if (this.modeRight == Mode.zoomBoxSingleShot) {
                        if (!onePoint) {
                            wnd.focusScreen(bounds);
                        }
                        WindowFrame.setListener(this.oldListener);
                        if (this.modeLeft == Mode.zoomBoxSingleShot) {
                            this.modeLeft = Mode.none;
                        }
                    }
                    if (this.modeRight == Mode.zoomBox) {
                        if (onePoint) {
                            double scale2 = wnd.getScale();
                            wnd.setScale(scale2 / 2.0);
                            wnd.clearDoingAreaDrag();
                            wnd.getSavedFocusBrowser().saveCurrentFocus();
                            wnd.repaintContents(null, false);
                        } else {
                            wnd.focusScreen(bounds);
                        }
                    }
                    highlighter.finished();
                    wnd.clearDoingAreaDrag();
                    wnd.repaint();
                }
                if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringConnect) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, this.endObj, dbMouse);
                    this.wiringTarget = null;
                }
                if (this.modeRight == Mode.wiringToSpace) {
                    EditWindow.gridAlign(dbMouse);
                    User.getUserTool().setCurrentArcProto(this.currentArcWhenWiringPressed);
                    this.router.makeRoute(wnd, cell, this.startObj, null, dbMouse);
                    this.wiringTarget = null;
                }
                this.modeRight = Mode.none;
            }
            if (this.isLeftMouse(evt)) {
                long curTime = evt.getWhen();
                if ((this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) && curTime - this.leftMousePressedTimeStamp < cancelMoveDelayMillis) {
                    highlighter.setHighlightOffset(0, 0);
                    this.modeLeft = Mode.none;
                    if (this.moveDelta != null) {
                        highlighter.remove(this.moveDelta);
                    }
                    wnd.repaint();
                    return;
                }
                if (this.getStickyMove() && this.modeLeft == Mode.move) {
                    this.modeLeft = Mode.stickyMove;
                } else {
                    if (this.modeLeft == Mode.selectBox || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.zoomBoxSingleShot) {
                        Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
                        Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
                        double minSelX = Math.min(start.getX(), end.getX());
                        double maxSelX = Math.max(start.getX(), end.getX());
                        double minSelY = Math.min(start.getY(), end.getY());
                        double maxSelY = Math.max(start.getY(), end.getY());
                        boolean onePoint = true;
                        Rectangle2D.Double bounds = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
                        if (((RectangularShape)bounds).getHeight() > 4.0 && ((RectangularShape)bounds).getWidth() > 4.0) {
                            onePoint = false;
                        }
                        if (Math.abs(wnd.getStartDrag().getX() - wnd.getEndDrag().getX()) > 10.0 || Math.abs(wnd.getStartDrag().getY() - wnd.getEndDrag().getY()) > 10.0) {
                            onePoint = false;
                        }
                        if (this.modeLeft == Mode.selectBox) {
                            if (!this.invertSelection) {
                                highlighter.clear();
                            }
                            highlighter.selectArea(wnd, minSelX, maxSelX, minSelY, maxSelY, this.invertSelection, this.specialSelect);
                        }
                        if (this.modeLeft == Mode.drawBox) {
                            highlighter.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
                        }
                        if (this.modeLeft == Mode.zoomBoxSingleShot) {
                            if (!onePoint) {
                                wnd.focusScreen(bounds);
                            }
                            WindowFrame.setListener(this.oldListener);
                            if (this.modeRight == Mode.zoomBoxSingleShot) {
                                this.modeRight = Mode.none;
                            }
                        }
                        highlighter.finished();
                        wnd.clearDoingAreaDrag();
                        wnd.repaint();
                    }
                    if (this.modeLeft == Mode.move || this.modeLeft == Mode.stickyMove) {
                        if (another) {
                            dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse);
                        }
                        Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                        EditWindow.gridAlign(dbDelta);
                        if (this.moveDelta != null) {
                            highlighter.remove(this.moveDelta);
                        }
                        if (((Point2D)dbDelta).getX() != 0.0 || ((Point2D)dbDelta).getY() != 0.0) {
                            highlighter.setHighlightOffset(0, 0);
                            CircuitChanges.manyMove(((Point2D)dbDelta).getX(), ((Point2D)dbDelta).getY());
                            wnd.repaintContents(null, false);
                        }
                    }
                    this.modeLeft = Mode.none;
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.mouseX = evt.getX();
        this.mouseY = evt.getY();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            this.specialSelect = ToolBar.isSelectSpecial();
            Point2D dbMouse = wnd.screenToDatabase(this.mouseX, this.mouseY);
            if (this.modeLeft == Mode.stickyMove) {
                if (this.another) {
                    dbMouse = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.dbMoveStartX, this.dbMoveStartY), dbMouse);
                }
                Point2D.Double dbDelta = new Point2D.Double(dbMouse.getX() - this.dbMoveStartX, dbMouse.getY() - this.dbMoveStartY);
                EditWindow.gridAlign(dbDelta);
                Point screenDelta = wnd.deltaDatabaseToScreen((int)((Point2D)dbDelta).getX(), (int)((Point2D)dbDelta).getY());
                highlighter.setHighlightOffset((int)((Point2D)screenDelta).getX(), (int)((Point2D)screenDelta).getY());
                wnd.repaint();
            }
            this.mouseOver(dbMouse, wnd);
        }
    }

    private void mouseOver(Point2D dbMouse, EditWindow wnd) {
        if (!User.isMouseOverHighlightingEnabled()) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Highlighter mouseOverHighlighter = wnd.getMouseOverHighlighter();
        Highlighter tempHighlighter = new Highlighter(1, null);
        tempHighlighter.copyState(highlighter);
        Point screenMouse = wnd.databaseToScreen(dbMouse);
        Highlight2 found = null;
        if (!this.another && !this.invertSelection) {
            found = tempHighlighter.overHighlighted(wnd, (int)((Point2D)screenMouse).getX(), (int)((Point2D)screenMouse).getY());
        }
        if (found == null) {
            found = tempHighlighter.findObject(dbMouse, wnd, false, this.another, this.invertSelection, true, false, this.specialSelect, true);
        }
        tempHighlighter.clear();
        if (found != null) {
            tempHighlighter.addHighlight(found);
        }
        boolean changed = false;
        List<Highlight2> mouseOld = mouseOverHighlighter.getHighlights();
        List<Highlight2> mouseNew = tempHighlighter.getHighlights();
        if (mouseOld.size() == mouseNew.size()) {
            for (int i = 0; i < mouseOld.size(); ++i) {
                Highlight2 h2;
                Highlight2 h1 = mouseOld.get(i);
                if (h1.equals(h2 = mouseNew.get(i))) continue;
                changed = true;
                break;
            }
        } else {
            changed = true;
        }
        if (changed) {
            mouseOverHighlighter.copyState(tempHighlighter);
            mouseOverHighlighter.finished();
            wnd.repaint();
        }
        tempHighlighter.delete();
        tempHighlighter = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)e.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            wnd.getWindowFrame().getFrame().getStatusBar().highlightChanged(highlighter);
            WindowFrame.show3DHighlight();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean sideways = (evt.getModifiersEx() & 0x40) != 0;
            boolean sideways2 = (evt.getModifiersEx() & 0x80) != 0;
            int rotation = evt.getWheelRotation();
            if (sideways || sideways2) {
                ZoomAndPanListener.panXOrY(0, wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            } else {
                ZoomAndPanListener.panXOrY(1, wnd.getWindowFrame(), rotation > 0 ? 1 : -1);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean redrawMouseOver = false;
            if (chr == 37) {
                ClickZoomWireListener.moveSelected(-1.0, 0.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 39) {
                ClickZoomWireListener.moveSelected(1.0, 0.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 38) {
                ClickZoomWireListener.moveSelected(0.0, 1.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 40) {
                ClickZoomWireListener.moveSelected(0.0, -1.0, evt.isShiftDown(), evt.isControlDown());
            } else if (chr == 27) {
                this.escapePressed(wnd);
            } else if (chr == 17) {
                if (!this.another) {
                    redrawMouseOver = true;
                }
                this.another = true;
            } else if (chr == 16) {
                if (!this.invertSelection) {
                    redrawMouseOver = true;
                }
                this.invertSelection = true;
            }
            if (redrawMouseOver) {
                this.mouseOver(wnd.screenToDatabase(this.mouseX, this.mouseY), wnd);
            }
        }
    }

    private void escapePressed(EditWindow wnd) {
        Highlighter highlighter = wnd.getHighlighter();
        if (this.modeRight == Mode.wiringConnect || this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
            this.router.cancelInteractiveRoute();
        }
        if (this.modeRight == Mode.zoomBox || this.modeRight == Mode.zoomBoxSingleShot || this.modeRight == Mode.zoomOut || this.modeLeft == Mode.drawBox || this.modeLeft == Mode.selectBox) {
            wnd.clearDoingAreaDrag();
        }
        this.modeLeft = Mode.none;
        this.modeRight = Mode.none;
        highlighter.setHighlightOffset(0, 0);
        wnd.repaint();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Cell cell = wnd.getCell();
            if (cell == null) {
                return;
            }
            boolean redrawMouseOver = false;
            if (chr == 17) {
                if (this.another) {
                    redrawMouseOver = true;
                }
                this.another = false;
            } else if (chr == 16) {
                if (this.invertSelection) {
                    redrawMouseOver = true;
                }
                this.invertSelection = false;
            }
            if (redrawMouseOver) {
                this.mouseOver(wnd.screenToDatabase(this.mouseX, this.mouseY), wnd);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    public static void moveSelected(double dX, double dY, boolean scaleMove, boolean scaleMove2) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        double arrowDistance = User.getAlignmentToGrid();
        dX *= arrowDistance;
        dY *= arrowDistance;
        int scaleX = User.getDefGridXBoldFrequency();
        int scaleY = User.getDefGridYBoldFrequency();
        if (scaleMove) {
            dX *= (double)scaleX;
            dY *= (double)scaleY;
        }
        if (scaleMove2) {
            dX *= (double)scaleX;
            dY *= (double)scaleY;
        }
        highlighter.setHighlightOffset(0, 0);
        if (wnd.isInPlaceEdit()) {
            Point2D.Double delta = new Point2D.Double(dX, dY);
            AffineTransform trans = wnd.getInPlaceTransformIn();
            double m00 = trans.getScaleX();
            double m01 = trans.getShearX();
            double m10 = trans.getShearY();
            double m11 = trans.getScaleY();
            AffineTransform justRot = new AffineTransform(m00, m10, m01, m11, 0.0, 0.0);
            justRot.transform(delta, delta);
            dX = ((Point2D)delta).getX();
            dY = ((Point2D)delta).getY();
        }
        CircuitChanges.manyMove(dX, dY);
        wnd.repaintContents(null, false);
    }

    public static Point2D convertToOrthogonal(Point2D startPoint, Point2D mousePoint) {
        double xdist = Math.abs(mousePoint.getX() - startPoint.getX());
        double ydist = Math.abs(mousePoint.getY() - startPoint.getY());
        if (ydist > xdist) {
            return new Point2D.Double(startPoint.getX(), mousePoint.getY());
        }
        return new Point2D.Double(mousePoint.getX(), startPoint.getY());
    }

    public void switchWiringTarget() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = wnd.getCell();
        if (this.modeRight == Mode.wiringToSpace) {
            this.modeRight = Mode.wiringFind;
        }
        if (this.modeRight == Mode.wiringFind || this.modeRight == Mode.stickyWiring) {
            Point2D.Double dbMouse = new Point2D.Double(this.lastdbMouseX, this.lastdbMouseY);
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.lastdbMouseX, this.lastdbMouseY, 0.0, 0.0);
            List<Highlight2> targets = Highlighter.findAllInArea(highlighter, wnd.getCell(), false, false, true, false, this.specialSelect, false, bounds, wnd);
            Iterator<Highlight2> it = targets.iterator();
            boolean found = false;
            if (this.wiringTarget == null) {
                this.wiringTarget = this.endObj;
            }
            while (it.hasNext()) {
                if (it.next().getElectricObject() != this.wiringTarget) continue;
                found = true;
                if (!it.hasNext()) {
                    this.modeRight = Mode.wiringToSpace;
                    this.wiringTarget = null;
                    break;
                }
                this.wiringTarget = it.next().getElectricObject();
                break;
            }
            if (!found) {
                it = targets.iterator();
                this.wiringTarget = it.hasNext() ? it.next().getElectricObject() : null;
            }
            if (this.modeRight == Mode.wiringToSpace) {
                this.endObj = null;
                System.out.println("Switching to 'ignore all wiring targets'");
                this.router.highlightRoute(wnd, cell, this.startObj, null, dbMouse);
                return;
            }
            if (this.endObj == this.wiringTarget) {
                return;
            }
            this.endObj = this.wiringTarget;
            if (this.wiringTarget == null) {
                System.out.println("Switching to wiring target 'none'");
            } else {
                System.out.println("Switching to wiring target '" + this.wiringTarget + "'");
            }
            this.router.highlightRoute(wnd, cell, this.startObj, this.wiringTarget, dbMouse);
        }
    }

    public void wireTo(int layerNumber) {
        ElectricObject obj;
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        ArcProto ap = null;
        Technology tech = Technology.getCurrent();
        boolean found = false;
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ap = it.next();
            if (ap.isNotUsed()) continue;
            switch (layerNumber) {
                case 0: {
                    if (ap.getFunction() != ArcProto.Function.POLY1) break;
                    found = true;
                    break;
                }
                case 1: {
                    if (ap.getFunction() != ArcProto.Function.METAL1) break;
                    found = true;
                    break;
                }
                case 2: {
                    if (ap.getFunction() != ArcProto.Function.METAL2 && ap.getFunction() != ArcProto.Function.BUS) break;
                    found = true;
                    break;
                }
                case 3: {
                    if (ap.getFunction() != ArcProto.Function.METAL3) break;
                    found = true;
                    break;
                }
                case 4: {
                    if (ap.getFunction() != ArcProto.Function.METAL4) break;
                    found = true;
                    break;
                }
                case 5: {
                    if (ap.getFunction() != ArcProto.Function.METAL5) break;
                    found = true;
                    break;
                }
                case 6: {
                    if (ap.getFunction() != ArcProto.Function.METAL6) break;
                    found = true;
                    break;
                }
                case 7: {
                    if (ap.getFunction() != ArcProto.Function.METAL7) break;
                    found = true;
                    break;
                }
                case 8: {
                    if (ap.getFunction() != ArcProto.Function.METAL8) break;
                    found = true;
                    break;
                }
                case 9: {
                    if (ap.getFunction() != ArcProto.Function.METAL9) break;
                    found = true;
                }
            }
            if (!found) continue;
        }
        if (!found) {
            return;
        }
        if (highlighter.getNumHighlights() == 1 && cell != null && (obj = highlighter.getOneHighlight().getElectricObject()) instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            this.router.makeVerticalRoute(wnd, pi, ap);
        }
        User.getUserTool().setCurrentArcProto(ap);
    }

    public JPopupMenu selectPopupMenu(List<Highlight2> objects) {
        JPopupMenu popup = new JPopupMenu("Choose One");
        for (Highlight2 obj : objects) {
            JMenuItem m = new JMenuItem(obj.toString());
            m.addActionListener(this);
            popup.add(m);
        }
        return popup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
    }

    private void readPrefs() {
        cancelMoveDelayMillis = prefs.getLong(cancelMoveDelayMillisPref, 200L);
        zoomInDelayMillis = prefs.getLong(zoomInDelayMillisPref, 120L);
    }

    public long getCancelMoveDelayMillis() {
        return cancelMoveDelayMillis;
    }

    public void setCancelMoveDelayMillis(long delay) {
        cancelMoveDelayMillis = delay;
        prefs.putLong(cancelMoveDelayMillisPref, delay);
    }

    public long getZoomInDelayMillis() {
        return zoomInDelayMillis;
    }

    public void setZoomInDelayMillis(long delay) {
        zoomInDelayMillis = delay;
        prefs.putLong(zoomInDelayMillisPref, delay);
    }

    static {
        theOne = new ClickZoomWireListener();
        isMac = Client.isOSMac();
    }

    private static class Mode {
        private final String name;
        public static final Mode none = new Mode("none");
        public static final Mode move = new Mode("move");
        public static final Mode stickyMove = new Mode("stickyMove");
        public static final Mode drawBox = new Mode("drawBox");
        public static final Mode zoomBox = new Mode("zoomBox");
        public static final Mode zoomBoxSingleShot = new Mode("zoomBoxSingleShot");
        public static final Mode zoomIn = new Mode("zoomIn");
        public static final Mode zoomOut = new Mode("zoomOut");
        public static final Mode selectBox = new Mode("selectBox");
        public static final Mode wiringConnect = new Mode("wiring");
        public static final Mode wiringFind = new Mode("wiringFind");
        public static final Mode wiringToSpace = new Mode("wiringToSpace");
        public static final Mode stickyWiring = new Mode("stickyWiring");

        public Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

