/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Version;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.JELIB;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashSet;

public class DELIB
extends JELIB {
    private LineNumberReader headerReader;
    private HashSet<String> delibCellFiles = new HashSet();

    DELIB() {
    }

    @Override
    protected boolean readLib() {
        String header = this.filePath + File.separator + "header";
        try {
            FileInputStream fin = new FileInputStream(header);
            InputStreamReader is = new InputStreamReader(fin);
            this.headerReader = new LineNumberReader(is);
        }
        catch (IOException e) {
            System.out.println("Error opening file " + header + ": " + e.getMessage());
            return true;
        }
        this.lineReader = this.headerReader;
        boolean b = super.readLib();
        if (!b) {
            this.lib.setDelibCellFiles(this.delibCellFiles);
        }
        return b;
    }

    @Override
    void readCell(int revision, String line) throws IOException {
        if (this.lineReader != this.headerReader) {
            super.readCell(revision, line);
            return;
        }
        String cellFile = line.substring(1, line.length());
        if (this.version.compareTo(Version.parseVersion("8.04n")) >= 0) {
            File delibDir;
            if (cellFile.equals("____SEARCH_FOR_CELL_FILES____") && (delibDir = new File(this.filePath)).exists() && delibDir.isDirectory()) {
                for (File file : delibDir.listFiles()) {
                    View view;
                    String name;
                    int dot;
                    if (file.isDirectory() || (dot = (name = file.getName()).lastIndexOf(46)) < 0 || (view = View.findView(name.substring(dot + 1))) == null) continue;
                    try {
                        this.readFile(file);
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        Input.errorLogger.logError("Exception reading file " + file, -1);
                    }
                }
            }
            return;
        }
        cellFile = cellFile.replace('/', File.separatorChar);
        File cellFD = new File(this.filePath, cellFile);
        this.readFile(cellFD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File cellFD) throws IOException {
        LineNumberReader cellReader;
        try {
            FileInputStream fin = new FileInputStream(cellFD);
            InputStreamReader is = new InputStreamReader(fin);
            cellReader = new LineNumberReader(is);
        }
        catch (IOException e) {
            System.out.println("Error opening file " + cellFD + ": " + e.getMessage());
            return;
        }
        Version savedVersion = this.version;
        char savedEscapeChar = this.escapeChar;
        String savedCurLibName = this.curLibName;
        this.lineReader = cellReader;
        this.curReadFile = cellFD.getAbsolutePath();
        try {
            this.readFromFile(true, false);
            this.delibCellFiles.add(this.curReadFile);
        }
        finally {
            this.version = savedVersion;
            this.escapeChar = savedEscapeChar;
            this.curLibName = savedCurLibName;
            this.lineReader.close();
            this.lineReader = this.headerReader;
            this.curReadFile = this.filePath;
        }
    }

    @Override
    protected FileType getPreferredFileType() {
        return FileType.DELIB;
    }
}

