/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class NewCell
extends EDialog {
    private JList viewList;
    private DefaultListModel viewModel;
    private static boolean makeWindow = false;
    private JButton cancel;
    private JTextField cellName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JComboBox library;
    private JCheckBox newWindow;
    private JButton ok;
    private JComboBox techComboBox;
    private JLabel techLabel;
    private JScrollPane view;

    public NewCell(Frame parent) {
        super(parent, true);
        ViewTechOption option;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.viewModel = new DefaultListModel();
        this.viewList = new JList(this.viewModel);
        this.viewList.setSelectionMode(0);
        this.view.setViewportView(this.viewList);
        Technology curTech = Technology.getCurrent();
        Technology defTech = Technology.findTechnology(User.getDefaultTechnology());
        ViewTechOption theViewOption = null;
        View defaultView = View.LAYOUT;
        if (curTech == Schematics.tech) {
            defaultView = View.SCHEMATIC;
        } else if (curTech == Artwork.tech) {
            defaultView = View.ICON;
        }
        for (View v : View.getOrderedViews()) {
            option = new ViewTechOption(v, null);
            this.viewModel.addElement(option);
            if (v != defaultView) continue;
            theViewOption = option;
        }
        this.viewList.setSelectedValue(theViewOption, true);
        this.viewList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                NewCell.this.techComboBoxItemStateChanged(null);
                if (e.getClickCount() == 2) {
                    NewCell.this.ok(null);
                }
            }
        });
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech == Schematics.tech || tech == Artwork.tech) continue;
            option = new ViewTechOption(null, tech);
            this.techComboBox.addItem(option);
            if ((defaultView != View.LAYOUT || tech != curTech) && tech != defTech) continue;
            this.techComboBox.setSelectedItem(option);
        }
        this.techComboBoxItemStateChanged(null);
        List<Library> libList = Library.getVisibleLibraries();
        for (Library lib : libList) {
            this.library.addItem(lib.getName());
        }
        int curIndex = libList.indexOf(Library.getCurrent());
        if (curIndex >= 0) {
            this.library.setSelectedIndex(curIndex);
        }
        this.newWindow.setSelected(makeWindow);
        this.cellName.grabFocus();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.cellName = new JTextField();
        this.jLabel4 = new JLabel();
        this.library = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.newWindow = new JCheckBox();
        this.view = new JScrollPane();
        this.techLabel = new JLabel();
        this.techComboBox = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("New Cell");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewCell.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCell.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCell.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.cellName.setColumns(20);
        this.cellName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewCell.this.cellNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cellName, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.library, gridBagConstraints);
        this.jLabel1.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("View:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.newWindow.setText("Make new window");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.newWindow, gridBagConstraints);
        this.view.setMinimumSize(new Dimension(200, 150));
        this.view.setPreferredSize(new Dimension(200, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.view, gridBagConstraints);
        this.techLabel.setHorizontalAlignment(2);
        this.techLabel.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.techLabel, gridBagConstraints);
        this.techComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                NewCell.this.techComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.techComboBox, gridBagConstraints);
        this.pack();
    }

    private void techComboBoxItemStateChanged(ItemEvent evt) {
        ViewTechOption view = (ViewTechOption)this.viewList.getSelectedValue();
        if (view != null) {
            this.techComboBox.setEnabled(view.view == View.LAYOUT);
        }
    }

    private void cellNameActionPerformed(ActionEvent evt) {
        this.ok(evt);
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        String libName;
        Library lib;
        String name = this.cellName.getText().trim();
        if (name.length() == 0) {
            Job.getUserInterface().showErrorMessage("Must type a cell name", "Invalid cell name");
            return;
        }
        String viewName = ((ViewTechOption)this.viewList.getSelectedValue()).view.getFullName();
        View v = View.findView(viewName);
        if (v != View.UNKNOWN) {
            name = name + v.getAbbreviationExtension();
        }
        if ((lib = Library.findLibrary(libName = (String)this.library.getSelectedItem())) == null) {
            Job.getUserInterface().showErrorMessage("No library exists.  Create one first.", "No Library");
            return;
        }
        makeWindow = this.newWindow.isSelected();
        Technology tech = null;
        if (this.techComboBox.isEnabled()) {
            tech = ((ViewTechOption)this.techComboBox.getSelectedItem()).tech;
        }
        new CreateCell(lib, name, tech, makeWindow);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        makeWindow = this.newWindow.isSelected();
        this.setVisible(false);
        this.dispose();
    }

    private static class CreateCell
    extends Job {
        private Library lib;
        private String cellName;
        private boolean newWindow;
        private Technology tech;
        private Cell newCell;

        protected CreateCell(Library lib, String cellName, Technology tech, boolean newWindow) {
            super("Create Cell " + cellName, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.cellName = cellName;
            this.newWindow = newWindow;
            this.tech = tech;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.newCell = Cell.makeInstance(this.lib, this.cellName);
            if (this.newCell == null) {
                throw new JobException("Unable to create cell " + this.cellName);
            }
            this.newCell.setTechnology(this.tech);
            this.fieldVariableChanged("newCell");
            return true;
        }

        public void terminateOK() {
            if (this.newWindow) {
                WindowFrame.createEditWindow(this.newCell);
            } else {
                WindowFrame wf = WindowFrame.getCurrentWindowFrame();
                wf.setCellWindow(this.newCell, null);
            }
        }
    }

    private static class ViewTechOption {
        View view;
        Technology tech;

        ViewTechOption(View view, Technology tech) {
            this.view = view;
            this.tech = tech;
        }

        public String toString() {
            if (this.view != null) {
                return this.view.getFullName();
            }
            return this.tech.getTechName();
        }
    }
}

