/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.PromptAt;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FPGA
extends Technology {
    private final Layer wireLayer;
    private final Layer componentLayer;
    private final Layer pipLayer;
    private final Layer repeaterLayer;
    private final ArcProto wireArc;
    private final PrimitiveNode wirePinNode;
    private final PrimitiveNode pipNode;
    private final PrimitiveNode repeaterNode;
    private static final int MAXDEPTH = 50;
    private static LispTree[] treeStack = new LispTree[50];
    private static int treeDepth;
    private static LispTree treePosition;
    private static final int DISPLAYLEVEL = 7;
    private static final int NOPRIMDISPLAY = 0;
    private static final int FULLPRIMDISPLAY = 1;
    private static final int ACTIVEPRIMDISPLAY = 2;
    private static final int TEXTDISPLAY = 8;
    private static final int ACTIVEPART = 1;
    private static final int ACTIVESAVE = 2;
    private static final Variable.Key ACTIVEPIPS_KEY;
    private static final Variable.Key ACTIVEREPEATERS_KEY;
    private String repeaterName;
    private boolean repeaterActive;
    private int internalDisplay = 10;
    private boolean defined = false;
    private static final Technology.NodeLayer[] NULLNODELAYER;
    Nodable[] path = new Nodable[100];

    public static FPGA tech() {
        return sysFPGA;
    }

    public FPGA(Generic generic) {
        super(generic, "fpga", Foundry.Type.NONE, 1);
        this.setTechShortName("FPGA");
        this.setTechDesc("FPGA Building-Blocks");
        this.setFactoryScale(2000.0, true);
        this.setStaticTechnology();
        this.setNonStandard();
        this.setNoPrimitiveNodes();
        this.wireLayer = Layer.newInstance(this, "Wire", new EGraphics(false, false, null, 0, 255, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.componentLayer = Layer.newInstance(this, "Component", new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.pipLayer = Layer.newInstance(this, "Pip", new EGraphics(false, false, null, 0, 0, 255, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.repeaterLayer = Layer.newInstance(this, "Repeater", new EGraphics(false, false, null, 0, 0, 0, 255, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        this.wireLayer.setFunction(Layer.Function.METAL1);
        this.componentLayer.setFunction(Layer.Function.ART);
        this.pipLayer.setFunction(Layer.Function.ART);
        this.repeaterLayer.setFunction(Layer.Function.ART);
        this.wireArc = this.newArcProto("wire", 0.0, 0.0, ArcProto.Function.METAL1, new Technology.ArcLayer(this.wireLayer, 0.0, Poly.Type.FILLED));
        this.wireArc.setFactoryFixedAngle(true);
        this.wireArc.setFactorySlidable(false);
        this.wireArc.setFactoryAngleIncrement(45);
        this.wirePinNode = PrimitiveNode.newInstance("Wire_Pin", this, 1.0, 1.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.wireLayer, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        this.wirePinNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.wirePinNode, new ArcProto[]{this.wireArc}, "wire", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        this.wirePinNode.setFunction(PrimitiveNode.Function.PIN);
        this.wirePinNode.setSquare();
        this.wirePinNode.setWipeOn1or2();
        this.pipNode = PrimitiveNode.newInstance("Pip", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.pipLayer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeTopEdge())})});
        this.pipNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.pipNode, new ArcProto[]{this.wireArc}, "pip", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        this.pipNode.setFunction(PrimitiveNode.Function.CONNECT);
        this.pipNode.setSquare();
        this.repeaterNode = PrimitiveNode.newInstance("Repeater", this, 10.0, 3.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(this.repeaterLayer, 0, Poly.Type.FILLED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeTopEdge())})});
        this.repeaterNode.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, this.repeaterNode, new ArcProto[]{this.wireArc}, "a", 180, 45, 0, PortCharacteristic.UNKNOWN, EdgeH.makeLeftEdge(), EdgeV.makeCenter(), EdgeH.makeLeftEdge(), EdgeV.makeCenter()), PrimitivePort.newInstance(this, this.repeaterNode, new ArcProto[]{this.wireArc}, "b", 0, 45, 1, PortCharacteristic.UNKNOWN, EdgeH.makeRightEdge(), EdgeV.makeCenter(), EdgeH.makeRightEdge(), EdgeV.makeCenter())});
        this.repeaterNode.setFunction(PrimitiveNode.Function.CONNECT);
        this.nodeGroups = new Object[8][1];
        int count = -1;
        this.nodeGroups[++count][0] = this.wireArc;
        this.nodeGroups[++count][0] = "Cell";
        this.nodeGroups[++count][0] = "Misc.";
        this.nodeGroups[++count][0] = "Pure";
        this.nodeGroups[++count][0] = this.wirePinNode;
        this.nodeGroups[++count][0] = this.pipNode;
        this.nodeGroups[++count][0] = this.repeaterNode;
        this.newFoundry(Foundry.Type.NONE, null, new String[0]);
    }

    protected Poly[] getShapeOfNode(NodeInst ni, boolean electrical, boolean reasonable, Technology.NodeLayer[] primLayers, Layer layerOverride) {
        return this.getShapeOfNode(ni, null, null, electrical, reasonable, primLayers, layerOverride);
    }

    private Poly[] getShapeOfNode(NodeInst ni, EditWindow0 wnd, VarContext context, boolean electrical, boolean reasonable, Technology.NodeLayer[] primLayers, Layer layerOverride) {
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode np = (PrimitiveNode)ni.getProto();
        if (np == this.wirePinNode) {
            if (ni.pinUseCount()) {
                primLayers = NULLNODELAYER;
            }
        } else if (np == this.repeaterNode) {
            if ((this.internalDisplay & 7) == 2 && !this.repeaterActive(ni)) {
                primLayers = NULLNODELAYER;
            }
        } else if (np instanceof FPGANode) {
            int i;
            int i2;
            FPGANode fn = (FPGANode)np;
            int numPips = 0;
            int numSegs = 0;
            for (i2 = 0; i2 < fn.numNets(); ++i2) {
                fn.netList[i2].segActive = 0;
            }
            for (i2 = 0; i2 < fn.numPips(); ++i2) {
                fn.pipList[i2].pipActive = 0;
            }
            switch (this.internalDisplay & 7) {
                case 0: {
                    break;
                }
                case 2: {
                    this.reEvaluatePips(ni, fn, context);
                    for (i2 = 0; i2 < fn.numNets(); ++i2) {
                        if ((fn.netList[i2].segActive & 1) == 0) continue;
                        fn.netList[i2].segActive |= 2;
                    }
                    for (i2 = 0; i2 < fn.numPips(); ++i2) {
                        if ((fn.pipList[i2].pipActive & 1) == 0) continue;
                        fn.pipList[i2].pipActive |= 2;
                    }
                    if (context != null && context.getNodable() != null) {
                        VarContext higher = context.pop();
                        for (int i3 = 0; i3 < fn.numNets(); ++i3) {
                            if ((fn.netList[i3].segActive & 2) != 0) continue;
                            boolean found = false;
                            for (int j = 0; j < fn.numPorts(); ++j) {
                                if (fn.portList[j].con != i3) continue;
                                Iterator<Connection> it = ni.getConnections();
                                while (it.hasNext()) {
                                    int otherEnd;
                                    ArcInst ai;
                                    Connection con = it.next();
                                    if (con.getPortInst().getPortProto() != fn.portList[j].pp || !this.arcEndActive(ai = con.getArc(), otherEnd = 1 - con.getEndIndex(), higher)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) break;
                            }
                            if (!found) continue;
                            fn.netList[i3].segActive |= 2;
                        }
                    }
                    for (i2 = 0; i2 < fn.numPips(); ++i2) {
                        if ((fn.pipList[i2].pipActive & 2) == 0) continue;
                        ++numPips;
                    }
                    for (i2 = 0; i2 < fn.numNets(); ++i2) {
                        if ((fn.netList[i2].segActive & 2) == 0) continue;
                        numSegs += fn.netList[i2].segFrom.length;
                    }
                    break;
                }
                case 1: {
                    for (i2 = 0; i2 < fn.numNets(); ++i2) {
                        fn.netList[i2].segActive |= 2;
                        numSegs += fn.netList[i2].segFrom.length;
                    }
                    break;
                }
            }
            int total = 1 + numPips + numSegs;
            if ((this.internalDisplay & 8) != 0) {
                ++total;
                if (wnd != null) {
                    total += ni.numDisplayableVariables(true);
                }
            }
            Poly[] polys = new Poly[total];
            double xCenter = ni.getTrueCenterX();
            double yCenter = ni.getTrueCenterY();
            double xSize = ni.getXSize();
            double ySize = ni.getYSize();
            Point2D[] pointList = Poly.makePoints(xCenter - xSize / 2.0, xCenter + xSize / 2.0, yCenter - ySize / 2.0, yCenter + ySize / 2.0);
            polys[0] = new Poly(pointList);
            polys[0].setStyle(fn.getLayers()[0].getStyle());
            polys[0].setLayer(this.componentLayer);
            int fillPos = 1;
            for (i = 0; i < fn.numPips(); ++i) {
                if ((fn.pipList[i].pipActive & 2) == 0) continue;
                double x = xCenter + fn.pipList[i].posX;
                double y = yCenter + fn.pipList[i].posY;
                polys[fillPos] = new Poly(Poly.makePoints(x - 1.0, x + 1.0, y - 1.0, y + 1.0));
                polys[fillPos].setStyle(Poly.Type.FILLED);
                polys[fillPos].setLayer(this.pipLayer);
                ++fillPos;
            }
            for (i = 0; i < fn.numNets(); ++i) {
                if ((fn.netList[i].segActive & 2) == 0) continue;
                for (int j = 0; j < fn.netList[i].segFrom.length; ++j) {
                    double fX = xCenter + fn.netList[i].segFrom[j].getX();
                    double fY = yCenter + fn.netList[i].segFrom[j].getY();
                    double tX = xCenter + fn.netList[i].segTo[j].getX();
                    double tY = yCenter + fn.netList[i].segTo[j].getY();
                    Point2D[] line = new Point2D[]{new Point2D.Double(fX, fY), new Point2D.Double(tX, tY)};
                    polys[fillPos] = new Poly(line);
                    polys[fillPos].setStyle(Poly.Type.OPENED);
                    polys[fillPos].setLayer(this.wireLayer);
                    ++fillPos;
                }
            }
            if ((this.internalDisplay & 8) != 0) {
                polys[fillPos] = new Poly(pointList);
                polys[fillPos].setStyle(Poly.Type.TEXTBOX);
                polys[fillPos].setLayer(this.componentLayer);
                polys[fillPos].setString(fn.getName());
                TextDescriptor td = TextDescriptor.EMPTY.withRelSize(3.0);
                polys[fillPos].setTextDescriptor(td);
                ++fillPos;
                if (wnd != null) {
                    Rectangle2D rect = ni.getUntransformedBounds();
                    ni.addDisplayableVariables(rect, polys, fillPos, wnd, true);
                }
            }
            return polys;
        }
        return super.getShapeOfNode(ni, electrical, reasonable, primLayers, layerOverride);
    }

    protected void getShapeOfArc(AbstractShapeBuilder b, ImmutableArcInst a) {
        super.getShapeOfArc(b, a);
    }

    public boolean isEasyShape(ImmutableArcInst a, boolean explain) {
        return false;
    }

    private boolean arcEndActive(ArcInst ai, int j, VarContext curContext) {
        Netlist nl;
        Network net;
        Cell parent;
        PortInst pi = ai.getPortInst(j);
        NodeInst ni = pi.getNodeInst();
        PortProto pp = pi.getPortProto();
        NodeProto np = ni.getProto();
        if (ni.isCellInstance()) {
            VarContext down = curContext.push(ni);
            NodeInst subni = ((Export)pp).getOriginalPort().getNodeInst();
            Iterator<Connection> it = subni.getConnections();
            while (it.hasNext()) {
                Connection nextCon = it.next();
                ArcInst oAi = nextCon.getArc();
                int newEnd = 0;
                if (oAi.getPortInst(0).getNodeInst() == subni) {
                    newEnd = 1;
                }
                if (!this.arcEndActive(oAi, newEnd, down)) continue;
                return true;
            }
            return false;
        }
        if (np instanceof FPGANode) {
            FPGANode fn = (FPGANode)np;
            this.reEvaluatePips(ni, fn, curContext);
            for (int i = 0; i < fn.numPorts(); ++i) {
                if (fn.portList[i].pp != pp) continue;
                int index = fn.portList[i].con;
                if (index < 0 || fn.netList == null || (fn.netList[index].segActive & 1) == 0) break;
                return true;
            }
        }
        if ((parent = ai.getParent()) != null && (net = (nl = parent.acquireUserNetlist()).getNetwork(ni, pp, 0)) != null) {
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                int newEnd;
                Network oNet;
                Connection nextCon = it.next();
                ArcInst oAi = nextCon.getArc();
                if (oAi == ai || (oNet = nl.getNetwork(oAi, 0)) != net || !this.arcEndActive(oAi, newEnd = 1 - nextCon.getEndIndex(), curContext)) continue;
                return true;
            }
            VarContext higher = curContext.pop();
            if (higher != null && higher.getNodable() != null) {
                NodeInst oNi = (NodeInst)higher.getNodable();
                Iterator<Export> it2 = ni.getExports();
                while (it2.hasNext()) {
                    Export opp = it2.next();
                    Network oNet = nl.getNetwork(opp, 0);
                    if (oNet != net) continue;
                    Iterator<Connection> uIt = oNi.getConnections();
                    while (uIt.hasNext()) {
                        int newEnd;
                        Connection nextCon = uIt.next();
                        ArcInst oAi = nextCon.getArc();
                        if (nextCon.getPortInst().getPortProto() != opp || !this.arcEndActive(oAi, newEnd = 1 - nextCon.getEndIndex(), higher)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void reEvaluatePips(NodeInst ni, FPGANode fn, VarContext context) {
        int i;
        if (fn.numNets() == 0 && fn.numPips() == 0) {
            return;
        }
        for (i = 0; i < fn.numNets(); ++i) {
            fn.netList[i].segActive &= 0xFFFFFFFE;
        }
        for (i = 0; i < fn.numPips(); ++i) {
            fn.pipList[i].pipActive &= 0xFFFFFFFE;
        }
        this.findVariableObjects(fn, ni, ACTIVEPIPS_KEY, true, context);
        for (i = 0; i < fn.numPips(); ++i) {
            FPGAPip fPip = fn.pipList[i];
            if ((fPip.pipActive & 1) == 0) continue;
            if (fPip.con1 > 0) {
                fn.netList[fPip.con1].segActive |= 1;
            }
            if (fPip.con2 <= 0) continue;
            fn.netList[fPip.con2].segActive |= 1;
        }
    }

    private boolean repeaterActive(NodeInst ni) {
        this.repeaterName = ni.getName();
        this.repeaterActive = false;
        this.findVariableObjects(null, ni, ACTIVEREPEATERS_KEY, false, null);
        return this.repeaterActive;
    }

    private void findVariableObjects(FPGANode fn, NodeInst ni, Variable.Key varKey, boolean setPips, VarContext context) {
        Nodable niClimb;
        int depth = 0;
        this.path[depth++] = ni;
        while (context != null && (niClimb = context.getNodable()) != null) {
            this.path[depth++] = niClimb;
            context = context.pop();
        }
        for (int c = 0; c < depth; ++c) {
            Nodable niClimb2 = this.path[c];
            Variable var = niClimb2.getVar(varKey);
            if (var == null) continue;
            String pt = (String)var.getObject();
            String[] pipNames = pt.split(" ");
            for (int i = 0; i < pipNames.length; ++i) {
                String[] pipParts;
                String start = pipNames[i];
                if (start.length() == 0 || (pipParts = start.split("\\.")).length == 0 || pipParts.length > depth) continue;
                boolean pathGood = true;
                for (int j = 0; j < pipParts.length - 1; ++j) {
                    if (pipParts[j].equalsIgnoreCase(this.path[depth - 2 - j].getName())) continue;
                    pathGood = false;
                    break;
                }
                if (!pathGood) continue;
                String lastPart = pipParts[pipParts.length - 1];
                if (setPips) {
                    for (int k = 0; k < fn.numPips(); ++k) {
                        if (!fn.pipList[k].name.equalsIgnoreCase(lastPart)) continue;
                        fn.pipList[k].pipActive |= 1;
                    }
                    continue;
                }
                if (!this.repeaterName.equalsIgnoreCase(lastPart)) continue;
                this.repeaterActive = true;
            }
            break;
        }
    }

    public void readArchitectureFile(boolean placeAndWire) {
        if (this.defined) {
            System.out.println("This technology already has primitives defined");
            return;
        }
        String fileName = OpenFile.chooseInputFile(FileType.FPGA, null);
        if (fileName == null) {
            return;
        }
        new BuildTechnology(this, fileName, placeAndWire);
    }

    public void setWireDisplay(int level) {
        switch (level) {
            case 0: {
                this.internalDisplay = this.internalDisplay & 0xFFFFFFF8 | 0;
                break;
            }
            case 1: {
                this.internalDisplay = this.internalDisplay & 0xFFFFFFF8 | 2;
                break;
            }
            case 2: {
                this.internalDisplay = this.internalDisplay & 0xFFFFFFF8 | 1;
            }
        }
        UserInterface ui = Job.getUserInterface();
        ui.repaintAllEditWindows();
    }

    public void setTextDisplay(boolean show) {
        this.internalDisplay = show ? (this.internalDisplay |= 8) : (this.internalDisplay &= 0xFFFFFFF7);
        UserInterface ui = Job.getUserInterface();
        ui.repaintAllEditWindows();
    }

    public void programPips() {
        String newPips;
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        ElectricObject eObj = wnd.getOneElectricObject(NodeInst.class);
        if (eObj == null) {
            return;
        }
        NodeInst ni = (NodeInst)eObj;
        String pips = "";
        Variable var = ni.getVar(ACTIVEPIPS_KEY);
        if (var != null) {
            pips = (String)var.getObject();
        }
        if ((newPips = PromptAt.showPromptAt(wnd, ni, "Edit Pips", "Pips on this node:", pips)) == null) {
            return;
        }
        new SetPips(ni, newPips);
    }

    private LispTree readFile(String fileName) {
        LispTree treeTop = new LispTree();
        treeTop.keyword = "TOP";
        treePosition = treeTop;
        treeDepth = 0;
        URL url = TextUtils.makeURLToFile(fileName);
        try {
            String line;
            URLConnection urlCon = url.openConnection();
            InputStreamReader is = new InputStreamReader(urlCon.getInputStream());
            LineNumberReader lnr = new LineNumberReader(is);
            block2: while ((line = lnr.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int pt = 0;
                while (true) {
                    char chEnd;
                    int ptEnd;
                    if (pt < line.length() && Character.isWhitespace(line.charAt(pt))) {
                        ++pt;
                        continue;
                    }
                    if (pt >= line.length()) continue block2;
                    char chr = line.charAt(pt);
                    if (chr == ')') {
                        if (this.pushKeyword(line.substring(pt, pt + 1), lnr)) {
                            return null;
                        }
                        ++pt;
                        continue;
                    }
                    for (ptEnd = pt; ptEnd < line.length() && (chEnd = line.charAt(ptEnd)) != ')' && !Character.isWhitespace(chEnd); ++ptEnd) {
                        if (chEnd != '\"') continue;
                        ++ptEnd;
                        while (ptEnd < line.length() && line.charAt(ptEnd) != '\"') {
                            ++ptEnd;
                        }
                        if (ptEnd >= line.length()) break;
                        ++ptEnd;
                        break;
                    }
                    if (this.pushKeyword(line.substring(pt, ptEnd), lnr)) {
                        return null;
                    }
                    pt = ptEnd;
                }
            }
            lnr.close();
            System.out.println(fileName + " read");
        }
        catch (IOException e) {
            System.out.println("Error reading " + fileName);
            return null;
        }
        if (treeDepth != 0) {
            System.out.println("Not enough close parenthesis in file");
            return null;
        }
        return treeTop;
    }

    private boolean pushKeyword(String keyword, LineNumberReader lnr) {
        if (keyword.startsWith("(")) {
            int pt;
            if (treeDepth >= 50) {
                System.out.println("Nesting too deep (more than 50)");
                return true;
            }
            LispTree newTree = new LispTree();
            newTree.lineNumber = lnr.getLineNumber();
            treePosition.add(newTree);
            for (pt = 1; pt < keyword.length() && Character.isWhitespace(keyword.charAt(pt)); ++pt) {
            }
            newTree.keyword = keyword.substring(pt);
            FPGA.treeStack[FPGA.treeDepth] = treePosition;
            ++treeDepth;
            treePosition = newTree;
            return false;
        }
        if (keyword.equals(")")) {
            if (treeDepth <= 0) {
                System.out.println("Too many close parenthesis");
                return true;
            }
            treePosition = treeStack[--treeDepth];
            return false;
        }
        if (keyword.startsWith("\"") && keyword.endsWith("\"")) {
            keyword = keyword.substring(1, keyword.length() - 1);
        }
        treePosition.add(keyword);
        return false;
    }

    private int makePrimitives(LispTree lt) {
        int total = 0;
        for (int i = 0; i < lt.size(); ++i) {
            LispTree subLT;
            if (lt.isLeaf(i) || !(subLT = lt.getBranch(i)).keyword.equalsIgnoreCase("primdef")) continue;
            if (this.makePrimitive(subLT)) {
                return 0;
            }
            ++total;
        }
        return total;
    }

    private boolean makePrimitive(LispTree lt) {
        LispTree scanLT;
        int j;
        int j2;
        LispTree ltAttribute = null;
        LispTree ltNets = null;
        LispTree ltPorts = null;
        LispTree ltComponents = null;
        String primName = null;
        String primSizeX = null;
        String primSizeY = null;
        for (int i = 0; i < lt.size(); ++i) {
            if (lt.isLeaf(i)) continue;
            LispTree scanLT2 = lt.getBranch(i);
            if (scanLT2.keyword.equalsIgnoreCase("attributes")) {
                if (ltAttribute != null) {
                    System.out.println("Multiple 'attributes' sections for a primitive (line " + scanLT2.lineNumber + ")");
                    return true;
                }
                for (int j3 = 0; j3 < scanLT2.size(); ++j3) {
                    if (scanLT2.isLeaf(j3)) continue;
                    LispTree subLT = scanLT2.getBranch(j3);
                    if (subLT.keyword.equalsIgnoreCase("name")) {
                        if (subLT.size() != 1 || subLT.isBranch(0)) {
                            System.out.println("Primitive 'name' attribute should take a single atomic parameter (line " + subLT.lineNumber + ")");
                            return true;
                        }
                        primName = subLT.getLeaf(0);
                        continue;
                    }
                    if (!subLT.keyword.equalsIgnoreCase("size")) continue;
                    if (subLT.size() != 2 || subLT.isBranch(0) || subLT.isBranch(1)) {
                        System.out.println("Primitive 'size' attribute should take two atomic parameters (line " + subLT.lineNumber + ")");
                        return true;
                    }
                    primSizeX = subLT.getLeaf(0);
                    primSizeY = subLT.getLeaf(1);
                }
                ltAttribute = scanLT2;
                continue;
            }
            if (scanLT2.keyword.equalsIgnoreCase("nets")) {
                if (ltNets != null) {
                    System.out.println("Multiple 'nets' sections for a primitive (line " + scanLT2.lineNumber + ")");
                    return true;
                }
                ltNets = scanLT2;
                continue;
            }
            if (scanLT2.keyword.equalsIgnoreCase("ports")) {
                if (ltPorts != null) {
                    System.out.println("Multiple 'ports' sections for a primitive (line " + scanLT2.lineNumber + ")");
                    return true;
                }
                ltPorts = scanLT2;
                continue;
            }
            if (!scanLT2.keyword.equalsIgnoreCase("components")) continue;
            if (ltComponents != null) {
                System.out.println("Multiple 'components' sections for a primitive (line " + scanLT2.lineNumber + ")");
                return true;
            }
            ltComponents = scanLT2;
        }
        if (primName == null) {
            System.out.println("Missing 'name' attribute in primitive definition (line " + lt.lineNumber + ")");
            return true;
        }
        if (primSizeX == null || primSizeY == null) {
            System.out.println("Missing 'size' attribute in primitive definition (line " + lt.lineNumber + ")");
            return true;
        }
        double sizeX = TextUtils.atof(primSizeX);
        double sizeY = TextUtils.atof(primSizeY);
        FPGANode primNP = new FPGANode(primName, this, sizeX, sizeY, new Technology.NodeLayer[]{new Technology.NodeLayer(this.componentLayer, 0, Poly.Type.CLOSED, 1, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeLeftEdge(), EdgeV.makeBottomEdge()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeTopEdge())})});
        primNP.setLockedPrim();
        this.defined = true;
        if (ltPorts != null) {
            int portCount = 0;
            for (j2 = 0; j2 < ltPorts.size(); ++j2) {
                LispTree scanLT3;
                if (ltPorts.isLeaf(j2) || !(scanLT3 = ltPorts.getBranch(j2)).keyword.equalsIgnoreCase("port")) continue;
                ++portCount;
            }
            primNP.portList = new FPGAPort[portCount];
            int portNumber = 0;
            for (j = 0; j < ltPorts.size(); ++j) {
                FPGAPort fp;
                if (ltPorts.isLeaf(j) || !(scanLT = ltPorts.getBranch(j)).keyword.equalsIgnoreCase("port")) continue;
                primNP.portList[portNumber] = fp = new FPGAPort();
                if (FPGA.makePrimPort(primNP, scanLT, fp, portNumber)) {
                    return true;
                }
                for (int k = 0; k < portNumber; ++k) {
                    if (!primNP.portList[k].name.equalsIgnoreCase(fp.name)) continue;
                    System.out.println("Duplicate port name: " + fp.name + " (line " + scanLT.lineNumber + ")");
                    return true;
                }
                ++portNumber;
            }
        }
        if (ltNets != null) {
            int netCount = 0;
            for (j2 = 0; j2 < ltNets.size(); ++j2) {
                LispTree scanLT4;
                if (ltNets.isLeaf(j2) || !(scanLT4 = ltNets.getBranch(j2)).keyword.equalsIgnoreCase("net")) continue;
                ++netCount;
            }
            primNP.netList = new FPGANet[netCount];
            int index = 0;
            for (j = 0; j < ltNets.size(); ++j) {
                if (ltNets.isLeaf(j) || !(scanLT = ltNets.getBranch(j)).keyword.equalsIgnoreCase("net")) continue;
                primNP.netList[index] = new FPGANet();
                if (FPGA.makePrimNet(primNP, scanLT, primNP, primNP.netList[index])) {
                    return true;
                }
                ++index;
            }
        }
        block7: for (int k = 0; k < primNP.numPorts(); ++k) {
            FPGAPort fp = primNP.portList[k];
            for (int i = 0; i < primNP.numNets(); ++i) {
                boolean found = false;
                for (int j4 = 0; j4 < primNP.netList[i].segFrom.length; ++j4) {
                    if ((primNP.netList[i].segFrom[j4].getX() != fp.posX || primNP.netList[i].segFrom[j4].getY() != fp.posY) && (primNP.netList[i].segTo[j4].getX() != fp.posX || primNP.netList[i].segTo[j4].getY() != fp.posY)) continue;
                    fp.con = i;
                    found = true;
                    break;
                }
                if (found) continue block7;
            }
        }
        PrimitivePort[] ports = new PrimitivePort[primNP.numPorts()];
        for (int i = 0; i < primNP.numPorts(); ++i) {
            FPGAPort fp = primNP.portList[i];
            ports[i] = fp.pp = PrimitivePort.newInstance(this, primNP, new ArcProto[]{this.wireArc}, fp.name, 0, 180, fp.con, fp.characteristic, EdgeH.fromCenter(fp.posX), EdgeV.fromCenter(fp.posY), EdgeH.fromCenter(fp.posX), EdgeV.fromCenter(fp.posY));
        }
        primNP.addPrimitivePorts(ports);
        if (ltComponents != null) {
            int pipCount = 0;
            for (int j5 = 0; j5 < ltComponents.size(); ++j5) {
                LispTree scanLT5;
                if (ltComponents.isLeaf(j5) || !(scanLT5 = ltComponents.getBranch(j5)).keyword.equalsIgnoreCase("pip")) continue;
                ++pipCount;
            }
            primNP.pipList = new FPGAPip[pipCount];
            int i = 0;
            for (int j6 = 0; j6 < ltComponents.size(); ++j6) {
                LispTree scanLT6;
                if (ltComponents.isLeaf(j6) || !(scanLT6 = ltComponents.getBranch(j6)).keyword.equalsIgnoreCase("pip")) continue;
                primNP.pipList[i] = new FPGAPip();
                if (FPGA.makePrimPip(primNP, scanLT6, primNP, primNP.pipList[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean makePrimPort(PrimitiveNode np, LispTree lt, FPGAPort fp, int net) {
        LispTree ltName = null;
        LispTree ltPosition = null;
        LispTree ltDirection = null;
        for (int j = 0; j < lt.size(); ++j) {
            if (lt.isLeaf(j)) continue;
            LispTree scanLT = lt.getBranch(j);
            if (scanLT.keyword.equalsIgnoreCase("name")) {
                ltName = scanLT;
                continue;
            }
            if (scanLT.keyword.equalsIgnoreCase("position")) {
                ltPosition = scanLT;
                continue;
            }
            if (!scanLT.keyword.equalsIgnoreCase("direction")) continue;
            ltDirection = scanLT;
        }
        if (ltName == null) {
            System.out.println("Port has no name (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltName.size() != 1 || ltName.isBranch(0)) {
            System.out.println("Port name must be a single atom (line " + ltName.lineNumber + ")");
            return true;
        }
        fp.name = ltName.getLeaf(0);
        if (ltPosition == null) {
            System.out.println("Port has no position (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltPosition.size() != 2 || ltPosition.isBranch(0) || ltPosition.isBranch(1)) {
            System.out.println("Port position must be two atoms (line " + ltPosition.lineNumber + ")");
            return true;
        }
        fp.posX = TextUtils.atof(ltPosition.getLeaf(0)) - np.getDefWidth() / 2.0;
        fp.posY = TextUtils.atof(ltPosition.getLeaf(1)) - np.getDefHeight() / 2.0;
        fp.characteristic = PortCharacteristic.UNKNOWN;
        if (ltDirection != null) {
            if (ltDirection.size() != 1 || ltDirection.isBranch(0)) {
                System.out.println("Port direction must be a single atom (line " + ltDirection.lineNumber + ")");
                return true;
            }
            String dir = ltDirection.getLeaf(0);
            if (dir.equalsIgnoreCase("input")) {
                fp.characteristic = PortCharacteristic.IN;
            } else if (dir.equalsIgnoreCase("output")) {
                fp.characteristic = PortCharacteristic.OUT;
            } else if (dir.equalsIgnoreCase("bidir")) {
                fp.characteristic = PortCharacteristic.BIDIR;
            } else {
                System.out.println("Unknown port direction (line " + ltDirection.lineNumber + ")");
                return true;
            }
        }
        fp.con = net;
        return false;
    }

    private static boolean makePrimNet(PrimitiveNode np, LispTree lt, FPGANode fn, FPGANet fNet) {
        fNet.name = null;
        int segCount = 0;
        Point2D[] seg = new Point2D[2];
        for (int j = 0; j < lt.size(); ++j) {
            if (lt.isLeaf(j)) continue;
            LispTree scanLT = lt.getBranch(j);
            if (scanLT.keyword.equalsIgnoreCase("name") && scanLT.size() == 1 && scanLT.isLeaf(0)) {
                if (fNet.name != null) {
                    System.out.println("Multiple names for network (line " + lt.lineNumber + ")");
                    return true;
                }
                fNet.name = scanLT.getLeaf(0);
                continue;
            }
            if (!scanLT.keyword.equalsIgnoreCase("segment")) continue;
            int pos = 0;
            for (int i = 0; i < 2; ++i) {
                if (scanLT.size() < pos + 1) {
                    System.out.println("Incomplete block net segment (line " + scanLT.lineNumber + ")");
                    return true;
                }
                if (scanLT.isBranch(pos)) {
                    System.out.println("Must have atoms in block net segment (line " + scanLT.lineNumber + ")");
                    return true;
                }
                if (scanLT.getLeaf(pos).equalsIgnoreCase("coord")) {
                    if (scanLT.size() < pos + 3) {
                        System.out.println("Incomplete block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    if (scanLT.isBranch(pos + 1) || scanLT.isBranch(pos + 2)) {
                        System.out.println("Must have atoms in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    double x = TextUtils.atof(scanLT.getLeaf(pos + 1)) - np.getDefWidth() / 2.0;
                    double y = TextUtils.atof(scanLT.getLeaf(pos + 2)) - np.getDefHeight() / 2.0;
                    seg[i] = new Point2D.Double(x, y);
                    pos += 3;
                    continue;
                }
                if (scanLT.getLeaf(pos).equalsIgnoreCase("port")) {
                    if (scanLT.size() < pos + 2) {
                        System.out.println("Incomplete block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    if (scanLT.isBranch(pos + 1)) {
                        System.out.println("Must have atoms in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    int found = -1;
                    for (int k = 0; k < fn.numPorts(); ++k) {
                        if (!fn.portList[k].name.equalsIgnoreCase(scanLT.getLeaf(pos + 1))) continue;
                        found = k;
                        break;
                    }
                    if (found < 0) {
                        System.out.println("Unknown port on primitive net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    double x = fn.portList[found].posX;
                    double y = fn.portList[found].posY;
                    seg[i] = new Point2D.Double(x, y);
                    pos += 2;
                    continue;
                }
                System.out.println("Unknown keyword '" + scanLT.getLeaf(pos) + "' in block net segment (line " + scanLT.lineNumber + ")");
                return true;
            }
            Point2D[] newFrom = new Point2D[segCount + 1];
            Point2D[] newTo = new Point2D[segCount + 1];
            for (int i = 0; i < segCount; ++i) {
                newFrom[i] = fNet.segFrom[i];
                newTo[i] = fNet.segTo[i];
            }
            newFrom[segCount] = seg[0];
            newTo[segCount] = seg[1];
            fNet.segFrom = newFrom;
            fNet.segTo = newTo;
            ++segCount;
        }
        return false;
    }

    private static boolean makePrimPip(PrimitiveNode np, LispTree lt, FPGANode fn, FPGAPip fPip) {
        fPip.name = null;
        fPip.con2 = -1;
        fPip.con1 = -1;
        for (int j = 0; j < lt.size(); ++j) {
            if (lt.isLeaf(j)) continue;
            LispTree scanLT = lt.getBranch(j);
            if (scanLT.keyword.equalsIgnoreCase("name") && scanLT.size() == 1 && scanLT.isLeaf(0)) {
                if (fPip.name != null) {
                    System.out.println("Multiple names for pip (line " + lt.lineNumber + ")");
                    return true;
                }
                fPip.name = scanLT.getLeaf(0);
                continue;
            }
            if (scanLT.keyword.equalsIgnoreCase("position") && scanLT.size() == 2 && scanLT.isLeaf(0) && scanLT.isLeaf(1)) {
                fPip.posX = TextUtils.atof(scanLT.getLeaf(0)) - np.getDefWidth() / 2.0;
                fPip.posY = TextUtils.atof(scanLT.getLeaf(1)) - np.getDefHeight() / 2.0;
                continue;
            }
            if (!scanLT.keyword.equalsIgnoreCase("connectivity") || scanLT.size() != 2 || !scanLT.isLeaf(0) || !scanLT.isLeaf(1)) continue;
            for (int i = 0; i < fn.numNets(); ++i) {
                if (fn.netList[i].name.equalsIgnoreCase(scanLT.getLeaf(0))) {
                    fPip.con1 = i;
                }
                if (!fn.netList[i].name.equalsIgnoreCase(scanLT.getLeaf(1))) continue;
                fPip.con2 = i;
            }
        }
        return false;
    }

    private Cell placePrimitives(LispTree lt) {
        Cell topLevel = null;
        for (int i = 0; i < lt.size(); ++i) {
            LispTree subLT;
            if (lt.isLeaf(i) || !(subLT = lt.getBranch(i)).keyword.equalsIgnoreCase("blockdef") && !subLT.keyword.equalsIgnoreCase("architecture")) continue;
            Cell np = this.makeCell(subLT);
            if (np == null) {
                return null;
            }
            if (!subLT.keyword.equalsIgnoreCase("architecture")) continue;
            topLevel = np;
        }
        return topLevel;
    }

    private Cell makeCell(LispTree lt) {
        LispTree scanLT;
        int j;
        LispTree ltAttribute = null;
        LispTree ltNets = null;
        LispTree ltPorts = null;
        LispTree ltComponents = null;
        for (int i = 0; i < lt.size(); ++i) {
            if (lt.isLeaf(i)) continue;
            LispTree scanLT2 = lt.getBranch(i);
            if (scanLT2.keyword.equalsIgnoreCase("attributes")) {
                if (ltAttribute != null) {
                    System.out.println("Multiple 'attributes' sections for a block (line " + lt.lineNumber + ")");
                    return null;
                }
                ltAttribute = scanLT2;
                continue;
            }
            if (scanLT2.keyword.equalsIgnoreCase("nets")) {
                if (ltNets != null) {
                    System.out.println("Multiple 'nets' sections for a block (line " + lt.lineNumber + ")");
                    return null;
                }
                ltNets = scanLT2;
                continue;
            }
            if (scanLT2.keyword.equalsIgnoreCase("ports")) {
                if (ltPorts != null) {
                    System.out.println("Multiple 'ports' sections for a block (line " + lt.lineNumber + ")");
                    return null;
                }
                ltPorts = scanLT2;
                continue;
            }
            if (!scanLT2.keyword.equalsIgnoreCase("components")) continue;
            if (ltComponents != null) {
                System.out.println("Multiple 'components' sections for a block (line " + lt.lineNumber + ")");
                return null;
            }
            ltComponents = scanLT2;
        }
        if (ltAttribute == null) {
            System.out.println("Missing 'attributes' sections on a block (line " + lt.lineNumber + ")");
            return null;
        }
        String blockName = null;
        boolean gotSize = false;
        double sizeX = 0.0;
        double sizeY = 0.0;
        for (int j2 = 0; j2 < ltAttribute.size(); ++j2) {
            if (ltAttribute.isLeaf(j2)) continue;
            LispTree scanLT3 = ltAttribute.getBranch(j2);
            if (scanLT3.keyword.equalsIgnoreCase("name")) {
                if (scanLT3.size() != 1 || scanLT3.isBranch(0)) {
                    System.out.println("Block 'name' attribute should take a single atomic parameter (line " + scanLT3.lineNumber + ")");
                    return null;
                }
                blockName = scanLT3.getLeaf(0);
                continue;
            }
            if (!scanLT3.keyword.equalsIgnoreCase("size") || scanLT3.size() != 2 || !scanLT3.isLeaf(0) || !scanLT3.isLeaf(1)) continue;
            gotSize = true;
            sizeX = TextUtils.atof(scanLT3.getLeaf(0));
            sizeY = TextUtils.atof(scanLT3.getLeaf(1));
        }
        if (blockName == null) {
            System.out.println("Missing 'name' attribute in block definition (line " + ltAttribute.lineNumber + ")");
            return null;
        }
        Cell cell = Cell.newInstance(Library.getCurrent(), blockName);
        if (cell == null) {
            return null;
        }
        System.out.println("Creating cell '" + blockName + "'");
        if (gotSize) {
            NodeInst.makeInstance(this.wirePinNode, new Point2D.Double(0.5, 0.5), 1.0, 1.0, cell);
            NodeInst.makeInstance(this.wirePinNode, new Point2D.Double(sizeX - 0.5, 0.5), 1.0, 1.0, cell);
            NodeInst.makeInstance(this.wirePinNode, new Point2D.Double(0.5, sizeY - 0.5), 1.0, 1.0, cell);
            NodeInst.makeInstance(this.wirePinNode, new Point2D.Double(sizeX - 0.5, sizeY - 0.5), 1.0, 1.0, cell);
        }
        for (j = 0; j < ltAttribute.size(); ++j) {
            if (ltAttribute.isLeaf(j) || (scanLT = ltAttribute.getBranch(j)).keyword.equalsIgnoreCase("name") || scanLT.keyword.equalsIgnoreCase("size")) continue;
            if (scanLT.size() != 1 || scanLT.isBranch(0)) {
                System.out.println("Attribute '" + scanLT.keyword + "' attribute should take a single atomic parameter (line " + scanLT.lineNumber + ")");
                return null;
            }
            cell.newVar(scanLT.keyword, (Object)scanLT.getLeaf(0));
        }
        if (ltComponents != null) {
            for (j = 0; j < ltComponents.size(); ++j) {
                if (ltComponents.isLeaf(j) || !((scanLT = ltComponents.getBranch(j)).keyword.equalsIgnoreCase("repeater") ? this.makeBlockRepeater(cell, scanLT) : scanLT.keyword.equalsIgnoreCase("instance") && this.makeBlockInstance(cell, scanLT))) continue;
                return null;
            }
        }
        if (ltPorts != null) {
            for (j = 0; j < ltPorts.size(); ++j) {
                if (ltPorts.isLeaf(j) || !(scanLT = ltPorts.getBranch(j)).keyword.equalsIgnoreCase("port") || !this.makeBlockPort(cell, scanLT)) continue;
                return null;
            }
        }
        if (ltNets != null) {
            for (j = 0; j < ltNets.size(); ++j) {
                if (ltNets.isLeaf(j) || !(scanLT = ltNets.getBranch(j)).keyword.equalsIgnoreCase("net") || !this.makeBlockNet(cell, scanLT)) continue;
                return null;
            }
        }
        return cell;
    }

    private boolean makeBlockInstance(Cell cell, LispTree lt) {
        Orientation orient;
        Point2D.Double ctr;
        NodeInst ni;
        LispTree ltType = null;
        LispTree ltName = null;
        LispTree ltPosition = null;
        LispTree ltRotation = null;
        LispTree ltAttribute = null;
        for (int i = 0; i < lt.size(); ++i) {
            if (lt.isLeaf(i)) continue;
            LispTree scanLT = lt.getBranch(i);
            if (scanLT.keyword.equalsIgnoreCase("type")) {
                if (ltType != null) {
                    System.out.println("Multiple 'type' sections for a block (line " + lt.lineNumber + ")");
                    return true;
                }
                ltType = scanLT;
                continue;
            }
            if (scanLT.keyword.equalsIgnoreCase("name")) {
                if (ltName != null) {
                    System.out.println("Multiple 'name' sections for a block (line " + lt.lineNumber + ")");
                    return true;
                }
                ltName = scanLT;
                continue;
            }
            if (scanLT.keyword.equalsIgnoreCase("position")) {
                if (ltPosition != null) {
                    System.out.println("Multiple 'position' sections for a block (line " + lt.lineNumber + ")");
                    return true;
                }
                ltPosition = scanLT;
                continue;
            }
            if (scanLT.keyword.equalsIgnoreCase("rotation")) {
                if (ltRotation != null) {
                    System.out.println("Multiple 'rotation' sections for a block (line " + lt.lineNumber + ")");
                    return true;
                }
                ltRotation = scanLT;
                continue;
            }
            if (!scanLT.keyword.equalsIgnoreCase("attributes")) continue;
            if (ltAttribute != null) {
                System.out.println("Multiple 'attributes' sections for a block (line " + lt.lineNumber + ")");
                return true;
            }
            ltAttribute = scanLT;
        }
        if (ltType == null) {
            System.out.println("No 'type' specified for block instance (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltType.size() != 1 || ltType.isBranch(0)) {
            System.out.println("Need one atom in 'type' of block instance (line " + ltType.lineNumber + ")");
            return true;
        }
        Comparable<PrimitiveNode> np = this.findNodeProto(ltType.getLeaf(0));
        if (np == null) {
            np = cell.getLibrary().findNodeProto(ltType.getLeaf(0));
        }
        if (np == null) {
            System.out.println("Cannot find block type '" + ltType.getLeaf(0) + "' (line " + ltType.lineNumber + ")");
            return true;
        }
        if (ltPosition == null) {
            System.out.println("No 'position' specified for block instance (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltPosition.size() != 2 || ltPosition.isBranch(0) || ltPosition.isBranch(1)) {
            System.out.println("Need two atoms in 'position' of block instance (line " + ltPosition.lineNumber + ")");
            return true;
        }
        int rotation = 0;
        if (ltRotation != null) {
            if (ltRotation.size() != 1 || ltRotation.isBranch(0)) {
                System.out.println("Need one atom in 'rotation' of block instance (line " + ltRotation.lineNumber + ")");
                return true;
            }
            rotation = TextUtils.atoi(ltRotation.getLeaf(0)) * 10;
        }
        String nodeName = null;
        if (ltName != null) {
            if (ltName.size() != 1 || ltName.isBranch(0)) {
                System.out.println("Need one atom in 'name' of block instance (line " + ltName.lineNumber + ")");
                return true;
            }
            nodeName = ltName.getLeaf(0);
        }
        double posX = TextUtils.atof(ltPosition.getLeaf(0));
        double posY = TextUtils.atof(ltPosition.getLeaf(1));
        double wid = np.getDefWidth();
        double hei = np.getDefHeight();
        if (np instanceof PrimitiveNode) {
            posX += wid / 2.0;
            posY += hei / 2.0;
        }
        if ((ni = NodeInst.makeInstance(np, ctr = new Point2D.Double(posX, posY), wid, hei, cell, orient = Orientation.fromAngle(rotation), nodeName, 0)) == null) {
            return true;
        }
        if (ltAttribute != null) {
            for (int i = 0; i < ltAttribute.size(); ++i) {
                if (ltAttribute.isLeaf(i)) continue;
                LispTree scanLT = ltAttribute.getBranch(i);
                if (scanLT.size() != 1 || scanLT.isBranch(0)) {
                    System.out.println("Attribute '" + scanLT.keyword + "' attribute should take a single atomic parameter (line " + lt.lineNumber + ")");
                    return true;
                }
                ni.newVar(scanLT.keyword, (Object)scanLT.getLeaf(0));
            }
        }
        return false;
    }

    private boolean makeBlockPort(Cell cell, LispTree lt) {
        double posY;
        double posX;
        NodeInst ni;
        LispTree ltName = null;
        LispTree ltPosition = null;
        for (int j = 0; j < lt.size(); ++j) {
            if (lt.isLeaf(j)) continue;
            LispTree scanLT = lt.getBranch(j);
            if (scanLT.keyword.equalsIgnoreCase("name")) {
                ltName = scanLT;
                continue;
            }
            if (scanLT.keyword.equalsIgnoreCase("position")) {
                ltPosition = scanLT;
                continue;
            }
            if (!scanLT.keyword.equalsIgnoreCase("direction")) continue;
        }
        if (ltName == null) {
            System.out.println("Port has no name (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltName.size() != 1 || ltName.isBranch(0)) {
            System.out.println("Port name must be a single atom (line " + ltName.lineNumber + ")");
        }
        if (ltPosition == null) {
            System.out.println("Port has no position (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltPosition.size() != 2 || ltPosition.isBranch(0) || ltPosition.isBranch(1)) {
            System.out.println("Port position must be two atoms (line " + ltPosition.lineNumber + ")");
        }
        if ((ni = NodeInst.makeInstance(this.wirePinNode, new Point2D.Double(posX = TextUtils.atof(ltPosition.getLeaf(0)), posY = TextUtils.atof(ltPosition.getLeaf(1))), 0.0, 0.0, cell)) == null) {
            System.out.println("Error creating pin for port '" + ltName.getLeaf(0) + "' (line " + lt.lineNumber + ")");
            return true;
        }
        PortInst pi = ni.getOnlyPortInst();
        Export e = Export.newInstance(cell, pi, ltName.getLeaf(0));
        if (e == null) {
            System.out.println("Error creating port '" + ltName.getLeaf(0) + "' (line " + lt.lineNumber + ")");
            return true;
        }
        return false;
    }

    private boolean makeBlockRepeater(Cell cell, LispTree lt) {
        int angle;
        Orientation orient;
        double portBY;
        LispTree ltName = null;
        LispTree ltPortA = null;
        LispTree ltPortB = null;
        for (int j = 0; j < lt.size(); ++j) {
            if (lt.isLeaf(j)) continue;
            LispTree scanLT = lt.getBranch(j);
            if (scanLT.keyword.equalsIgnoreCase("name")) {
                ltName = scanLT;
                continue;
            }
            if (scanLT.keyword.equalsIgnoreCase("porta")) {
                ltPortA = scanLT;
                continue;
            }
            if (!scanLT.keyword.equalsIgnoreCase("portb")) continue;
            ltPortB = scanLT;
        }
        if (ltPortA == null) {
            System.out.println("Repeater has no 'porta' (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltPortA.size() != 2 || ltPortA.isBranch(0) || ltPortA.isBranch(1)) {
            System.out.println("Repeater 'porta' position must be two atoms (line " + ltPortA.lineNumber + ")");
        }
        if (ltPortB == null) {
            System.out.println("Repeater has no 'portb' (line " + lt.lineNumber + ")");
            return true;
        }
        if (ltPortB.size() != 2 || ltPortB.isBranch(0) || ltPortB.isBranch(1)) {
            System.out.println("Repeater 'portb' position must be two atoms (line " + ltPortB.lineNumber + ")");
        }
        String name = null;
        if (ltName != null) {
            if (ltName.size() != 1 || ltName.isBranch(0)) {
                System.out.println("Need one atom in 'name' of block repeater (line " + ltName.lineNumber + ")");
                return true;
            }
            name = ltName.getLeaf(0);
        }
        double portAX = TextUtils.atof(ltPortA.getLeaf(0));
        double portAY = TextUtils.atof(ltPortA.getLeaf(1));
        double portBX = TextUtils.atof(ltPortB.getLeaf(0));
        Point2D.Double ctr = new Point2D.Double((portAX + portBX) / 2.0, (portAY + (portBY = TextUtils.atof(ltPortB.getLeaf(1)))) / 2.0);
        NodeInst ni = NodeInst.makeInstance(this.repeaterNode, ctr, 10.0, 3.0, cell, orient = Orientation.fromAngle(angle = GenMath.figureAngle(new Point2D.Double(portAX, portAY), new Point2D.Double(portBX, portBY))), name, 0);
        if (ni == null) {
            System.out.println("Error creating repeater (line " + lt.lineNumber + ")");
            return true;
        }
        return false;
    }

    private boolean makeBlockNet(Cell cell, LispTree lt) {
        LispTree scanLT;
        int j;
        for (j = 0; j < lt.size(); ++j) {
            if (lt.isLeaf(j) || !(scanLT = lt.getBranch(j)).keyword.equalsIgnoreCase("name") || scanLT.size() == 1 && !scanLT.isBranch(0)) continue;
            System.out.println("Net name must be a single atom (line " + scanLT.lineNumber + ")");
            return true;
        }
        for (j = 0; j < lt.size(); ++j) {
            PortInst pi1;
            if (lt.isLeaf(j) || !(scanLT = lt.getBranch(j)).keyword.equalsIgnoreCase("segment")) continue;
            int pos = 0;
            NodeInst[] nis = new NodeInst[2];
            PortProto[] pps = new PortProto[2];
            for (int i = 0; i < 2; ++i) {
                if (scanLT.size() < pos + 1) {
                    System.out.println("Incomplete block net segment (line " + scanLT.lineNumber + ")");
                    return true;
                }
                if (scanLT.isBranch(pos)) {
                    System.out.println("Must have atoms in block net segment (line " + scanLT.lineNumber + ")");
                    return true;
                }
                if (scanLT.getLeaf(pos).equalsIgnoreCase("component")) {
                    if (scanLT.size() < pos + 3) {
                        System.out.println("Incomplete block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    if (scanLT.isBranch(pos + 1) || scanLT.isBranch(pos + 2)) {
                        System.out.println("Must have atoms in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    NodeInst niFound = null;
                    String name = scanLT.getLeaf(pos + 1);
                    Iterator<NodeInst> it = cell.getNodes();
                    while (it.hasNext()) {
                        NodeInst ni = it.next();
                        if (!ni.getName().equalsIgnoreCase(name)) continue;
                        niFound = ni;
                        break;
                    }
                    if (niFound == null) {
                        System.out.println("Cannot find component '" + scanLT.getLeaf(pos + 1) + "' in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    nis[i] = niFound;
                    pps[i] = niFound.getProto().findPortProto(scanLT.getLeaf(pos + 2));
                    if (pps[i] == null) {
                        System.out.println("Cannot find port '" + scanLT.getLeaf(pos + 2) + "' on component '" + scanLT.getLeaf(pos + 1) + "' in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    pos += 3;
                    continue;
                }
                if (scanLT.getLeaf(pos).equalsIgnoreCase("coord")) {
                    if (scanLT.size() < pos + 3) {
                        System.out.println("Incomplete block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    if (scanLT.isBranch(pos + 1) || scanLT.isBranch(pos + 2)) {
                        System.out.println("Must have atoms in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    double x = TextUtils.atof(scanLT.getLeaf(pos + 1));
                    double y = TextUtils.atof(scanLT.getLeaf(pos + 2));
                    Rectangle2D.Double search = new Rectangle2D.Double(x, y, 0.0, 0.0);
                    NodeInst niFound = null;
                    Iterator<RTBounds> it = cell.searchIterator(search);
                    while (it.hasNext()) {
                        NodeInst ni;
                        RTBounds geom = it.next();
                        if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() != this.wirePinNode || ni.getTrueCenterX() != x || ni.getTrueCenterY() != y) continue;
                        niFound = ni;
                        break;
                    }
                    if (niFound == null && (niFound = NodeInst.makeInstance(this.wirePinNode, new Point2D.Double(x, y), 0.0, 0.0, cell)) == null) {
                        System.out.println("Cannot create pin for block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    nis[i] = niFound;
                    pps[i] = niFound.getProto().getPort(0);
                    pos += 3;
                    continue;
                }
                if (scanLT.getLeaf(pos).equalsIgnoreCase("port")) {
                    if (scanLT.size() < pos + 2) {
                        System.out.println("Incomplete block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    if (scanLT.isBranch(pos + 1)) {
                        System.out.println("Must have atoms in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    Export pp = cell.findExport(scanLT.getLeaf(pos + 1));
                    if (pp == null) {
                        System.out.println("Cannot find port '" + scanLT.getLeaf(pos + 1) + "' in block net segment (line " + scanLT.lineNumber + ")");
                        return true;
                    }
                    pps[i] = pp.getOriginalPort().getPortProto();
                    nis[i] = pp.getOriginalPort().getNodeInst();
                    pos += 2;
                    continue;
                }
                System.out.println("Unknown keyword '" + scanLT.getLeaf(pos) + "' in block net segment (line " + scanLT.lineNumber + ")");
                return true;
            }
            PortInst pi0 = nis[0].findPortInstFromProto(pps[0]);
            ArcInst ai = ArcInst.makeInstanceBase(this.wireArc, 0.0, pi0, pi1 = nis[1].findPortInstFromProto(pps[1]));
            if (ai != null) continue;
            System.out.println("Cannot run segment (line " + scanLT.lineNumber + ")");
            return true;
        }
        return false;
    }

    static {
        ACTIVEPIPS_KEY = Variable.newKey("FPGA_activepips");
        ACTIVEREPEATERS_KEY = Variable.newKey("FPGA_activerepeaters");
        NULLNODELAYER = new Technology.NodeLayer[0];
    }

    private static class BuildTechnology
    extends Job {
        private FPGA tech;
        private String fileName;
        private boolean placeAndWire;
        private Cell topCell;

        private BuildTechnology(FPGA tech, String fileName, boolean placeAndWire) {
            super("Build FPGA Technology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tech = tech;
            this.fileName = fileName;
            this.placeAndWire = placeAndWire;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            LispTree lt = this.tech.readFile(this.fileName);
            if (lt == null) {
                throw new JobException("Error reading file");
            }
            int total = this.tech.makePrimitives(lt);
            System.out.println("Created " + total + " primitives");
            if (this.placeAndWire) {
                this.topCell = this.tech.placePrimitives(lt);
                this.fieldVariableChanged("topCell");
            }
            return true;
        }

        public void terminateOK() {
            if (this.topCell != null) {
                UserInterface ui = Job.getUserInterface();
                ui.displayCell(this.topCell);
            }
        }
    }

    private static class SetPips
    extends Job {
        private NodeInst ni;
        private String newPips;

        private SetPips(NodeInst ni, String newPips) {
            super("Program Pips", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.newPips = newPips;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.ni.newVar(ACTIVEPIPS_KEY, (Object)this.newPips);
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            ui.repaintAllEditWindows();
        }
    }

    private static class FPGANode
    extends PrimitiveNode {
        FPGAPort[] portList;
        FPGANet[] netList;
        FPGAPip[] pipList;

        protected FPGANode(String protoName, Technology tech, double defWidth, double defHeight, Technology.NodeLayer[] layers) {
            super(protoName, tech, EPoint.ORIGIN, EPoint.ORIGIN, null, defWidth, defHeight, ERectangle.ORIGIN, ERectangle.ORIGIN, layers);
        }

        int numPorts() {
            if (this.portList == null) {
                return 0;
            }
            return this.portList.length;
        }

        int numNets() {
            if (this.netList == null) {
                return 0;
            }
            return this.netList.length;
        }

        int numPips() {
            if (this.pipList == null) {
                return 0;
            }
            return this.pipList.length;
        }
    }

    private static class FPGAPip {
        String name;
        int pipActive;
        int con1;
        int con2;
        double posX;
        double posY;

        private FPGAPip() {
        }
    }

    private static class FPGANet {
        String name;
        int segActive;
        Point2D[] segFrom;
        Point2D[] segTo;

        private FPGANet() {
        }
    }

    private static class FPGAPort {
        String name;
        double posX;
        double posY;
        int con;
        PortCharacteristic characteristic;
        PrimitivePort pp;

        private FPGAPort() {
        }
    }

    private static class LispTree {
        private String keyword;
        private int lineNumber;
        private List<Object> values = new ArrayList<Object>();

        LispTree() {
        }

        void add(Object obj) {
            this.values.add(obj);
        }

        int size() {
            return this.values.size();
        }

        boolean isLeaf(int i) {
            return !(this.values.get(i) instanceof LispTree);
        }

        boolean isBranch(int i) {
            return this.values.get(i) instanceof LispTree;
        }

        String getLeaf(int i) {
            return (String)this.values.get(i);
        }

        LispTree getBranch(int i) {
            return (LispTree)this.values.get(i);
        }
    }
}

