/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Change
extends EModelessDialog
implements HighlightListener {
    private static final int CHANGE_SELECTED = 1;
    private static final int CHANGE_CONNECTED = 2;
    private static final int CHANGE_CELL = 3;
    private static final int CHANGE_LIBRARY = 4;
    private static final int CHANGE_EVERYWHERE = 5;
    private static Change theDialog = null;
    private static boolean lastChangeNodesWithArcs = false;
    private static boolean lastIgnorePortNames = false;
    private static boolean lastAllowMissingPorts = false;
    private static int whatToChange = 1;
    private static String libSelected = null;
    private List<Geometric> geomsToChange;
    private JList changeList;
    private DefaultListModel changeListModel;
    private List<NodeProto> changeNodeProtoList;
    private EditWindow wnd;
    private static final Pattern dummyName = Pattern.compile("(.*?)FROM(.*?)\\{(.*)");
    private boolean dontReload = false;
    private JCheckBox allowMissingPorts;
    private JButton apply;
    private JRadioButton changeConnected;
    private JRadioButton changeEverywhere;
    private JRadioButton changeInCell;
    private JRadioButton changeInLibrary;
    private JCheckBox changeNodesWithArcs;
    private ButtonGroup changeOption;
    private JRadioButton changeSelected;
    private JButton done;
    private JCheckBox ignorePortNames;
    private JLabel jLabel1;
    private JComboBox librariesPopup;
    private JScrollPane listPane;
    private JCheckBox showCells;
    private JCheckBox showPrimitives;

    public static void showChangeDialog() {
        if (Client.getOperatingSystem() == Client.OS.UNIX && theDialog != null) {
            theDialog.closeDialog(null);
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new Change(jf);
        }
        theDialog.loadInfo(true);
        theDialog.setVisible(true);
        theDialog.toFront();
    }

    private Change(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        this.apply.setMnemonic('A');
        this.done.setMnemonic('D');
        this.changeListModel = new DefaultListModel();
        this.changeList = new JList(this.changeListModel);
        this.changeList.setSelectionMode(0);
        this.listPane.setViewportView(this.changeList);
        this.changeNodeProtoList = new ArrayList<NodeProto>();
        this.changeList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Change.this.apply(null);
                }
            }
        });
        List<Library> libList = Library.getVisibleLibraries();
        int curIndex = libList.indexOf(Library.getCurrent());
        for (Library lib : libList) {
            this.librariesPopup.addItem(lib.getName());
            if (!lib.getName().equals(libSelected)) continue;
            curIndex = -1;
            this.librariesPopup.setSelectedItem(libSelected);
        }
        if (curIndex >= 0) {
            this.librariesPopup.setSelectedIndex(curIndex);
        }
        this.librariesPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.ignorePortNames.setSelected(lastIgnorePortNames);
        this.allowMissingPorts.setSelected(lastAllowMissingPorts);
        this.ignorePortNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
            }
        });
        this.allowMissingPorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.rememberState();
            }
        });
        this.showPrimitives.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.showCells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeNodesWithArcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.reload(false);
            }
        });
        this.changeSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeConnected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeInLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        this.changeEverywhere.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.whatToChangeChanged(evt);
            }
        });
        switch (whatToChange) {
            case 1: {
                this.changeSelected.setSelected(true);
                break;
            }
            case 2: {
                this.changeConnected.setSelected(true);
                break;
            }
            case 3: {
                this.changeInCell.setSelected(true);
                break;
            }
            case 4: {
                this.changeInLibrary.setSelected(true);
                break;
            }
            case 5: {
                this.changeEverywhere.setSelected(true);
            }
        }
        this.finishInitialization();
        Highlighter.addHighlightListener(this);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(true);
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo(false);
    }

    protected void escapePressed() {
        this.done(null);
    }

    private void whatToChangeChanged(ActionEvent evt) {
        JRadioButton src = (JRadioButton)evt.getSource();
        if (src == this.changeSelected) {
            whatToChange = 1;
        } else if (src == this.changeConnected) {
            whatToChange = 2;
        } else if (src == this.changeInCell) {
            whatToChange = 3;
        } else if (src == this.changeInLibrary) {
            whatToChange = 4;
        } else if (src == this.changeEverywhere) {
            whatToChange = 5;
        }
        Geometric geomToChange = this.geomsToChange.get(0);
        if (whatToChange == 5) {
            if (geomToChange instanceof ArcInst) {
                if (this.changeNodesWithArcs.isSelected()) {
                    this.changeNodesWithArcs.setSelected(false);
                    this.reload(false);
                }
                this.changeNodesWithArcs.setEnabled(false);
            }
        } else if (geomToChange instanceof ArcInst) {
            this.changeNodesWithArcs.setEnabled(true);
        }
    }

    private void loadInfo(boolean showHighlighted) {
        EditWindow curWnd = EditWindow.getCurrent();
        if (curWnd != null) {
            this.wnd = curWnd;
        }
        this.geomsToChange = new ArrayList<Geometric>();
        if (this.wnd != null) {
            List<Geometric> highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
            boolean hasArcs = false;
            boolean hasCells = false;
            boolean hasPrimitives = false;
            for (Geometric geom : highs) {
                this.geomsToChange.add(geom);
                if (geom instanceof ArcInst) {
                    hasArcs = true;
                    continue;
                }
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                if (ni.isCellInstance()) {
                    hasCells = true;
                    continue;
                }
                hasPrimitives = true;
            }
            if (hasArcs && hasCells) {
                System.out.println("The 'Change' dialog cannot handle selection of both arcs and cells.\n Close the dialog if the selection of elements is correct.");
                this.geomsToChange.clear();
            } else if (hasArcs && hasPrimitives) {
                System.out.println("The 'Change' dialog cannot handle selection of both arcs and primitives.\n Close the dialog if the selection of elements is correct.");
                this.geomsToChange.clear();
            } else if (hasCells && hasPrimitives) {
                System.out.println("The 'Change' dialog cannot handle selection of both cells and primitives.\n Close the dialog if the selection of elements is correct.");
                this.geomsToChange.clear();
            }
        }
        if (this.geomsToChange.size() == 0) {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(false);
            this.apply.setEnabled(false);
            this.changeSelected.setEnabled(false);
            this.changeConnected.setEnabled(false);
            this.changeInCell.setEnabled(false);
            this.changeInLibrary.setEnabled(false);
            this.changeEverywhere.setEnabled(false);
            return;
        }
        this.apply.setEnabled(true);
        this.changeSelected.setEnabled(true);
        this.changeConnected.setEnabled(true);
        this.changeInCell.setEnabled(true);
        this.changeInLibrary.setEnabled(true);
        this.changeEverywhere.setEnabled(true);
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            this.librariesPopup.setEnabled(true);
            this.ignorePortNames.setEnabled(true);
            this.allowMissingPorts.setEnabled(true);
            this.showPrimitives.setEnabled(true);
            this.showCells.setEnabled(true);
            NodeInst ni = (NodeInst)geomToChange;
            if (ni.isCellInstance()) {
                this.showCells.setSelected(true);
            } else {
                this.showPrimitives.setSelected(true);
            }
            this.changeNodesWithArcs.setSelected(false);
            this.changeNodesWithArcs.setEnabled(false);
        } else {
            this.librariesPopup.setEnabled(false);
            this.ignorePortNames.setEnabled(false);
            this.allowMissingPorts.setEnabled(false);
            this.showPrimitives.setEnabled(false);
            this.showCells.setEnabled(false);
            this.changeNodesWithArcs.setEnabled(true);
            this.changeNodesWithArcs.setSelected(lastChangeNodesWithArcs);
        }
        this.reload(true);
    }

    private void rememberState() {
        lastIgnorePortNames = this.ignorePortNames.isSelected();
        lastAllowMissingPorts = this.allowMissingPorts.isSelected();
    }

    private void reload(boolean canSwitchLibraries) {
        lastChangeNodesWithArcs = this.changeNodesWithArcs.isSelected();
        if (this.dontReload) {
            return;
        }
        this.changeListModel.clear();
        this.changeNodeProtoList.clear();
        if (this.geomsToChange.size() == 0) {
            return;
        }
        Technology curTech = Technology.getCurrent();
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            NodeInst ni = (NodeInst)geomToChange;
            if (this.showCells.isSelected()) {
                if (ni.isCellInstance() && canSwitchLibraries) {
                    Cell parent = (Cell)ni.getProto();
                    Library lib = parent.getLibrary();
                    this.dontReload = true;
                    this.librariesPopup.setSelectedItem(lib.getName());
                    this.dontReload = false;
                }
                View origView = null;
                if (ni.isCellInstance()) {
                    origView = ((Cell)ni.getProto()).getView();
                }
                String libName = (String)this.librariesPopup.getSelectedItem();
                Library lib = Library.findLibrary(libName);
                Iterator<Cell> it = lib.getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    if (origView != null && (origView == View.ICON ? cell.getView() != View.ICON : (origView == View.LAYOUT || origView == View.LAYOUTCOMP || origView == View.LAYOUTSKEL) && cell.getView() != View.LAYOUT && cell.getView() != View.LAYOUTCOMP && cell.getView() != View.LAYOUTSKEL)) continue;
                    this.changeListModel.addElement(cell.noLibDescribe());
                    this.changeNodeProtoList.add(cell);
                }
            }
            if (this.showPrimitives.isSelected()) {
                for (PrimitiveNode np : curTech.getNodesSortedByName()) {
                    if (np.isNotUsed()) continue;
                    this.changeListModel.addElement(np.describe(false));
                    this.changeNodeProtoList.add(np);
                }
                if (curTech != Generic.tech()) {
                    this.changeListModel.addElement("Generic:Universal-Pin");
                    this.changeNodeProtoList.add(Generic.tech().universalPinNode);
                    this.changeListModel.addElement("Generic:Invisible-Pin");
                    this.changeNodeProtoList.add(Generic.tech().invisiblePinNode);
                    this.changeListModel.addElement("Generic:Unrouted-Pin");
                    this.changeNodeProtoList.add(Generic.tech().unroutedPinNode);
                }
            }
            this.changeList.setSelectedIndex(0);
            if (ni.isCellInstance()) {
                Cell c = (Cell)ni.getProto();
                for (int i = 0; i < this.changeListModel.getSize(); ++i) {
                    String str = (String)this.changeListModel.get(i);
                    if (!str.equals(c.noLibDescribe())) continue;
                    this.changeList.setSelectedIndex(i);
                    break;
                }
            } else {
                for (int i = 0; i < this.changeListModel.getSize(); ++i) {
                    String str = (String)this.changeListModel.get(i);
                    if (!str.equals(ni.getProto().describe(false))) continue;
                    this.changeList.setSelectedIndex(i);
                    break;
                }
            }
            if (this.showCells.isSelected()) {
                String geomName = ((NodeInst)geomToChange).getProto().describe(false);
                Matcher mat = dummyName.matcher(geomName);
                if (mat.matches()) {
                    this.changeList.setSelectedValue(mat.group(1) + "{" + mat.group(3), true);
                    this.librariesPopup.setSelectedItem(mat.group(2));
                } else {
                    this.changeList.setSelectedValue(geomName, true);
                }
            }
        } else {
            Technology arcTech;
            ArcProto ap;
            ArcInst ai = (ArcInst)geomToChange;
            PortProto pp1 = ai.getHeadPortInst().getPortProto();
            PortProto pp2 = ai.getTailPortInst().getPortProto();
            Iterator<ArcProto> it = curTech.getArcs();
            while (it.hasNext()) {
                ap = it.next();
                if (ap.isNotUsed() || !this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                this.changeListModel.addElement(ap.describe());
            }
            if (curTech != Generic.tech()) {
                it = Generic.tech().getArcs();
                while (it.hasNext()) {
                    ap = it.next();
                    if (ap.isNotUsed() || !this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap) || !pp2.connectsTo(ap))) continue;
                    this.changeListModel.addElement(ap.describe());
                }
            }
            if ((arcTech = ai.getProto().getTechnology()) != curTech && arcTech != Generic.tech()) {
                Iterator<ArcProto> it2 = arcTech.getArcs();
                while (it2.hasNext()) {
                    ArcProto ap2 = it2.next();
                    if (ap2.isNotUsed() || !this.changeNodesWithArcs.isSelected() && (!pp1.connectsTo(ap2) || !pp2.connectsTo(ap2))) continue;
                    this.changeListModel.addElement(ap2.describe());
                }
            }
            this.changeList.setSelectedIndex(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EDialog.centerSelection(Change.this.changeList);
            }
        });
    }

    private void doTheChange() {
        NodeProto np = null;
        ArcProto ap = null;
        Geometric geomToChange = this.geomsToChange.get(0);
        if (geomToChange instanceof NodeInst) {
            int index = this.changeList.getSelectedIndex();
            np = this.changeNodeProtoList.get(index);
        } else {
            String line = (String)this.changeList.getSelectedValue();
            ap = ArcProto.findArcProto(line);
            if (ap == null) {
                System.out.println("Nothing called '" + line + "'");
                return;
            }
        }
        List<Geometric> highs = this.wnd.getHighlighter().getHighlightedEObjs(true, true);
        new ChangeObject(this.geomsToChange, highs, this.getLibSelected(), np, ap, this.ignorePortNames.isSelected(), this.allowMissingPorts.isSelected(), this.changeNodesWithArcs.isSelected(), this.changeInCell.isSelected(), this.changeInLibrary.isSelected(), this.changeEverywhere.isSelected(), this.changeConnected.isSelected());
    }

    private String getLibSelected() {
        return (String)this.librariesPopup.getSelectedItem();
    }

    private void initComponents() {
        this.changeOption = new ButtonGroup();
        this.done = new JButton();
        this.apply = new JButton();
        this.listPane = new JScrollPane();
        this.changeSelected = new JRadioButton();
        this.changeConnected = new JRadioButton();
        this.changeInCell = new JRadioButton();
        this.changeInLibrary = new JRadioButton();
        this.changeEverywhere = new JRadioButton();
        this.changeNodesWithArcs = new JCheckBox();
        this.showPrimitives = new JCheckBox();
        this.showCells = new JCheckBox();
        this.ignorePortNames = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.librariesPopup = new JComboBox();
        this.allowMissingPorts = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Change");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Change.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.done(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Change.this.apply(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(150, 22));
        this.listPane.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.changeSelected.setText("Change selected ones only");
        this.changeOption.add(this.changeSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.changeSelected, gridBagConstraints);
        this.changeConnected.setText("Change all connected to this");
        this.changeOption.add(this.changeConnected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeConnected, gridBagConstraints);
        this.changeInCell.setText("Change all in this cell");
        this.changeOption.add(this.changeInCell);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInCell, gridBagConstraints);
        this.changeInLibrary.setText("Change all in this library");
        this.changeOption.add(this.changeInLibrary);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.changeInLibrary, gridBagConstraints);
        this.changeEverywhere.setText("Change all in all libraries");
        this.changeOption.add(this.changeEverywhere);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 10, 4);
        this.getContentPane().add((Component)this.changeEverywhere, gridBagConstraints);
        this.changeNodesWithArcs.setText("Change nodes with arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 4, 4, 4);
        this.getContentPane().add((Component)this.changeNodesWithArcs, gridBagConstraints);
        this.showPrimitives.setText("Show primitives");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showPrimitives, gridBagConstraints);
        this.showCells.setText("Show cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.showCells, gridBagConstraints);
        this.ignorePortNames.setText("Ignore port names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ignorePortNames, gridBagConstraints);
        this.jLabel1.setText("Library:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.librariesPopup, gridBagConstraints);
        this.allowMissingPorts.setText("Allow missing ports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allowMissingPorts, gridBagConstraints);
        this.pack();
    }

    private void done(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void apply(ActionEvent evt) {
        this.doTheChange();
        libSelected = (String)this.librariesPopup.getSelectedItem();
    }

    private void closeDialog(WindowEvent evt) {
        Highlighter.removeHighlightListener(this);
        this.setVisible(false);
        this.dispose();
        theDialog = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeObject
    extends Job {
        private List<Geometric> geomsToChange;
        private List<Geometric> highs;
        private String libName;
        private NodeProto np;
        private ArcProto ap;
        private Cell cell;
        private boolean ignorePortNames;
        private boolean allowMissingPorts;
        private boolean changeNodesWithArcs;
        private boolean changeInCell;
        private boolean changeInLibrary;
        private boolean changeEverywhere;
        private boolean changeConnected;
        private List<Geometric> highlightThese;
        private NodeProto[] contactStack = new NodeProto[100];
        private ArcProto[] contactStackArc = new ArcProto[100];
        private Technology connectionTech = null;
        private Map<ArcProto, Map<ArcProto, PrimitivePort>> connectionMap;

        private ChangeObject(List<Geometric> geomsToChange, List<Geometric> highs, String libName, NodeProto np, ArcProto ap, boolean ignorePortNames, boolean allowMissingPorts, boolean changeNodesWithArcs, boolean changeInCell, boolean changeInLibrary, boolean changeEverywhere, boolean changeConnected) {
            super("Change type", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.geomsToChange = geomsToChange;
            this.highs = highs;
            this.libName = libName;
            this.np = np;
            this.ap = ap;
            this.cell = WindowFrame.getCurrentCell();
            this.ignorePortNames = ignorePortNames;
            this.allowMissingPorts = allowMissingPorts;
            this.changeNodesWithArcs = changeNodesWithArcs;
            this.changeInCell = changeInCell;
            this.changeInLibrary = changeInLibrary;
            this.changeEverywhere = changeEverywhere;
            this.changeConnected = changeConnected;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.highlightThese = new ArrayList<Geometric>();
            this.fieldVariableChanged("highlightThese");
            HashSet<NodeInst> changedAlready = new HashSet<NodeInst>();
            for (Geometric geomToChange : this.geomsToChange) {
                Iterator<Geometric> nIt;
                Cell cell;
                Iterator<Cell> cIt;
                Iterator<Cell> cIt2;
                Library lib;
                int total;
                if (geomToChange instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geomToChange;
                    if (CircuitChangeJobs.cantEdit(ni.getParent(), ni, true, false, true) != 0) {
                        return false;
                    }
                    Library library = Library.findLibrary(this.libName);
                    if (library == null) {
                        return false;
                    }
                    if (this.np == null) {
                        return false;
                    }
                    NodeProto oldNType = ni.getProto();
                    if (oldNType == this.np) {
                        System.out.println("Node already of type " + this.np.describe(true));
                        continue;
                    }
                    if (!changedAlready.contains(ni)) {
                        changedAlready.add(ni);
                        NodeInst onlyNewNi = CircuitChangeJobs.replaceNodeInst(ni, this.np, this.ignorePortNames, this.allowMissingPorts);
                        if (onlyNewNi == null) {
                            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), this.np + " does not fit in the place of " + oldNType, "Change failed", 0);
                            return false;
                        }
                        this.highlightThese.add(onlyNewNi);
                    }
                    total = 1;
                    if (this.changeEverywhere) {
                        Iterator<Library> it = Library.getLibraries();
                        while (it.hasNext()) {
                            lib = it.next();
                            cIt2 = lib.getCells();
                            while (cIt2.hasNext()) {
                                Cell cell2 = cIt2.next();
                                boolean found = true;
                                block3: while (found) {
                                    found = false;
                                    Iterator<NodeInst> nIt2 = cell2.getNodes();
                                    while (nIt2.hasNext()) {
                                        NodeInst newNi;
                                        NodeInst lNi = nIt2.next();
                                        if (lNi.getProto() != oldNType || changedAlready.contains(lNi)) continue;
                                        changedAlready.add(lNi);
                                        if (lNi.isIconOfParent()) {
                                            System.out.println("Example icon in " + cell2 + " not replaced");
                                            continue;
                                        }
                                        int errorCode = CircuitChangeJobs.cantEdit(cell2, lNi, true, false, true);
                                        if (errorCode < 0) {
                                            return false;
                                        }
                                        if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                                        ++total;
                                        found = true;
                                        continue block3;
                                    }
                                }
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes in all libraries replaced with " + this.np);
                        continue;
                    }
                    if (this.changeInLibrary) {
                        Library lib2 = this.cell.getLibrary();
                        cIt = lib2.getCells();
                        while (cIt.hasNext()) {
                            cell = cIt.next();
                            boolean found = true;
                            block6: while (found) {
                                found = false;
                                Iterator<NodeInst> nIt3 = cell.getNodes();
                                while (nIt3.hasNext()) {
                                    NodeInst newNi;
                                    NodeInst lNi = nIt3.next();
                                    if (lNi.getProto() != oldNType || changedAlready.contains(lNi)) continue;
                                    changedAlready.add(lNi);
                                    int errorCode = CircuitChangeJobs.cantEdit(cell, lNi, true, false, true);
                                    if (errorCode < 0) {
                                        return false;
                                    }
                                    if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block6;
                                }
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes in " + lib2 + " replaced with " + this.np);
                        continue;
                    }
                    if (this.changeInCell) {
                        boolean found = true;
                        block8: while (found) {
                            found = false;
                            nIt = this.cell.getNodes();
                            while (nIt.hasNext()) {
                                NodeInst newNi;
                                NodeInst lNi = nIt.next();
                                if (lNi.getProto() != oldNType || changedAlready.contains(lNi)) continue;
                                changedAlready.add(lNi);
                                int errorCode = CircuitChangeJobs.cantEdit(this.cell, lNi, true, false, true);
                                if (errorCode < 0) {
                                    return false;
                                }
                                if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                                ++total;
                                found = true;
                                continue block8;
                            }
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes in " + this.cell + " replaced with " + this.np);
                        continue;
                    }
                    if (this.changeConnected) {
                        Netlist netlist = this.cell.getUserNetlist();
                        ArrayList<NodeInst> others = new ArrayList<NodeInst>();
                        NodeInst onlyNewNi = null;
                        if (this.highlightThese.size() == 1 && this.highlightThese.get(0) instanceof NodeInst) {
                            onlyNewNi = (NodeInst)this.highlightThese.get(0);
                        }
                        Iterator<NodeInst> it = this.cell.getNodes();
                        while (it.hasNext()) {
                            NodeInst lNi = it.next();
                            if (lNi.getProto() != oldNType || lNi == onlyNewNi) continue;
                            boolean found = false;
                            Iterator<PortInst> pIt = onlyNewNi.getPortInsts();
                            while (pIt.hasNext()) {
                                PortInst pi = pIt.next();
                                Iterator<PortInst> lPIt = lNi.getPortInsts();
                                while (lPIt.hasNext()) {
                                    PortInst lPi = lPIt.next();
                                    if (!netlist.sameNetwork(pi.getNodeInst(), pi.getPortProto(), lPi.getNodeInst(), lPi.getPortProto())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) continue;
                                break;
                            }
                            if (!found) continue;
                            others.add(lNi);
                        }
                        for (NodeInst lNi : others) {
                            NodeInst newNi;
                            if (changedAlready.contains(lNi)) continue;
                            changedAlready.add(lNi);
                            int errorCode = CircuitChangeJobs.cantEdit(this.cell, lNi, true, false, true);
                            if (errorCode < 0) {
                                return false;
                            }
                            if (errorCode > 0 || (newNi = CircuitChangeJobs.replaceNodeInst(lNi, this.np, this.ignorePortNames, this.allowMissingPorts)) == null) continue;
                            ++total;
                        }
                        System.out.println("All " + total + " " + oldNType.describe(true) + " nodes connected to this replaced with " + this.np);
                        continue;
                    }
                    System.out.println(oldNType + " replaced with " + this.np);
                    continue;
                }
                ArcInst ai = (ArcInst)geomToChange;
                if (this.ap == null) {
                    System.out.println("Arc " + ai.getName() + " skipped");
                    continue;
                }
                if (CircuitChangeJobs.cantEdit(ai.getParent(), null, true, false, true) != 0) {
                    return false;
                }
                ArcProto oldAType = ai.getProto();
                if (oldAType == this.ap) {
                    System.out.println("Arc already of type " + this.ap.describe());
                    return false;
                }
                if (this.changeNodesWithArcs) {
                    if (this.changeInLibrary) {
                        Iterator<Cell> it = Library.getCurrent().getCells();
                        while (it.hasNext()) {
                            Cell cell3 = it.next();
                            this.replaceAllArcs(cell3, this.highs, ai, this.ap, false, true);
                        }
                    } else {
                        this.replaceAllArcs(ai.getParent(), this.highs, ai, this.ap, this.changeConnected, this.changeInCell);
                    }
                    return true;
                }
                ArcInst onlyNewAi = ai.replace(this.ap);
                if (onlyNewAi == null) {
                    System.out.println(this.ap + " does not fit in the place of " + oldAType);
                    return false;
                }
                this.highlightThese.add(onlyNewAi);
                total = 1;
                if (this.changeEverywhere) {
                    Iterator<Library> it = Library.getLibraries();
                    while (it.hasNext()) {
                        lib = it.next();
                        cIt2 = lib.getCells();
                        while (cIt2.hasNext()) {
                            Cell cell4 = cIt2.next();
                            boolean found = true;
                            block17: while (found) {
                                found = false;
                                Iterator<ArcInst> nIt4 = cell4.getArcs();
                                while (nIt4.hasNext()) {
                                    ArcInst newAi;
                                    ArcInst lAi = nIt4.next();
                                    if (lAi.getProto() != oldAType) continue;
                                    int errorCode = CircuitChangeJobs.cantEdit(cell4, null, true, false, true);
                                    if (errorCode < 0) {
                                        return false;
                                    }
                                    if (errorCode > 0 || (newAi = lAi.replace(this.ap)) == null) continue;
                                    ++total;
                                    found = true;
                                    continue block17;
                                }
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in the library replaced with " + this.ap);
                    continue;
                }
                if (this.changeInLibrary) {
                    Library lib3 = Library.getCurrent();
                    cIt = lib3.getCells();
                    while (cIt.hasNext()) {
                        cell = cIt.next();
                        boolean found = true;
                        block20: while (found) {
                            found = false;
                            Iterator<ArcInst> nIt5 = cell.getArcs();
                            while (nIt5.hasNext()) {
                                ArcInst newAi;
                                ArcInst lAi = nIt5.next();
                                if (lAi.getProto() != oldAType) continue;
                                int errorCode = CircuitChangeJobs.cantEdit(cell, null, true, false, true);
                                if (errorCode < 0) {
                                    return false;
                                }
                                if (errorCode > 0 || (newAi = lAi.replace(this.ap)) == null) continue;
                                ++total;
                                found = true;
                                continue block20;
                            }
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in " + lib3 + " replaced with " + this.ap);
                    continue;
                }
                if (this.changeInCell) {
                    boolean found = true;
                    block22: while (found) {
                        found = false;
                        nIt = this.cell.getArcs();
                        while (nIt.hasNext()) {
                            ArcInst newAi;
                            ArcInst lAi = (ArcInst)nIt.next();
                            if (lAi.getProto() != oldAType) continue;
                            int errorCode = CircuitChangeJobs.cantEdit(this.cell, null, true, false, true);
                            if (errorCode < 0) {
                                return false;
                            }
                            if (errorCode > 0 || (newAi = lAi.replace(this.ap)) == null) continue;
                            ++total;
                            found = true;
                            continue block22;
                        }
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs in " + this.cell + " replaced with " + this.ap);
                    continue;
                }
                if (this.changeConnected) {
                    ArrayList<ArcInst> others = new ArrayList<ArcInst>();
                    Netlist netlist = this.cell.getUserNetlist();
                    Iterator<ArcInst> it = this.cell.getArcs();
                    while (it.hasNext()) {
                        ArcInst lAi = it.next();
                        if (lAi == onlyNewAi || !netlist.sameNetwork(onlyNewAi, lAi)) continue;
                        others.add(lAi);
                    }
                    for (ArcInst lAi : others) {
                        ArcInst newAi = lAi.replace(this.ap);
                        if (newAi == null) continue;
                        ++total;
                    }
                    System.out.println("All " + total + " " + oldAType.describe() + " arcs connected to this replaced with " + this.ap);
                    continue;
                }
                System.out.println(oldAType + " replaced with " + this.ap);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                for (Geometric geom : this.highlightThese) {
                    highlighter.addElectricObject(geom, geom.getParent());
                }
                highlighter.finished();
            }
        }

        private void replaceAllArcs(Cell cell, List<Geometric> highs, ArcInst oldAi, ArcProto ap, boolean connected, boolean thiscell) {
            ArcInst ai;
            Iterator<Geometric> it;
            HashSet<ArcInst> geomMarked = new HashSet<ArcInst>();
            ArrayList<NodeInst> changePins = new ArrayList<NodeInst>();
            for (Geometric geom : highs) {
                ArcInst ai2;
                if (!(geom instanceof ArcInst) || (ai2 = (ArcInst)geom).getProto() != oldAi.getProto()) continue;
                geomMarked.add(ai2);
            }
            if (connected) {
                Netlist netlist = cell.getUserNetlist();
                Iterator<ArcInst> it2 = cell.getArcs();
                while (it2.hasNext()) {
                    ArcInst ai2 = it2.next();
                    if (ai2.getProto() != oldAi.getProto() || !netlist.sameNetwork(ai2, oldAi)) continue;
                    geomMarked.add(ai2);
                }
            }
            if (thiscell) {
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai3 = (ArcInst)it.next();
                    if (ai3.getProto() != oldAi.getProto()) continue;
                    geomMarked.add(ai3);
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (ni.isCellInstance() || !ni.getFunction().isPin()) continue;
                boolean allArcs = true;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    if (geomMarked.contains(con.getArc())) continue;
                    allArcs = false;
                    break;
                }
                if (!ni.hasConnections() || !allArcs) continue;
                changePins.add(ni);
            }
            EditingPreferences ep = cell.getEditingPreferences();
            PrimitiveNode pin = ap.findOverridablePinProto(ep);
            double xS = pin.getDefWidth();
            double yS = pin.getDefHeight();
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            for (NodeInst nodeInst : changePins) {
                NodeInst newNi = NodeInst.makeInstance(pin, nodeInst.getAnchorCenter(), xS, yS, cell);
                if (newNi == null) {
                    return;
                }
                newNodes.put(nodeInst, newNi);
                Iterator<Export> eIt = nodeInst.getExports();
                while (eIt.hasNext()) {
                    Export oldExport = eIt.next();
                    if (!oldExport.move(newNi.getOnlyPortInst())) continue;
                    System.out.println("Unable to move export " + oldExport.getName() + " from old pin " + nodeInst.describe(true) + " to new pin " + newNi);
                }
            }
            for (Geometric geometric : geomMarked) {
                ArcInst newAi;
                if (!(geometric instanceof ArcInst)) continue;
                ai = (ArcInst)geometric;
                PortInst pi0 = null;
                NodeInst newNi0 = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
                if (newNi0 != null) {
                    pi0 = newNi0.getOnlyPortInst();
                } else {
                    pi0 = this.makeContactStack(ai, 1, ap);
                    if (pi0 == null) {
                        return;
                    }
                }
                PortInst pi1 = null;
                NodeInst newNi1 = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
                if (newNi1 != null) {
                    pi1 = newNi1.getOnlyPortInst();
                } else {
                    pi1 = this.makeContactStack(ai, 0, ap);
                    if (pi1 == null) {
                        return;
                    }
                }
                double wid = ap.getDefaultLambdaBaseWidth();
                if (ai.getLambdaBaseWidth() > wid) {
                    wid = ai.getLambdaBaseWidth();
                }
                if ((newAi = ArcInst.makeInstanceBase(ap, wid, pi0, pi1, ai.getHeadLocation(), ai.getTailLocation(), ai.getName())) == null) {
                    return;
                }
                newAi.copyPropertiesFrom(ai);
                geomMarked.remove(newAi);
            }
            for (Geometric geometric : geomMarked) {
                if (!(geometric instanceof ArcInst)) continue;
                ai = (ArcInst)geometric;
                ai.kill();
            }
            for (NodeInst nodeInst : changePins) {
                if (nodeInst.hasExports()) continue;
                String niName = nodeInst.getName();
                nodeInst.kill();
                NodeInst newNi = (NodeInst)newNodes.get(nodeInst);
                newNi.setName(niName);
            }
        }

        private PortInst makeContactStack(ArcInst ai, int end, ArcProto ap) {
            NodeInst lastNi = ai.getPortInst(end).getNodeInst();
            PortProto lastPp = ai.getPortInst(end).getPortProto();
            PortInst lastPi = lastNi.findPortInstFromProto(lastPp);
            EPoint center = ai.getLocation(end);
            Cell cell = ai.getParent();
            this.setupConnections(ap.getTechnology());
            HashSet<ArcProto> markedArcs = new HashSet<ArcProto>();
            int depth = this.findOtherPathToArc(lastPp, ai.getProto(), ap, 0, markedArcs);
            if (depth < 0) {
                return null;
            }
            for (int i = 0; i < depth; ++i) {
                ArcProto typ = this.contactStackArc[i];
                double wid = ai.getLambdaBaseWidth();
                double xS = this.contactStack[i].getDefWidth();
                double yS = this.contactStack[i].getDefHeight();
                SizeOffset so = this.contactStack[i].getProtoSizeOffset();
                NodeInst newNi = NodeInst.makeInstance(this.contactStack[i], center, xS = Math.max(xS - so.getLowXOffset() - so.getHighXOffset(), wid) + so.getLowXOffset() + so.getHighXOffset(), yS = Math.max(yS - so.getLowYOffset() - so.getHighYOffset(), wid) + so.getLowYOffset() + so.getHighYOffset(), cell);
                if (newNi == null) {
                    return null;
                }
                PortInst thisPi = newNi.findPortInstFromProto(this.contactStack[i].getPort(0));
                ArcInst newAi = ArcInst.newInstanceBase(typ, wid, thisPi, lastPi, center, center, null, ai.getAngle());
                lastPi = thisPi;
                if (newAi == null) {
                    return null;
                }
                newAi.setFixedAngle(true);
            }
            return lastPi;
        }

        private void setupConnections(Technology tech) {
            if (this.connectionTech == tech) {
                return;
            }
            this.connectionTech = tech;
            this.connectionMap = new HashMap<ArcProto, Map<ArcProto, PrimitivePort>>();
            Iterator<PrimitiveNode> it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode.Function fun;
                PrimitiveNode np = it.next();
                if (np.isNotUsed() || !(fun = np.getFunction()).isContact()) continue;
                PrimitivePort pp = np.getPort(0);
                ArcProto[] arcs = pp.getConnections();
                ArcProto ap1 = null;
                ArcProto ap2 = null;
                for (int i = 0; i < arcs.length; ++i) {
                    ArcProto ap = arcs[i];
                    if (ap.getTechnology() != tech) continue;
                    if (ap1 == null) {
                        ap1 = ap;
                        continue;
                    }
                    if (ap2 != null) continue;
                    ap2 = ap;
                }
                if (ap1 == null || ap2 == null) continue;
                this.addConnection(ap1, ap2, null);
                this.addConnection(ap2, ap1, null);
            }
        }

        private void addConnection(ArcProto ap1, ArcProto ap2, PrimitivePort np) {
            Map<ArcProto, PrimitivePort> arcMap = this.connectionMap.get(ap1);
            if (arcMap == null) {
                arcMap = new HashMap<ArcProto, PrimitivePort>();
                this.connectionMap.put(ap1, arcMap);
            }
            if (arcMap.get(ap2) == null) {
                PrimitivePort pp = User.getUserTool().getCurrentContactPortProto(ap1, ap2);
                if (pp == null) {
                    System.out.println("NULL PORT CONNECTING " + ap1.describe() + " AND " + ap2.describe());
                }
                arcMap.put(ap2, pp);
            }
        }

        private int findOtherPathToArc(PortProto pp, ArcProto sourceAp, ArcProto destAp, int depth, Set<ArcProto> markedArcs) {
            if (pp.connectsTo(destAp)) {
                return depth;
            }
            PrimitiveNode bestNp = null;
            ArcProto bestAp = null;
            int bestDepth = 0;
            Map<ArcProto, PrimitivePort> arcMap = this.connectionMap.get(sourceAp);
            for (ArcProto nextAp : arcMap.keySet()) {
                PortProto nextPp;
                if (markedArcs.contains(nextAp) || (nextPp = (PortProto)arcMap.get(nextAp)) == null) continue;
                PrimitiveNode nextNp = (PrimitiveNode)nextPp.getParent();
                this.contactStack[depth] = nextNp;
                markedArcs.add(nextAp);
                int newDepth = this.findOtherPathToArc(nextPp, nextAp, destAp, depth + 1, markedArcs);
                markedArcs.remove(nextAp);
                if (newDepth < 0 || bestNp != null && newDepth >= bestDepth) continue;
                bestDepth = newDepth;
                bestNp = nextNp;
                bestAp = nextAp;
            }
            if (bestNp != null) {
                this.contactStack[depth] = bestNp;
                this.contactStackArc[depth] = sourceAp;
                markedArcs.add(bestAp);
                int newDepth = this.findOtherPathToArc(bestNp.getPort(0), bestAp, destAp, depth + 1, markedArcs);
                markedArcs.remove(bestAp);
                return newDepth;
            }
            return -1;
        }
    }
}

