/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.launcher;

import com.sun.electric.api.minarea.LayoutCell;
import com.sun.electric.api.minarea.MinAreaChecker;
import com.sun.electric.api.minarea.errorLogging.AbstractErrorLogger;
import com.sun.electric.api.minarea.errorLogging.ErrorLoggerFactory;
import com.sun.electric.api.minarea.launcher.ElapseTimer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;

public class Launcher {
    private static void help() {
        System.out.println("Usage: file.lay minarea CheckerAlgorithm errorLogger [algorithm.properties]");
        System.out.println("    file.lay             - file with serialized layout");
        System.out.println("    minarea              - minarea threashold");
        System.out.println("    checkerAlgorithm     - class that implements com.sun.electric.api.minarea.MinAreaChecker");
        System.out.println("    errorLogger          - error logger type: {stdout, electric, csv}");
        System.out.println("    algorithm.properties - optional file with algorithm properties");
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            Launcher.help();
            System.exit(0);
        }
        String layoutFileName = args[0];
        long minarea = Long.valueOf(args[1]);
        String className = args[2];
        ErrorLoggerFactory.LoggerTypes errorLoggerType = ErrorLoggerFactory.LoggerTypes.valueOf(args[3]);
        String algorithmPropertiesFileName = args.length > 4 ? args[4] : null;
        try {
            InputStream is;
            File layoutFile = new File(layoutFileName);
            if (layoutFile.canRead()) {
                is = new FileInputStream(layoutFileName);
                System.out.println("file " + layoutFileName);
            } else {
                is = Launcher.class.getResourceAsStream(layoutFileName);
                System.out.println("resource " + layoutFileName);
            }
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(is));
            LayoutCell topCell = (LayoutCell)in.readObject();
            in.close();
            Class<?> algorithmClass = Class.forName(className);
            MinAreaChecker checker = (MinAreaChecker)algorithmClass.newInstance();
            System.out.println("topCell " + topCell.getName() + " [" + topCell.getBoundingMinX() + ".." + topCell.getBoundingMaxX() + "]x[" + topCell.getBoundingMinY() + ".." + topCell.getBoundingMaxY() + "] minarea=" + minarea);
            Properties parameters = checker.getDefaultParameters();
            if (algorithmPropertiesFileName != null) {
                FileInputStream propertiesIn = new FileInputStream(algorithmPropertiesFileName);
                parameters.load(propertiesIn);
                ((InputStream)propertiesIn).close();
            }
            AbstractErrorLogger logger = ErrorLoggerFactory.createErrorLogger(errorLoggerType, topCell.getName());
            System.out.println("algorithm " + checker.getAlgorithmName() + " parameters:" + parameters + " errorLogger:" + (Object)((Object)errorLoggerType));
            ElapseTimer timer = ElapseTimer.createInstance().start();
            checker.check(topCell, minarea, parameters, logger);
            timer.end();
            logger.printReports(timer.getTime());
            System.out.println("Elapsed time for min-area checking: " + timer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static String getPID() throws IOException {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }
}

