/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.Topology;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.WindowMenu;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.ExplorerTreeModel;
import com.sun.electric.tool.user.ui.ExternalEditing;
import com.sun.electric.tool.user.ui.LayerTab;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.math.FixpTransform;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class WindowFrame
extends Observable {
    private static final int WINDOW_OFFSET = 0;
    private WindowContent content;
    private JSplitPane js;
    private JInternalFrame jif = null;
    private TopLevel jf = null;
    private InternalWindowsEvents internalWindowsEvents;
    private WindowsEvents windowsEvents;
    private JTabbedPane sideBar;
    private boolean sideBarOnLeft;
    private ExplorerTree explorerTab;
    private PaletteFrame paletteTab;
    private LayerTab layersTab;
    private boolean finished = false;
    private int index = windowIndexCounter++;
    private int usageClock;
    private JMenu dynamicMenu;
    private static int usageCounter = 0;
    private static int windowIndexCounter = 0;
    private static int windowOffset = 0;
    private static List<WindowFrame> windowList = new ArrayList<WindowFrame>();
    private static WindowFrame curWindowFrame = null;
    private static ElectricEventListener curListener = null;
    private List<CellHistory> cellHistory = new ArrayList<CellHistory>();
    private int cellHistoryLocation = -1;
    private static final int cellHistoryLimit = 20;

    public static void showFrame(WindowFrame wf) {
        if (TopLevel.isMDIMode()) {
            JInternalFrame jif = wf.getInternalFrame();
            try {
                jif.setIcon(false);
                jif.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!jif.isVisible()) {
                jif.toFront();
                TopLevel.addToDesktop(jif);
            } else {
                jif.toFront();
            }
        } else {
            TopLevel jf = wf.getFrame();
            jf.setState(0);
            if (!jf.isVisible()) {
                jf.toFront();
                jf.setVisible(true);
            } else {
                jf.toFront();
            }
        }
    }

    public static void repaintAllWindows() {
        WindowFrame wf;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            wf = it.next();
            WindowContent content = wf.getContent();
            content.fullRepaint();
        }
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            wf = it.next();
            wf.loadComponentMenuForTechnology();
        }
        PreferencesFrame.updateLayerPreferencesColors();
    }

    public void setDynamicMenu(JMenu menu) {
        this.dynamicMenu = menu;
    }

    public JMenu getDynamicMenu() {
        return this.dynamicMenu;
    }

    public static WindowFrame createEditWindow(final Cell cell) {
        final WindowFrame frame = new WindowFrame();
        if (cell != null && cell.getView().isTextView()) {
            TextWindow tWnd = new TextWindow(cell, frame);
            frame.finishWindowFrameInformation(tWnd, cell);
            tWnd.fillScreen();
        } else {
            EditWindow eWnd = EditWindow.CreateElectricDoc(cell, frame, null);
            frame.finishWindowFrameInformation(eWnd, cell);
            eWnd.fillScreen();
            eWnd.fullRepaint();
        }
        WindowFrame.removeUIBinding(frame.js, KeyStroke.getKeyStroke(117, 0));
        WindowFrame.removeUIBinding(frame.js, KeyStroke.getKeyStroke(119, 0));
        if (cell != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.explorerTab.openLibraryInExplorerTree(cell.getLibrary(), cell, true);
                }
            });
        }
        return frame;
    }

    public int getIndex() {
        return this.index;
    }

    public static WindowFrame findFromIndex(int index) {
        for (WindowFrame wf : windowList) {
            if (wf.index != index) continue;
            return wf;
        }
        return null;
    }

    public void finishWindowFrameInformation(WindowContent wnd, Cell cell) {
        this.buildWindowStructure(wnd, cell, null);
        WindowFrame.setCurrentWindowFrame(this, true);
        this.populateJFrame();
        WindowMenu.setDynamicMenus();
    }

    public static void show3DHighlight() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.setChanged();
            wf.notifyObservers(wf.getContent());
            wf.clearChanged();
        }
    }

    public void set3DLayerVisibility(LayerVisibility lv) {
        this.setChanged();
        this.notifyObservers(lv);
        this.clearChanged();
    }

    public static WindowFrame createWaveformWindow(Stimuli sd) {
        WindowFrame frame = new WindowFrame();
        WaveformWindow wWnd = new WaveformWindow(sd, frame);
        frame.finishWindowFrameInformation(wWnd, sd.getCell());
        wWnd.fillScreen();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowFrame.wantToOpenCurrentLibrary(false, null);
            }
        });
        return frame;
    }

    public static void updateTechnologyLists() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.layersTab.loadTechnologies(false);
            wf.paletteTab.loadTechnologies(false);
            wf.getContent().loadTechnologies();
        }
    }

    public List<MutableTreeNode> loadDefaultExplorerTree() {
        DefaultMutableTreeNode libraryExplorerNode = ExplorerTreeModel.makeLibraryTree();
        return Collections.singletonList(libraryExplorerNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension buildWindowStructure(WindowContent content, Cell cell, GraphicsConfiguration gc) {
        this.content = content;
        this.explorerTab = new ExplorerTree(content.loadExplorerTrees());
        JScrollPane scrolledTree = new JScrollPane(this.explorerTab);
        this.sideBar = new JTabbedPane();
        if (ClientOS.isOSMac()) {
            this.sideBar.setTabPlacement(2);
        }
        this.paletteTab = PaletteFrame.newInstance(this);
        this.layersTab = new LayerTab(this);
        this.loadComponentMenuForTechnology();
        this.sideBar.add("Components", this.paletteTab.getMainPanel());
        this.sideBar.add("Explorer", scrolledTree);
        this.sideBar.add("Layers", this.layersTab);
        this.sideBar.setSelectedIndex(User.getDefaultWindowTab());
        this.sideBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane tp = (JTabbedPane)evt.getSource();
                User.setDefaultWindowTab(tp.getSelectedIndex());
            }
        });
        String cellDescription = cell == null ? "no cell" : cell.describe(false);
        Dimension sz = this.createJFrame(cellDescription, gc);
        if ((windowOffset += 70) > 300) {
            windowOffset = 0;
        }
        this.js = new JSplitPane(1);
        this.sideBarOnLeft = !User.isSideBarOnRight();
        JComponent panel = content.getPanel();
        if (User.isDockMessagesWindow()) {
            JSplitPane js2 = new JSplitPane(0);
            js2.setTopComponent(panel);
            js2.setBottomComponent(new MessagesWindow().getContent());
            js2.setDividerLocation(js2.getMaximumDividerLocation());
            panel = js2;
        }
        if (this.sideBarOnLeft) {
            this.js.setLeftComponent(this.sideBar);
            this.js.setRightComponent(panel);
            this.js.setDividerLocation(200);
        } else {
            this.js.setLeftComponent(panel);
            this.js.setRightComponent(this.sideBar);
            this.js.setDividerLocation(sz.width - 200);
        }
        List<WindowFrame> list = windowList;
        synchronized (list) {
            windowList.add(this);
        }
        return sz;
    }

    private Dimension createJFrame(String title, GraphicsConfiguration gc) {
        Dimension scrnSize = TopLevel.getScreenSize();
        Dimension frameSize = new Dimension(scrnSize.width * 4 / 5, scrnSize.height * 6 / 8);
        if (TopLevel.isMDIMode()) {
            this.jif = new JInternalFrame(title, true, true, true, true);
            this.jif.setSize(frameSize);
            this.jif.setLocation(windowOffset + 0, windowOffset);
            this.jif.setAutoscrolls(true);
            this.jif.setFrameIcon(TopLevel.getFrameIcon());
        } else {
            this.jf = new TopLevel("Electric - " + title, new Rectangle(frameSize), this, gc, true);
            Dimension preferredSize = User.getDefaultWindowSize();
            if (preferredSize != null) {
                frameSize = preferredSize;
            }
            this.jf.setSize(frameSize);
            Point preferredLoc = User.getDefaultWindowPos();
            this.jf.setLocation(windowOffset + 0 + preferredLoc.x, windowOffset + preferredLoc.y);
        }
        return frameSize;
    }

    public void loadComponentMenuForTechnology() {
        Technology tech = Technology.getCurrent();
        if (this.content.getCell() != null) {
            tech = this.content.getCell().getTechnology();
        }
        this.paletteTab.loadForTechnology(tech, this);
        this.layersTab.updateLayersTab();
    }

    private void populateJFrame() {
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().add(this.js);
            this.internalWindowsEvents = new InternalWindowsEvents(this);
            this.jif.addInternalFrameListener(this.internalWindowsEvents);
            TopLevel.addToDesktop(this.jif);
        } else {
            this.jf.getContentPane().add(this.js);
            this.windowsEvents = new WindowsEvents(this);
            this.jf.addWindowListener(this.windowsEvents);
            this.jf.addWindowFocusListener(this.windowsEvents);
            this.jf.setVisible(true);
        }
    }

    public Component getComponent() {
        if (TopLevel.isMDIMode()) {
            return this.jif;
        }
        return this.jf;
    }

    public int getUsageClock() {
        return this.usageClock;
    }

    private void depopulateJFrame() {
        assert (SwingUtilities.isEventDispatchThread());
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().remove(this.js);
            this.jif.removeInternalFrameListener(this.internalWindowsEvents);
            TopLevel.removeFromDesktop(this.jif);
        } else {
            this.jf.getContentPane().remove(this.js);
            this.jf.removeWindowListener(this.windowsEvents);
            this.jf.removeWindowFocusListener(this.windowsEvents);
        }
    }

    public void setCellWindow(Cell cell, CellHistory history) {
        if (cell != null && cell.getView().isTextView()) {
            if (!(this.getContent() instanceof TextWindow)) {
                this.getContent().finished();
                this.content = new TextWindow(cell, this);
                int i = this.js.getDividerLocation();
                if (this.sideBarOnLeft) {
                    this.js.setRightComponent(this.content.getPanel());
                } else {
                    this.js.setLeftComponent(this.content.getPanel());
                }
                this.js.setDividerLocation(i);
                this.content.fillScreen();
                if (history == null) {
                    this.addToHistory(cell, VarContext.globalContext, null);
                }
                this.currentCellChanged(true);
                return;
            }
        } else if (!(this.getContent() instanceof EditWindow)) {
            this.getContent().finished();
            Component c = this.js.getLeftComponent();
            if (this.sideBarOnLeft) {
                c = this.js.getRightComponent();
            }
            Dimension sz = c.getSize();
            this.content = EditWindow.CreateElectricDoc(cell, this, sz);
            int i = this.js.getDividerLocation();
            if (this.sideBarOnLeft) {
                this.js.setRightComponent(this.content.getPanel());
            } else {
                this.js.setLeftComponent(this.content.getPanel());
            }
            this.js.setDividerLocation(i);
            this.content.fillScreen();
            if (history == null) {
                this.addToHistory(cell, VarContext.globalContext, null);
            }
            this.currentCellChanged(true);
            this.loadComponentMenuForTechnology();
            return;
        }
        DisplayAttributes da = null;
        VarContext upperContext = VarContext.globalContext;
        if (history != null) {
            da = history.da;
            upperContext = history.context;
        }
        this.content.setCell(cell, upperContext, da);
        this.currentCellChanged(true);
        this.loadComponentMenuForTechnology();
        WindowMenu.setDynamicMenus();
        if (history == null) {
            this.addToHistory(cell, VarContext.globalContext, null);
        }
    }

    public void moveEditWindow(GraphicsConfiguration gc) {
        if (TopLevel.isMDIMode()) {
            return;
        }
        this.jf.setVisible(false);
        this.depopulateJFrame();
        TopLevel oldFrame = this.jf;
        Cell cell = this.content.getCell();
        String cellDescription = cell == null ? "no cell" : cell.describe(false);
        this.createJFrame(cellDescription, gc);
        this.populateJFrame();
        this.fireCellHistoryStatus();
        oldFrame.finished();
    }

    public static void wantToOpenCurrentLibrary(boolean openLib, Cell cell) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.explorerTab.openLibraryInExplorerTree(Library.getCurrent(), cell, openLib);
        }
    }

    public static void wantToRedoLibraryTree() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.explorerTab.redoContentTrees(wf.content.loadExplorerTrees());
        }
    }

    public void wantToRedoSignalTree() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowFrame.this.wantToRedoSignalTree();
                }
            });
            return;
        }
        if (this.explorerTab != null) {
            this.explorerTab.redoContentTrees(this.content.loadExplorerTrees());
        }
    }

    public static void setSideBarLocation(boolean onLeft) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf.sideBarOnLeft == onLeft) {
            return;
        }
        wf.sideBarOnLeft = onLeft;
        wf.js.setLeftComponent(null);
        wf.js.setRightComponent(null);
        Dimension sz = wf.js.getSize();
        int loc = sz.width - wf.js.getDividerLocation();
        wf.js.setDividerLocation(loc);
        if (onLeft) {
            wf.js.setLeftComponent(wf.sideBar);
            wf.js.setRightComponent(wf.content.getPanel());
        } else {
            wf.js.setLeftComponent(wf.content.getPanel());
            wf.js.setRightComponent(wf.sideBar);
        }
    }

    public WindowContent getContent() {
        return this.content;
    }

    public static WindowFrame getCurrentWindowFrame() {
        return WindowFrame.getCurrentWindowFrame(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowFrame getCurrentWindowFrame(boolean makeNewFrame) {
        List<WindowFrame> list = windowList;
        synchronized (list) {
            if (curWindowFrame == null && makeNewFrame) {
                Iterator<WindowFrame> i$ = windowList.iterator();
                while (i$.hasNext()) {
                    WindowFrame wf;
                    curWindowFrame = wf = i$.next();
                }
                if (curWindowFrame == null) {
                    curWindowFrame = WindowFrame.createEditWindow(null);
                }
            }
            return curWindowFrame;
        }
    }

    public static void setListener(ElectricEventListener listener) {
        curListener = listener;
    }

    public static ElectricEventListener getListener() {
        if (curListener == null) {
            curListener = ClickZoomWireListener.theOne;
        }
        return curListener;
    }

    public static MouseListener getMouseListener() {
        return WindowFrame.getListener();
    }

    public static MouseMotionListener getMouseMotionListenerListener() {
        return WindowFrame.getListener();
    }

    public static MouseWheelListener getMouseWheelListenerListener() {
        return WindowFrame.getListener();
    }

    public static KeyListener getKeyListenerListener() {
        return WindowFrame.getListener();
    }

    public static Cell getCurrentCell() {
        assert (SwingUtilities.isEventDispatchThread());
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf == null) {
            return null;
        }
        return wf.getContent().getCell();
    }

    public static Cell needCurCell() {
        Cell curCell = WindowFrame.getCurrentCell();
        if (curCell == null) {
            System.out.println("There is no current cell for this operation.  To create one, use the 'New Cell' command from the 'Cell' menu.");
        }
        return curCell;
    }

    public void setCursor(Cursor cursor) {
        if (!TopLevel.isMDIMode()) {
            this.jf.setCursor(cursor);
        }
        this.js.setCursor(cursor);
        this.content.setCursor(cursor);
    }

    public static void removeLibraryReferences(Library lib) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            Cell cell = content.getCell();
            if (cell != null && cell.getLibrary() == lib) {
                content.setCell(null, null, null);
            }
            content.fullRepaint();
        }
    }

    public void requestFocus() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowFrame.this.requestFocusUnsafe();
                }
            });
            return;
        }
        this.requestFocusUnsafe();
    }

    private void requestFocusUnsafe() {
        if (this.jif != null) {
            this.jif.toFront();
            try {
                this.jif.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (this.jf != null) {
            this.jf.toFront();
            this.jf.requestFocus();
        }
    }

    public boolean isFocusOwner() {
        if (this.jif != null) {
            return this.jif.isSelected();
        }
        if (this.jf != null) {
            return this.jf.isFocusOwner();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCurrentWindowFrame(WindowFrame wf, boolean autoSwitchTech) {
        List<WindowFrame> list = windowList;
        synchronized (list) {
            if (wf.finished) {
                return;
            }
            curWindowFrame = wf;
            windowList.remove(wf);
            windowList.add(wf);
        }
        if (wf != null) {
            Highlighter highlighter;
            wf.currentCellChanged(autoSwitchTech);
            if (wf.getContent() != null && (highlighter = wf.getContent().getHighlighter()) != null) {
                highlighter.gainedFocus();
            }
        }
        WindowFrame.wantToRedoTitleNames();
    }

    private void currentCellChanged(boolean autoSwitchTech) {
        if (this != WindowFrame.getCurrentWindowFrame(false)) {
            return;
        }
        Cell cell = this.getContent().getCell();
        if (cell != null) {
            cell.getLibrary().setCurCell(cell);
            if (autoSwitchTech) {
                WindowFrame.autoTechnologySwitch(cell, this);
            }
        }
    }

    public static void wantToRedoTitleNames() {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame w = it.next();
            WindowContent content = w.getContent();
            if (content == null) continue;
            content.setWindowTitle();
        }
        WindowMenu.setDynamicMenus();
    }

    public void setWindowSize(Rectangle frameRect) {
        Dimension frameSize = new Dimension(frameRect.width, frameRect.height);
        if (TopLevel.isMDIMode()) {
            this.jif.setSize(frameSize);
            this.jif.setLocation(frameRect.x, frameRect.y);
        } else {
            this.jf.setSize(frameSize);
            this.jf.setLocation(frameRect.x, frameRect.y);
            this.jf.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        assert (SwingUtilities.isEventDispatchThread());
        if (TopLevel.isMDIMode()) {
            this.jif.setVisible(false);
            this.jif.dispose();
        }
        List<WindowFrame> list = windowList;
        synchronized (list) {
            if (windowList.size() <= 1 && !TopLevel.isMDIMode()) {
                FileMenu.quitCommand();
                return;
            }
            windowList.remove(this);
            this.finished = true;
            if (curWindowFrame == this) {
                curWindowFrame = null;
            }
        }
        this.content.finished();
        this.explorerTab.setModel(null);
        WindowMenu.setDynamicMenus();
        this.layersTab.finished();
        this.depopulateJFrame();
        if (!TopLevel.isMDIMode()) {
            this.jf.finished();
        }
    }

    public WaveformWindow getWaveformWindow() {
        return (WaveformWindow)this.content;
    }

    public ExplorerTree getExplorerTab() {
        return this.explorerTab;
    }

    public PaletteFrame getPaletteTab() {
        return this.paletteTab;
    }

    public LayerTab getLayersTab() {
        return this.layersTab;
    }

    public TopLevel getFrame() {
        if (TopLevel.isMDIMode()) {
            return TopLevel.getCurrentJFrame();
        }
        return this.jf;
    }

    public JInternalFrame getInternalFrame() {
        if (TopLevel.isMDIMode()) {
            return this.jif;
        }
        return null;
    }

    public boolean generatedEvent(AWTEvent e) {
        if (e instanceof InternalFrameEvent) {
            JInternalFrame source = ((InternalFrameEvent)e).getInternalFrame();
            return source == this.jif;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumWindows() {
        List<WindowFrame> list = windowList;
        synchronized (list) {
            return windowList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<WindowFrame> getWindows() {
        ArrayList<WindowFrame> listCopy = new ArrayList<WindowFrame>();
        List<WindowFrame> list = windowList;
        synchronized (list) {
            listCopy.addAll(windowList);
        }
        return listCopy.iterator();
    }

    public String composeTitle(Cell cell, String prefix, int pageNo) {
        StringBuffer title = new StringBuffer();
        if (cell != null && cell.isLinked()) {
            title.append(prefix + cell.libDescribe());
            if (cell.isMultiPage()) {
                title.append(" - Page " + (pageNo + 1));
            }
            Library curLib = Library.getCurrent();
            if (cell.getLibrary() != curLib && curLib != null) {
                title.append(" - Current library: " + curLib.getName());
            }
        } else {
            title.append("***NONE***");
        }
        return title.toString();
    }

    public void setTitle(String title) {
        String curTitle = this.getTitle();
        if (title.equals(curTitle)) {
            return;
        }
        if (TopLevel.isMDIMode()) {
            if (this.jif != null) {
                this.jif.setTitle(title);
            }
        } else if (this.jf != null) {
            this.jf.setTitle(title);
        }
    }

    public String getTitle() {
        if (TopLevel.isMDIMode()) {
            if (this.jif != null) {
                return this.jif.getTitle();
            }
        } else if (this.jf != null) {
            return this.jf.getTitle();
        }
        return "";
    }

    private static void removeUIBinding(JComponent comp, KeyStroke key) {
        WindowFrame.removeUIBinding(comp.getInputMap(1), key);
        WindowFrame.removeUIBinding(comp.getInputMap(0), key);
        WindowFrame.removeUIBinding(comp.getInputMap(2), key);
    }

    private static void removeUIBinding(InputMap map2, KeyStroke key) {
        if (map2 == null) {
            return;
        }
        map2.remove(key);
        WindowFrame.removeUIBinding(map2.getParent(), key);
    }

    public static void autoTechnologySwitch(Cell cell, WindowFrame wf) {
        if (cell.getView().isTextView()) {
            return;
        }
        Technology tech = cell.getTechnology();
        if (tech != null && tech != Technology.getCurrent() && User.isAutoTechnologySwitch()) {
            Job.getExtendedUserInterface().setCurrentTechnology(tech);
            wf.getPaletteTab().loadForTechnology(tech, wf);
            wf.getLayersTab().updateLayersTab();
        }
    }

    public List<CellHistory> getCellHistoryList() {
        return this.cellHistory;
    }

    public int getCellHistoryLocation() {
        return this.cellHistoryLocation;
    }

    public void cellHistoryGoBack() {
        if (this.cellHistoryLocation <= 0) {
            return;
        }
        this.setCellByHistory(this.cellHistoryLocation - 1);
    }

    public void cellHistoryGoForward() {
        if (this.cellHistoryLocation >= this.cellHistory.size() - 1) {
            return;
        }
        this.setCellByHistory(this.cellHistoryLocation + 1);
    }

    private boolean cellHistoryCanGoBack() {
        return this.cellHistoryLocation > 0;
    }

    private boolean cellHistoryCanGoForward() {
        return this.cellHistoryLocation < this.cellHistory.size() - 1;
    }

    private void fireCellHistoryStatus() {
        ToolBar toolBar = this.getToolBar();
        if (toolBar == null) {
            return;
        }
        toolBar.updateCellHistoryStatus(this.cellHistoryCanGoBack(), this.cellHistoryCanGoForward());
    }

    private ToolBar getToolBar() {
        TopLevel topLevel = this.getFrame();
        return topLevel != null ? topLevel.getToolBar() : null;
    }

    public void addToHistory(Cell cell, VarContext context, DisplayAttributes da) {
        if (cell == null) {
            return;
        }
        CellHistory history = new CellHistory();
        history.cell = cell;
        history.context = context;
        if (da == null) {
            da = new DisplayAttributes();
        }
        history.da = da;
        if (this.cellHistoryLocation < this.cellHistory.size() - 1) {
            for (int i = this.cellHistory.size() - 1; i > this.cellHistoryLocation; --i) {
                this.cellHistory.remove(i);
            }
        }
        this.cellHistory.add(history);
        this.cellHistoryLocation = this.cellHistory.size() - 1;
        if (this.cellHistoryLocation > 20) {
            this.cellHistory.remove(0);
            --this.cellHistoryLocation;
        }
        this.fireCellHistoryStatus();
    }

    public void saveCurrentCellHistoryState() {
        if (this.cellHistoryLocation < 0) {
            return;
        }
        if (this.content instanceof EditWindow) {
            ElectricObject eobj;
            Highlight h;
            EditWindow wnd = (EditWindow)this.content;
            CellHistory current = this.cellHistory.get(this.cellHistoryLocation);
            current.context = wnd.getVarContext();
            current.da = new DisplayAttributes(wnd);
            current.selPort = null;
            Highlighter highlighter = wnd.getHighlighter();
            if (highlighter.getNumHighlights() == 1 && (h = highlighter.getOneHighlight()) != null && (eobj = h.getElectricObject()) instanceof PortInst) {
                current.selPort = (PortInst)eobj;
            }
            current.highlights = new ArrayList();
            Cell cell = this.content.getCell();
            for (Highlight h2 : highlighter.getHighlights()) {
                if (h2.getCell() != cell) continue;
                current.highlights.add(h2);
            }
            Point2D off = highlighter.getHighlightOffset();
            if (off != null) {
                current.offX = off.getX();
                current.offY = off.getY();
            }
        }
    }

    public void setCellByHistory(int location) {
        CellHistory history = this.cellHistory.get(location);
        if (history.cell == null || !history.cell.isLinked()) {
            history.cell = null;
            history.context = VarContext.globalContext;
            history.selPort = null;
            history.da = new DisplayAttributes();
            history.highlights = new ArrayList();
            history.offX = (history.offY = 0.0);
        }
        this.setCellWindow(history.cell, history);
        if (history.cell != null && !history.cell.getView().isTextView()) {
            EditWindow wnd = (EditWindow)this.content;
            if (history.selPort != null) {
                wnd.getHighlighter().clear();
                wnd.getHighlighter().addElectricObject(history.selPort, history.cell);
            } else if (history.highlights != null) {
                wnd.getHighlighter().setHighlightList(history.highlights);
                wnd.getHighlighter().setHighlightOffset((int)history.offX, (int)history.offY);
            }
        }
        this.content.fullRepaint();
        this.cellHistoryLocation = location;
        this.fireCellHistoryStatus();
    }

    public int findCellHistoryIndex(Cell cell, VarContext context) {
        for (int i = this.cellHistory.size() - 1; i > -1; --i) {
            CellHistory history = this.cellHistory.get(i);
            if (history.cell != cell || !history.context.equals(context)) continue;
            return i;
        }
        return -1;
    }

    public static void showCellHistoryStats() {
        HashSet<Topology> topologySet = new HashSet<Topology>();
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            for (CellHistory ch : wf.cellHistory) {
                if (ch.selPort != null) {
                    topologySet.add(ch.selPort.getNodeInst().getTopology());
                }
                for (VarContext varContext = ch.context; varContext != null && varContext != VarContext.globalContext; varContext = varContext.pop()) {
                    Nodable no = varContext.getNodableOptional();
                    if (no == null) continue;
                    topologySet.add(no.getNodeInst().getTopology());
                }
                if (ch.highlights == null) continue;
                for (Highlight h : ch.highlights) {
                    ElectricObject eobj = h.getElectricObject();
                    if (eobj instanceof ArcInst) {
                        topologySet.add(((ArcInst)eobj).getTopology());
                        continue;
                    }
                    if (eobj instanceof NodeInst) {
                        topologySet.add(((NodeInst)eobj).getTopology());
                        continue;
                    }
                    if (!(eobj instanceof PortInst)) continue;
                    topologySet.add(((PortInst)eobj).getNodeInst().getTopology());
                }
            }
        }
        System.out.println("Topologies:");
        for (Topology topology : topologySet) {
            System.out.println("  " + topology.getCell());
        }
    }

    static {
        new LibraryTreeUpdater();
    }

    private static class LibraryTreeUpdater
    implements DatabaseChangeListener {
        private LibraryTreeUpdater() {
            UserInterfaceMain.addDatabaseChangeListener(this);
        }

        @Override
        public void databaseChanged(DatabaseChangeEvent e) {
            if (e.cellTreeChanged()) {
                WindowFrame.wantToRedoLibraryTree();
            }
            if (curListener != null) {
                curListener.databaseChanged(e);
            }
        }
    }

    private class InternalWindowsEvents
    extends InternalFrameAdapter {
        WeakReference<WindowFrame> wf;

        InternalWindowsEvents(WindowFrame wf) {
            this.wf = new WeakReference<WindowFrame>(wf);
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent evt) {
            ((WindowFrame)this.wf.get()).finished();
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent evt) {
            WindowFrame realWF = (WindowFrame)this.wf.get();
            realWF.usageClock = usageCounter++;
            WindowFrame.setCurrentWindowFrame(realWF, false);
            realWF.fireCellHistoryStatus();
        }
    }

    private class WindowsEvents
    extends WindowAdapter {
        WeakReference<WindowFrame> wf;

        WindowsEvents(WindowFrame wf) {
            this.wf = new WeakReference<WindowFrame>(wf);
        }

        @Override
        public void windowActivated(WindowEvent evt) {
            WindowFrame realWF = (WindowFrame)this.wf.get();
            realWF.usageClock = usageCounter++;
            WindowFrame.setCurrentWindowFrame(realWF, false);
            realWF.fireCellHistoryStatus();
            ExternalEditing.updateEditors();
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            ((WindowFrame)this.wf.get()).finished();
        }
    }

    public static class CellHistory {
        private Cell cell;
        private VarContext context;
        private PortInst selPort;
        private DisplayAttributes da;
        private List<Highlight> highlights;
        private double offX;
        private double offY;

        public Cell getCell() {
            return this.cell;
        }

        public VarContext getContext() {
            return this.context;
        }

        public void setContext(VarContext context) {
            this.context = context;
        }

        public void setSelPort(PortInst selPort) {
            this.selPort = selPort;
        }

        public DisplayAttributes getDisplayAttributes() {
            return this.da;
        }

        public void setDisplayAttributes(DisplayAttributes da) {
            this.da = da;
        }
    }

    public static interface ElectricEventListener
    extends MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    KeyListener,
    DatabaseChangeListener {
    }

    public static class CurTechControlListener
    implements ActionListener {
        private WindowFrame wf;

        CurTechControlListener(WindowFrame wf) {
            this.wf = wf;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JComboBox source = (JComboBox)evt.getSource();
            String techName = (String)source.getSelectedItem();
            Technology tech = Technology.findTechnology(techName);
            if (tech != null) {
                Job.getExtendedUserInterface().setCurrentTechnology(tech);
                this.wf.getPaletteTab().loadForTechnology(tech, this.wf);
                this.wf.getLayersTab().updateLayersTab();
                WindowContent content = this.wf.getContent();
                if (content != null) {
                    content.fullRepaint();
                }
            }
        }
    }

    public static class DisplayAttributes {
        public final double scale;
        public final double offX;
        public final double offY;
        public final List<NodeInst> inPlaceDescent;

        public DisplayAttributes() {
            this(1.0, 0.0, 0.0, Collections.emptyList());
        }

        public DisplayAttributes(EditWindow wnd) {
            this(wnd.getScale(), wnd.getOffset().getX(), wnd.getOffset().getY(), wnd.getInPlaceEditNodePath());
        }

        public DisplayAttributes(double scale, double offX, double offY, List<NodeInst> inPlaceDescent) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.inPlaceDescent = new ArrayList<NodeInst>(inPlaceDescent);
        }

        public FixpTransform getIntoCellTransform() {
            FixpTransform intoCell = new FixpTransform();
            for (NodeInst ni : this.inPlaceDescent) {
                intoCell.preConcatenate(ni.rotateIn(ni.translateIn()));
            }
            return intoCell;
        }

        public FixpTransform getOutofCellTransform() {
            FixpTransform outofCell = new FixpTransform();
            for (NodeInst ni : this.inPlaceDescent) {
                outofCell.concatenate(ni.translateOut(ni.rotateOut()));
            }
            return outofCell;
        }

        public boolean equals(Object o) {
            if (o instanceof DisplayAttributes) {
                DisplayAttributes that = (DisplayAttributes)o;
                return this.scale == that.scale && this.offX == that.offX && this.offY == that.offY && this.inPlaceDescent.equals(that.inPlaceDescent);
            }
            return false;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (int)(Double.doubleToLongBits(this.scale) ^ Double.doubleToLongBits(this.scale) >>> 32);
            hash = 53 * hash + (int)(Double.doubleToLongBits(this.offX) ^ Double.doubleToLongBits(this.offX) >>> 32);
            hash = 53 * hash + (int)(Double.doubleToLongBits(this.offY) ^ Double.doubleToLongBits(this.offY) >>> 32);
            return hash;
        }
    }
}

