/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class GratingCoupler
extends PrimitiveNode {
    private static final double BASESIZE = 20.0;
    private static final double DEFDEGREES = 180.0;
    private static final Variable.Key COUPLER_ANGLE = Variable.newKey("SIPHOTONICS_GratingCouplerAngle");
    private PrimitivePort pp;

    public GratingCoupler(Photonics tech, Technology.NodeLayer[] layers) {
        super("Grating-Coupler", tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 20.0, 20.0, ERectangle.fromLambda(-10.0, -10.0, 20.0, 20.0), ERectangle.fromLambda(-10.0, -10.0, 20.0, 20.0), layers);
        new Technology.ExtraField(this, COUPLER_ANGLE, "Angle of Fan");
        this.pp = PrimitivePort.single(this, new ArcProto[]{Photonics.opticalArc}, "g-c", 90, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.c(0.0), EdgeH.c(0.0), EdgeV.c(0.0));
        this.addPrimitivePorts(this.pp);
    }

    @Override
    public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
        double botRadius;
        assert (n.protoId == this.getId());
        double degrees = 180.0;
        Double userDegrees = (Double)n.getVarValue(COUPLER_ANGLE, Double.class);
        if (userDegrees != null) {
            degrees = userDegrees;
        }
        double halfDegrees = degrees / 2.0;
        long radius = (n.size.getFixpY() + Photonics.lambdaToFixp(20.0)) / 2L;
        double botRightAngle = (270.0 + halfDegrees) * Math.PI / 180.0;
        double botLeftAngle = (270.0 - halfDegrees) * Math.PI / 180.0;
        PLayer[] ol = Photonics.getOpticalLayers(false);
        for (int l = 0; l < ol.length; ++l) {
            Layer layer = ol[l].findLayer();
            if (layer == null) continue;
            b.setCurNode(n);
            b.pushPoint(0L, 0L);
            for (int i = 0; i <= 128; ++i) {
                double angle = botLeftAngle + (botRightAngle - botLeftAngle) / 128.0 * (double)i;
                double x = (double)radius * Math.cos(angle);
                double y = (double)radius * Math.sin(angle);
                b.pushPoint(x, y);
            }
            b.pushPoly(Poly.Type.FILLED, layer, null, null);
        }
        PLayer trench = Photonics.photonicsWaveguide;
        Layer trenchLay = trench.findLayer();
        double trenchWidth = trench.getWidth();
        double ringRadius = 0.0;
        long one = Photonics.lambdaToFixp(1.0);
        while (!((botRadius = (ringRadius += trenchWidth * (double)one) + trenchWidth * (double)one) > (double)radius)) {
            double y;
            double x;
            double angle;
            int i;
            b.setCurNode(n);
            for (i = 0; i <= 128; ++i) {
                angle = botLeftAngle + (botRightAngle - botLeftAngle) / 128.0 * (double)i;
                x = ringRadius * Math.cos(angle);
                y = ringRadius * Math.sin(angle);
                b.pushPoint(x, y);
            }
            ringRadius = botRadius;
            for (i = 128; i >= 0; --i) {
                angle = botLeftAngle + (botRightAngle - botLeftAngle) / 128.0 * (double)i;
                x = ringRadius * Math.cos(angle);
                y = ringRadius * Math.sin(angle);
                b.pushPoint(x, y);
            }
            b.pushPoly(Poly.Type.FILLED, trenchLay, null, null);
        }
    }
}

