/* java-chartables.h -- Character tables for java.lang.Character -*- c++ -*-
   Copyright (C) 2002 Free Software Foundation, Inc.
   *** This file is generated by scripts/MakeCharTables.java ***

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

#ifndef __JAVA_CHARTABLES_H__
#define __JAVA_CHARTABLES_H__

// These tables are automatically generated by scripts/MakeCharTables.java.
// This is in turn parsing gnu.java.lang.CharData, which is generated by
// scripts/unicode-muncher.pl.  The Unicode data comes from
// www.unicode.org; this header is based on
// gnu/gcj/convert/UnicodeData-3.0.0.txt. JDK 1.4 uses Unicode version 3.0.0.
// DO NOT EDIT the tables.  Instead, fix the upstream scripts and run
// them again.

// The data is stored in C style arrays of the appropriate CNI types, to
// guarantee that the data is constant and non-relocatable.  The field
// <code>blocks</code> stores the offset of a block of 2<supSHIFT</sup>
// characters within <code>data</code>. The data field, in turn, stores
// information about each character in the low order bits, and an offset
// into the attribute tables <code>upper</code>, <code>lower</code>,
// <code>numValue</code>, and <code>direction</code>.  Notice that the
// attribute tables are much smaller than 0xffff entries; as many characters
// in Unicode share common attributes.  Finally, there is a listing for
// <code>title</code> exceptions (most characters just have the same title
// case as upper case).

// This file should only be included by natCharacter.cc

/**
 * The character shift amount to look up the block offset. In other words,
 * <code>(char) (blocks[ch >> SHIFT] + ch)</code> is the index where
 * <code>ch</code> is described in <code>data</code>.
 */
#define SHIFT 5

/**
 * The mapping of character blocks to their location in <code>data</code>.
 * Each entry has been adjusted so that a modulo 16 sum with the desired
 * character gives the actual index into <code>data</code>.
 */
static const jchar blocks[] = {
    450, 450, 449, 300, 299, 416, 504, 732, 607, 750,
    533, 838, 732, 806, 700, 534, 351, 724, 886, 886,
    886, 873, 65167, 836, 65413, 65381, 64949, 64929, 27, 708,
    28, 71, 65192, 65420, 565, 65279, 26, 65215, 38, 64288,
    65064, 275, 260, 64353, 64346, 267, 265, 254, 65288, 553,
    606, 455, 508, 476, 64582, 553, 65063, 64341, 361, 64456,
    252, 259, 64360, 64328, 64296, 64264, 64232, 64200, 64168, 64136,
    64104, 64072, 101, 80, 171, 313, 65038, 99, 341, 424,
    63081, 297, 296, 63775, 65110, 264, 263, 64192, 64654, 65197,
    198, 64679, 64405, 62589, 159, 64279, 65056, 64808, 64303, 59,
    62393, 65111, 64718, 65467, 62265, 64152, 65419, 65339, 64084, 63459,
    65323, 64215, 64361, 64570, 65253, 62664, 64688, 64136, 64959, 62536,
    65093, 64711, 65103, 63473, 63253, 62184, 64927, 62280, 63850, 64514,
    64919, 62152, 62120, 62649, 62643, 61291, 63594, 63562, 64600, 63498,
    63466, 64527, 63402, 61084, 64400, 63306, 63482, 63242, 63434, 63378,
    62577, 62674, 63282, 63050, 62465, 63053, 61352, 62922, 62890, 60577,
    62825, 62794, 62762, 62730, 62698, 62666, 62634, 62602, 62570, 62538,
    62506, 62474, 62442, 62410, 62378, 62346, 62314, 62282, 62250, 62089,
    63351, 62154, 62122, 63287, 60456, 60424, 60392, 60360, 61930, 62626,
    62789, 60870, 62167, 61770, 59629, 59422, 61674, 62871, 60008, 59976,
    59944, 59912, 59880, 59848, 59816, 59784, 59752, 59720, 59688, 59656,
    59624, 59592, 59560, 59528, 59496, 59464, 59432, 59400, 59368, 59336,
    59304, 59272, 59240, 59208, 59176, 59144, 59112, 59080, 59048, 59016,
    58984, 58952, 58920, 58888, 58856, 58824, 58792, 58760, 58728, 58696,
    58719, 58687, 58655, 58623, 61399, 58559, 58527, 58501, 61319, 61271,
    61271, 61271, 61271, 61255, 57773, 61254, 61254, 61254, 57824, 58333,
    61190, 59865, 60395, 57924, 61140, 61285, 57845, 61253, 61161, 61308,
    61044, 61296, 61309, 61304, 61073, 61395, 61053, 60965, 60967, 61285,
    61405, 61078, 61395, 61409, 61289, 57224, 57192, 57160, 60715, 60733,
    60697, 61212, 61192, 60743, 60733, 60723, 60459, 60427, 60395, 60363,
    60366, 60028, 60265, 60268, 59830, 60171, 60139, 59881, 56488, 56456,
    56424, 56392, 59664, 59939, 60248, 60239, 60229, 60133, 56168, 56136,
    59691, 59659, 59627, 59595, 59563, 59531, 59499, 59467, 55848, 55816,
    55784, 55752, 55720, 55688, 55656, 55624, 55592, 55560, 55528, 55496,
    55464, 55432, 55400, 55368, 55336, 55304, 55272, 55240, 55208, 55176,
    55144, 55112, 55080, 55048, 55016, 54984, 54952, 54920, 54888, 54856,
    54824, 54792, 54760, 54728, 54696, 54664, 54632, 54600, 54568, 54536,
    54504, 54472, 58033, 57995, 57963, 57968, 57899, 57867, 57835, 57803,
    57771, 57739, 57742, 56719, 58280, 57299, 55593, 55562, 58184, 55497,
    55466, 56535, 56498, 54913, 55338, 55306, 57960, 52958, 53608, 53576,
    57622, 57577, 57803, 57527, 57527, 57694, 57111, 57396, 57363, 57331,
    57299, 56940, 57235, 57203, 57173, 57140, 54634, 54602, 54570, 54538,
    54506, 54474, 54442, 54410, 54378, 54346, 54314, 54282, 54250, 54218,
    54186, 54154, 54122, 54090, 54058, 54026, 53994, 53962, 53930, 53898,
    53866, 53834, 53802, 53770, 53738, 53706, 53674, 53642, 53610, 53578,
    53546, 53514, 53482, 53450, 53418, 53386, 53354, 53322, 53290, 53258,
    53226, 53194, 53162, 53130, 53098, 53066, 53034, 53002, 52970, 52938,
    52906, 52874, 52842, 52810, 52778, 52746, 52714, 52682, 52650, 52618,
    52586, 52554, 52522, 52490, 52458, 52426, 52394, 52362, 52330, 52298,
    52266, 52234, 52202, 52170, 52138, 52106, 52074, 52042, 52010, 51978,
    51946, 51914, 51882, 51850, 51818, 51786, 51754, 51722, 51690, 51658,
    51626, 51594, 51562, 51530, 51498, 51466, 51434, 51402, 51370, 51338,
    51306, 51274, 51242, 51210, 51178, 51146, 51114, 51082, 51050, 51018,
    50986, 50954, 50922, 50890, 50858, 50826, 50794, 50762, 50730, 50698,
    50666, 50634, 50602, 50570, 50538, 50506, 50474, 50442, 50410, 50378,
    50346, 50314, 50282, 50250, 50218, 50186, 50154, 50122, 50090, 50058,
    50026, 49994, 49962, 49930, 49898, 49866, 49834, 49802, 49770, 49738,
    49706, 49674, 49642, 49610, 49578, 49546, 49514, 49482, 49450, 49418,
    49386, 49354, 49322, 49290, 49258, 49226, 49194, 49162, 49130, 49098,
    49066, 49034, 49002, 48970, 48938, 48906, 48874, 48842, 48810, 48778,
    48746, 48714, 48682, 48650, 48618, 48586, 48554, 48522, 48490, 48458,
    48426, 48394, 48362, 48330, 48298, 48266, 48234, 48202, 48170, 48138,
    48106, 45792, 46440, 46408, 47978, 47946, 47914, 47882, 47850, 47818,
    47786, 47754, 47722, 47690, 47658, 47626, 47594, 47562, 47530, 47498,
    47466, 47434, 47402, 47370, 47338, 47306, 47274, 47242, 47210, 47178,
    47146, 47114, 47082, 47050, 47018, 46986, 46954, 46922, 46890, 46858,
    46826, 46794, 46762, 46730, 46698, 46666, 46634, 46602, 46570, 46538,
    46506, 46474, 46442, 46410, 46378, 46346, 46314, 46282, 46250, 46218,
    46186, 46154, 46122, 46090, 46058, 46026, 45994, 45962, 45930, 45898,
    45866, 45834, 45802, 45770, 45738, 45706, 45674, 45642, 45610, 45578,
    45546, 45514, 45482, 45450, 45418, 45386, 45354, 45322, 45290, 45258,
    45226, 45194, 45162, 45130, 45098, 45066, 45034, 45002, 44970, 44938,
    44906, 44874, 44842, 44810, 44778, 44746, 44714, 44682, 44650, 44618,
    44586, 44554, 44522, 44490, 44458, 44426, 44394, 44362, 44330, 44298,
    44266, 44234, 44202, 44170, 44138, 44106, 44074, 44042, 44010, 43978,
    43946, 43914, 43882, 43850, 43818, 43786, 43754, 43722, 43690, 43658,
    43626, 43594, 43562, 43530, 43498, 43466, 43434, 43402, 43370, 43338,
    43306, 43274, 43242, 43210, 43178, 43146, 43114, 43082, 43050, 43018,
    42986, 42954, 42922, 42890, 42858, 42826, 42794, 42762, 42730, 42698,
    42666, 42634, 42602, 42570, 42538, 42506, 42474, 42442, 42410, 42378,
    42346, 42314, 42282, 42250, 42218, 42186, 42154, 42122, 42090, 42058,
    42026, 41994, 41962, 41930, 41898, 41866, 41834, 41802, 41770, 41738,
    41706, 41674, 41642, 41610, 41578, 41546, 41514, 41482, 41450, 41418,
    41386, 41354, 41322, 41290, 41258, 41226, 41194, 41162, 41130, 41098,
    41066, 41034, 41002, 40970, 40938, 40906, 40874, 40842, 40810, 40778,
    40746, 40714, 40682, 40650, 40618, 40586, 40554, 40522, 40490, 40458,
    40426, 40394, 40362, 40330, 40298, 40266, 40234, 40202, 40170, 40138,
    40106, 40074, 40042, 40010, 39978, 39946, 39914, 39882, 39850, 39818,
    39786, 39754, 39722, 39690, 39658, 39626, 39594, 39562, 39530, 39498,
    39466, 39434, 39402, 39370, 39338, 39306, 39274, 39242, 39210, 39178,
    39146, 39114, 39082, 39050, 39018, 38986, 38954, 38922, 38890, 38858,
    38826, 38794, 38762, 38730, 38698, 38666, 38634, 38602, 38570, 38538,
    38506, 38474, 38442, 38410, 38378, 38346, 38314, 38282, 38250, 38218,
    38186, 38154, 38122, 38090, 38058, 38026, 37994, 37962, 37930, 37898,
    37866, 37834, 37802, 37770, 37738, 37706, 37674, 37642, 37610, 37578,
    37546, 37514, 37482, 37450, 37418, 37386, 37354, 37322, 37290, 37258,
    37226, 37194, 37162, 37130, 37098, 37066, 37034, 37002, 36970, 36938,
    36906, 36874, 36842, 36810, 36778, 36746, 36714, 36682, 36650, 36618,
    36586, 36554, 36522, 36490, 36458, 36426, 36394, 36362, 36330, 36298,
    36266, 36234, 36202, 36170, 36138, 36106, 36074, 36042, 36010, 35978,
    35946, 35914, 35882, 35850, 35818, 35786, 35754, 35722, 35690, 35658,
    35626, 35594, 35562, 35530, 35498, 35466, 35434, 35402, 35370, 35338,
    35306, 35274, 35242, 35210, 35178, 35146, 35114, 35082, 35050, 35018,
    34986, 34954, 34922, 34890, 34858, 34826, 34794, 34762, 34730, 34698,
    34666, 34634, 34602, 34570, 34538, 34506, 34474, 34442, 34410, 34378,
    34346, 34314, 34282, 34250, 34218, 34186, 34154, 34122, 34090, 34058,
    34026, 33994, 33962, 33930, 33898, 33866, 33834, 33802, 33770, 33738,
    33706, 33674, 33642, 33610, 33578, 33546, 33514, 33482, 33450, 33418,
    33386, 33354, 33322, 33290, 33258, 33226, 33194, 33162, 33130, 33098,
    33066, 33034, 33002, 32970, 32938, 32906, 32874, 32842, 32810, 32778,
    32746, 32714, 32682, 32650, 32618, 32586, 32554, 32522, 32490, 32458,
    32426, 32394, 32362, 32330, 32298, 32266, 32234, 32202, 32170, 32138,
    32106, 32074, 32042, 32010, 31978, 31946, 31914, 31882, 31850, 31818,
    31786, 31754, 31722, 31690, 31658, 31626, 31594, 31562, 31530, 31498,
    31466, 31434, 31402, 31370, 31338, 31306, 31274, 31242, 31210, 31178,
    31146, 31114, 31082, 31050, 31018, 30986, 30954, 30922, 30890, 30858,
    30826, 30794, 30762, 30730, 30698, 30666, 30634, 30602, 30570, 30538,
    30506, 30474, 30442, 30410, 30378, 30346, 30314, 30282, 30250, 30218,
    30186, 30154, 30122, 30090, 30058, 30026, 29994, 29962, 29930, 29898,
    29866, 29834, 29802, 29770, 29738, 29706, 29674, 29642, 29610, 29578,
    29546, 29514, 29482, 29450, 29418, 29386, 29354, 29322, 29290, 29258,
    29226, 29194, 29162, 29130, 29098, 29066, 29034, 29002, 28970, 28938,
    28906, 28874, 28842, 28810, 28778, 28746, 28714, 28682, 28650, 28618,
    28586, 28554, 28522, 28490, 28458, 28426, 28394, 28362, 28330, 28298,
    28266, 28234, 28202, 28170, 28138, 28106, 28074, 28042, 28010, 27978,
    27946, 27914, 27882, 27850, 27818, 27786, 27754, 27722, 27690, 27658,
    27626, 27594, 27562, 27530, 27498, 27466, 27434, 27402, 27370, 27338,
    27306, 27274, 27242, 27210, 27178, 27146, 27114, 24816, 25448, 25416,
    26986, 26954, 26922, 26890, 26858, 26826, 26794, 26762, 26730, 26698,
    26666, 26634, 26602, 26570, 26538, 26506, 26474, 26442, 26410, 26378,
    26346, 26314, 26282, 26250, 26218, 26186, 26154, 26122, 26090, 26058,
    26026, 25994, 25962, 25930, 25898, 25866, 27430, 28129, 28316, 24136,
    24104, 24072, 24040, 24008, 23976, 23944, 23912, 23880, 23848, 23816,
    23784, 23752, 23720, 23688, 23656, 23624, 23592, 23560, 23528, 23496,
    23464, 23432, 23400, 23368, 23336, 23304, 23272, 23240, 23208, 23176,
    23144, 23112, 23080, 23048, 23016, 22984, 22952, 22920, 22888, 22856,
    22824, 22792, 22760, 22728, 22696, 22664, 22632, 22600, 22568, 22536,
    22504, 22472, 22440, 22408, 22376, 22344, 23914, 23882, 23850, 23818,
    23786, 23754, 23722, 23690, 23658, 23626, 23594, 23562, 23530, 23498,
    23466, 23434, 23402, 23370, 23338, 23306, 23274, 23242, 23210, 23178,
    23146, 23114, 23082, 23050, 23018, 22986, 22954, 22922, 22890, 22858,
    22826, 22794, 22762, 22730, 22698, 22666, 22634, 22602, 22570, 22538,
    22506, 22474, 22442, 22410, 22378, 22346, 22314, 22282, 22250, 22218,
    22186, 22154, 22122, 22090, 22058, 22026, 21994, 21962, 21930, 21898,
    21866, 21834, 21802, 21770, 21738, 21706, 21674, 21642, 21610, 21578,
    21546, 21514, 21482, 21450, 21418, 21386, 21354, 21322, 21290, 21258,
    21226, 21194, 21162, 21130, 21098, 21066, 21034, 21002, 20970, 20938,
    20906, 20874, 20842, 20810, 20778, 20746, 20714, 20682, 20650, 20618,
    20586, 20554, 20522, 20490, 20458, 20426, 20394, 20362, 20330, 20298,
    20266, 20234, 20202, 20170, 20138, 20106, 20074, 20042, 20010, 19978,
    19946, 19914, 19882, 19850, 19818, 19786, 19754, 19722, 19690, 19658,
    19626, 19594, 19562, 19530, 19498, 19466, 19434, 19402, 19370, 19338,
    19306, 19274, 19242, 19210, 19178, 19146, 19114, 19082, 19050, 19018,
    18986, 18954, 18922, 18890, 18858, 18826, 18794, 18762, 18730, 18698,
    18666, 18634, 18602, 18570, 18538, 18506, 18474, 18442, 18410, 18378,
    18346, 18314, 18282, 18250, 18218, 18186, 18154, 18122, 18090, 18058,
    18026, 17994, 17962, 17930, 17898, 17866, 17834, 17802, 17770, 17738,
    17706, 17674, 17642, 17610, 17578, 17546, 17514, 17482, 17450, 17418,
    17386, 17354, 17322, 17290, 17258, 17226, 17194, 17162, 17130, 17098,
    17066, 17034, 17002, 16970, 16938, 16906, 16874, 16842, 16810, 16778,
    16746, 16714, 16682, 16650, 16618, 16586, 16554, 16522, 16490, 16458,
    16426, 16394, 16362, 16330, 16298, 16266, 16234, 16202, 16170, 16138,
    16106, 16074, 16042, 16010, 15978, 15946, 15914, 15882, 15850, 15818,
    15786, 15754, 15722, 15690, 15658, 15626, 15594, 15562, 15530, 15498,
    15466, 15434, 15402, 15370, 15338, 15306, 15274, 15242, 15210, 15178,
    15146, 15114, 15082, 15050, 15018, 14986, 14954, 14922, 14890, 14858,
    14826, 14794, 14762, 14730, 14698, 14666, 14634, 14602, 14570, 14538,
    14506, 14474, 14442, 14410, 14378, 14346, 14314, 14282, 14250, 14218,
    14186, 14154, 14122, 14090, 14058, 14026, 13994, 13962, 13930, 13898,
    13866, 13834, 13802, 13770, 13738, 13706, 13674, 13642, 13610, 13578,
    13546, 13514, 13482, 13450, 13418, 13386, 13354, 13322, 13290, 13258,
    13226, 13194, 13162, 13130, 13098, 13066, 13034, 13002, 12970, 12938,
    12906, 12874, 12842, 12810, 12778, 10482, 11112, 11080, 15403, 15371,
    15339, 15307, 15275, 15243, 15211, 15179, 15147, 15115, 15083, 15051,
    15019, 14987, 14955, 14923, 14891, 14859, 14827, 14795, 14763, 14731,
    14699, 14667, 14635, 14603, 14571, 14539, 14507, 14475, 14443, 14411,
    14379, 14347, 14315, 14283, 14251, 14219, 14187, 14155, 14123, 14091,
    14059, 14027, 13995, 13963, 13931, 13899, 13867, 13835, 13803, 13771,
    13739, 13707, 13675, 13643, 13611, 13579, 13547, 13515, 13483, 13451,
    13419, 13387, 13387, 13355, 13323, 13291, 13259, 13227, 13195, 13163,
    13131, 13099, 13067, 13035, 13003, 12971, 12939, 12907, 12875, 12843,
    12811, 12779, 12747, 12715, 12683, 12651, 12619, 12587, 12555, 12523,
    12491, 12459, 12427, 12395, 12363, 12331, 12299, 12267, 12235, 12203,
    12171, 12139, 12107, 12075, 12043, 12011, 11979, 11947, 11915, 11883,
    11851, 11819, 11787, 11755, 11723, 11691, 11659, 11627, 11595, 11563,
    11531, 11499, 11467, 11435, 11403, 11371, 11339, 11307, 11275, 11243,
    11211, 11179, 11147, 11115, 11083, 11051, 11019, 10987, 10955, 10923,
    10891, 10859, 10827, 10795, 10763, 10731, 10699, 10667, 10635, 10603,
    10571, 10539, 10507, 10475, 10443, 10411, 10379, 10347, 10315, 10283,
    10251, 10219, 10187, 10155, 10123, 10091, 10059, 10027, 9995, 9963,
    9931, 9899, 9867, 9835, 9803, 9771, 9739, 9707, 9675, 9643,
    9611, 9579, 9547, 9515, 9483, 9451, 9419, 9387, 9355, 9323,
    9291, 9259, 9227, 9195, 9163, 9131, 9099, 9067, 9035, 9003,
    8971, 8939, 8907, 8875, 8843, 8811, 8779, 8747, 8715, 8683,
    8651, 8619, 8587, 8555, 8523, 8491, 8459, 8427, 8395, 8363,
    8331, 8299, 8267, 8235, 8203, 8171, 8139, 8107, 8075, 8043,
    8011, 7979, 7947, 7915, 7883, 7851, 7819, 7787, 7755, 7723,
    7691, 7659, 7627, 7595, 7563, 7531, 7499, 7467, 7435, 7403,
    7371, 7339, 7307, 7275, 7243, 7211, 7179, 7147, 7115, 7083,
    7051, 7019, 4202, 4170, 4138, 4106, 4074, 4042, 4010, 3978,
    3946, 1640, 2280, 2248, 2216, 2184, 2152, 2120, 2007, 6475,
    1974, 3356, 3324, 3250, 3241, 3228, 3196, 3164, 3132, 3100,
    3068, 3036, 3004, 2972, 2940, 2910, 2860, 2844, 2744, 2780,
    2716, 706, 1320, 5739, 5735, 1023, 2556, 2524, 2492, 1625,
    3000, 5543, 4038, 448, 433, 2507, 2092, 4741,
  };
/** Length of blocks. */
static const int blocks_length = 2048;

/**
 * Information about each character.  The low order 5 bits form the
 * character type, the next bit is a flag for non-breaking spaces, and the
 * next bit is a flag for mirrored directionality.  The high order 9 bits
 * form the offset into the attribute tables.  Note that this limits the
 * number of unique character attributes to 512, which is not a problem
 * as of Unicode version 3.2.0, but may soon become one.
 */
static const jchar data[] = {
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 16000, 16000, 12289, 12418, 16000, 16000, 16000, 16000,
    16000, 16000, 14981, 14981, 16000, 16000, 16000, 14981, 14981, 14981,
    16000, 16000, 16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 16000, 14981, 14981, 14981, 16000, 16000, 16000, 16000, 23432,
    23432, 16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    16000, 14981, 14981, 14981, 16000, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000, 16000,
    16000, 16000, 20888, 16000, 16000, 16000, 16000, 17926, 16000, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 16000, 16000, 16000,
    14981, 14981, 16000, 16000, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    16000, 16000, 16000, 16000, 20994, 20994, 20994, 20994, 20994, 20994,
    20994, 20994, 20994, 20994, 20994, 20994, 20994, 20994, 20994, 20994,
    20994, 20994, 20994, 20994, 20994, 20994, 20994, 20994, 20994, 20994,
    20994, 20994, 20994, 20994, 20994, 11906, 16000, 20888, 10772, 16000,
    16000, 16000, 16000, 16000, 16000, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    18054, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 6683, 6683, 16000,
    16000, 16000, 16000, 17796, 16000, 16000, 16000, 664, 16000, 664,
    26133, 26262, 664, 6807, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 17796, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 17796, 17796, 6683, 6683, 6683,
    6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683, 6683,
    6683, 17796, 17796, 6683, 6683, 6683, 6683, 6683, 6683, 6683,
    6683, 6683, 6683, 6683, 6683, 6683, 6683, 11906, 29314, 11906,
    16000, 11906, 18690, 29825, 29825, 29825, 29825, 29571, 6683, 6683,
    6683, 28034, 28034, 18690, 18690, 16000, 16000, 11906, 18690, 28161,
    28161, 29953, 29953, 16000, 6683, 6683, 6683, 6914, 7042, 7170,
    7298, 7426, 7554, 7682, 7810, 7938, 8066, 8194, 8322, 8450,
    8578, 8706, 8834, 8962, 9090, 9218, 9346, 9474, 9602, 9730,
    9858, 9986, 10114, 1109, 3225, 1238, 3225, 15, 15, 15,
    15, 15, 271, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15, 143,
    271, 143, 399, 271, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 271, 271,
    271, 143, 524, 664, 664, 792, 922, 792, 664, 664,
    1109, 1238, 664, 1305, 1432, 1556, 1432, 1688, 1801, 1929,
    2057, 2185, 2313, 2441, 2569, 2697, 2825, 2953, 1432, 664,
    3161, 3225, 3161, 664, 3329, 3457, 3585, 3713, 3841, 3969,
    4097, 4225, 4353, 4481, 4609, 4737, 4865, 4993, 5121, 5249,
    5377, 5505, 5633, 5761, 5889, 6017, 6145, 6273, 6401, 6529,
    1109, 664, 1238, 6683, 6807, 664, 664, 664, 3225, 1109,
    1238, 16000, 664, 664, 664, 664, 664, 664, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 10284, 664, 922, 922,
    922, 922, 10396, 10396, 6683, 10396, 10498, 10717, 3225, 10772,
    10396, 6683, 10908, 1305, 11019, 11147, 6683, 11266, 10396, 664,
    6683, 11403, 10498, 11614, 11659, 11659, 11659, 664, 664, 1305,
    1556, 3225, 3225, 3225, 16000, 664, 922, 792, 664, 16000,
    16000, 16000, 16000, 21509, 21509, 21509, 16000, 21509, 16000, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 16000, 16000, 16000, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 16000, 20508, 20508,
    20353, 20353, 20353, 20353, 20353, 20353, 20353, 20353, 20353, 20353,
    20353, 20353, 20353, 20353, 20353, 20353, 11777, 11777, 11777, 11777,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 3225,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11906, 11906, 11906,
    18690, 18690, 11906, 11906, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 11906, 11906, 11906, 11906,
    11906, 16000, 16000, 16000, 16000, 16000, 21253, 17926, 21253, 21253,
    16000, 21253, 21253, 16000, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21400, 21509, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 20615, 20615, 17926, 20615, 20615, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    11659, 11659, 11659, 11659, 11659, 11659, 11659, 11659, 11659, 11659,
    11659, 11659, 33803, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 11906, 12289, 12418, 12289, 12418, 12289, 12418, 12289,
    12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289,
    12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289,
    12418, 12289, 12418, 12289, 12418, 16000, 16000, 16000, 16000, 16000,
    16000, 23561, 23689, 23817, 23945, 24073, 24201, 24329, 24457, 24585,
    24713, 17926, 17926, 14981, 14981, 14981, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 6683, 6683, 18177,
    664, 18305, 18305, 18305, 16000, 18433, 16000, 18561, 18561, 18690,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777,
    11777, 11777, 11777, 11777, 11777, 11777, 12034, 12034, 12034, 12034,
    12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034,
    12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 3225,
    12034, 12034, 12034, 12034, 12034, 12034, 12034, 12162, 12034, 12034,
    19074, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034,
    19202, 19330, 19330, 16000, 19458, 19586, 19713, 19713, 19713, 19842,
    19970, 10498, 16000, 16000, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    11906, 15233, 15363, 15490, 12289, 12418, 15745, 15873, 12289, 12418,
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 12289, 12418, 12545, 12674, 12289, 12418, 12289, 12418,
    12289, 12418, 10498, 12289, 12418, 12289, 12418, 12289, 12418, 12289,
    12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 20098,
    20226, 15618, 10498, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 23312, 23312, 23312, 23312, 23312,
    23312, 32523, 16000, 16000, 16000, 32651, 32779, 32907, 33035, 33163,
    33291, 1305, 1305, 3225, 1109, 1238, 10498, 13057, 12289, 12418,
    12289, 12418, 13185, 12289, 12418, 13313, 13313, 12289, 12418, 10498,
    13441, 13569, 13697, 12289, 12418, 13313, 13825, 13954, 14081, 14209,
    12289, 12418, 10498, 10498, 14081, 14337, 10498, 14465, 14981, 14981,
    14981, 14981, 15233, 15363, 15490, 15233, 15363, 15490, 15233, 15363,
    15490, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289,
    12418, 12289, 12418, 12289, 12418, 12289, 12418, 15618, 12289, 12418,
    20508, 17926, 17926, 17926, 17926, 16000, 20615, 20615, 16000, 16000,
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 12289, 12418, 12801, 12289, 12418, 12289, 12418, 12289,
    12418, 12930, 12289, 12418, 12289, 12418, 12289, 12418, 14593, 12289,
    12418, 14593, 10498, 10498, 12289, 12418, 14593, 12289, 12418, 14721,
    14721, 12289, 12418, 12289, 12418, 14849, 12289, 12418, 10498, 14981,
    12289, 12418, 10498, 15106, 19713, 12289, 12418, 12289, 12418, 16000,
    16000, 12289, 12418, 16000, 16000, 12289, 12418, 16000, 16000, 16000,
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418,
    12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    1432, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 21400, 16000, 16000, 16000, 21400,
    21400, 21400, 21400, 21400, 21400, 21400, 21400, 21400, 21400, 21400,
    21400, 21400, 21400, 16000, 23312, 21509, 17926, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 16000, 16000, 23312, 19713,
    19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713,
    19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713,
    19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713, 19713,
    19713, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000,
    14981, 16000, 16000, 16000, 16000, 16000, 23561, 23689, 23817, 23945,
    24073, 24201, 24329, 24457, 24585, 24713, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 10498, 10498,
    10498, 16130, 16258, 10498, 16386, 16386, 10498, 16514, 10498, 16642,
    10498, 10498, 10498, 10498, 16386, 10498, 10498, 16770, 10498, 10498,
    10498, 10498, 16898, 17026, 10498, 10498, 10498, 10498, 10498, 17026,
    10498, 10498, 17154, 10498, 10498, 17282, 10498, 10498, 10498, 10498,
    10498, 10498, 10498, 10498, 10498, 10498, 17410, 10498, 10498, 17410,
    10498, 10498, 10498, 10498, 17410, 10498, 17538, 17538, 10498, 10498,
    10498, 10498, 10498, 10498, 17666, 10498, 10498, 10498, 10498, 10498,
    10498, 10498, 10498, 10498, 10498, 10498, 10498, 10498, 10498, 16000,
    16000, 17796, 17796, 17796, 17796, 17796, 17796, 17796, 17796, 17796,
    6683, 6683, 17796, 17796, 17796, 17796, 17796, 6683, 6683, 6683,
    6683, 6683, 6683, 6683, 6683, 6683, 17796, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 20737, 20737, 20737, 20737, 20737, 20737,
    20737, 20737, 20737, 20737, 20737, 20737, 20737, 20737, 20737, 20737,
    20737, 20737, 20737, 20737, 20737, 20737, 20737, 16000, 16000, 17796,
    20888, 20888, 20888, 20888, 20888, 20888, 11777, 11777, 16000, 11777,
    11777, 11777, 11777, 11777, 11777, 11777, 11777, 11777, 18818, 18946,
    18946, 18946, 18690, 12034, 12034, 12034, 12034, 12034, 12034, 12034,
    12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 12034, 20226,
    20226, 20226, 20226, 20226, 20226, 20226, 20226, 20226, 20226, 20226,
    20226, 20226, 20226, 20226, 20226, 17926, 17926, 17926, 17926, 17926,
    20888, 17926, 17926, 14981, 14981, 14981, 14981, 16000, 16000, 16000,
    16000, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 16000,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 16000, 17926, 17926, 17926, 21144, 17926, 17926,
    21144, 17926, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 16000,
    16000, 16000, 16000, 16000, 21253, 21253, 21253, 21144, 21144, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    23689, 23817, 23945, 24073, 24201, 24329, 24457, 24585, 24713, 25611,
    25739, 25867, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 17926, 23432, 16000, 14981, 14981,
    14981, 14981, 14981, 14981, 16000, 16000, 16000, 14981, 14981, 14981,
    16000, 14981, 14981, 14981, 14981, 16000, 16000, 16000, 14981, 14981,
    16000, 14981, 16000, 14981, 14981, 14981, 14981, 16000, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 16000, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 16000, 16000, 16000, 16000, 16000, 16000,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 17926, 23432, 23432, 23432, 23432, 16000, 17926,
    17926, 17926, 16000, 17926, 17926, 17926, 17926, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 17926, 17926, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 17926, 23432, 23432, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000, 16000, 14981,
    14981, 16000, 16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 16000, 16000, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 16000, 16000, 16000, 16000, 23432, 23432, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000, 16000, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 16000, 14981, 14981,
    14981, 14981, 14981, 14981, 16000, 16000, 14981, 14981, 14981, 14981,
    14981, 14981, 16000, 16000, 14981, 14981, 14981, 16000, 16000, 16000,
    16000, 23561, 23689, 23817, 23945, 24073, 24201, 24329, 24457, 24585,
    24713, 20508, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 21769, 21897, 22025,
    22153, 22281, 22409, 22537, 22665, 22793, 22921, 792, 23064, 23064,
    21400, 16000, 16000, 17926, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    16000, 16000, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 26133, 26262, 21636, 21509, 21509, 21509,
    21509, 21509, 21509, 21509, 21509, 21509, 21509, 17926, 17926, 17926,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 23432,
    23432, 20888, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 17926, 17926, 23432, 16000, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 16000, 14981, 16000, 14981, 14981, 14981,
    16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 20888, 20888, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 17926, 17926, 17926, 17926, 17926, 21636, 21636,
    17926, 17926, 10396, 17926, 17926, 17926, 17926, 16000, 16000, 1801,
    1929, 2057, 2185, 2313, 2441, 2569, 2697, 2825, 2953, 21509,
    21509, 21509, 23196, 23196, 16000, 14981, 14981, 14981, 16000, 14981,
    16000, 14981, 16000, 16000, 14981, 14981, 16000, 14981, 14981, 14981,
    14981, 17926, 14981, 14981, 17926, 17926, 17926, 17926, 17926, 17926,
    16000, 17926, 17926, 14981, 16000, 16000, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 14981,
    14981, 14981, 16000, 16000, 16000, 16000, 17926, 17926, 23432, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 16000, 16000, 17926, 14981, 23432, 23432, 23432, 23432,
    23432, 16000, 17926, 23432, 23432, 16000, 23432, 23432, 17926, 17926,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 23432, 23432, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 14981, 16000, 20888, 20888,
    20888, 20888, 20888, 20888, 20888, 20888, 23689, 23817, 23945, 24073,
    24201, 24329, 24457, 24585, 24713, 25611, 26379, 26507, 26635, 26763,
    26891, 27019, 27147, 27275, 25739, 27403, 16000, 16000, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 16000,
    16000, 14981, 14981, 14981, 14981, 16000, 16000, 17926, 14981, 23432,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 23432, 23432,
    23432, 23432, 17926, 16000, 16000, 14981, 17926, 17926, 17926, 17926,
    16000, 16000, 16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    16000, 14981, 16000, 16000, 16000, 14981, 14981, 14981, 14981, 16000,
    16000, 17926, 16000, 23432, 23432, 23432, 16000, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 14981, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 16000, 14981, 16000, 14981, 14981,
    14981, 14981, 16000, 16000, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 16000, 14981, 16000, 14981, 14981, 14981, 14981, 16000, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 17926, 14981, 14981,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 16000, 16000, 16000,
    16000, 922, 922, 922, 922, 922, 922, 922, 922, 922,
    922, 922, 922, 922, 922, 922, 922, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 14981, 14981, 17926, 17926, 20888, 20888, 23561,
    23689, 23817, 23945, 24073, 24201, 24329, 24457, 24585, 24713, 20888,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 664, 664, 792, 922, 792,
    664, 664, 26133, 26262, 664, 1305, 1432, 1556, 1432, 1688,
    1801, 1929, 2057, 2185, 2313, 2441, 2569, 2697, 2825, 2953,
    1432, 664, 3225, 3225, 3225, 664, 664, 664, 664, 664,
    664, 10772, 664, 664, 664, 664, 23312, 23312, 23312, 23312,
    16000, 23561, 23689, 23817, 23945, 24073, 24201, 24329, 24457, 24585,
    24713, 16000, 16000, 16000, 16000, 16000, 16000, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981,
    14981, 14981, 14981, 16000, 16000, 16000, 16000, 23432, 17926, 17926,
    17926, 17926, 16000, 16000, 23432, 23432, 16000, 16000, 23432, 23432,
    17926, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    23432, 16000, 16000, 16000, 16000, 14981, 14981, 16000, 14981, 16000,
    16000, 14981, 14981, 16000, 14981, 16000, 16000, 14981, 16000, 16000,
    16000, 16000, 16000, 16000, 14981, 14981, 14981, 14981, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 14981, 14981, 16000,
    14981, 14981, 16000, 14981, 14981, 16000, 16000, 17926, 16000, 23432,
    23432, 17926, 17926, 16000, 16000, 16000, 16000, 17926, 17926, 16000,
    16000, 17926, 17926, 17926, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 14981, 14981, 14981, 14981, 16000,
    14981, 16000, 14981, 14981, 17926, 17926, 16000, 16000, 23561, 23689,
    23817, 23945, 24073, 24201, 24329, 24457, 24585, 24713, 14981, 14981,
    922, 922, 24843, 24971, 25099, 25227, 25355, 25483, 20508, 16000,
    16000, 16000, 16000, 16000, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 16000, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 16000, 14981, 14981, 16000, 14981, 14981, 14981, 14981, 14981,
    16000, 16000, 17926, 14981, 23432, 23432, 17926, 17926, 17926, 17926,
    17926, 16000, 17926, 17926, 23432, 16000, 23432, 23432, 17926, 16000,
    16000, 14981, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 23561, 23689, 23817,
    23945, 24073, 24201, 24329, 24457, 24585, 24713, 25355, 25355, 25355,
    25355, 25355, 25355, 25355, 25355, 25355, 25355, 20508, 17926, 20508,
    17926, 20508, 17926, 26133, 26262, 26133, 26262, 23432, 23432, 17926,
    17926, 17926, 16000, 16000, 16000, 23432, 23432, 16000, 16000, 23432,
    23432, 17926, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    17926, 23432, 16000, 16000, 16000, 16000, 14981, 14981, 16000, 14981,
    14981, 14981, 14981, 14981, 16000, 14981, 14981, 16000, 23432, 17926,
    17926, 17926, 17926, 23432, 17926, 16000, 16000, 16000, 17926, 17926,
    23432, 17926, 16000, 16000, 16000, 16000, 16000, 16000, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 23432, 23432,
    23432, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 23432, 23432,
    16000, 16000, 16000, 23432, 23432, 23432, 16000, 23432, 23432, 23432,
    17926, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    23432, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 14981,
    14981, 14981, 14981, 14981, 16000, 17796, 16000, 17926, 17926, 17926,
    17926, 17926, 17926, 16000, 16000, 23561, 23689, 23817, 23945, 24073,
    24201, 24329, 24457, 24585, 24713, 16000, 16000, 14981, 14981, 16000,
    16000, 16000, 16000, 23561, 23689, 23817, 23945, 24073, 24201, 24329,
    24457, 24585, 24713, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 17926,
    17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 20615, 20615, 20615, 23432, 17926, 17926, 17926, 16000,
    16000, 23432, 23432, 23432, 16000, 23432, 23432, 23432, 17926, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 23432, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 16000, 16000, 16000, 17926, 16000, 16000,
    16000, 16000, 23432, 23432, 23432, 17926, 17926, 17926, 16000, 17926,
    16000, 23432, 23432, 23432, 23432, 23432, 23432, 23432, 23432, 17926,
    23432, 23432, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    17926, 17926, 17926, 20888, 20888, 20888, 20888, 20888, 20888, 20888,
    922, 20888, 16000, 16000, 16000, 14981, 14981, 14981, 14981, 14981,
    14981, 17796, 17926, 17926, 17926, 17926, 17926, 17926, 17926, 17926,
    20888, 23561, 23689, 23817, 23945, 24073, 24201, 24329, 24457, 24585,
    24713, 20888, 20888, 16000, 16000, 16000, 16000, 14981, 20508, 20508,
    20508, 20888, 20888, 20888, 20888, 20888, 20888, 20888, 20888, 26040,
    20888, 20888, 20888, 20888, 20888, 20888, 20508, 20508, 20508, 20508,
    20508, 17926, 17926, 20508, 20508, 20508, 20508, 20508, 20508, 17926,
    20508, 20508, 20508, 20508, 20508, 20508, 16000, 16000, 20508, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 16000, 16000, 16000,
    16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 16000, 16000, 16000, 16000,
    16000, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 6807, 17796,
    17796, 17796, 16000, 23561, 23689, 23817, 23945, 24073, 24201, 24329,
    24457, 24585, 24713, 20888, 20888, 20888, 20888, 20888, 20888, 14981,
    14981, 14981, 14981, 14981, 14981, 23432, 23432, 17926, 17926, 16000,
    16000, 16000, 16000, 16000, 16000, 524, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 26133, 26262, 16000, 16000, 16000, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 20888, 20888,
    20888, 27531, 27659, 27787, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 17926, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289,
    12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289, 12418, 12289,
    12418, 12289, 12418, 11906, 11906, 11906, 11906, 11906, 27906, 16000,
    16000, 16000, 16000, 28034, 28034, 28034, 28034, 28034, 28034, 28034,
    28034, 28161, 28161, 28161, 28161, 28161, 28161, 28161, 28161, 28034,
    28034, 28034, 28034, 28034, 28034, 28034, 28034, 28161, 28161, 28161,
    28161, 28161, 28161, 28161, 28161, 28034, 28034, 28034, 28034, 28034,
    28034, 16000, 16000, 28161, 28161, 28161, 28161, 28161, 28161, 16000,
    16000, 11906, 28034, 18690, 28034, 18690, 28034, 18690, 28034, 16000,
    28161, 16000, 28161, 16000, 28161, 16000, 28161, 28034, 28034, 28034,
    28034, 28034, 28034, 28034, 28034, 28161, 28161, 28161, 28161, 28161,
    28161, 28161, 28161, 28290, 28290, 28418, 28418, 28418, 28418, 28546,
    28546, 28674, 28674, 28802, 28802, 28930, 28930, 16000, 16000, 29058,
    29058, 29058, 29058, 29058, 29058, 29058, 29058, 29187, 29187, 29187,
    29187, 29187, 29187, 29187, 29187, 29058, 29058, 29058, 29058, 29058,
    29058, 29058, 29058, 29187, 29187, 29187, 29187, 29187, 29187, 29187,
    29187, 28034, 28034, 11906, 29314, 11906, 16000, 11906, 18690, 28161,
    28161, 29441, 29441, 29571, 6683, 29698, 6683, 6914, 7042, 7170,
    7298, 7426, 7554, 7682, 7810, 7938, 8066, 8194, 8322, 8450,
    8578, 8706, 8834, 8962, 9090, 9218, 9346, 9474, 9602, 9730,
    9858, 9986, 10114, 26133, 3225, 26262, 3225, 16000, 28034, 28034,
    18690, 18690, 11906, 30082, 11906, 18690, 28161, 28161, 30209, 30209,
    30337, 6683, 6683, 6683, 16000, 16000, 11906, 29314, 11906, 16000,
    11906, 18690, 30465, 30465, 30593, 30593, 29571, 6683, 6683, 16000,
    524, 524, 524, 524, 524, 524, 524, 30764, 524, 524,
    524, 30860, 23312, 23312, 30992, 31120, 10772, 31284, 10772, 10772,
    10772, 10772, 664, 664, 31389, 31518, 26133, 31389, 31389, 31518,
    26133, 31389, 664, 664, 664, 664, 664, 664, 664, 664,
    31629, 31758, 31888, 32016, 32144, 32272, 32400, 30764, 792, 792,
    792, 792, 792, 664, 664, 664, 664, 10717, 11614, 664,
    664, 664, 664, 6807, 32523, 11403, 11019, 11147, 32651, 32779,
    32907, 33035, 33163, 33291, 1305, 1305, 3225, 1109, 1238, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 16000,
    16000, 16000, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 16000, 16000, 16000, 16000, 16000, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 19713, 10396, 10396, 10396, 10396, 19713,
    10396, 10396, 10498, 19713, 19713, 19713, 10498, 10498, 19713, 19713,
    19713, 10498, 10396, 19713, 10396, 10396, 10396, 19713, 19713, 19713,
    19713, 19713, 10396, 10396, 41482, 41610, 41738, 41866, 41994, 42122,
    42250, 42378, 42506, 17926, 17926, 17926, 17926, 17926, 17926, 10772,
    17796, 17796, 17796, 17796, 17796, 10396, 10396, 42634, 42762, 42890,
    16000, 16000, 16000, 10396, 10396, 10396, 10396, 16000, 10396, 10396,
    10396, 10396, 16000, 16000, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 3225, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 3225, 3225, 10396, 10396, 3225, 10396, 3225, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 3225, 10396, 10396, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 38026, 38154, 38282, 38410, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 3225, 3225, 3225,
    3225, 3225, 10396, 10396, 10396, 10396, 10396, 3225, 3225, 10396,
    10396, 10396, 10396, 19713, 10396, 33409, 10396, 19713, 10396, 33537,
    33665, 19713, 19713, 10908, 10498, 19713, 19713, 10396, 19713, 10498,
    14981, 14981, 14981, 14981, 10498, 10396, 16000, 16000, 16000, 16000,
    16000, 33930, 34058, 34186, 34314, 34442, 34570, 34698, 34826, 34954,
    35082, 35210, 35338, 35466, 35594, 35722, 35850, 35978, 36106, 36234,
    36362, 36490, 36618, 36746, 36874, 37002, 37130, 37258, 37386, 37514,
    37642, 37770, 37898, 3225, 3225, 3161, 3161, 3225, 3225, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3225, 3225,
    3225, 3225, 3225, 3161, 3161, 3161, 3161, 3225, 3225, 3225,
    3225, 3225, 3225, 3225, 3225, 3225, 3161, 3161, 3161, 3161,
    3161, 3225, 3225, 3161, 3161, 3225, 3225, 3225, 3225, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3225, 3225, 3161, 3161, 3161, 3161, 3225, 3225,
    3225, 3225, 3225, 3161, 3225, 3225, 3225, 3225, 3225, 3225,
    3225, 10396, 10396, 3225, 10396, 10396, 3225, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 3225, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 16000, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 3225, 3161, 3161,
    3161, 3161, 3225, 3225, 3225, 3161, 3161, 3161, 3161, 3161,
    3161, 3225, 3225, 3225, 3161, 1305, 1305, 3225, 3161, 3161,
    3225, 3225, 3225, 3161, 3161, 3161, 3161, 3225, 3161, 3225,
    3161, 3225, 3225, 3225, 3225, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3225, 3225, 3225, 3225, 3225, 3161,
    3225, 3161, 3161, 3161, 3161, 3161, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 1109, 1238, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 16000,
    16000, 16000, 16000, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 39964, 39964, 39964, 39964, 39964,
    39964, 39964, 39964, 39964, 39964, 39964, 39964, 39964, 39964, 39964,
    39964, 40092, 40092, 40092, 40092, 40092, 40092, 40092, 40092, 40092,
    40092, 40092, 40092, 40092, 40092, 40092, 40092, 32523, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 3161,
    3225, 3161, 3225, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3225, 3225, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161, 3161,
    3161, 3225, 3225, 3161, 3161, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 922,
    922, 3225, 6683, 10396, 922, 922, 16000, 10396, 3225, 3225,
    3225, 3225, 10396, 10396, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 23312, 23312, 23312, 10396, 10396, 16000,
    16000, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 16000, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 16000, 10396, 16000, 10396, 10396, 10396, 10396, 16000,
    16000, 16000, 10396, 16000, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 33803, 40203, 40331, 40459, 40587,
    40715, 40843, 40971, 41099, 41227, 33803, 40203, 40331, 40459, 40587,
    40715, 40843, 40971, 41099, 41227, 10396, 16000, 16000, 16000, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 3161, 3161, 3161,
    3161, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396, 10396,
    10396, 10396, 20508, 10396, 10396, 10396, 10396, 10396, 16000, 16000,
    16000, 16000, 16000, 25355, 25355, 25355, 25355, 25355, 25355, 25355,
    25355, 25355, 25355, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 16000, 16000, 16000, 20508, 24843,
    24971, 25099, 25227, 43019, 43147, 43275, 43403, 43531, 25611, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 10396, 16000, 10396, 10396,
    10396, 16000, 10396, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 11403, 11019,
    11147, 32651, 32779, 32907, 33035, 33163, 33291, 38539, 38667, 38795,
    38923, 39051, 39179, 39307, 39435, 39563, 39691, 39819, 11403, 11019,
    11147, 32651, 32779, 32907, 33035, 33163, 33291, 38539, 38667, 38795,
    38923, 39051, 39179, 39307, 39435, 39563, 39691, 39819, 20508, 20508,
    20508, 20508, 524, 664, 664, 664, 10396, 17796, 14981, 41354,
    1109, 1238, 1109, 1238, 1109, 1238, 1109, 1238, 1109, 1238,
    10396, 10396, 1109, 1238, 1109, 1238, 1109, 1238, 1109, 1238,
    10772, 26133, 26262, 26262, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 16000, 16000, 16000, 16000, 17926,
    17926, 6683, 6683, 17796, 17796, 16000, 14981, 14981, 14981, 14981,
    14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981, 14981,
    14981, 16000, 20508, 20508, 25355, 25355, 25355, 25355, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508, 20508,
    20508, 20508, 20508, 20508, 20508, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 43667, 43667, 43667, 43667, 43667, 43667, 43667,
    43667, 43667, 43667, 43667, 43667, 43667, 43667, 43667, 43667, 43667,
    43667, 43667, 43667, 43667, 43667, 43667, 43667, 43667, 43667, 43667,
    43667, 43667, 43667, 43667, 43667, 43794, 43794, 43794, 43794, 43794,
    43794, 43794, 43794, 43794, 43794, 43794, 43794, 43794, 43794, 43794,
    43794, 43794, 43794, 43794, 43794, 43794, 43794, 43794, 43794, 43794,
    43794, 43794, 43794, 43794, 43794, 43794, 43794, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 1305, 21253, 21253, 21253,
    21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253, 21253,
    16000, 21253, 21253, 21253, 21253, 21253, 16000, 21253, 16000, 17926,
    17926, 17926, 17926, 16000, 16000, 16000, 16000, 16000, 16000, 16000,
    16000, 16000, 16000, 16000, 16000, 664, 10772, 10772, 6807, 6807,
    26133, 26262, 26133, 26262, 26133, 26262, 26133, 26262, 26133, 26262,
    26133, 26262, 16000, 16000, 16000, 16000, 664, 664, 664, 664,
    6807, 6807, 6807, 1432, 664, 1432, 16000, 664, 1432, 664,
    664, 10772, 26133, 26262, 26133, 26262, 26133, 26262, 792, 664,
    3329, 3457, 3585, 3713, 3841, 3969, 4097, 4225, 4353, 4481,
    4609, 4737, 4865, 4993, 5121, 5249, 5377, 5505, 5633, 5761,
    5889, 6017, 6145, 6273, 6401, 6529, 26133, 664, 26262, 6683,
    6807,
  };
/** Length of data. */
static const int data_length = 5351;

/**
 * This is the attribute table for computing the numeric value of a
 * character.  The value is -1 if Unicode does not define a value, -2
 * if the value is not a positive integer, otherwise it is the value.
 */
static const jshort numValue[] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
    -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
    21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
    34, 35, -1, -1, -1, -1, -1, -1, 2, 3, -1, 1, -1,
    -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1,
    2, 3, 4, -1, 16, 10, 100, 1000, -1, -1, -1, 20, 30,
    40, 50, 60, 70, 80, 90, 10000, 17, 18, 19, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 4, 5, 6, 7, 8,
    9, -1, -1, -1, 1, 1, 2, 3, 4, 5, 6, 7, 8,
    9, 10, 11, 12, 50, 100, 500, 1000, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 10, 11, 12, 50, 100, 500, 1000, 1000, 5000,
    10000, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
    -1, -1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 30, 5, 6,
    7, 8, 9, -1, -1,
  };
/** Length of numValue. */
static const int numValue_length = 343;

/**
 * This is the attribute table for computing the uppercase representation
 * of a character.  The value is the difference between the character and
 * its uppercase version.
 */
static const jshort upper[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32,
    -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32,
    -32, -32, 0, 0, 0, 0, 0, 0, 0, 0, 743, 0, 0,
    0, 0, 0, -32, 121, 0, -1, 0, -232, 0, -300, 0, 0,
    0, 0, 0, 0, 0, 97, 0, 0, 0, 0, 0, 0, 0,
    0, 56, 0, -1, -2, -79, 0, 0, 0, -210, -206, -205, -202,
    -203, -207, -209, -211, -213, -214, -218, -217, -219, 0, 0, 84, 0,
    0, 0, 0, 0, -38, -37, -31, -64, -63, -62, -57, 0, -47,
    -54, -86, -80, 0, 0, 0, 0, 0, -48, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -59, 8, 0,
    74, 86, 100, 128, 112, 126, 8, 0, 9, 0, 0, -7205, 0,
    0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, -16, -16, -16, -16, -16,
    -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0,
  };
/** Length of upper. */
static const int upper_length = 343;

/**
 * This is the attribute table for computing the lowercase representation
 * of a character.  The value is the difference between the character and
 * its lowercase version.
 */
static const jshort lower[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 32, 0, 0, 0, 1, 0, -199, 0, -121, 0, 210, 206,
    205, 79, 202, 203, 207, 0, 211, 209, 213, 214, 218, 217, 219,
    0, 0, 2, 1, 0, 0, -97, -56, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38,
    37, 64, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 80, 0, 0, 48, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -8,
    0, 0, 0, 0, 0, 0, 0, -8, 0, -74, -9, 0, -86,
    -100, 0, -112, -7, -128, -126, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -7517, -8383, -8262, 0, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0,
  };
/** Length of lower. */
static const int lower_length = 343;

/**
 * This is the attribute table for computing the directionality class
 * of a character.  At present, the value is in the range 0 - 18 if the
 * character has a direction, otherwise it is -1.
 */
static const jbyte direction[] = {
    36, 44, 40, 48, 48, 52, 20, 20, 52, 52, 20, 28, 20, 16, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 52, 0, 52,
    52, 20, 12, 12, 0, 12, 52, 52, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0, 0, 0, 0, 2,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 4, 4, 8,
    8, 8, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 8, 36, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 52, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0,
    1, 0, 0, 0, 0, 0, 0, 0, 0, 48, 36, 0, 4, 52, 52, 52, 48, 40, 56, 64, 72,
    60, 68, 12, 12, 12, 12, 12, 12, 12, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 0, 52,
    52, 52, 52, 52, 52, 52, 52, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0,
  };
/** Length of direction. */
static const int direction_length = 343;

/**
 * This is the listing of titlecase special cases (all other character
 * can use <code>upper</code> to determine their titlecase).  The listing
 * is a sequence of character pairs; converting the first character of the
 * pair to titlecase produces the second character.
 */
static const jchar title[] = {
    452, 453, 453, 453, 454, 453, 455, 456, 456, 456,
    457, 456, 458, 459, 459, 459, 460, 459, 497, 498,
    498, 498, 499, 498,
  };
/** Length of title. */
static const int title_length = 24;

#endif /* __JAVA_CHARTABLES_H__ */
