/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.dialogs;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.buildins.dialogs.Predicate_dialog;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class Predicate_file_save
extends Predicate_dialog {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        JFileChooser choose = this.createFileDialog(args);
        while (choose.showSaveDialog(null) == 0) {
            if (choose.getSelectedFile().exists() && JOptionPane.showConfirmDialog(null, String.format("Are you sure you want to overwrite the existing file:\n%s ?", choose.getSelectedFile().toString()), "File Exists", 0) == 1) continue;
            AtomTerm term = AtomTerm.get(choose.getSelectedFile().toString());
            return interpreter.unify(args[0], term);
        }
        return -1;
    }

    protected JFileChooser createFileDialog(Term[] args) throws PrologException {
        Predicate_dialog.DialogOptions options = args.length >= 2 ? this.processOptions(args[1]) : new Predicate_dialog.DialogOptions();
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        chooser.setMultiSelectionEnabled(false);
        if (options.title != null) {
            chooser.setDialogTitle(options.title);
        }
        if (options.fileFilters != null) {
            FileFilter selfilter = null;
            chooser.setAcceptAllFileFilterUsed(false);
            for (FileFilter filter : options.fileFilters) {
                chooser.addChoosableFileFilter(filter);
                if (selfilter != null) continue;
                selfilter = filter;
            }
            chooser.addChoosableFileFilter(chooser.getAcceptAllFileFilter());
            if (selfilter != null) {
                chooser.setFileFilter(selfilter);
            }
        }
        if (options.selection != null) {
            chooser.setSelectedFile(new File(options.selection));
        }
        return chooser;
    }
}

