//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Steet, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

extern "C" {
#include <libexif/exif-content.h>
}

#include "kexifentry.h"
#include "kexififd.h"

KExifIfd::KExifIfd()
{
    mName = "";
    mEntryList.setAutoDelete(true);
    mExifContent = 0;
}

KExifIfd::KExifIfd(const QString& name, ExifContent* content)
{
    mName = name;
    mEntryList.setAutoDelete(true);
    mExifContent = 0;

    setContent(content);
}

KExifIfd::~KExifIfd()
{
    mEntryList.clear();

    if (mExifContent)
        exif_content_unref(mExifContent);
}

KExifIfd::KExifIfd(const KExifIfd& ifd)
{
    if (this != &ifd) {
        mName = ifd.mName;
        mEntryList.setAutoDelete(true);
        setContent(ifd.mExifContent);
    }
}

KExifIfd& KExifIfd::operator=(const KExifIfd& ifd)
{
    if (this != &ifd) {
        mName = ifd.mName;
        mEntryList.setAutoDelete(true);
        setContent(ifd.mExifContent);
    }
    return (*this);
}


void KExifIfd::setName(const QString& name)
{
    mName = name;
}

void KExifIfd::setContent(ExifContent* content)
{
    if (!content) return;

    if (mExifContent) {
        exif_content_unref(mExifContent);
        mExifContent = 0;
    }

    mExifContent = content;
    exif_content_ref(mExifContent);
    mEntryList.clear();

    for (unsigned int i=0; i<content->count; i++) {
        mEntryList.append(new KExifEntry(content->entries[i]));
    }

}

int KExifIfd::numberEntries()
{
    return mEntryList.count();
}


QPtrList<KExifEntry> KExifIfd::entryList() const
{
    return mEntryList;
}

QString KExifIfd::getName() const
{
    return mName;
}
