/*
 * autoconfig.h
 *
 * Create mappings between new-style autoconfigured parameters, and the
 * old-style hard coded approach.
 *
 *  Copyright (C) 2004        John Williams <jwilliams@itee.uq.edu.au>
 *
 * Released under the GPL etc etc
 */

#ifndef _AUTOCONFIG_H
#define _AUTOCONFIG_H

/* Only need this if the uclinux-auto target is not selected */
#ifndef PLATFORM

#include <linux/config.h>
#include <asm/xparameters.h>
 /* Backwards compatability mappings for old-style code
    Essentially use the old config macro values, to provide values that are
    now provided by the auto-config file, and required in various drivers */

/* The timer and clock frequency */
#define CONFIG_XILINX_CPU_CLOCK_FREQ CONFIG_CPU_CLOCK_FREQ
#define CONFIG_XILINX_TIMER_0_BASEADDR MICROBLAZE_TIMER_BASE_ADDR
#define CONFIG_XILINX_TIMER_0_IRQ 0

/* The interrupt controller */
#define CONFIG_XILINX_INTC_0_BASEADDR MICROBLAZE_INTC_BASE_ADDR 
#define CONFIG_XILINX_INTC_0_KIND_OF_INTR XPAR_SYSTEM_INTC_KIND_OF_INTR 

#ifdef CONFIG_MICROBLAZE_INTC_HAS_IVR
#define CONFIG_XILINX_INTC_0_HAS_IVR 1
#else
#define CONFIG_XILINX_INTC_0_HAS_IVR 0
#endif

#ifdef CONFIG_MICROBLAZE_INTC_HAS_SIE
#define CONFIG_XILINX_INTC_0_HAS_SIE 1
#else
#define CONFIG_XILINX_INTC_0_HAS_SIE 0
#endif

#ifdef CONFIG_MICROBLAZE_INTC_HAS_CIE
#define CONFIG_XILINX_INTC_0_HAS_CIE 1
#else
#define CONFIG_XILINX_INTC_0_HAS_CIE 0
#endif

/* Cache support */
#ifdef CONFIG_MICROBLAZE_ICACHE
#define CONFIG_XILINX_MICROBLAZE0_USE_ICACHE 1
#define CONFIG_XILINX_MICROBLAZE0_ICACHE_BASEADDR CONFIG_MICROBLAZE_ICACHE_BASE
#define CONFIG_XILINX_MICROBLAZE0_CACHE_BYTE_SIZE CONFIG_MICROBLAZE_ICACHE_SIZE
#else
#define CONFIG_XILINX_MICROBLAZE0_USE_ICACHE 0
#endif

#ifdef CONFIG_MICROBLAZE_DCACHE
#define CONFIG_XILINX_MICROBLAZE0_USE_DCACHE 1
#define CONFIG_XILINX_MICROBLAZE0_DCACHE_BASEADDR CONFIG_MICROBLAZE_DCACHE_BASE
#define CONFIG_XILINX_MICROBLAZE0_DCACHE_BYTE_SIZE CONFIG_MICROBLAZE_DCACHE_SIZE
#else
#define CONFIG_XILINX_MICROBLAZE0_USE_DCACHE 0
#endif

#ifdef CONFIG_MICROBLAZE_MSRSETCLR
#define CONFIG_XILINX_MICROBLAZE0_USE_MSR_INSTR (1)
#else
#define CONFIG_XILINX_MICROBLAZE0_USE_MSR_INSTR (0)
#endif

/* The UARTLITES */
#ifdef XPAR_CONSOLE_UART_BASEADDR
#define CONFIG_XILINX_UARTLITE_0_INSTANCE "console_uart"
#define CONFIG_XILINX_UARTLITE_0_BASEADDR XPAR_CONSOLE_UART_BASEADDR 
#define CONFIG_XILINX_UARTLITE_0_IRQ 1
#endif


/* The GPIO */
#ifdef XPAR_SYSTEM_GPIO_BASEADDR
#define CONFIG_XILINX_GPIO_0_BASEADDR XPAR_SYSTEM_GPIO_BASEADDR
#define CONFIG_XILINX_GPIO_0_HIGHADDR XPAR_SYSTEM_GPIO_HIGHADDR
#define CONFIG_XILINX_GPIO_NUM_INSTANCES 1
#endif

#ifndef CONFIG_SUZAKU

#ifdef XPAR_DEBUG_UART_BASEADDR
#define CONFIG_XILINX_UARTLITE_1_INSTANCE "debug_uart"
#define CONFIG_XILINX_UARTLITE_1_BASEADDR XPAR_DEBUG_UART_BASEADDR
#define CONFIG_XILINX_UARTLITE_1_IRQ 2
#endif

/* The ethernet MAC */
#define CONFIG_XILINX_ETHERNET_0_INSTANCE "system_ethernet"
#define CONFIG_XILINX_ETHERNET_0_DEVICE_ID XPAR_OPB_ETHERNET_0_DEVICE_ID
#define CONFIG_XILINX_ETHERNET_0_ERR_COUNT_EXIST XPAR_OPB_ETHERNET_0_ERR_COUNT_EXIST
#define CONFIG_XILINX_ETHERNET_0_DMA_PRESENT XPAR_OPB_ETHERNET_0_DMA_PRESENT
#define CONFIG_XILINX_ETHERNET_0_MII_EXIST XPAR_OPB_ETHERNET_0_MII_EXIST
#define CONFIG_XILINX_ETHERNET_0_BASEADDR XPAR_EMAC_0_BASEADDR
#define CONFIG_XILINX_ETHERNET_0_HIGHADDR XPAR_EMAC_0_HIGHADDR
#define CONFIG_XILINX_ETHERNET_0_IRQ 3
#define CONFIG_XILINX_ETHERNET_NUM_INSTANCES XPAR_XEMAC_NUM_INSTANCES

#endif /* !CONFIG_SUZAKU */

#endif /* PLATFORM */

#endif /* !defined _AUTOCONFIG_H */
