# Моделі параметрів заголовків { #header-parameter-models }

Якщо у вас є група пов’язаних **параметрів заголовків**, ви можете створити **Pydantic модель** для їх оголошення.

Це дозволить вам повторно **використовувати модель** в **різних місцях**, а також оголосити валідації та метадані для всіх параметрів одночасно. 😎

/// note | Примітка

Ця можливість підтримується починаючи з версії FastAPI `0.115.0`. 🤓

///

## Параметри заголовків з використанням Pydantic моделі { #header-parameters-with-a-pydantic-model }

Оголосіть потрібні **параметри заголовків** у **Pydantic моделі**, а потім оголосіть параметр як `Header`:

{* ../../docs_src/header_param_models/tutorial001_an_py310.py hl[9:14,18] *}

**FastAPI** буде **витягувати** дані для **кожного поля** з **заголовків** у запиті та передавати їх у створену вами Pydantic модель.

## Перевірка в документації { #check-the-docs }

Ви можете побачити необхідні заголовки в інтерфейсі документації за адресою `/docs`:

<div class="screenshot">
<img src="/img/tutorial/header-param-models/image01.png">
</div>

## Заборонити додаткові заголовки { #forbid-extra-headers }

У деяких особливих випадках (ймовірно, не дуже поширених) ви можете захотіти **обмежити** заголовки, які хочете отримати.

Ви можете використати конфігурацію моделі Pydantic, щоб `заборонити` будь-які `додаткові` поля:

{* ../../docs_src/header_param_models/tutorial002_an_py310.py hl[10] *}

Якщо клієнт спробує надіслати **додаткові заголовки**, він отримає **помилку** у відповіді.

Наприклад, якщо клієнт спробує надіслати заголовок `tool` зі значенням `plumbus`, він отримає **помилку** у відповіді з повідомленням про те, що параметр заголовка `tool` не дозволений:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["header", "tool"],
            "msg": "Extra inputs are not permitted",
            "input": "plumbus",
        }
    ]
}
```

## Вимкнути перетворення підкреслень { #disable-convert-underscores }

Так само, як і зі звичайними параметрами заголовків, коли у назвах параметрів є символи підкреслення, вони **автоматично перетворюються на дефіси**.

Наприклад, якщо у коді у вас є параметр заголовка `save_data`, очікуваний HTTP-заголовок буде `save-data`, і він так само відображатиметься в документації.

Якщо з якоїсь причини вам потрібно вимкнути це автоматичне перетворення, ви також можете зробити це для Pydantic моделей для параметрів заголовків.

{* ../../docs_src/header_param_models/tutorial003_an_py310.py hl[19] *}

/// warning | Попередження

Перш ніж встановлювати `convert_underscores` у значення `False`, пам’ятайте, що деякі HTTP проксі та сервери забороняють використання заголовків із підкресленнями.

///

## Підсумок { #summary }

Ви можете використовувати **Pydantic моделі** для оголошення **заголовків** у **FastAPI**. 😎
