# Безпека { #security }

Існує багато способів реалізувати безпеку, автентифікацію та авторизацію.

І зазвичай це складна і «непроста» тема.

У багатьох фреймворках і системах лише обробка безпеки та автентифікації потребує великих зусиль і коду (у багатьох випадках це може бути 50% або більше від усього написаного коду).

**FastAPI** надає кілька інструментів, які допоможуть вам працювати з **безпекою** легко, швидко, стандартним способом, без необхідності вивчати всі специфікації безпеки.

Але спочатку розгляньмо кілька невеликих понять.

## Поспішаєте? { #in-a-hurry }

Якщо вам не цікаві всі ці терміни й вам просто потрібно додати безпеку з автентифікацією на основі імені користувача та пароля *прямо зараз*, переходьте до наступних розділів.

## OAuth2 { #oauth2 }

OAuth2 — це специфікація, що визначає кілька способів обробки автентифікації та авторизації.

Це досить об'ємна специфікація, яка охоплює кілька складних випадків використання.

Вона включає способи автентифікації через «третю сторону».

Саме це лежить в основі всіх систем із «увійти через Facebook, Google, X (Twitter), GitHub».

### OAuth 1 { #oauth-1 }

Раніше існував OAuth 1, який значно відрізняється від OAuth2 і є складнішим, оскільки містив прямі специфікації щодо того, як шифрувати комунікацію.

Зараз він не дуже популярний або використовується.

OAuth2 не вказує, як саме шифрувати комунікацію — він очікує, що ваш застосунок доступний через HTTPS.

/// tip | Порада

У розділі про **деплой** ви побачите, як налаштувати HTTPS безкоштовно з Traefik та Let's Encrypt.

///

## OpenID Connect { #openid-connect }

OpenID Connect — ще одна специфікація, побудована на основі **OAuth2**.

Вона просто розширює OAuth2, уточнюючи деякі відносно неоднозначні речі в OAuth2, щоб зробити його більш сумісним.

Наприклад, вхід через Google використовує OpenID Connect (який під капотом використовує OAuth2).

Але вхід через Facebook не підтримує OpenID Connect. Він має власний різновид OAuth2.

### OpenID (не «OpenID Connect») { #openid-not-openid-connect }

Існувала також специфікація «OpenID». Вона намагалася розвʼязати те саме, що й **OpenID Connect**, але не базувалась на OAuth2.

Тож це була повністю додаткова система.

Зараз вона не дуже популярна або використовується.

## OpenAPI { #openapi }

OpenAPI (раніше відомий як Swagger) — це відкрита специфікація для побудови API (тепер частина Linux Foundation).

**FastAPI** базується на **OpenAPI**.

Саме це робить можливими кілька автоматичних інтерактивних інтерфейсів документації, генерацію коду тощо.

OpenAPI має спосіб визначати різні «схеми» безпеки.

Використовуючи їх, ви можете скористатися всіма цими інструментами, що базуються на стандартах, зокрема цими інтерактивними системами документації.

OpenAPI визначає такі схеми безпеки:

* `apiKey`: специфічний для застосунку ключ, який може передаватися через:
    * Параметр запиту.
    * Заголовок.
    * Кукі.
* `http`: стандартні системи HTTP-автентифікації, включаючи:
    * `bearer`: заголовок `Authorization` зі значенням `Bearer ` та токеном. Це успадковано з OAuth2.
    * базову автентифікацію HTTP.
    * HTTP дайджест тощо.
* `oauth2`: усі способи обробки безпеки за допомогою OAuth2 (так звані «потоки»).
    * Декілька з цих потоків підходять для створення провайдера автентифікації OAuth 2.0 (наприклад, Google, Facebook, X (Twitter), GitHub тощо):
        * `implicit`
        * `clientCredentials`
        * `authorizationCode`
    * Але є один окремий «потік», який можна ідеально використати для обробки автентифікації напряму в цьому ж застосунку:
        * `password`: у кількох наступних розділах будуть приклади цього.
* `openIdConnect`: має спосіб визначити, як автоматично виявляти дані автентифікації OAuth2.
    * Саме це автоматичне виявлення визначено у специфікації OpenID Connect.


/// tip | Порада

Інтеграція інших провайдерів автентифікації/авторизації, таких як Google, Facebook, X (Twitter), GitHub тощо, також можлива і відносно проста.

Найскладніше — це створити провайдера автентифікації/авторизації на кшталт таких, але **FastAPI** надає вам інструменти, щоб зробити це легко, виконуючи важку частину роботи за вас.

///

## Утиліти **FastAPI** { #fastapi-utilities }

FastAPI надає кілька інструментів для кожної з описаних схем безпеки в модулі `fastapi.security`, які спрощують використання цих механізмів безпеки.

У наступних розділах ви побачите, як додати безпеку до свого API за допомогою цих інструментів, які надає **FastAPI**.

А також побачите, як це автоматично інтегрується в інтерактивну систему документації.
