# Умовний OpenAPI { #conditional-openapi }

Якщо потрібно, ви можете використовувати налаштування і змінні оточення, щоб умовно налаштовувати OpenAPI залежно від середовища, а також повністю вимикати його.

## Про безпеку, API та документацію { #about-security-apis-and-docs }

Приховування інтерфейсів документації у продукційному середовищі *не має* бути способом захисту вашого API.

Це не додає жодної додаткової безпеки вашому API, *операції шляху* й надалі будуть доступні там, де вони є.

Якщо у вашому коді є вразливість, вона залишиться.

Приховування документації лише ускладнює розуміння того, як взаємодіяти з вашим API, і може ускладнити для вас його налагодження у продакшні. Це можна вважати просто формою <a href="https://en.wikipedia.org/wiki/Security_through_obscurity" class="external-link" target="_blank">Безпека через неясність</a>.

Якщо ви хочете захистити ваш API, є кілька кращих дій, які ви можете зробити, наприклад:

- Переконайтеся, що у вас добре визначені моделі Pydantic для тіл запитів і відповідей.
- Налаштуйте потрібні дозволи та ролі за допомогою залежностей.
- Ніколи не зберігайте паролі у відкритому вигляді, лише хеші паролів.
- Реалізуйте та використовуйте відомі криптографічні інструменти, як-от pwdlib і токени JWT.
- Додайте більш детальний контроль дозволів із областями OAuth2 там, де це потрібно.
- ...тощо.

Втім, у вас може бути дуже специфічний випадок використання, коли справді потрібно вимкнути документацію API для певного середовища (наприклад, для продакшну) або залежно від конфігурацій зі змінних оточення.

## Умовний OpenAPI з налаштувань і змінних оточення { #conditional-openapi-from-settings-and-env-vars }

Ви можете легко використати ті самі налаштування Pydantic, щоб налаштувати згенерований OpenAPI та інтерфейси документації.

Наприклад:

{* ../../docs_src/conditional_openapi/tutorial001_py310.py hl[6,11] *}

Тут ми оголошуємо налаштування `openapi_url` з тим самим значенням за замовчуванням `"/openapi.json"`.

Потім ми використовуємо його під час створення застосунку `FastAPI`.

Далі ви можете вимкнути OpenAPI (включно з інтерфейсами документації), встановивши змінну оточення `OPENAPI_URL` у пусту строку, наприклад:

<div class="termy">

```console
$ OPENAPI_URL= uvicorn main:app

<span style="color: green;">INFO</span>:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)
```

</div>

Потім, якщо ви перейдете за URL `/openapi.json`, `/docs` або `/redoc`, ви просто отримаєте помилку `404 Not Found` на кшталт:

```JSON
{
    "detail": "Not Found"
}
```
