# Aider FastAPI - Obtenir de l'aide { #help-fastapi-get-help }

Aimez-vous **FastAPI** ?

Souhaitez-vous aider FastAPI, les autres utilisateurs et l'auteur ?

Ou souhaitez-vous obtenir de l'aide avec **FastAPI** ?

Il existe des moyens très simples d'aider (plusieurs ne nécessitent qu'un ou deux clics).

Et il existe aussi plusieurs façons d'obtenir de l'aide.

## S'abonner à la newsletter { #subscribe-to-the-newsletter }

Vous pouvez vous abonner à la (peu fréquente) [newsletter **FastAPI and friends**](newsletter.md){.internal-link target=_blank} pour rester informé à propos :

* Nouvelles sur FastAPI et ses amis 🚀
* Guides 📝
* Fonctionnalités ✨
* Changements majeurs 🚨
* Astuces et conseils ✅

## Suivre FastAPI sur X (Twitter) { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">Suivez @fastapi sur **X (Twitter)**</a> pour obtenir les dernières nouvelles sur **FastAPI**. 🐦

## Mettre une étoile à **FastAPI** sur GitHub { #star-fastapi-in-github }

Vous pouvez « star » FastAPI sur GitHub (en cliquant sur le bouton étoile en haut à droite) : <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

En ajoutant une étoile, les autres utilisateurs pourront le trouver plus facilement et voir qu'il a déjà été utile à d'autres.

## Suivre le dépôt GitHub pour les releases { #watch-the-github-repository-for-releases }

Vous pouvez « watch » FastAPI sur GitHub (en cliquant sur le bouton « watch » en haut à droite) : <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Vous pouvez y sélectionner « Releases only ».

Ainsi, vous recevrez des notifications (par e‑mail) chaque fois qu'il y aura une nouvelle release (une nouvelle version) de **FastAPI** avec des corrections de bugs et de nouvelles fonctionnalités.

## Entrer en contact avec l'auteur { #connect-with-the-author }

Vous pouvez entrer en contact avec <a href="https://tiangolo.com" class="external-link" target="_blank">moi (Sebastián Ramírez / `tiangolo`)</a>, l'auteur.

Vous pouvez :

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Me suivre sur **GitHub**</a>.
    * Voir d'autres projets Open Source que j'ai créés et qui pourraient vous aider.
    * Me suivre pour voir quand je crée un nouveau projet Open Source.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Me suivre sur **X (Twitter)**</a> ou sur <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Me dire comment vous utilisez FastAPI (j'adore l'entendre).
    * Être informé quand je fais des annonces ou publie de nouveaux outils.
    * Vous pouvez aussi <a href="https://x.com/fastapi" class="external-link" target="_blank">suivre @fastapi sur X (Twitter)</a> (un compte séparé).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Me suivre sur **LinkedIn**</a>.
    * Être informé quand je fais des annonces ou publie de nouveaux outils (même si j'utilise plus souvent X (Twitter) 🤷‍♂).
* Lire ce que j'écris (ou me suivre) sur <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> ou <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Lire d'autres idées, des articles, et découvrir des outils que j'ai créés.
    * Me suivre pour lire quand je publie quelque chose de nouveau.

## Tweeter à propos de **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Tweetez à propos de **FastAPI**</a> et faites savoir à moi et aux autres pourquoi vous l'appréciez. 🎉

J'adore entendre comment **FastAPI** est utilisé, ce que vous avez aimé, dans quel projet/quelle entreprise vous l'utilisez, etc.

## Voter pour FastAPI { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Votez pour **FastAPI** sur Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Votez pour **FastAPI** sur AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Indiquez que vous utilisez **FastAPI** sur StackShare</a>.

## Aider les autres avec des questions sur GitHub { #help-others-with-questions-in-github }

Vous pouvez essayer d'aider les autres avec leurs questions dans :

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

Dans de nombreux cas, vous connaissez peut-être déjà la réponse à ces questions. 🤓

Si vous aidez beaucoup de personnes avec leurs questions, vous deviendrez un [Expert FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank} officiel. 🎉

N'oubliez pas, le point le plus important est : essayez d'être aimable. Les gens viennent avec leurs frustrations et, dans bien des cas, ne posent pas la question de la meilleure façon, mais faites de votre mieux pour rester aimable. 🤗

L'idée est que la communauté **FastAPI** soit bienveillante et accueillante. En même temps, n'acceptez pas l'intimidation ni les comportements irrespectueux envers les autres. Nous devons prendre soin les uns des autres.

---

Voici comment aider les autres avec des questions (dans les discussions ou les issues) :

### Comprendre la question { #understand-the-question }

* Vérifiez si vous comprenez quel est l’**objectif** et le cas d'utilisation de la personne qui pose la question.

* Ensuite, vérifiez si la question (la grande majorité sont des questions) est **claire**.

* Dans de nombreux cas, la question porte sur une solution imaginaire de l'utilisateur, mais il pourrait y en avoir une **meilleure**. Si vous comprenez mieux le problème et le cas d'utilisation, vous pourriez suggérer une **solution alternative** plus adaptée.

* Si vous ne comprenez pas la question, demandez plus de **détails**.

### Reproduire le problème { #reproduce-the-problem }

Dans la plupart des cas et pour la plupart des questions, il y a quelque chose lié au **code original** de la personne.

Dans de nombreux cas, elle ne copiera qu'un fragment de code, mais ce n'est pas suffisant pour **reproduire le problème**.

* Vous pouvez leur demander de fournir un <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">exemple minimal, complet et vérifiable</a>, que vous pouvez **copier‑coller** et exécuter localement pour voir la même erreur ou le même comportement qu'ils observent, ou pour mieux comprendre leur cas d'utilisation.

* Si vous vous sentez très généreux, vous pouvez essayer de **créer un tel exemple** vous‑même, simplement à partir de la description du problème. Gardez simplement à l'esprit que cela peut prendre beaucoup de temps et qu'il peut être préférable de leur demander d'abord de clarifier le problème.

### Suggérer des solutions { #suggest-solutions }

* Après avoir compris la question, vous pouvez leur donner une **réponse** possible.

* Dans de nombreux cas, il est préférable de comprendre leur **problème sous‑jacent ou cas d'utilisation**, car il pourrait exister une meilleure façon de le résoudre que ce qu'ils essaient de faire.

### Demander la clôture { #ask-to-close }

S'ils répondent, il y a de fortes chances que vous ayez résolu leur problème, bravo, **vous êtes un héros** ! 🦸

* Maintenant, si cela a résolu leur problème, vous pouvez leur demander de :

    * Dans GitHub Discussions : marquer le commentaire comme **réponse**.
    * Dans GitHub Issues : **fermer** l'issue.

## Suivre le dépôt GitHub { #watch-the-github-repository }

Vous pouvez « watch » FastAPI sur GitHub (en cliquant sur le bouton « watch » en haut à droite) : <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Si vous sélectionnez « Watching » au lieu de « Releases only », vous recevrez des notifications lorsque quelqu'un crée une nouvelle issue ou question. Vous pouvez aussi préciser que vous ne souhaitez être notifié que pour les nouvelles issues, ou les discussions, ou les PR, etc.

Vous pouvez alors essayer de les aider à résoudre ces questions.

## Poser des questions { #ask-questions }

Vous pouvez <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">créer une nouvelle question</a> dans le dépôt GitHub, par exemple pour :

* Poser une **question** ou demander à propos d'un **problème**.
* Suggérer une nouvelle **fonctionnalité**.

**Remarque** : si vous le faites, je vais vous demander d'aider aussi les autres. 😉

## Relire des Pull Requests { #review-pull-requests }

Vous pouvez m'aider à relire les pull requests des autres.

Encore une fois, essayez autant que possible d'être aimable. 🤗

---

Voici ce à garder à l'esprit et comment relire une pull request :

### Comprendre le problème { #understand-the-problem }

* D'abord, assurez‑vous de **comprendre le problème** que la pull request essaie de résoudre. Il peut y avoir une discussion plus longue dans une GitHub Discussion ou une issue.

* Il y a aussi de bonnes chances que la pull request ne soit pas réellement nécessaire parce que le problème peut être résolu d'une **autre manière**. Vous pouvez alors le suggérer ou poser la question.

### Ne pas s'inquiéter du style { #dont-worry-about-style }

* Ne vous souciez pas trop des choses comme les styles de messages de commit, je ferai un squash and merge en personnalisant le commit manuellement.

* Ne vous inquiétez pas non plus des règles de style, il existe déjà des outils automatisés qui vérifient cela.

Et s'il y a d'autres besoins de style ou de cohérence, je le demanderai directement, ou j'ajouterai des commits par‑dessus avec les changements nécessaires.

### Vérifier le code { #check-the-code }

* Vérifiez et lisez le code, voyez s'il a du sens, **exécutez‑le localement** et voyez s'il résout effectivement le problème.

* Ensuite, **commentez** en disant que vous l'avez fait, c'est ainsi que je saurai que vous l'avez vraiment vérifié.

/// info

Malheureusement, je ne peux pas simplement faire confiance aux PR qui ont juste plusieurs approbations.

Plusieurs fois, il est arrivé qu'il y ait des PR avec 3, 5 ou plus approbations, probablement parce que la description est attrayante, mais lorsque je vérifie les PR, elles sont en fait cassées, ont un bug, ou ne résolvent pas le problème qu'elles prétendent résoudre. 😅

Donc, il est vraiment important que vous lisiez et exécutiez le code, et que vous me le disiez dans les commentaires. 🤓

///

* Si la PR peut être simplifiée d'une certaine manière, vous pouvez le demander, mais il n'est pas nécessaire d'être trop pointilleux, il peut y avoir beaucoup de points de vue subjectifs (et j'aurai les miens aussi 🙈), donc il est préférable de vous concentrer sur les choses fondamentales.

### Tests { #tests }

* Aidez‑moi à vérifier que la PR a des **tests**.

* Vérifiez que les tests **échouent** avant la PR. 🚨

* Puis vérifiez que les tests **réussissent** après la PR. ✅

* Beaucoup de PR n'ont pas de tests, vous pouvez leur **rappeler** d'ajouter des tests, ou même **suggérer** des tests vous‑même. C'est l'une des choses qui consomment le plus de temps et vous pouvez beaucoup aider.

* Commentez aussi ce que vous avez essayé, ainsi je saurai que vous l'avez vérifié. 🤓

## Créer une Pull Request { #create-a-pull-request }

Vous pouvez [contribuer](contributing.md){.internal-link target=_blank} au code source avec des Pull Requests, par exemple :

* Corriger une coquille que vous avez trouvée dans la documentation.
* Partager un article, une vidéo ou un podcast que vous avez créé ou trouvé à propos de FastAPI en <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">modifiant ce fichier</a>.
    * Vous devez vous assurer d'ajouter votre lien au début de la section correspondante.
* Aider à [traduire la documentation](contributing.md#translations){.internal-link target=_blank} dans votre langue.
    * Vous pouvez aussi aider à relire les traductions créées par d'autres.
* Proposer de nouvelles sections de documentation.
* Corriger une issue/un bug existant.
    * Vous devez ajouter des tests.
* Ajouter une nouvelle fonctionnalité.
    * Vous devez ajouter des tests.
    * Vous devez ajouter de la documentation si c'est pertinent.

## Aider à maintenir FastAPI { #help-maintain-fastapi }

Aidez‑moi à maintenir **FastAPI** ! 🤓

Il y a beaucoup de travail à faire, et pour la plupart, **VOUS** pouvez le faire.

Les principales tâches que vous pouvez faire dès maintenant sont :

* [Aider les autres avec des questions sur GitHub](#help-others-with-questions-in-github){.internal-link target=_blank} (voir la section ci‑dessus).
* [Relire des Pull Requests](#review-pull-requests){.internal-link target=_blank} (voir la section ci‑dessus).

Ces deux tâches sont celles qui **consomment le plus de temps**. C'est le travail principal de la maintenance de FastAPI.

Si vous pouvez m'aider avec cela, **vous m'aidez à maintenir FastAPI** et à vous assurer qu'il continue **d'avancer plus vite et mieux**. 🚀

## Rejoindre le chat { #join-the-chat }

Rejoignez le 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">serveur Discord</a> 👥 et échangez avec d'autres membres de la communauté FastAPI.

/// tip | Astuce

Pour les questions, posez‑les dans <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>, vous avez bien plus de chances de recevoir de l'aide par les [Experts FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}.

Utilisez le chat uniquement pour d'autres conversations générales.

///

### N'utilisez pas le chat pour les questions { #dont-use-the-chat-for-questions }

Gardez à l'esprit que, comme les chats permettent une « conversation libre », il est facile de poser des questions trop générales et plus difficiles à répondre ; vous pourriez donc ne pas recevoir de réponses.

Sur GitHub, le modèle vous guidera pour rédiger la bonne question afin que vous puissiez plus facilement obtenir une bonne réponse, ou même résoudre le problème vous‑même avant de demander. Et sur GitHub, je peux m'assurer de toujours tout répondre, même si cela prend du temps. Je ne peux pas personnellement faire cela avec les systèmes de chat. 😅

Les conversations dans les systèmes de chat ne sont pas non plus aussi facilement recherchables que sur GitHub, donc les questions et réponses peuvent se perdre dans la conversation. Et seules celles sur GitHub comptent pour devenir un [Expert FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}, vous aurez donc très probablement plus d'attention sur GitHub.

D'un autre côté, il y a des milliers d'utilisateurs dans les systèmes de chat, il y a donc de fortes chances que vous trouviez presque toujours quelqu'un avec qui parler. 😄

## Sponsoriser l'auteur { #sponsor-the-author }

Si votre **produit/entreprise** dépend de **FastAPI** ou y est lié et que vous souhaitez atteindre ses utilisateurs, vous pouvez sponsoriser l'auteur (moi) via <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a>. Selon le niveau, vous pourriez obtenir des avantages supplémentaires, comme un badge dans la documentation. 🎁

---

Merci ! 🚀
