# デプロイメントのコンセプト { #deployments-concepts }

**FastAPI**を用いたアプリケーションをデプロイするとき、もしくはどのようなタイプのWeb APIであっても、おそらく気になるコンセプトがいくつかあります。

それらを活用することでアプリケーションを**デプロイするための最適な方法**を見つけることができます。

重要なコンセプトのいくつかを紹介します:

* セキュリティ - HTTPS
* 起動時の実行
* 再起動
* レプリケーション（実行中のプロセス数）
* メモリ
* 開始前の事前のステップ

これらが**デプロイメント**にどのような影響を与えるかを見ていきましょう。

最終的な目的は、**安全な方法で**APIクライアントに**サービスを提供**し、**中断を回避**するだけでなく、**計算リソース**（例えばリモートサーバー/仮想マシン）を可能な限り効率的に使用することです。 🚀

この章では前述した**コンセプト**についてそれぞれ説明します。

この説明を通して、普段とは非常に異なる環境や存在しないであろう**将来の**環境に対し、デプロイの方法を決める上で必要な**直感**を与えてくれることを願っています。

これらのコンセプトを意識することにより、**あなた自身のAPI**をデプロイするための最適な方法を**評価**し、**設計**することができるようになるでしょう。

次の章では、FastAPIアプリケーションをデプロイするための**具体的なレシピ**を紹介します。

しかし、今はこれらの重要な**コンセプトに基づくアイデア**を確認しましょう。これらのコンセプトは、他のどのタイプのWeb APIにも当てはまります。💡

## セキュリティ - HTTPS { #security-https }

[前チャプターのHTTPSについて](https.md){.internal-link target=_blank}では、HTTPSがどのようにAPIを暗号化するのかについて学びました。

通常、アプリケーションサーバにとって**外部の**コンポーネントである**TLS Termination Proxy**によって提供されることが一般的です。このプロキシは通信の暗号化を担当します。

さらに、HTTPS証明書の更新を担当するものが必要で、同じコンポーネントが担当することもあれば、別のコンポーネントが担当することもあります。

### HTTPS 用ツールの例 { #example-tools-for-https }
TLS Termination Proxyとして使用できるツールには以下のようなものがあります：

* Traefik
    * 証明書の更新を自動的に処理 ✨
* Caddy
    * 証明書の更新を自動的に処理 ✨
* Nginx
    * 証明書更新のためにCertbotのような外部コンポーネントを使用
* HAProxy
    * 証明書更新のためにCertbotのような外部コンポーネントを使用
* Nginx のような Ingress Controller を持つ Kubernetes
    * 証明書の更新に cert-manager のような外部コンポーネントを使用
* クラウド・プロバイダーがサービスの一部として内部的に処理（下記を参照👇）

もう1つの選択肢は、HTTPSのセットアップを含んだより多くの作業を行う**クラウド・サービス**を利用することです。 このサービスには制限があったり、料金が高くなったりする可能性があります。しかしその場合、TLS Termination Proxyを自分でセットアップする必要はないです。

次の章で具体例をいくつか紹介します。

---

次に考慮すべきコンセプトは、実際のAPIを実行するプログラム（例：Uvicorn）に関連するものすべてです。

## プログラム と プロセス { #program-and-process }

私たちは「**プロセス**」という言葉についてたくさん話すので、その意味や「**プログラム**」という言葉との違いを明確にしておくと便利です。

### プログラムとは何か { #what-is-a-program }

**プログラム**という言葉は、一般的にいろいろなものを表現するのに使われます：

* プログラマが書く**コード**、**Pythonファイル**
* OSによって実行することができるファイル（例: `python`, `python.exe` or `uvicorn`）
* OS上で**実行**している間、CPUを使用し、メモリ上に何かを保存する特定のプログラム（**プロセス**とも呼ばれる）

### プロセスとは何か { #what-is-a-process }

**プロセス**という言葉は通常、より具体的な意味で使われ、OSで実行されているものだけを指します（先ほどの最後の説明のように）：

* OS上で**実行**している特定のプログラム
    * これはファイルやコードを指すのではなく、OSによって**実行**され、管理されているものを指します。
* どんなプログラムやコードも、それが**実行されているときにだけ機能**します。つまり、**プロセスとして実行されているときだけ**です。
* プロセスは、ユーザーにあるいはOSによって、 **終了**（あるいは "kill"）させることができます。その時点で、プロセスは実行/実行されることを停止し、それ以降は**何もできなくなります**。
* コンピュータで実行されている各アプリケーションは、実行中のプログラムや各ウィンドウなど、その背後にいくつかのプロセスを持っています。そして通常、コンピュータが起動している間、**多くのプロセスが**同時に実行されています。
* **同じプログラム**の**複数のプロセス**が同時に実行されていることがあります。

OSの「タスク・マネージャー」や「システム・モニター」（または同様のツール）を確認すれば、これらのプロセスの多くが実行されているの見ることができるでしょう。

例えば、同じブラウザプログラム（Firefox、Chrome、Edgeなど）を実行しているプロセスが複数あることがわかります。通常、1つのタブにつき1つのプロセスが実行され、さらに他のプロセスも実行されます。

<img class="shadow" src="/img/deployment/concepts/image01.png">

---

さて、**プロセス**と**プログラム**という用語の違いを確認したところで、デプロイメントについて話を続けます。

## 起動時の実行 { #running-on-startup }

ほとんどの場合、Web APIを作成するときは、クライアントがいつでもアクセスできるように、**常に**中断されることなく**実行される**ことを望みます。もちろん、特定の状況でのみ実行させたい特別な理由がある場合は別ですが、その時間のほとんどは、常に実行され、**利用可能**であることを望みます。

### リモートサーバー上での実行 { #in-a-remote-server }

リモートサーバー（クラウドサーバー、仮想マシンなど）をセットアップするときにできる最も簡単なことは、ローカルで開発するときと同じように、`fastapi run`（Uvicornを使用します）や同様のものを手動で実行することです。

そしてこれは動作し、**開発中**には役に立つでしょう。

しかし、サーバーへの接続が切れた場合、**実行中のプロセス**はおそらくダウンしてしまうでしょう。

そしてサーバーが再起動された場合（アップデートやクラウドプロバイダーからのマイグレーションの後など）、おそらくあなたはそれに**気づかないでしょう**。そのため、プロセスを手動で再起動しなければならないことすら気づかないでしょう。つまり、APIはダウンしたままなのです。😱

### 起動時に自動的に実行 { #run-automatically-on-startup }

一般的に、サーバープログラム（Uvicornなど）はサーバー起動時に自動的に開始され、**人の介入**を必要とせずに、APIと一緒にプロセスが常に実行されるようにしたいと思われます（UvicornがFastAPIアプリを実行するなど）。

### 別のプログラムの用意 { #separate-program }

これを実現するために、通常は**別のプログラム**を用意し、起動時にアプリケーションが実行されるようにします。そして多くの場合、他のコンポーネントやアプリケーション、例えばデータベースも実行されるようにします。

### 起動時に実行するツールの例 { #example-tools-to-run-at-startup }

実行するツールの例をいくつか挙げます:

* Docker
* Kubernetes
* Docker Compose
* Swarm モードによる Docker
* Systemd
* Supervisor
* クラウドプロバイダーがサービスの一部として内部的に処理
* そのほか...

次の章で、より具体的な例を挙げていきます。

## 再起動 { #restarts }

起動時にアプリケーションが実行されることを確認するのと同様に、失敗後にアプリケーションが**再起動**されることも確認したいと思われます。

### 我々は間違いを犯す { #we-make-mistakes }

私たち人間は常に**間違い**を犯します。ソフトウェアには、ほとんど常に**バグ**があらゆる箇所に隠されています。🐛

そして私たち開発者は、それらのバグを見つけたり新しい機能を実装したりしながらコードを改善し続けます（新しいバグも追加してしまうかもしれません😅）。

### 小さなエラーは自動的に処理される { #small-errors-automatically-handled }

FastAPIでWeb APIを構築する際に、コードにエラーがある場合、FastAPIは通常、エラーを引き起こした単一のリクエストにエラーを含めます。🛡

クライアントはそのリクエストに対して**500 Internal Server Error**を受け取りますが、アプリケーションは完全にクラッシュするのではなく、次のリクエストのために動作を続けます。

### 重大なエラー - クラッシュ { #bigger-errors-crashes }

しかしながら、**アプリケーション全体をクラッシュさせるようなコードを書いて**UvicornとPythonをクラッシュさせるようなケースもあるかもしれません。💥

それでも、ある箇所でエラーが発生したからといって、アプリケーションを停止させたままにしたくないでしょう。 少なくとも壊れていない*path operation*については、**実行し続けたい**はずです。

### クラッシュ後の再起動 { #restart-after-crash }

しかし、実行中の**プロセス**をクラッシュさせるような本当にひどいエラーの場合、少なくとも2〜3回ほどプロセスを**再起動**させる外部コンポーネントが必要でしょう。

/// tip | 豆知識

...とはいえ、アプリケーション全体が**すぐにクラッシュする**のであれば、いつまでも再起動し続けるのは意味がないでしょう。しかし、その場合はおそらく開発中か少なくともデプロイ直後に気づくと思われます。

そこで、**将来**クラッシュする可能性があり、それでも再スタートさせることに意味があるような、主なケースに焦点を当ててみます。

///

あなたはおそらく**外部コンポーネント**がアプリケーションの再起動を担当することを望むと考えます。 なぜなら、その時点でUvicornとPythonを使った同じアプリケーションはすでにクラッシュしており、同じアプリケーションの同じコードに対して何もできないためです。

### 自動的に再起動するツールの例 { #example-tools-to-restart-automatically }

ほとんどの場合、前述した**起動時にプログラムを実行する**ために使用されるツールは、自動で**再起動**することにも利用されます。

例えば、次のようなものがあります：

* Docker
* Kubernetes
* Docker Compose
* Swarm モードによる Docker
* Systemd
* Supervisor
* クラウドプロバイダーがサービスの一部として内部的に処理
* そのほか...

## レプリケーション - プロセスとメモリ { #replication-processes-and-memory }

FastAPI アプリケーションでは、Uvicorn を実行する `fastapi` コマンドのようなサーバープログラムを使用し、**1つのプロセス**で1度に複数のクライアントに同時に対応できます。

しかし、多くの場合、複数のワーカー・プロセスを同時に実行したいと考えるでしょう。

### 複数のプロセス - Worker { #multiple-processes-workers }

クライアントの数が単一のプロセスで処理できる数を超えており（たとえば仮想マシンがそれほど大きくない場合）、かつサーバーの CPU に**複数のコア**がある場合、同じアプリケーションで同時に**複数のプロセス**を実行させ、すべてのリクエストを分散させることができます。

同じAPIプログラムの**複数のプロセス**を実行する場合、それらは一般的に**Worker／ワーカー**と呼ばれます。

### ワーカー・プロセス と ポート { #worker-processes-and-ports }

[HTTPSについて](https.md){.internal-link target=_blank}のドキュメントで、1つのサーバーで1つのポートとIPアドレスの組み合わせでリッスンできるのは1つのプロセスだけであることを覚えていますでしょうか？

これはいまだに同じです。

そのため、**複数のプロセス**を同時に持つには**ポートでリッスンしている単一のプロセス**が必要であり、それが何らかの方法で各ワーカー・プロセスに通信を送信することが求められます。

### プロセスあたりのメモリ { #memory-per-process }

さて、プログラムがメモリにロードする際には、例えば機械学習モデルや大きなファイルの内容を変数に入れたりする場合では、**サーバーのメモリ（RAM）**を少し消費します。

そして複数のプロセスは通常、**メモリを共有しません**。これは、実行中の各プロセスがそれぞれ独自の変数やメモリ等を持っていることを意味します。つまり、コード内で大量のメモリを消費している場合、**各プロセス**は同等の量のメモリを消費することになります。

### サーバーメモリ { #server-memory }

例えば、あなたのコードが **1GBのサイズの機械学習モデル**をロードする場合、APIで1つのプロセスを実行すると、少なくとも1GBのRAMを消費します。

また、**4つのプロセス**（4つのワーカー）を起動すると、それぞれが1GBのRAMを消費します。つまり、合計でAPIは**4GBのRAM**を消費することになります。

リモートサーバーや仮想マシンのRAMが3GBしかない場合、4GB以上のRAMをロードしようとすると問題が発生します。🚨

### 複数プロセス - 例 { #multiple-processes-an-example }

この例では、2つの**ワーカー・プロセス**を起動し制御する**マネージャー・ プロセス**があります。

このマネージャー・ プロセスは、おそらくIPの**ポート**でリッスンしているものです。そして、すべての通信をワーカー・プロセスに転送します。

これらのワーカー・プロセスは、アプリケーションを実行するものであり、**リクエスト**を受けて**レスポンス**を返すための主要な計算を行い、あなたが変数に入れたものは何でもRAMにロードします。

<img src="/img/deployment/concepts/process-ram.drawio.svg">

そしてもちろん、同じマシンでは、あなたのアプリケーションとは別に、**他のプロセス**も実行されているでしょう。

興味深いことに、各プロセスが使用する**CPU**の割合は時間とともに大きく**変動**する可能性がありますが、**メモリ（RAM）**は通常、多かれ少なかれ**安定**します。

毎回同程度の計算を行うAPIがあり、多くのクライアントがいるのであれば、**CPU使用率**もおそらく**安定**するでしょう（常に急激に上下するのではなく）。

### レプリケーション・ツールと戦略の例 { #examples-of-replication-tools-and-strategies }

これを実現するにはいくつかのアプローチがありますが、具体的な戦略については次の章(Dockerやコンテナの章など)で詳しく説明します。

考慮すべき主な制約は、**パブリックIP**の**ポート**を処理する**単一の**コンポーネントが存在しなければならないということです。

そして、レプリケートされた**プロセス/ワーカー**に通信を**送信**する方法を持つ必要があります。

考えられる組み合わせと戦略をいくつか紹介します：

* `--workers` を指定した **Uvicorn**
    * 1つのUvicornの**プロセスマネージャー**が**IP**と**ポート**をリッスンし、**複数のUvicornワーカー・プロセス**を起動する。
* **Kubernetes**やその他の分散**コンテナ・システム**
    * **Kubernetes**レイヤーの何かが**IP**と**ポート**をリッスンする。レプリケーションは、**複数のコンテナ**にそれぞれ**1つのUvicornプロセス**を実行させることで行われる。
* **クラウド・サービス**によるレプリケーション
    * クラウド・サービスはおそらく**あなたのためにレプリケーションを処理**します。**実行するプロセス**や使用する**コンテナイメージ**を定義できるかもしれませんが、いずれにせよ、それはおそらく**単一のUvicornプロセス**であり、クラウドサービスはそのレプリケーションを担当するでしょう。

/// tip | 豆知識

これらの**コンテナ**やDockerそしてKubernetesに関する項目が、まだあまり意味をなしていなくても心配しないでください。

コンテナ・イメージ、Docker、Kubernetesなどについては、将来の章で詳しく説明します: [コンテナ内のFastAPI - Docker](docker.md){.internal-link target=_blank}.

///

## 開始前の事前のステップ { #previous-steps-before-starting }

アプリケーションを**開始する前**に、いくつかのステップを実行したい場合が多くあります。

例えば、**データベース・マイグレーション** を実行したいかもしれません。

しかしほとんどの場合、これらの手順を**1度**に実行したいと考えるでしょう。

そのため、アプリケーションを開始する前の**事前のステップ**を実行する**単一のプロセス**を用意したいと思われます。

そして、それらの事前のステップを実行しているのが単一のプロセスであることを確認する必要があります。このことはその後アプリケーション自体のために**複数のプロセス**（複数のワーカー）を起動した場合も同様です。

これらのステップが**複数のプロセス**によって実行された場合、**並列**に実行されることによって作業が**重複**することになります。そして、もしそのステップがデータベースのマイグレーションのような繊細なものであった場合、互いに競合を引き起こす可能性があります。

もちろん、事前のステップを何度も実行しても問題がない場合もあり、その際は対処がかなり楽になります。

/// tip | 豆知識

また、セットアップによっては、アプリケーションを開始する前の**事前のステップ**が必要ない場合もあることを覚えておいてください。

その場合は、このようなことを心配する必要はないです。🤷

///

### 事前ステップの戦略例 { #examples-of-previous-steps-strategies }

これは**システムを**デプロイする方法に**大きく依存**するだろうし、おそらくプログラムの起動方法や再起動の処理などにも関係してくるでしょう。

考えられるアイデアをいくつか挙げてみます：

* アプリコンテナの前に実行されるKubernetesのInitコンテナ
* 事前のステップを実行し、アプリケーションを起動するbashスクリプト
    * 利用するbashスクリプトを起動／再起動したり、エラーを検出したりする方法は以前として必要になるでしょう。

/// tip | 豆知識

コンテナを使った具体的な例については、将来の章で紹介します: [コンテナ内のFastAPI - Docker](docker.md){.internal-link target=_blank}.

///

## リソースの利用 { #resource-utilization }

あなたのサーバーは**リソース**であり、プログラムを実行しCPUの計算時間や利用可能なRAMメモリを消費または**利用**することができます。

システムリソースをどれくらい消費／利用したいですか？ 「少ない方が良い」と考えるのは簡単かもしれないですが、実際には、**クラッシュせずに可能な限り**最大限に活用したいでしょう。

3台のサーバーにお金を払っているにも関わらず、そのRAMとCPUを少ししか使っていないとしたら、おそらく**お金を無駄にしている** 💸、おそらく**サーバーの電力を無駄にしている** 🌎ことになるでしょう。

その場合は、サーバーを2台だけにして、そのリソース（CPU、メモリ、ディスク、ネットワーク帯域幅など）をより高い割合で使用する方がよいでしょう。

一方、2台のサーバーがあり、そのCPUとRAMの**100%を使用している**場合、ある時点で1つのプロセスがより多くのメモリを要求し、サーバーはディスクを「メモリ」として使用しないといけません。（何千倍も遅くなる可能性があります。）
もしくは**クラッシュ**することもあれば、あるいはあるプロセスが何らかの計算をする必要があり、そしてCPUが再び空くまで待たなければならないかもしれません。

この場合、**1つ余分なサーバー**を用意し、その上でいくつかのプロセスを実行し、すべてのサーバーが**十分なRAMとCPU時間を持つようにする**のがよいでしょう。

また、何らかの理由でAPIの利用が急増する可能性もあります。もしかしたらそれが流行ったのかもしれないし、他のサービスやボットが使い始めたのかもしれないです。そのような場合に備えて、余分なリソースを用意しておくと安心でしょう。

例えば、リソース使用率の**50%から90%の範囲**で**任意の数字**をターゲットとすることができます。

重要なのは、デプロイメントを微調整するためにターゲットを設定し測定することが、おそらく使用したい主要な要素であることです。

`htop`のような単純なツールを使って、サーバーで使用されているCPUやRAM、あるいは各プロセスで使用されている量を見ることができます。あるいは、より複雑な監視ツールを使って、サーバに分散して使用することもできます。

## まとめ { #recap }

アプリケーションのデプロイ方法を決定する際に、考慮すべきであろう主要なコンセプトのいくつかを紹介していきました：

* セキュリティ - HTTPS
* 起動時の実行
* 再起動
* レプリケーション（実行中のプロセス数）
* メモリ
* 開始前の事前ステップ

これらの考え方とその適用方法を理解することで、デプロイメントを設定したり調整したりする際に必要な直感的な判断ができるようになるはずです。🤓

次のセクションでは、あなたが取り得る戦略について、より具体的な例を挙げます。🚀
