# Користувацькі статичні ресурси інтерфейсу документації (самохостинг) { #custom-docs-ui-static-assets-self-hosting }

Документація API використовує **Swagger UI** і **ReDoc**, і кожному з них потрібні файли JavaScript та CSS.

Типово ці файли віддаються з <abbr title="Content Delivery Network - Мережа доставки контенту: Сервіс, зазвичай складений з кількох серверів, що надає статичні файли, як-от JavaScript і CSS. Його зазвичай використовують, щоб віддавати ці файли з сервера, ближчого до клієнта, покращуючи продуктивність.">CDN</abbr>.

Але це можна налаштувати: ви можете вказати конкретний CDN або віддавати файли самостійно.

## Власний CDN для JavaScript і CSS { #custom-cdn-for-javascript-and-css }

Припустімо, що ви хочете використовувати інший <abbr title="Content Delivery Network - Мережа доставки контенту">CDN</abbr>, наприклад `https://unpkg.com/`.

Це може бути корисно, якщо, наприклад, ви живете в країні, що обмежує деякі URL-адреси.

### Вимкніть автоматичну документацію { #disable-the-automatic-docs }

Перший крок - вимкнути автоматичну документацію, адже типово вона використовує стандартний CDN.

Щоб їх вимкнути, встановіть їхні URL у `None` під час створення вашого застосунку `FastAPI`:

{* ../../docs_src/custom_docs_ui/tutorial001_py310.py hl[8] *}

### Додайте користувацьку документацію { #include-the-custom-docs }

Тепер ви можете створити *операції шляху* для користувацької документації.

Ви можете перевикористати внутрішні функції FastAPI для створення HTML-сторінок документації і передати їм потрібні аргументи:

- `openapi_url`: URL, за яким HTML-сторінка документації зможе отримати схему OpenAPI для вашого API. Тут можна використати атрибут `app.openapi_url`.
- `title`: заголовок вашого API.
- `oauth2_redirect_url`: тут можна використати `app.swagger_ui_oauth2_redirect_url`, щоб узяти значення за замовчуванням.
- `swagger_js_url`: URL, за яким HTML для Swagger UI зможе отримати файл **JavaScript**. Це URL вашого користувацького CDN.
- `swagger_css_url`: URL, за яким HTML для Swagger UI зможе отримати файл **CSS**. Це URL вашого користувацького CDN.

Аналогічно для ReDoc...

{* ../../docs_src/custom_docs_ui/tutorial001_py310.py hl[2:6,11:19,22:24,27:33] *}

/// tip | Порада

*Операція шляху* для `swagger_ui_redirect` - це допоміжний маршрут, коли ви використовуєте OAuth2.

Якщо ви інтегруєте ваш API з провайдером OAuth2, ви зможете автентифікуватися і повернутися до документації API з отриманими обліковими даними. І взаємодіяти з ним, використовуючи реальну автентифікацію OAuth2.

Swagger UI впорається з цим «за лаштунками», але йому потрібен цей «redirect» хелпер.

///

### Створіть операцію шляху для перевірки { #create-a-path-operation-to-test-it }

Тепер, щоб перевірити, що все працює, створіть *операцію шляху*:

{* ../../docs_src/custom_docs_ui/tutorial001_py310.py hl[36:38] *}

### Перевірте { #test-it }

Тепер ви маєте змогу відкрити документацію за <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a> і перезавантажити сторінку, вона завантажить ці ресурси з нового CDN.

## Самохостинг JavaScript і CSS для документації { #self-hosting-javascript-and-css-for-docs }

Самохостинг JavaScript і CSS може бути корисним, якщо, наприклад, ваш застосунок має працювати офлайн, без доступу до Інтернету, або в локальній мережі.

Тут ви побачите, як віддавати ці файли самостійно, у тому самому застосунку FastAPI, і налаштувати документацію на їх використання.

### Структура файлів проєкту { #project-file-structure }

Припустімо, що структура файлів вашого проєкту виглядає так:

```
.
├── app
│   ├── __init__.py
│   ├── main.py
```

Тепер створіть каталог для збереження цих статичних файлів.

Нова структура файлів може виглядати так:

```
.
├── app
│   ├── __init__.py
│   ├── main.py
└── static/
```

### Завантажте файли { #download-the-files }

Завантажте статичні файли, потрібні для документації, і помістіть їх у каталог `static/`.

Ви, ймовірно, можете натиснути правою кнопкою на кожному посиланні і вибрати опцію на кшталт «Зберегти посилання як...».

**Swagger UI** використовує файли:

- <a href="https://cdn.jsdelivr.net/npm/swagger-ui-dist@5/swagger-ui-bundle.js" class="external-link" target="_blank">`swagger-ui-bundle.js`</a>
- <a href="https://cdn.jsdelivr.net/npm/swagger-ui-dist@5/swagger-ui.css" class="external-link" target="_blank">`swagger-ui.css`</a>

А **ReDoc** використовує файл:

- <a href="https://cdn.jsdelivr.net/npm/redoc@2/bundles/redoc.standalone.js" class="external-link" target="_blank">`redoc.standalone.js`</a>

Після цього ваша структура файлів може виглядати так:

```
.
├── app
│   ├── __init__.py
│   ├── main.py
└── static
    ├── redoc.standalone.js
    ├── swagger-ui-bundle.js
    └── swagger-ui.css
```

### Обслуговуйте статичні файли { #serve-the-static-files }

- Імпортуйте `StaticFiles`.
- Змонтуйте екземпляр `StaticFiles()` у певному шляху.

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[7,11] *}

### Перевірте статичні файли { #test-the-static-files }

Запустіть ваш застосунок і перейдіть до <a href="http://127.0.0.1:8000/static/redoc.standalone.js" class="external-link" target="_blank">http://127.0.0.1:8000/static/redoc.standalone.js</a>.

Ви маєте побачити дуже довгий файл JavaScript для **ReDoc**.

Він може починатися приблизно так:

```JavaScript
/*! For license information please see redoc.standalone.js.LICENSE.txt */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(require("null")):
...
```

Це підтверджує, що ви можете віддавати статичні файли з вашого застосунку і що ви розмістили статичні файли для документації у правильному місці.

Тепер ми можемо налаштувати застосунок на використання цих статичних файлів для документації.

### Вимкніть автоматичну документацію для статичних файлів { #disable-the-automatic-docs-for-static-files }

Як і при використанні користувацького CDN, першим кроком є вимкнення автоматичної документації, оскільки типово вона використовує CDN.

Щоб їх вимкнути, встановіть їхні URL у `None` під час створення вашого застосунку `FastAPI`:

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[9] *}

### Додайте користувацьку документацію для статичних файлів { #include-the-custom-docs-for-static-files }

Аналогічно користувацькому CDN, тепер ви можете створити *операції шляху* для користувацької документації.

Знову ж, ви можете перевикористати внутрішні функції FastAPI для створення HTML-сторінок документації і передати їм потрібні аргументи:

- `openapi_url`: URL, за яким HTML-сторінка документації зможе отримати схему OpenAPI для вашого API. Тут можна використати атрибут `app.openapi_url`.
- `title`: заголовок вашого API.
- `oauth2_redirect_url`: тут можна використати `app.swagger_ui_oauth2_redirect_url`, щоб узяти значення за замовчуванням.
- `swagger_js_url`: URL, за яким HTML для Swagger UI зможе отримати файл **JavaScript**. **Це той файл, який тепер віддає ваш власний застосунок**.
- `swagger_css_url`: URL, за яким HTML для Swagger UI зможе отримати файл **CSS**. **Це той файл, який тепер віддає ваш власний застосунок**.

Аналогічно для ReDoc...

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[2:6,14:22,25:27,30:36] *}

/// tip | Порада

*Операція шляху* для `swagger_ui_redirect` - це допоміжний маршрут, коли ви використовуєте OAuth2.

Якщо ви інтегруєте ваш API з провайдером OAuth2, ви зможете автентифікуватися і повернутися до документації API з отриманими обліковими даними. І взаємодіяти з ним, використовуючи реальну автентифікацію OAuth2.

Swagger UI впорається з цим «за лаштунками», але йому потрібен цей «redirect» хелпер.

///

### Створіть операцію шляху для перевірки статичних файлів { #create-a-path-operation-to-test-static-files }

Тепер, щоб перевірити, що все працює, створіть *операцію шляху*:

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[39:41] *}

### Перевірте UI зі статичними файлами { #test-static-files-ui }

Тепер ви маєте змогу вимкнути WiFi, відкрити документацію за <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a> і перезавантажити сторінку.

І навіть без Інтернету ви зможете побачити документацію для вашого API і взаємодіяти з ним.
