# Параметри заголовків { #header-parameters }

Ви можете визначати параметри заголовків так само, як визначаєте параметри `Query`, `Path` і `Cookie`.

## Імпорт `Header` { #import-header }

Спочатку імпортуйте `Header`:

{* ../../docs_src/header_params/tutorial001_an_py310.py hl[3] *}

## Оголошення параметрів `Header` { #declare-header-parameters }

Потім оголосіть параметри заголовків, використовуючи ту ж структуру, що й для `Path`, `Query` та `Cookie`.

Ви можете визначити значення за замовчуванням, а також усі додаткові параметри валідації або анотації:

{* ../../docs_src/header_params/tutorial001_an_py310.py hl[9] *}

/// note | Технічні деталі

`Header` є «сестринським» класом для `Path`, `Query` і `Cookie`. Він також успадковується від того ж спільного класу `Param`.

Але пам’ятайте, що коли ви імпортуєте `Query`, `Path`, `Header` та інші з `fastapi`, то насправді це функції, які повертають спеціальні класи.

///

/// info | Інформація

Щоб оголосити заголовки, потрібно використовувати `Header`, інакше параметри будуть інтерпретуватися як параметри запиту.

///

## Автоматичне перетворення { #automatic-conversion }

`Header` має трохи додаткової функціональності порівняно з тим, що надають `Path`, `Query` та `Cookie`.

Більшість стандартних заголовків розділяються символом «дефіс», також відомим як «символ мінуса» (`-`).

Але змінна, така як `user-agent`, є недійсною в Python.

Тому, за замовчуванням, `Header` перетворюватиме символи підкреслення (`_`) у назвах параметрів на дефіси (`-`), щоб отримувати та документувати заголовки.

Також заголовки HTTP не чутливі до регістру, тож ви можете оголошувати їх у стандартному стилі Python (також відомому як «snake_case»).

Тому ви можете використовувати `user_agent`, як зазвичай у коді Python, замість того щоб потрібно було писати з великої літери перші літери, як `User_Agent` або щось подібне.

Якщо з якоїсь причини вам потрібно вимкнути автоматичне перетворення підкреслень на дефіси, встановіть параметр `convert_underscores` у `Header` в `False`:

{* ../../docs_src/header_params/tutorial002_an_py310.py hl[10] *}

/// warning | Попередження

Перед тим як встановити `convert_underscores` в `False`, пам’ятайте, що деякі HTTP-представники та сервери забороняють використання заголовків із підкресленнями.

///

## Дубльовані заголовки { #duplicate-headers }

Можливо отримати дубльовані заголовки. Тобто один і той самий заголовок із кількома значеннями.

Ви можете визначити такі випадки, використовуючи список у типізації.

Ви отримаєте всі значення дубльованого заголовка у вигляді Python-`list`.

Наприклад, щоб оголосити заголовок `X-Token`, який може з’являтися більше ніж один раз, ви можете написати:

{* ../../docs_src/header_params/tutorial003_an_py310.py hl[9] *}

Якщо ви взаємодієте з цією *операцією шляху*, надсилаючи два HTTP-заголовки, наприклад:

```
X-Token: foo
X-Token: bar
```

Відповідь буде така:

```JSON
{
    "X-Token values": [
        "bar",
        "foo"
    ]
}
```

## Підсумок { #recap }

Оголошуйте заголовки за допомогою `Header`, використовуючи той самий загальний підхід, що й для `Query`, `Path` та `Cookie`.

І не хвилюйтеся про підкреслення у ваших змінних — **FastAPI** подбає про їх перетворення.
