# npm CLI Contributor Roles and Responsibilities

## Table of Contents

* [Introduction](#introduction)
* [Roles](#roles)
  * [Community Members](#community-members)
  * [Collaborators](#collaborators)
  * [npm, Inc Employeees](#npm-inc-employees)


## Introduction

Welcome to the npm CLI Contributor Guide! This document outlines the npm CLI repository's process for community interaction and contribution. This includes the issue tracker, pull requests, wiki pages, and, to a certain extent, outside communication in the context of the npm CLI. It defines roles, responsibilities, and procedures, and is an entry point for anyone wishing to contribute their time and effort to making npm a better tool for the JavaScript community!

All interactions in the npm repository are covered by the [npm Code of Conduct](https://www.npmjs.com/policies/conduct)

## Roles

There are three main roles for people participating in the npm issue tracker. Each has a specific set of abilities and responsibilities: [Community members](#community-members), [Collaborators](#collaborators), and [npm, Inc employees](#npm-inc-employees).

Failure to comply with the expected responsibilities of each role, or violating the Code of Conduct will result in punitive action relative to the transgression, ranging from a warning to full removal from the project, at the discretion of npm employees.

### Community Members

This includes anyone who may show up to the npm/npm repo with issues, PRs, comments etc. They may not have any other involvement with npm.

#### Abilities

* Open issues and PRs
* Comment on issues and PRs

#### Responsibilities

* Comment on issues when they have a reference to the answer.
* If community members aren't sure they are correct and don't have a reference to the answer, please leave the issue and try another one.
* Defer to collaborators and npm employees for answers.
* Make sure to search for [the troubleshooting doc](./TROUBLESHOOTING.md) and search on the issue tracker for similar issues before opening a new one.
* Any users with urgent support needs are welcome to email support@npmjs.com, and our dedicated support team will be happy to help.

PLEASE don't @ collaborators or npm employees on issues. The CLI team is small, and has many outstanding commitments to fulfill.

### Collaborators

These are folks who have the ability to label and close issues. The role of collaborators may expand over time, but for now it is a limited (& important) role. This is an excellent way to contribute to npm without writing code.

Community members may become collaborators by showing consistent, proven track record of quality contributions to the project, a reasonable level of proficiency with the CLI, and regular participation through the tracker and other related mediums, including regular contact with the CLI team itself. This role entails a higher level of responsibility than community member, so we ask for a higher level of understanding and commitment.

Collaborators who become inactive for 3 months or longer may have their collaborator privileges removed until they are ready to return.

#### Abilities

* Label/triage new issues
* Respond to ongoing issues
* Close resolved issues.

#### Responsibilities

* Only answer questions when they know the answer, and provide a reference to the answer.
* If collaborators aren't totally confident about their answer, please leave the issue and try another one.
* If they've responded to an issue, it becomes their responsibility to see it to resolution.
* Close issues if there's no response within a month.
* Defer to fellow Collaborators & npm employees for answers (Again, please don't @ collaborators or npm employees, thank you!)
* Make sure to search for [the troubleshooting doc](./TROUBLESHOOTING.md) and search on the issue tracker for similar issues before opening a new one.

### npm, Inc Employees

Folks who work at npm, Inc, who have a responsibility to ensure the stability and functionality of the tools npm offers.

#### Abilities
* Label/triage new issues
* Respond to ongoing issues
* Close resolved issues
* Land PRs

Please note that this is a living document, and the CLI team will put up PRs to it as needed.

#### Responsibilities

* Preserve and promote the health of the CLI, the registry, the website, etc.

In special cases, [Collaborators](#collaborators) may request time to speak with an npm employee directly, by contacting them and coordinating a time/place.
