#version 440

layout(location = 0) in vec2 texCoord;
layout(location = 1) in vec2 fragCoord;
layout(location = 0) out vec4 fragColor;

layout(std140, binding = 0) uniform buf {
    mat4 qt_Matrix;
    float qt_Opacity;
    float iTime;
    float cloudsPerspective;
    float cloudsXScale;
    float cloudsYScale;
    vec4 cloudsHorizonColor;
    float cloudsHorizonGlowSize;
    vec4 cloudsColor;
    vec4 cloudsSkyColor;
    float cloudsThickness;
    float cloudsBrightness;
    float cloudsSharpness;
    float cloudsMovementAngle;
    float cloudsSpeed;
    float cloudsXSpeed;
    float cloudsYSpeed;
};

layout(binding = 1) uniform sampler2D cloudsTexture;

layout(location = 2) in float glowFactor;
layout(location = 3) in float z;
layout(location = 4) in vec2 tc;
layout(location = 5) in vec2 thresholds;

void main() {
    {
        vec4 texclouds = texture(cloudsTexture, fract(tc));
        texclouds.r = smoothstep(thresholds.s,  thresholds.t, texclouds.r) * cloudsBrightness;
        texclouds = mix(cloudsSkyColor, cloudsColor, texclouds.r);
        texclouds = mix(cloudsHorizonColor, texclouds, glowFactor);

        fragColor = texclouds;
    }
    fragColor = fragColor * qt_Opacity;
}
