/****************************************************************************
**
** Copyright (C) 2017 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Installer Framework.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef LIB7Z_CREATE_H
#define LIB7Z_CREATE_H

#include "installer_global.h"

#include <Common/MyCom.h>
#include <7zip/UI/Common/Update.h>

QT_BEGIN_NAMESPACE
class QFileDevice;
class QStringList;
QT_END_NAMESPACE

namespace Lib7z
{
    enum struct TmpFile {
        No,
        Yes
    };

    enum struct Compression {
        Non = 0,
        Fastest = 1,
        Fast = 3,
        Normal = 5,
        Maximum = 7,
        Ultra = 9
    };

    class INSTALLER_EXPORT UpdateCallback : public IUpdateCallbackUI2, public CMyUnknownImp
    {
        Q_DISABLE_COPY(UpdateCallback)

    public:
        UpdateCallback() = default;
        virtual ~UpdateCallback() {}

        MY_UNKNOWN_IMP
        INTERFACE_IUpdateCallbackUI2(;)
    };

    void INSTALLER_EXPORT createArchive(QFileDevice *archive, const QStringList &sources,
        Compression level = Compression::Normal, UpdateCallback *callback = 0);
    void INSTALLER_EXPORT createArchive(const QString &archive, const QStringList &sources,
        TmpFile mode, Compression level = Compression::Normal, UpdateCallback *callback = 0);

} // namespace Lib7z

#endif // LIB7Z_CREATE_H
