/* Copyright (c) 2009 Peter Troshin
 *  
 *  JAva Bioinformatics Analysis Web Services (JABAWS) @version: 1.0     
 * 
 *  This library is free software; you can redistribute it and/or modify it under the terms of the
 *  Apache License version 2 as published by the Apache Software Foundation
 * 
 *  This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 *  even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Apache 
 *  License for more details.
 * 
 *  A copy of the license is in apache_license.txt. It is also available here:
 * @see: http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * Any republication or derived work distributed in source code form
 * must include this copyright and license notice.
 */

package compbio.ws.client;

/**
 * List of web services currently supported by JABAWS version 1
 * 
 */
public enum Services {
    MafftWS, MuscleWS, ClustalWS, TcoffeeWS, ProbconsWS;

    public static Services getService(String servName) {
	servName = servName.trim().toLowerCase();
	if (servName.equalsIgnoreCase(MafftWS.toString())) {
	    return MafftWS;
	}
	if (servName.equalsIgnoreCase(ClustalWS.toString())) {
	    return ClustalWS;
	}
	if (servName.equalsIgnoreCase(TcoffeeWS.toString())) {
	    return TcoffeeWS;
	}
	if (servName.equalsIgnoreCase(MuscleWS.toString())) {
	    return MuscleWS;
	}
	if (servName.equalsIgnoreCase(ProbconsWS.toString())) {
	    return ProbconsWS;
	}
	return null;
    }

    public static Services getService(Class wsImplClass) {
	return getService(wsImplClass.getSimpleName());
    }

}