# Oauth2️⃣ ⏮️ 🔐 (&amp; 🔁), 📨 ⏮️ 🥙 🤝

🔜 👈 👥 ✔️ 🌐 💂‍♂ 💧, ➡️ ⚒ 🈸 🤙 🔐, ⚙️ <abbr title="JSON Web Tokens">🥙</abbr> 🤝 &amp; 🔐 🔐 🔁.

👉 📟 🕳 👆 💪 🤙 ⚙️ 👆 🈸, 🖊 🔐 #️⃣ 👆 💽, ♒️.

👥 🔜 ▶️ ⚪️➡️ 🌐❔ 👥 ◀️ ⏮️ 📃 &amp; 📈 ⚫️.

## 🔃 🥙

🥙 ⛓ "🎻 🕸 🤝".

⚫️ 🐩 🚫 🎻 🎚 📏 💧 🎻 🍵 🚀. ⚫️ 👀 💖 👉:

```
eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c
```

⚫️ 🚫 🗜,, 🙆 💪 🛡 ℹ ⚪️➡️ 🎚.

✋️ ⚫️ 🛑. , 🕐❔ 👆 📨 🤝 👈 👆 ♨, 👆 💪 ✔ 👈 👆 🤙 ♨ ⚫️.

👈 🌌, 👆 💪 ✍ 🤝 ⏮️ 👔, ➡️ 💬, 1️⃣ 🗓️. &amp; ⤴️ 🕐❔ 👩‍💻 👟 🔙 ⏭ 📆 ⏮️ 🤝, 👆 💭 👈 👩‍💻 🕹 👆 ⚙️.

⏮️ 🗓️, 🤝 🔜 🕛 &amp; 👩‍💻 🔜 🚫 ✔ &amp; 🔜 ✔️ 🛑 🔄 🤚 🆕 🤝. &amp; 🚥 👩‍💻 (⚖️ 🥉 🥳) 🔄 🔀 🤝 🔀 👔, 👆 🔜 💪 🔎 ⚫️, ↩️ 💳 🔜 🚫 🏏.

🚥 👆 💚 🤾 ⏮️ 🥙 🤝 &amp; 👀 ❔ 👫 👷, ✅ <a href="https://jwt.io/" class="external-link" target="_blank">https://jwt.io</a>.

## ❎ `python-jose`

👥 💪 ❎ `python-jose` 🏗 &amp; ✔ 🥙 🤝 🐍:

<div class="termy">

```console
$ pip install "python-jose[cryptography]"

---> 100%
```

</div>

<a href="https://github.com/mpdavis/python-jose" class="external-link" target="_blank">🐍-🇩🇬</a> 🚚 🔐 👩‍💻 ➕.

📥 👥 ⚙️ 👍 1️⃣: <a href="https://cryptography.io/" class="external-link" target="_blank">)/⚛</a>.

/// tip

👉 🔰 ⏪ ⚙️ <a href="https://pyjwt.readthedocs.io/" class="external-link" target="_blank">PyJWT</a>.

✋️ ⚫️ ℹ ⚙️ 🐍-🇩🇬 ↩️ ⚫️ 🚚 🌐 ⚒ ⚪️➡️ PyJWT ➕ ➕ 👈 👆 💪 💪 ⏪ 🕐❔ 🏗 🛠️ ⏮️ 🎏 🧰.

///

## 🔐 🔁

"🔁" ⛓ 🏭 🎚 (🔐 👉 💼) 🔘 🔁 🔢 (🎻) 👈 👀 💖 🙃.

🕐❔ 👆 🚶‍♀️ ⚫️❔ 🎏 🎚 (⚫️❔ 🎏 🔐) 👆 🤚 ⚫️❔ 🎏 🙃.

✋️ 👆 🚫🔜 🗜 ⚪️➡️ 🙃 🔙 🔐.

### ⚫️❔ ⚙️ 🔐 🔁

🚥 👆 💽 📎, 🧙‍♀ 🏆 🚫 ✔️ 👆 👩‍💻' 🔢 🔐, 🕴#️⃣.

, 🧙‍♀ 🏆 🚫 💪 🔄 ⚙️ 👈 🔐 ➕1️⃣ ⚙️ (📚 👩‍💻 ⚙️ 🎏 🔐 🌐, 👉 🔜 ⚠).

## ❎ `passlib`

🇸🇲 👑 🐍 📦 🍵 🔐#️⃣.

⚫️ 🐕‍🦺 📚 🔐 🔁 📊 &amp; 🚙 👷 ⏮️ 👫.

👍 📊 "🐡".

, ❎ 🇸🇲 ⏮️ 🐡:

<div class="termy">

```console
$ pip install "passlib[bcrypt]"

---> 100%
```

</div>

/// tip

⏮️ `passlib`, 👆 💪 🔗 ⚫️ 💪 ✍ 🔐 ✍ **✳**, **🏺** 💂‍♂ 🔌-⚖️ 📚 🎏.

, 👆 🔜 💪, 🖼, 💰 🎏 📊 ⚪️➡️ ✳ 🈸 💽 ⏮️ FastAPI 🈸. ⚖️ 📉 ↔ ✳ 🈸 ⚙️ 🎏 💽.

 &amp; 👆 👩‍💻 🔜 💪 💳 ⚪️➡️ 👆 ✳ 📱 ⚖️ ⚪️➡️ 👆 **FastAPI** 📱, 🎏 🕰.

///

##  #️⃣ &amp; ✔ 🔐

🗄 🧰 👥 💪 ⚪️➡️ `passlib`.

✍ 🇸🇲 "🔑". 👉 ⚫️❔ 🔜 ⚙️ #️⃣ &amp; ✔ 🔐.

/// tip

🇸🇲 🔑 ✔️ 🛠️ ⚙️ 🎏 🔁 📊, 🔌 😢 🗝 🕐 🕴 ✔ ✔ 👫, ♒️.

🖼, 👆 💪 ⚙️ ⚫️ ✍ &amp; ✔ 🔐 🏗 ➕1️⃣ ⚙️ (💖 ✳) ✋️ #️⃣ 🙆 🆕 🔐 ⏮️ 🎏 📊 💖 🐡.

 &amp; 🔗 ⏮️ 🌐 👫 🎏 🕰.

///

✍ 🚙 🔢 #️⃣ 🔐 👟 ⚪️➡️ 👩‍💻.

&amp; ➕1️⃣ 🚙 ✔ 🚥 📨 🔐 🏏 #️⃣ 🏪.

&amp; ➕1️⃣ 1️⃣ 🔓 &amp; 📨 👩‍💻.

//// tab | 🐍 3️⃣.6️⃣ &amp; 🔛

```Python hl_lines="7  48  55-56  59-60  69-75"
{!> ../../../docs_src/security/tutorial004.py!}
```

////

//// tab | 🐍 3️⃣.1️⃣0️⃣ &amp; 🔛

```Python hl_lines="6  47  54-55  58-59  68-74"
{!> ../../../docs_src/security/tutorial004_py310.py!}
```

////

/// note

🚥 👆 ✅ 🆕 (❌) 💽 `fake_users_db`, 👆 🔜 👀 ❔ #️⃣ 🔐 👀 💖 🔜: `"$2b$12$EixZaYVK1fsbw1ZfbX3OXePaWxn96p36WQoeG6Lruj3vjPGga31lW"`.

///

## 🍵 🥙 🤝

🗄 🕹 ❎.

✍ 🎲 ㊙ 🔑 👈 🔜 ⚙️ 🛑 🥙 🤝.

🏗 🔐 🎲 ㊙ 🔑 ⚙️ 📋:

<div class="termy">

```console
$ openssl rand -hex 32

09d25e094faa6ca2556c818166b7a9563b93f7099f6f0f4caa6cf63b88e8d3e7
```

</div>

&amp; 📁 🔢 🔢 `SECRET_KEY` (🚫 ⚙️ 1️⃣ 🖼).

✍ 🔢 `ALGORITHM` ⏮️ 📊 ⚙️ 🛑 🥙 🤝 &amp; ⚒ ⚫️ `"HS256"`.

✍ 🔢 👔 🤝.

🔬 Pydantic 🏷 👈 🔜 ⚙️ 🤝 🔗 📨.

✍ 🚙 🔢 🏗 🆕 🔐 🤝.

//// tab | 🐍 3️⃣.6️⃣ &amp; 🔛

```Python hl_lines="6  12-14  28-30  78-86"
{!> ../../../docs_src/security/tutorial004.py!}
```

////

//// tab | 🐍 3️⃣.1️⃣0️⃣ &amp; 🔛

```Python hl_lines="5  11-13  27-29  77-85"
{!> ../../../docs_src/security/tutorial004_py310.py!}
```

////

## ℹ 🔗

ℹ `get_current_user` 📨 🎏 🤝 ⏭, ✋️ 👉 🕰, ⚙️ 🥙 🤝.

🔣 📨 🤝, ✔ ⚫️, &amp; 📨 ⏮️ 👩‍💻.

🚥 🤝 ❌, 📨 🇺🇸🔍 ❌ ▶️️ ↖️.

//// tab | 🐍 3️⃣.6️⃣ &amp; 🔛

```Python hl_lines="89-106"
{!> ../../../docs_src/security/tutorial004.py!}
```

////

//// tab | 🐍 3️⃣.1️⃣0️⃣ &amp; 🔛

```Python hl_lines="88-105"
{!> ../../../docs_src/security/tutorial004_py310.py!}
```

////

## ℹ `/token` *➡ 🛠️*

✍ `timedelta` ⏮️ 👔 🕰 🤝.

✍ 🎰 🥙 🔐 🤝 &amp; 📨 ⚫️.

//// tab | 🐍 3️⃣.6️⃣ &amp; 🔛

```Python hl_lines="115-130"
{!> ../../../docs_src/security/tutorial004.py!}
```

////

//// tab | 🐍 3️⃣.1️⃣0️⃣ &amp; 🔛

```Python hl_lines="114-129"
{!> ../../../docs_src/security/tutorial004_py310.py!}
```

////

### 📡 ℹ 🔃 🥙 "📄" `sub`

🥙 🔧 💬 👈 📤 🔑 `sub`, ⏮️ 📄 🤝.

⚫️ 📦 ⚙️ ⚫️, ✋️ 👈 🌐❔ 👆 🔜 🚮 👩‍💻 🆔, 👥 ⚙️ ⚫️ 📥.

🥙 5️⃣📆 ⚙️ 🎏 👜 ↖️ ⚪️➡️ ⚖ 👩‍💻 &amp; 🤝 👫 🎭 🛠️ 🔗 🔛 👆 🛠️.

🖼, 👆 💪 🔬 "🚘" ⚖️ "📰 🏤".

⤴️ 👆 💪 🚮 ✔ 🔃 👈 👨‍💼, 💖 "💾" (🚘) ⚖️ "✍" (📰).

&amp; ⤴️, 👆 💪 🤝 👈 🥙 🤝 👩‍💻 (⚖️ 🤖), &amp; 👫 💪 ⚙️ ⚫️ 🎭 👈 🎯 (💾 🚘, ⚖️ ✍ 📰 🏤) 🍵 💆‍♂ ✔️ 🏧, ⏮️ 🥙 🤝 👆 🛠️ 🏗 👈.

⚙️ 👫 💭, 🥙 💪 ⚙️ 🌌 🌖 🤓 😐.

📚 💼, 📚 👈 👨‍💼 💪 ✔️ 🎏 🆔, ➡️ 💬 `foo` (👩‍💻 `foo`, 🚘 `foo`, &amp; 📰 🏤 `foo`).

, ❎ 🆔 💥, 🕐❔ 🏗 🥙 🤝 👩‍💻, 👆 💪 🔡 💲 `sub` 🔑, ✅ ⏮️ `username:`. , 👉 🖼, 💲 `sub` 💪 ✔️: `username:johndoe`.

⚠ 👜 ✔️ 🤯 👈 `sub` 🔑 🔜 ✔️ 😍 🆔 🤭 🎂 🈸, &amp; ⚫️ 🔜 🎻.

## ✅ ⚫️

🏃 💽 &amp; 🚶 🩺: <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a>.

👆 🔜 👀 👩‍💻 🔢 💖:

<img src="/img/tutorial/security/image07.png">

✔ 🈸 🎏 🌌 ⏭.

⚙️ 🎓:

🆔: `johndoe`
🔐: `secret`

/// check

👀 👈 🕳 📟 🔢 🔐 "`secret`", 👥 🕴 ✔️ #️⃣ ⏬.

///

<img src="/img/tutorial/security/image08.png">

🤙 🔗 `/users/me/`, 👆 🔜 🤚 📨:

```JSON
{
  "username": "johndoe",
  "email": "johndoe@example.com",
  "full_name": "John Doe",
  "disabled": false
}
```

<img src="/img/tutorial/security/image09.png">

🚥 👆 📂 👩‍💻 🧰, 👆 💪 👀 ❔ 📊 📨 🕴 🔌 🤝, 🔐 🕴 📨 🥇 📨 🔓 👩‍💻 &amp; 🤚 👈 🔐 🤝, ✋️ 🚫 ⏮️:

<img src="/img/tutorial/security/image10.png">

/// note

👀 🎚 `Authorization`, ⏮️ 💲 👈 ▶️ ⏮️ `Bearer `.

///

## 🏧 ⚙️ ⏮️ `scopes`

Oauth2️⃣ ✔️ 🔑 "↔".

👆 💪 ⚙️ 👫 🚮 🎯 ⚒ ✔ 🥙 🤝.

⤴️ 👆 💪 🤝 👉 🤝 👩‍💻 🔗 ⚖️ 🥉 🥳, 🔗 ⏮️ 👆 🛠️ ⏮️ ⚒ 🚫.

👆 💪 💡 ❔ ⚙️ 👫 &amp; ❔ 👫 🛠️ 🔘 **FastAPI** ⏪ **🏧 👩‍💻 🦮**.

## 🌃

⏮️ ⚫️❔ 👆 ✔️ 👀 🆙 🔜, 👆 💪 ⚒ 🆙 🔐 **FastAPI** 🈸 ⚙️ 🐩 💖 Oauth2️⃣ &amp; 🥙.

🌖 🙆 🛠️ 🚚 💂‍♂ ▶️️ 👍 🏗 📄 🔜.

📚 📦 👈 📉 ⚫️ 📚 ✔️ ⚒ 📚 ⚠ ⏮️ 💽 🏷, 💽, &amp; 💪 ⚒. &amp; 👉 📦 👈 📉 👜 💁‍♂️ 🌅 🤙 ✔️ 💂‍♂ ⚠ 🔘.

---

**FastAPI** 🚫 ⚒ 🙆 ⚠ ⏮️ 🙆 💽, 💽 🏷 ⚖️ 🧰.

⚫️ 🤝 👆 🌐 💪 ⚒ 🕐 👈 👖 👆 🏗 🏆.

&amp; 👆 💪 ⚙️ 🔗 📚 👍 🚧 &amp; 🛎 ⚙️ 📦 💖 `passlib` &amp; `python-jose`, ↩️ **FastAPI** 🚫 🚚 🙆 🏗 🛠️ 🛠️ 🔢 📦.

✋️ ⚫️ 🚚 👆 🧰 📉 🛠️ 🌅 💪 🍵 🎯 💪, ⚖, ⚖️ 💂‍♂.

&amp; 👆 💪 ⚙️ &amp; 🛠️ 🔐, 🐩 🛠️, 💖 Oauth2️⃣ 📶 🙅 🌌.

👆 💪 💡 🌅 **🏧 👩‍💻 🦮** 🔃 ❔ ⚙️ Oauth2️⃣ "↔", 🌖 👌-🧽 ✔ ⚙️, 📄 👫 🎏 🐩. Oauth2️⃣ ⏮️ ↔ 🛠️ ⚙️ 📚 🦏 🤝 🐕‍🦺, 💖 👱📔, 🇺🇸🔍, 📂, 🤸‍♂, 👱📔, ♒️. ✔ 🥉 🥳 🈸 🔗 ⏮️ 👫 🔗 🔛 👨‍💼 👫 👩‍💻.
