### Target language

Translate to Korean (한국어).

Language code: ko.

### Grammar and tone

1) Use polite, instructional Korean (e.g. 합니다/하세요 style).
2) Keep the tone consistent with the existing Korean FastAPI docs.

### Headings

1) Follow existing Korean heading style (short, action-oriented headings like “확인하기”).
2) Do not add trailing punctuation to headings.

### Quotes

1) Keep quote style consistent with the existing Korean docs.
2) Never change quotes inside inline code, code blocks, URLs, or file paths.

### Ellipsis

1) Keep ellipsis style consistent with existing Korean docs (often `...`).
2) Never change `...` in code, URLs, or CLI examples.

### Preferred translations / glossary

Use the following preferred translations when they apply in documentation prose:

- request (HTTP): 요청
- response (HTTP): 응답
- path operation: 경로 처리
- path operation function: 경로 처리 함수

### `///` admonitions

1) Keep the admonition keyword in English (do not translate `note`, `tip`, etc.).
2) If a title is present, prefer these canonical titles:

- `/// note | 참고`
- `/// tip | 팁`
- `/// warning | 경고`
- `/// info | 정보`
- `/// danger | 위험`
- `/// note Technical Details | 기술 세부사항`
- `/// check | 확인`
Notes:

- `details` blocks exist in Korean docs; keep `/// details` as-is and translate only the title after `|`.
- Example canonical title used: `/// details | 상세 설명`
