/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_grid.h"
        #include <wx/grid.h>



PyDoc_STRVAR(doc_wxGridFitMode_IsSpecified, "IsSpecified() -> bool\n"
"\n"
"Return true if the object specifies some particular behaviour.");

extern "C" {static PyObject *meth_wxGridFitMode_IsSpecified(PyObject *, PyObject *);}
static PyObject *meth_wxGridFitMode_IsSpecified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridFitMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridFitMode, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsSpecified();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridFitMode, sipName_IsSpecified, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridFitMode_IsClip, "IsClip() -> bool\n"
"\n"
"Return true if the object specifies clipping behaviour.");

extern "C" {static PyObject *meth_wxGridFitMode_IsClip(PyObject *, PyObject *);}
static PyObject *meth_wxGridFitMode_IsClip(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridFitMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridFitMode, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsClip();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridFitMode, sipName_IsClip, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridFitMode_IsOverflow, "IsOverflow() -> bool\n"
"\n"
"Return true if the object specifies overflow behaviour.");

extern "C" {static PyObject *meth_wxGridFitMode_IsOverflow(PyObject *, PyObject *);}
static PyObject *meth_wxGridFitMode_IsOverflow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridFitMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridFitMode, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOverflow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridFitMode, sipName_IsOverflow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridFitMode_GetEllipsizeMode, "GetEllipsizeMode() -> wx.EllipsizeMode\n"
"\n"
"Return ellipsize mode, possibly wxELLIPSIZE_NONE.");

extern "C" {static PyObject *meth_wxGridFitMode_GetEllipsizeMode(PyObject *, PyObject *);}
static PyObject *meth_wxGridFitMode_GetEllipsizeMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxGridFitMode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxGridFitMode, &sipCpp))
        {
            ::wxEllipsizeMode sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEllipsizeMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxEllipsizeMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridFitMode, sipName_GetEllipsizeMode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridFitMode_Clip, "Clip() -> GridFitMode\n"
"\n"
"Pseudo-constructor for object specifying clipping behaviour.");

extern "C" {static PyObject *meth_wxGridFitMode_Clip(PyObject *, PyObject *);}
static PyObject *meth_wxGridFitMode_Clip(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxGridFitMode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridFitMode(::wxGridFitMode::Clip());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridFitMode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridFitMode, sipName_Clip, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridFitMode_Overflow, "Overflow() -> GridFitMode\n"
"\n"
"Pseudo-constructor for object specifying overflow behaviour.");

extern "C" {static PyObject *meth_wxGridFitMode_Overflow(PyObject *, PyObject *);}
static PyObject *meth_wxGridFitMode_Overflow(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::wxGridFitMode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridFitMode(::wxGridFitMode::Overflow());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridFitMode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridFitMode, sipName_Overflow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxGridFitMode_Ellipsize, "Ellipsize(ellipsize=wx.ELLIPSIZE_END) -> GridFitMode\n"
"\n"
"Pseudo-constructor for object specifying ellipsize behaviour.");

extern "C" {static PyObject *meth_wxGridFitMode_Ellipsize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxGridFitMode_Ellipsize(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxEllipsizeMode ellipsize = wxELLIPSIZE_END;

        static const char *sipKwdList[] = {
            sipName_ellipsize,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "|E", sipType_wxEllipsizeMode, &ellipsize))
        {
            ::wxGridFitMode*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxGridFitMode(::wxGridFitMode::Ellipsize(ellipsize));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxGridFitMode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_GridFitMode, sipName_Ellipsize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxGridFitMode(void *, int);}
static void release_wxGridFitMode(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxGridFitMode *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxGridFitMode(Py_ssize_t);}
static void *array_wxGridFitMode(Py_ssize_t sipNrElem)
{
    return new ::wxGridFitMode[sipNrElem];
}


extern "C" {static void array_delete_wxGridFitMode(void *);}
static void array_delete_wxGridFitMode(void *sipCpp)
{
    delete[] reinterpret_cast<::wxGridFitMode *>(sipCpp);
}


extern "C" {static void assign_wxGridFitMode(void *, Py_ssize_t, void *);}
static void assign_wxGridFitMode(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxGridFitMode *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxGridFitMode *>(sipSrc);
}


extern "C" {static void *copy_wxGridFitMode(const void *, Py_ssize_t);}
static void *copy_wxGridFitMode(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxGridFitMode(reinterpret_cast<const ::wxGridFitMode *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxGridFitMode(sipSimpleWrapper *);}
static void dealloc_wxGridFitMode(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxGridFitMode(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxGridFitMode(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxGridFitMode(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxGridFitMode *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGridFitMode();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxGridFitMode* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxGridFitMode, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxGridFitMode(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxGridFitMode[] = {
    {sipName_Clip, meth_wxGridFitMode_Clip, METH_VARARGS, doc_wxGridFitMode_Clip},
    {sipName_Ellipsize, SIP_MLMETH_CAST(meth_wxGridFitMode_Ellipsize), METH_VARARGS|METH_KEYWORDS, doc_wxGridFitMode_Ellipsize},
    {sipName_GetEllipsizeMode, meth_wxGridFitMode_GetEllipsizeMode, METH_VARARGS, doc_wxGridFitMode_GetEllipsizeMode},
    {sipName_IsClip, meth_wxGridFitMode_IsClip, METH_VARARGS, doc_wxGridFitMode_IsClip},
    {sipName_IsOverflow, meth_wxGridFitMode_IsOverflow, METH_VARARGS, doc_wxGridFitMode_IsOverflow},
    {sipName_IsSpecified, meth_wxGridFitMode_IsSpecified, METH_VARARGS, doc_wxGridFitMode_IsSpecified},
    {sipName_Overflow, meth_wxGridFitMode_Overflow, METH_VARARGS, doc_wxGridFitMode_Overflow}
};

sipVariableDef variables_wxGridFitMode[] = {
    {PropertyVariable, sipName_EllipsizeMode, &methods_wxGridFitMode[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxGridFitMode, "GridFitMode() -> None\n"
"\n"
"Allows to specify the behaviour when the cell contents doesn't fit\n"
"into its allotted space.");


sipClassTypeDef sipTypeDef__grid_wxGridFitMode = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxGridFitMode,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_GridFitMode,
        {0, 0, 1},
        7, methods_wxGridFitMode,
        0, SIP_NULLPTR,
        1, variables_wxGridFitMode,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxGridFitMode,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxGridFitMode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxGridFitMode,
    assign_wxGridFitMode,
    array_wxGridFitMode,
    copy_wxGridFitMode,
    release_wxGridFitMode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxGridFitMode,
    sizeof (::wxGridFitMode),
};
