/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildconfiguration;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Problems;
import org.gradle.buildconfiguration.tasks.UpdateDaemonJvm;
import org.gradle.configuration.project.ProjectConfigureAction;
import org.gradle.internal.Pair;
import org.gradle.internal.buildconfiguration.resolvers.UnconfiguredToolchainRepositoriesResolver;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainDownload;
import org.gradle.jvm.toolchain.JavaToolchainRequest;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRequest;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverService;
import org.gradle.platform.Architecture;
import org.gradle.platform.BuildPlatform;
import org.gradle.platform.BuildPlatformFactory;
import org.gradle.platform.OperatingSystem;

public class DaemonJvmPropertiesConfigurator
implements ProjectConfigureAction {
    public static final String TASK_NAME = "updateDaemonJvm";

    public void execute(ProjectInternal project) {
        if (project.getParent() == null) {
            ProblemReporter reporter = ((Problems)project.getServices().get(Problems.class)).getReporter();
            project.getTasks().register(TASK_NAME, UpdateDaemonJvm.class, task -> {
                task.setGroup("Build Setup");
                task.setDescription("Generates or updates the Gradle Daemon JVM criteria.");
                task.getPropertiesFile().convention(project.getLayout().getProjectDirectory().file("gradle/gradle-daemon-jvm.properties"));
                task.getLanguageVersion().convention((Object)JavaLanguageVersion.of((int)Jvm.current().getJavaVersionMajor()));
                task.getToolchainPlatforms().convention((Iterable)Stream.of(Architecture.X86_64, Architecture.AARCH64).flatMap(arch -> Stream.of(OperatingSystem.values()).map(os -> BuildPlatformFactory.of((Architecture)arch, (OperatingSystem)os))).collect(Collectors.toSet()));
                task.getToolchainDownloadUrls().convention(task.getToolchainPlatforms().zip(task.getLanguageVersion().zip(task.getVendor().orElse((Object)DefaultJvmVendorSpec.any()), Pair::of), (platforms, versionVendor) -> {
                    JvmVendorSpec vendor = (JvmVendorSpec)versionVendor.getRight();
                    JavaToolchainSpec toolchainSpec = (JavaToolchainSpec)project.getObjects().newInstance(DefaultToolchainSpec.class, new Object[0]);
                    toolchainSpec.getLanguageVersion().set((Object)((JavaLanguageVersion)versionVendor.getLeft()));
                    if (!vendor.equals(DefaultJvmVendorSpec.any())) {
                        toolchainSpec.getVendor().set((Object)vendor);
                    }
                    if (platforms.isEmpty()) {
                        return Collections.emptyMap();
                    }
                    JavaToolchainResolverService resolverService = (JavaToolchainResolverService)project.getServices().get(JavaToolchainResolverService.class);
                    if (!resolverService.hasConfiguredToolchainRepositories()) {
                        UnconfiguredToolchainRepositoriesResolver exception = new UnconfiguredToolchainRepositoriesResolver();
                        throw reporter.throwing((Throwable)((Object)exception), UpdateDaemonJvm.TASK_CONFIGURATION_PROBLEM_ID, problemSpec -> {
                            problemSpec.contextualLabel(exception.getLocalizedMessage());
                            exception.getResolutions().forEach(arg_0 -> ((ProblemSpec)problemSpec).solution(arg_0));
                        });
                    }
                    Map<BuildPlatform, Optional> buildPlatformOptionalUriMap = platforms.stream().collect(Collectors.toMap(platform -> platform, platform -> resolverService.tryResolve((JavaToolchainRequest)new DefaultJavaToolchainRequest(toolchainSpec, platform)).map(JavaToolchainDownload::getUri)));
                    Map<BuildPlatform, URI> platformToDownloadUri = buildPlatformOptionalUriMap.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> (URI)((Optional)e.getValue()).get()));
                    if (platformToDownloadUri.isEmpty()) {
                        String message = "Toolchain resolvers did not return download URLs providing a JDK matching " + toolchainSpec + " for any of the requested platforms " + platforms;
                        throw reporter.throwing((Throwable)new IllegalStateException(message), UpdateDaemonJvm.TASK_CONFIGURATION_PROBLEM_ID, problemSpec -> {
                            problemSpec.contextualLabel(message);
                            problemSpec.solution("Use a toolchain download repository capable of resolving the toolchain spec for the given platforms");
                            problemSpec.documentedAt(Documentation.userManual((String)"gradle_daemon", (String)"sec:daemon_jvm_provisioning").getUrl());
                        });
                    }
                    return platformToDownloadUri;
                }));
            });
        }
    }
}

