/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.util.Set;
import org.gradle.api.NonNullApi;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.internal.IdeaModuleInternal;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.internal.tooling.IdeaModelParameter;
import org.gradle.plugins.ide.internal.tooling.IdeaModuleBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.idea.IsolatedIdeaModuleInternal;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;

@NonNullApi
public class IsolatedIdeaModuleInternalBuilder
implements ParameterizedToolingModelBuilder<IdeaModelParameter> {
    public Class<IdeaModelParameter> getParameterType() {
        return IdeaModelParameter.class;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(IsolatedIdeaModuleInternal.class.getName());
    }

    public IsolatedIdeaModuleInternal buildAll(String modelName, IdeaModelParameter parameter, Project project) {
        return IsolatedIdeaModuleInternalBuilder.build(project, parameter.getOfflineDependencyResolution());
    }

    public IsolatedIdeaModuleInternal buildAll(String modelName, Project project) {
        return IsolatedIdeaModuleInternalBuilder.build(project, false);
    }

    private static IsolatedIdeaModuleInternal build(Project project, boolean offlineDependencyResolution) {
        project.getPluginManager().apply(IdeaPlugin.class);
        IdeaModel ideaModelExt = (IdeaModel)project.getExtensions().getByType(IdeaModel.class);
        IdeaModuleInternal ideaModuleExt = (IdeaModuleInternal)ideaModelExt.getModule();
        ideaModuleExt.setOffline(offlineDependencyResolution);
        Set<Dependency> resolvedDependencies = ideaModuleExt.resolveDependencies();
        IsolatedIdeaModuleInternal model = new IsolatedIdeaModuleInternal();
        model.setName(ideaModuleExt.getName());
        model.setJdkName(ideaModuleExt.getJdkName());
        model.setContentRoot(IdeaModuleBuilderSupport.buildContentRoot(ideaModuleExt));
        model.setCompilerOutput(IdeaModuleBuilderSupport.buildCompilerOutput(ideaModuleExt));
        if (project.getPlugins().hasPlugin(JavaPlugin.class)) {
            model.setExplicitSourceLanguageLevel(ideaModuleExt.getRawLanguageLevel());
            model.setExplicitTargetBytecodeVersion(ideaModuleExt.getRawTargetBytecodeVersion());
        }
        if (project.getPlugins().hasPlugin(JavaBasePlugin.class)) {
            JavaPluginExtension javaExt = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            model.setJavaSourceCompatibility(javaExt.getSourceCompatibility());
            model.setJavaTargetCompatibility(javaExt.getTargetCompatibility());
        }
        model.setDependencies(IdeaModuleBuilderSupport.buildDependencies(resolvedDependencies));
        return model;
    }
}

