/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class ComponentConfigurationIdentifier
implements VariantResolveMetadata.Identifier {
    private final ComponentIdentifier component;
    private final String configurationName;
    private final int hashCode;

    public ComponentConfigurationIdentifier(ComponentIdentifier component, String configurationName) {
        this.component = component;
        this.configurationName = configurationName;
        this.hashCode = ComponentConfigurationIdentifier.computeHashCode(component, configurationName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ComponentConfigurationIdentifier other = (ComponentConfigurationIdentifier)obj;
        return this.component.equals(other.component) && this.configurationName.equals(other.configurationName);
    }

    private static int computeHashCode(ComponentIdentifier component, String configurationName) {
        return 31 * component.hashCode() + configurationName.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }
}

